// CheckTrView.cpp : implementation of the CCheckTrView class
//

#include "stdafx.h"

#include "CheckTr.h"
#include "CheckTrDoc.h"
#include "CheckTrView.h"
#include "threadMag.h"
#include "ExpTime.h"
#include "DlgInReport.h"
#include "Calibration.h"
#include "SpectrInit1.h"
#include "Concentration.h"
#include "Baseline1.h"
#include "XYScale.h"
#include "ThreePointsCalibration.h"
#include "PlanckTemperature.h"
#include "Trigger.h"
#include <math.h>
#include "MainFrm.h"
#include "AboutB.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int const WM_USRMSGTO=WM_USER+90;
int const WM_USRMSGFROM=WM_USER+91;
/////////////////////////////////////////////////////////////////////////////
// CCheckTrView

IMPLEMENT_DYNCREATE(CCheckTrView, CView)

//const UINT WM_MYMES=RegisterWindowMessage( FINDMSGSTRING );

BEGIN_MESSAGE_MAP(CCheckTrView, CView)
	//{{AFX_MSG_MAP(CCheckTrView)
	ON_COMMAND(ID_MESSAGE, OnMessage)
	ON_COMMAND(ID_SPEC_SAVE, OnSpecSave)
	ON_COMMAND(ID_CALIBRATION, OnCalibration)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_FILE_SAVE1, OnFileSave1)
	ON_BN_CLICKED(IDC_GETBCK, OnGetbck)
	ON_COMMAND(ID_XYAUTOSCALE, OnXyautoscale)
	ON_COMMAND(ID_XAUTOSCALE, OnXautoscale)
	ON_COMMAND(ID_YAUTOSCALE, OnYautoscale)
	ON_COMMAND(ID_FAST, OnFast)
	ON_COMMAND(ID_SETSCALE, OnSetscale)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_BN_CLICKED(IDC_SBSTRBCK, OnSbstrbck)
	ON_BN_CLICKED(IDC_AVERAGING, OnAveraging)
	ON_BN_CLICKED(IDC_RUN, OnRun)
	ON_COMMAND(ID_GETSPECTRA, OnGetspectra)
	ON_COMMAND(ID_LOADSOURCESPECTRA, OnLoadsourcespectra)
	ON_BN_CLICKED(IDC_RAD_REF_M_SP, OnRef_min_Sp)
	ON_BN_CLICKED(IDC_RAD_SP_DEV_REF, OnSp_dev_Ref)
	ON_COMMAND(ID_OPEN, OnOpenSpectra)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen1)
	ON_BN_CLICKED(IDC_RAD_LOG1, OnRadLog1)
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_VIEW_400to700, OnVIEW400to700)
	ON_COMMAND(ID_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_XYSPACE, OnXyspace)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_COMMAND(ID_CHOOSESPECTR, OnChoosespectr)
	ON_BN_CLICKED(IDC_XYZMINUS, OnXyzminus)
	ON_BN_CLICKED(IDC_XYZPLUS, OnXyzplus)
	ON_BN_CLICKED(IDC_CNSTR, OnCnstr)
	ON_BN_CLICKED(IDC_LOG, OnLog)
	ON_COMMAND(ID_BASELINE, OnBaseline)
	ON_BN_CLICKED(IDC_AUTOY, OnAutoy)
	ON_COMMAND(ID_VIEW_CM, OnViewCm)
	ON_COMMAND(ID_VIEW_NM, OnViewNm)
	ON_COMMAND(ID_PLST_CLBR, OnPlstClbr)
	ON_COMMAND(ID_SAVE_CALIBRATION, OnSaveCalibration)
	ON_COMMAND(ID_LOAD_CALIBRATION, OnLoadCalibration)
	ON_COMMAND(ID_PLANCKCALIBRATION, OnPlanckcalibration)
	ON_COMMAND(ID_FILE_SAVE_ONE, OnFileSaveOne)
	ON_COMMAND(ID_SAVESCREEN, OnSavescreen)
	ON_COMMAND(ID_SAVE_CALIBRATION_TO_FLASH, OnSaveCalibrationToFlash)
	ON_COMMAND(ID_FILE_SAVE_BMP, OnFileSaveBmp)
	ON_COMMAND(ID_FILE_SAVE_XYZ, OnFileSaveXyz)
	ON_WM_TIMER()
	ON_COMMAND(ID_SNAP, OnSnap)
	ON_COMMAND(ID_CLEARALL, OnClearall)
	ON_COMMAND(ID_CALIBRATION_OFF, OnCalibrationOff)
	ON_BN_CLICKED(IDC_FAST, OnFast)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
	ON_COMMAND(ID_TRIGGER, OnTrigger)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_MESSAGE(WM_USRMSGFROM, Mes_Anal)	
	ON_COMMAND(ID_FILE_PRINT_DIRECT, OnFilePrint)

	
END_MESSAGE_MAP()

CthreadMag *pThread;


/////////////////////////////////////////////////////////////////////////////
// CCheckTrView construction/destruction

CCheckTrView::CCheckTrView()
{
		NScans=1;
		SpecToGet=1;//0- get to Spectra; 1- get to Spectra1
		DevDet=false;
		MaxXT=MaxX;
		MinXT=MinX;
		Fast=false;
		Test=false;
		TotStartPix=33;
		TotEndPix=3685;
		RefSpectra=false;
		MinRef_or_DevRef=0;
		applBck=false;
		ExpN=10;
		BoxCarN=0;
		Average=true;
		Log=false;
		Back1=0;
		select_Dev=0;//selected device
		GaussAppr=false;
		SpectraLength_T[0]=3652;
		SpectraLength_T[1]=-1;
		int i;
		for(i=0;i<1000000;i++)
		{
			SpectraData_T[i]=0;
			SpectraWavelength_T[i]=i;
		}
		MaxX=3652;
		MaxXT=MaxX;
		MinX=0;
		MinXT=MinX;
		MaxY=64000;//16384;
		MinY=0;
		lmbdMin=MinX;
		lmbdMax=MaxX;
		for(i=0;i<4096*64;i++)
		{
			Spectra[i]=0;
			Spectra1[i]=0;
		}
		SN_T=14;
		ref_line_index=100;
		width=0;
		high=0;
		RLn=15;
		TransNmb=250;
		MaxX=3652;
		MaxXT=MaxX;
		MinX=0;
		MinXT=MinX;
		MaxY=64000;
		MinY=0;
		mesage_to=0;	//index in getting spectra
		ShowReport=0;
		ShowReportTmp=0;
		Run_get_spec=false;
		Test=false;
		Fast=false;
		AutoY=false;
		DevDet=false;
		TotStartPix=33;
		TotEndPix=3685;
		TotPix=TotEndPix-TotStartPix;
		Blank=0;
		toDetach=1;
		NScans=1;
		Trigger=false;
		KeepTrigger=false;
		StartEx=false;
		Average=true;
		Log=false;
		Back1=0;
		ExpN=5;
		ExpCorrect=(ExpN-1)*375+2332;
		EnergyCorrect=1;
		SpecToGet=1;//0- get to Spectra; 1- get to Spectra1
		botDwn=false;
		LeftBot=false;
		Xmargin_left=60;
		Xmargin_right=10;
		Ymargin_top=10;
		Ymargin_bottom=30;
		getCoeff=false;
		getCoeff2=false;
		norm_Spec=false;
		sendOne=false;
		applBck=false;
		InitCCD=false;
		ColBar=false;
		BoxCarN=0;
		XYSpace=false;
		select_Dev=0;//selected device
		ShowMaxInt=false;
		AutoSave=false;
		AutoMinutes=1;
		AutoNmb=0;
		AutoSave1=false;//Save spectra, txt
		AutoSave2=false;//Save screen, bmp
		AutoSave3=false;//Save, 1nm step
		AutoSave4=false;//Save, 380-760nm normalized to sensitivity
		slopeIndex=0;

		RefSpectra=false;
		MinRef_or_DevRef=0;
		ConcentrationSet=false;
		MolExt=1;//molar absorptivity (extinction coefficient) of the absorber
		CuvLength=1;//cuvette length
		LoadSpecFlag=0;

		coeff_A=7.48705E-6;
		coeff_B=-0.22976;
		coeff_C=949.65802;
		bck_a=1;//new defenition: normalization coefficient for absolute irradiation; EnergyCorrect=bck_a;
		bck_b=0;
		applyNorm=true;
		applyCal=true;
		CMscaleView=false;
		SaveCalibrationAskUser=true;
		AllClbrToFLASH=false;
		addressF=0;

		CalcEnDistr=false;
		LowRange=380;
		UpperRange=760;
		LowRange1=380;
		UpperRange1=490;
		LowRange2=490;
		UpperRange2=580;
		LowRange3=580;
		UpperRange3=760;
		XYZ_CRI_calibr=false;

		Xcolor=0.3;
		Ycolor=0.2;
		Zcolor=0;
		colorSize=3.5;
		Ucolor=0;
		Vcolor=0;
		TTemp=0;
		DCcolor=0;

		windowG=50;
		iterations=100;
		ExpTimerCount=0;

		SN_T=14;
		SpectraLength_T[LoadSpecFlag+1]=-1;
		LoadS=0;
		reset=true;

		TrigStat=0; //0-no trig; 1-ext.trig; 2-optical trig.
		noTrig = true;
		OptTrig = FALSE;
		ExtTrig = FALSE;
		BothEdgesElectr = FALSE;
		OneTimeElectr = FALSE;
		FallEdgeElectr = FALSE;
		FallEdgeOneTineOpt = FALSE;
		FallEdgeOpt = FALSE;
		RisingEdgeElectr = true;
		RisingEdgeOneTimeOpt = FALSE;
		RisingEdgeOpt = true;
		ThreshOpt = FALSE;
		TrigIntensity = 2000;
		TrigWavelength = 500;
		TrigEnableMode=0;
		TrigSignalFrontMode=0;
		ref_line_pixel=1800;
		enableMode=0;
		pixel=1850;
		threshold=TrigIntensity;
	
		int j;
		if(coeff_B>0)
		{
			SclDir=true;
			for(i=0;i<=TotPix;i++)
			Xscl_lmbd[i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
		}
		else
		{
			SclDir=false;
			for(i=0;i<=TotPix;i++)
			Xscl_lmbd[TotPix-i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
		}
		
		lmbdMin=Xscl_lmbd[0];
		lmbdMax=Xscl_lmbd[TotPix];
		ref_line=(lmbdMax+lmbdMin)/2;

		for(i=0;i<=4095;i++)
		{
			NormS[i]=1;
			Background[i]=0;
			for(j=0;j<=63;j++)
			{
				Spectra[j*4096+i]=-1;
				Spectra1[j*4096+i]=-1;
			}
		}	

		for (i=0;i<=7;i++)	DirectWrite[i]=0;


	pThread=new CthreadMag(
		this,
		&mesage_to,
		DataIn,
		DataOut,
		&NScans,
		Spectra,
		Spectra1,
		&SpecToGet,
		&DevDet,
		&MinXT,
		&MaxXT,
		&Fast,
		&Test,
		&TotStartPix,
		&TotEndPix,
		&SclDir,
		NormS,
		&applyNorm,
		SourceSpectra,
		&MinRef_or_DevRef,
		Background,
		&applBck,
		&ExpN,
		&bck_a,
		&bck_b,
		&BoxCarN,
		&Average,
		&conn_Dev,
		&select_Dev,
		&Log,
		&AllClbrToFLASH,
		ColorNorm,
		Xscl_lmbd,
		InfoString,
		&slopeIndex,
		&reset,
		&Blank,
		&TrigEnableMode,
		&TrigSignalFrontMode,
		&enableMode,
		&pixel,
		&threshold
		);

	if(!pThread->CreateThread(CREATE_SUSPENDED))
	{
	   delete pThread;
	   return;
	}
	VERIFY(pThread->SetThreadPriority(THREAD_PRIORITY_ABOVE_NORMAL));
	pThread->ResumeThread();
	firstStart=false;
	Run_get_spec=false;
	OnChoosespectr();
}

CCheckTrView::~CCheckTrView()
{
}

BOOL CCheckTrView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCheckTrView drawing

void CCheckTrView::OnDraw(CDC* pDC)
{
	CCheckTrDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here

	CBitmap junk;
	CBitmap junk1;
	CDC dc;
	CDC dc_Frame;

	int tmp2,tmp3,i,j,k;
	double tmp1,lambda_tmp1,k1,k2;
	bool flag1;

	GetClientRect(rect);

	if(width!=rect.right||high!=rect.bottom)
	{
		width=rect.right;
		high=rect.bottom;
	}
	Xmargin_left=(int)(width*0.075);
	Xmargin_right=(int)(width*0.025);;
	Ymargin_top=Xmargin_right;
	Ymargin_bottom=2*SN_T;
		
	dc.CreateCompatibleDC(pDC);
	junk.CreateCompatibleBitmap(pDC,rect.right,rect.bottom);
	CBitmap *OldBitmap1=dc.SelectObject(&junk);
		
	dc_Frame.CreateCompatibleDC(pDC);
	junk1.CreateCompatibleBitmap(pDC,rect.right,rect.bottom);
	CBitmap *OldBitmap2=dc_Frame.SelectObject(&junk1);
	
	dc_Frame.FillRect(rect,&CBrush(RGB(255,255,255)));

///////////////////
		CString Out;

		if(ColBar==true)//draw color bar
		{
			CPen BlackPen	(PS_SOLID, 1, RGB(0,0,0));
			CPen* OldPen =	(CPen*)dc_Frame.SelectObject(&BlackPen);
			i=width-Xmargin_right-Xmargin_left-2;//total pixels (for spectra) range in the screen
			for(k=0;k<=i;k++)
			{
				j=lmbdMin+k*(lmbdMax-lmbdMin)/i;//current approx wavelength

				if((j>=400)&(j<420))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(0,0,255));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
				if((j>=420)&(j<475))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(0,255*(j-420)/(475-420),255));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
				if((j>=475)&(j<525))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(0,255,255*(525-j)/(525-475)));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
				if((j>=525)&(j<560))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(255*(j-525)/(560-525),255,0));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
				if((j>=560)&(j<620))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(255,255*(620-j)/(620-560),0));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
				if((j>=620)&(j<700))
				{
					CPen CurPen		(PS_SOLID, 1, RGB(255,0,0));
					dc_Frame.SelectObject(&CurPen);
					dc_Frame.MoveTo(k+Xmargin_left+1,high-Ymargin_bottom-20);
					dc_Frame.LineTo(k+Xmargin_left+1,high-Ymargin_bottom-50);
					dc_Frame.SelectObject(OldPen);
				}
			}
		}
////////////////
		
//CreateBtMp();
////////////////
	dc.BitBlt(0,0,rect.right,rect.bottom,&dc_Frame,0,0,SRCCOPY);
	
	CPen BlackPen	(PS_SOLID, 1, RGB(0,0,0));
	CPen* OldPen =	(CPen*)dc.SelectObject(&BlackPen);
	CPen RedPen		(PS_SOLID, 1, RGB(255,0,0));
	CPen GreenPen	(PS_SOLID, 1, RGB(0,255,0));
	CPen BluePen	(PS_SOLID, 1, RGB(0,0,255));
	CPen YellowPen	(PS_SOLID, 1, RGB(128,128,0));

	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CEdit *pEditBoxCar = reinterpret_cast<CEdit *>(cFrame->m_wndChartBar.GetDlgItem(IDC_BOXCAR));
	pEditBoxCar->GetWindowText(Out);
	BoxCarN=(int)(atof(Out));
	if(BoxCarN<0||BoxCarN>50)
	{
		BoxCarN=1;
		sprintf(Out.GetBuffer(16),"%d",BoxCarN);
		Out.ReleaseBuffer();
		pEditBoxCar->SetWindowText(Out);
	}

	double tmp_offset;
	tmp_offset=bck_a*ExpN+bck_b;
	double IrradRef;



	if(XYSpace==true)
	{
//		void ColorSpectraMultiplying(double *SourceSpectra,double *WlgthSpectra,int ArLength1,double *ResultsData);		
		if(Fast==false)//all pixels
		{
			double SourceSpectr[4096];
			double WlgthSpectra[4096];
			int j;
			if(SpecToGet==0)
				for(i=0;i<=MaxXT;i++)
				{
					SourceSpectr[i]=Spectra[i]*ColorNorm[i];
					j=i;
				}
			else
				for(i=0;i<=MaxXT;i++)
				{
					SourceSpectr[i]=Spectra1[i]*ColorNorm[i];
					j=i;
				}
			for(i=0;i<=MaxXT;i++)
			{
				WlgthSpectra[i]=Xscl_lmbd[i];
				j=i;
			}
			ColorSpectraMultiplying(SourceSpectr,WlgthSpectra,MaxXT,CRI_Results);

			IrradRef=SourceSpectr[ref_line_pixel]/((ExpN-1)*475+2332);
		}
		else//Fast=true; half of the pixels
		{
			double SourceSpectr[1826];
			double WlgthSpectra[1826];
			if(SpecToGet==0)	for(i=0;i<=1825;i++) SourceSpectr[i]=Spectra[i]*ColorNorm[2*i];
			else				for(i=0;i<=1825;i++) SourceSpectr[i]=Spectra1[i]*ColorNorm[2*i];
			for(i=0;i<=1825;i++) WlgthSpectra[i]=Xscl_lmbd[2*i];
			ColorSpectraMultiplying(SourceSpectr,WlgthSpectra,1825,CRI_Results);

			IrradRef=SourceSpectr[ref_line_pixel]/((ExpN-1)*475+2332);
		}
		/*
		ResultsData[0]=X;
		ResultsData[1]=Y;
		ResultsData[2]=Z;
		ResultsData[3]=uk;
		ResultsData[4]=vk;
		ResultsData[5]=Tc;
		ResultsData[6]=DC;
		ResultsData[7]=deltaE[1];
		......
		ResultsData[20]=deltaE[14];
		ResultsData[21]=R[1];
		......
		ResultsData[34]=R[14];
		ResultsData[35]=CRI (mean of R1..R14)
		*/
		Xcolor=CRI_Results[0];
		Ycolor=CRI_Results[1];
		Zcolor=CRI_Results[2]; 
		Ucolor=CRI_Results[3];
		Vcolor=CRI_Results[4];
		TTemp=CRI_Results[5];
		DCcolor=CRI_Results[6];
	}

	if(Average==true && NScans>=1)
	{
		if(Fast==false)//all pixels
		{
			
			for(i=0;i<=MaxXT;i++)
			{
				if(SpecToGet==0)	tmp1=Spectra[i];
				else				tmp1=Spectra1[i];
				SpectraData_T[i]=tmp1;
				SpectraWavelength_T[i]=Xscl_lmbd[i];
			}
			SpectraLength_T[0]=MaxXT;
			SpectraColorR_T[0]=0;
			SpectraColorG_T[0]=0;
			SpectraColorB_T[0]=0;
			SpectraColorW_T[0]=1;
			
			if(Back1==1)//to get background
			{
				for(i=0;i<=MaxXT;i++)
				{
					if(SpecToGet==0)	Background[i]=Spectra[i];
					else				Background[i]=Spectra1[i];
				}
				Back1=2;//background is in memory
			}			
		}
		else//Fast=true; half of the pixels
		{
			for(i=0;i<=3652/2;i++)
			{
				if(SpecToGet==0)	tmp1=Spectra[i];
				else				tmp1=Spectra1[i];

				SpectraData_T[i]=tmp1;
				SpectraWavelength_T[i]=Xscl_lmbd[2*i];
			}
			SpectraLength_T[0]=3652/2-1;
			SpectraColorR_T[0]=0;
			SpectraColorG_T[0]=0;
			SpectraColorB_T[0]=0;
			SpectraColorW_T[0]=1;
			if(Back1==1)//to get background
			{
				for(i=0;i<1826;i++)
				{
					if(SpecToGet==0)	Background[i]=Spectra[i];
					else				Background[i]=Spectra1[i];
				}
				Back1=2;//background is in memory
			}
		}			
	}
	else	//no Average or NScans=1
	{
		int range;
		if(Fast==false) range =MaxXT-1;
		else range=3652/2-1;
		for(j=0;j<NScans;j++)
		{
			if(j==0)
			{
				SpectraLength_T[0]=range;
				SpectraColorR_T[0]=0;
				SpectraColorG_T[0]=0;
				SpectraColorB_T[0]=0;
				SpectraColorW_T[0]=1;
			}
			else
				if(j==1)
				{
					SpectraLength_T[1]=range;
					SpectraColorR_T[1]=255;
					SpectraColorG_T[1]=0;
					SpectraColorB_T[1]=0;
					SpectraColorW_T[1]=1;
				}
				else
					if(j==2)
					{
						SpectraLength_T[2]=range;
						SpectraColorR_T[2]=0;
						SpectraColorG_T[2]=255;
						SpectraColorB_T[2]=0;
						SpectraColorW_T[2]=1;
					}
					else
						if(j==3)
						{
							SpectraLength_T[3]=range;
							SpectraColorR_T[3]=0;
							SpectraColorG_T[3]=0;
							SpectraColorB_T[3]=255;
							SpectraColorW_T[3]=1;
						}
						else
							if(j==4)
							{
								SpectraLength_T[4]=range;
								SpectraColorR_T[4]=155;
								SpectraColorG_T[4]=155;
								SpectraColorB_T[4]=0;
								SpectraColorW_T[4]=1;
							}
							else
							{
								SpectraLength_T[j]=range;
								SpectraColorR_T[j]=0;
								SpectraColorG_T[j]=0;
								SpectraColorB_T[j]=0;
								SpectraColorW_T[j]=1;
							}

			SpectraLength_T[NScans]=-1;
			if(Fast==false)//all pixels
			{
				for(i=0;i<=MaxXT;i++)
				{
					if(SpecToGet==0)	tmp1=Spectra[j*4096+i];
					else				tmp1=Spectra1[j*4096+i];
					SpectraData_T[j*range+i]=tmp1;
					SpectraWavelength_T[j*range+i]=Xscl_lmbd[i];
				}
			}
			else//Fast=true; half of the pixels
			{
				for(i=0;i<=3652/2;i++)
				{
					if(SpecToGet==0)	tmp1=Spectra[j*4096+i];
					else				tmp1=Spectra1[j*4096+i];

					SpectraData_T[i+j*range]=tmp1;
					SpectraWavelength_T[i+j*range]=Xscl_lmbd[2*i];
				}
			}
		}
	}

	if(GaussAppr==true)
	{
		for(i=0;i<=3652;i++)
		{
			Data[i]=SpectraData_T[i];
			Spec[i]=SpectraWavelength_T[i];
		}
		GaussT(3652);
		for(i=0;i<=3652;i++)
		{
			SpectraData_T[GaussIndex+i]=GaussData[i];
			SpectraWavelength_T[GaussIndex+i]=SpectraWavelength_T[i];
		}
	}

	if(AutoY==true)
	{
		MinY=-1;
		MaxY=-1;
	}
	TDGraph(&dc_Frame,
		SN_T,
		lmbdMin,
		lmbdMax,
		MinY,
		MaxY,
		SpectraData_T,
		SpectraWavelength_T,
		SpectraLength_T,
		SpectraColorR_T,
		SpectraColorG_T,
		SpectraColorB_T,
		SpectraColorW_T);

	dc.BitBlt(0,0,rect.right,rect.bottom,&dc_Frame,0,0,SRCCOPY);

	if(GaussAppr==true)
	{
		sprintf(Out.GetBuffer(160),"center: %.2f nm",X0_V);
		Out.ReleaseBuffer();
		i=Out.GetLength();		
		dc.TextOut(width-Xmargin_right-150,Ymargin_top+20,Out);

		sprintf(Out.GetBuffer(160),"Width %.2f nm",0.48*dX_V);
		Out.ReleaseBuffer();
		i=Out.GetLength();		
		dc.TextOut(width-Xmargin_right-150,Ymargin_top+40,Out);
	}

	CPen GreenPen1	(PS_SOLID, 1, RGB(0,128,128));
	dc.SelectObject(&GreenPen1);
	if(ShowMaxInt==true)
	{
		double mnY=10000000;//min
		double mxY=-10000000;//max
		int indT=0;
		for(i=0;i<=SpectraLength_T[0];i++)
		{
			if((SpectraWavelength_T[i]>=lmbdMin)&(SpectraWavelength_T[i]<=lmbdMax))
			{
				if(mxY<SpectraData_T[i])
				{
					mxY=SpectraData_T[i];
					indT=i;
				}
			}
		}
		ref_line_index=indT;
	}
	ref_line_pos=Xmargin_left+(width-Xmargin_right-Xmargin_left)*(SpectraWavelength_T[ref_line_index]-lmbdMin)/(lmbdMax-lmbdMin);
	dc.MoveTo(ref_line_pos,Ymargin_top+4);
	dc.LineTo(ref_line_pos,high-Ymargin_bottom-4);

	sprintf(Out.GetBuffer(16),"%.2f nm",SpectraWavelength_T[ref_line_index]);
	Out.ReleaseBuffer();
	i=Out.GetLength();

	if(ref_line_pos<=(int)(width/2))		
		dc.TextOut(ref_line_pos+5,Ymargin_top+20,Out);
	else
		dc.TextOut(ref_line_pos-i*8,Ymargin_top+20,Out);

	if(MinRef_or_DevRef==3)
	{
		if(SpecToGet==0)	
		{
			if(Fast==false)
			{
				sprintf(Out.GetBuffer(48),"y: %.3f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
			else
			{
				sprintf(Out.GetBuffer(48),"y: %.3f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
		}
		else
		{
			if(Fast==false)
			{
				sprintf(Out.GetBuffer(48),"y: %.3f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
			else
			{
				sprintf(Out.GetBuffer(48),"y: %.3f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
		}
	}
	else
	{
		if(SpecToGet==0)
		{
			if(Fast==false)
			{
				sprintf(Out.GetBuffer(48),"y: %.2f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
			else
			{
				sprintf(Out.GetBuffer(48),"y: %.2f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
		}
		else
		{
			if(Fast==false)
			{
				sprintf(Out.GetBuffer(48),"y: %.2f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
			else
			{
				sprintf(Out.GetBuffer(48),"y: %.2f",SpectraData_T[ref_line_index]);
				tmp1=SpectraData_T[ref_line_index];
			}
		}
	}
	Out.ReleaseBuffer();

	if((tmp1>=MinY)&(tmp1<=MaxY))
	{
		dc.MoveTo(Xmargin_left+1,Ymargin_top+(MaxY-tmp1)*(high-Ymargin_top-Ymargin_bottom)/(MaxY-MinY));
		dc.LineTo(width-Xmargin_right-1,Ymargin_top+(MaxY-tmp1)*(high-Ymargin_top-Ymargin_bottom)/(MaxY-MinY));
	}


	if(XYZ_CRI_calibr==true)
	{
		if(Fast==false)//all pixels
		{
			if(SpecToGet==0)	 IrradRef=Spectra[ref_line_index]*ColorNorm[ref_line_index]/ExpCorrect;//((ExpN-1)*475+2332);
			else				IrradRef=Spectra1[ref_line_index]*ColorNorm[ref_line_index]/ExpCorrect;//((ExpN-1)*475+2332);
		}
		else//Fast=true; half of the pixels
		{
			if(SpecToGet==0)	IrradRef=Spectra[ref_line_index]*ColorNorm[2*ref_line_index]/ExpCorrect;//((ExpN-1)*475+2332);
			else			   IrradRef=Spectra1[ref_line_index]*ColorNorm[2*ref_line_index]/ExpCorrect;//((ExpN-1)*475+2332);
		}
	}

	if(LeftBot==true)
	{
		CPen RedPen1	(2, 1, RGB(255,0,0));
		dc.SelectObject(&RedPen1);
		dc.MoveTo(zoomUpX+Xmargin_left,zoomUpY+Ymargin_top);
		dc.LineTo(zoomUpX+Xmargin_left,zoomDownY+Ymargin_top);
		dc.LineTo(zoomDownX+Xmargin_left,zoomDownY+Ymargin_top);
		dc.LineTo(zoomDownX+Xmargin_left,zoomUpY+Ymargin_top);
		dc.LineTo(zoomUpX+Xmargin_left,zoomUpY+Ymargin_top);
	}

	if(XYSpace==true)
	{
		CBitmap bmp, *poldbmp;
		CDC memdc;
		bmp.LoadBitmap(IDB_BITMAPPLANC);
		memdc.CreateCompatibleDC(pDC);
		poldbmp = memdc.SelectObject(&bmp);
		memdc.Rectangle(113+(1258-113)*Xcolor/0.8-15,1337-(1337-50)*Ycolor/0.9-15,113+(1258-113)*Xcolor/0.8+15,1337-(1337-50)*Ycolor/0.9+15);
		dc.StretchBlt( Xmargin_left+5, Ymargin_top+5, (int)((width-Xmargin_left-Xmargin_right)/colorSize),(int)((width-Xmargin_left-Xmargin_right)/colorSize)*1462/1300, 
                     &memdc, 0, 0, 1300-1, 1462-1,
                     SRCCOPY );

		memdc.SelectObject(poldbmp);
	}

////////////////
	
	if(XYSpace==true)
	{
		LOGFONT logFont;
		CFont font;
		logFont.lfHeight=(int)(80/colorSize);
		logFont.lfWidth = (int)(40/colorSize);
		logFont.lfEscapement = 0;//-10*15;
		logFont.lfOrientation = 0;//-10*15;
		logFont.lfWeight = FW_BOLD;
		logFont.lfItalic = TRUE;
		logFont.lfUnderline = false;
		logFont.lfStrikeOut = false;
		logFont.lfCharSet = ANSI_CHARSET;
		logFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
		logFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		logFont.lfQuality = DEFAULT_QUALITY;
		logFont.lfPitchAndFamily = FF_DONTCARE;
		strcpy(logFont.lfFaceName, "Courier New");


		font.CreateFontIndirect( &logFont);
		CFont* oldFont = dc.SelectObject( &font);
		
		sprintf(Out.GetBuffer(32),"x = %.2f",Xcolor);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30),Out);
	
		sprintf(Out.GetBuffer(32),"y = %.2f",Ycolor);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(30*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"z = %.2f",Zcolor);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(60*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"u = %.2f",Ucolor);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(90*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"v = %.2f",Vcolor);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(120*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"T = %.0f",CRI_Results[5]);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(150*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"DC=%.0E",CRI_Results[6]);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5)),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(180*3.5/colorSize),Out);

//		CRI_Results[21]=R[1];
//		CRI_Results[34]=R[14];
		for(i=1;i<=7;i++)
		{
			sprintf(Out.GetBuffer(32),"R%d=%0.f",i,CRI_Results[20+i]);
			Out.ReleaseBuffer();
			dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5))+(int)(110*3.5/colorSize),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(30*(i-1)*3.5/colorSize),Out);

			sprintf(Out.GetBuffer(32),"R%d=%.0f",i+7,CRI_Results[27+i]);
			Out.ReleaseBuffer();
			dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5))+(int)(180*3.5/colorSize),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(30*(i-1)*3.5/colorSize),Out);
		}
		sprintf(Out.GetBuffer(32),"CRI Ra(1-8)=%.1f",CRI_Results[35]);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5))+(int)(180*3.5/colorSize),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(30*7*3.5/colorSize),Out);

		sprintf(Out.GetBuffer(32),"CRI Re(1-14)=%.1f",CRI_Results[36]);
		Out.ReleaseBuffer();
		dc.TextOut(Xmargin_left+(int)((width-Xmargin_left-Xmargin_right)/(colorSize*1.5))+(int)(180*3.5/colorSize),Ymargin_top+(int)((high-Ymargin_top-Ymargin_bottom)/30)+(int)(30*8*3.5/colorSize),Out);

			
		dc.SelectObject( oldFont);
		font.DeleteObject();
	}

//	bool	CalcEnDistr;
//	double	LowRange;
//	double	UpperRange;
//	double	LowRange1;
//	double	UpperRange1;
//	double	LowRange2;
//	double	UpperRange2;
//	double	LowRange3;
//	double	UpperRange3;

	double tmpConc;
	if(ref_line_pos<=(int)(width/2))
	{
		dc.TextOut(ref_line_pos+5,Ymargin_top+35,Out);
		if(XYZ_CRI_calibr==true)
		{
			sprintf(Out.GetBuffer(1000),"uW/cm^2/nm:");
			dc.TextOut(ref_line_pos+5,Ymargin_top+65,Out);
			sprintf(Out.GetBuffer(1000),"%.2E",IrradRef);
			dc.TextOut(ref_line_pos+5,Ymargin_top+85,Out);
		}
		if((MinRef_or_DevRef==3) && (ConcentrationSet==true))
		{
			if(SpecToGet==0)	tmpConc=Spectra[ref_line_pixel]/(MolExt*CuvLength);
			else				tmpConc=Spectra1[ref_line_pixel]/(MolExt*CuvLength);
			sprintf(Out.GetBuffer(16),"concentration: %.3f",tmpConc);
			Out.ReleaseBuffer();
			dc.TextOut(ref_line_pos+5,Ymargin_top+60,Out);
		}
	}
	else
	{
		dc.TextOut(ref_line_pos-i*8,Ymargin_top+35,Out);
		if(XYZ_CRI_calibr==true)
		{
			sprintf(Out.GetBuffer(1000),"uW/cm^2/nm:");
			i=Out.GetLength();
			dc.TextOut(ref_line_pos-i*10,Ymargin_top+65,Out);
			sprintf(Out.GetBuffer(1000),"%.2E",IrradRef);
			i=Out.GetLength();
			dc.TextOut(ref_line_pos-(i+1)*10,Ymargin_top+85,Out);
		}
		if((MinRef_or_DevRef==3) && (ConcentrationSet==true))
		{
			if(SpecToGet==0)	tmpConc=Spectra[ref_line_pixel]/(MolExt*CuvLength);
			else				tmpConc=Spectra1[ref_line_pixel]/(MolExt*CuvLength);
			sprintf(Out.GetBuffer(16),"concentration: %.3f",tmpConc);
			Out.ReleaseBuffer();
			dc.TextOut(ref_line_pos-i*8,Ymargin_top+60,Out);
		}
	}


	if((CalcEnDistr==true)&&(Fast==false))//all pixels
	{
		double Integral_TotRange=0;
		double Integral_Range1=0;
		double Integral_Range2=0;
		double Integral_Range3=0;
		double DeltaLambdaAveraged=Xscl_lmbd[(int)(TotPix/2)+1]-Xscl_lmbd[(int)(TotPix/2)];
	
		for(i=0;i<=MaxX;i++)
		{
			if((Xscl_lmbd[i]>=LowRange)&&(Xscl_lmbd[i]<=UpperRange))
			{
				if(SpecToGet==0)	Integral_TotRange+=Spectra[i]*ColorNorm[i]/DeltaLambdaAveraged;
				else				Integral_TotRange+=Spectra1[i]*ColorNorm[i]/DeltaLambdaAveraged;
			}
			if((Xscl_lmbd[i]>=LowRange1)&&(Xscl_lmbd[i]<=UpperRange1))
			{
				if(SpecToGet==0)	Integral_Range1+=Spectra[i]*ColorNorm[i]/DeltaLambdaAveraged;
				else				Integral_Range1+=Spectra1[i]*ColorNorm[i]/DeltaLambdaAveraged;
			}
			if((Xscl_lmbd[i]>=LowRange2)&&(Xscl_lmbd[i]<=UpperRange2))
			{
				if(SpecToGet==0)	Integral_Range2+=Spectra[i]*ColorNorm[i]/DeltaLambdaAveraged;
				else				Integral_Range2+=Spectra1[i]*ColorNorm[i]/DeltaLambdaAveraged;
			}
			if((Xscl_lmbd[i]>=LowRange3)&&(Xscl_lmbd[i]<=UpperRange3))
			{
				if(SpecToGet==0)	Integral_Range3+=Spectra[i]*ColorNorm[i]/DeltaLambdaAveraged;
				else				Integral_Range3+=Spectra1[i]*ColorNorm[i]/DeltaLambdaAveraged;
			}
		}

		if(Integral_TotRange>0)
		{
			Integral_TotRange =Integral_TotRange /ExpCorrect;// /Integral_TotRange
			Integral_Range1=Integral_Range1/ExpCorrect;//Range1
			Integral_Range2=Integral_Range2/ExpCorrect;//Range2
			Integral_Range3=Integral_Range3/ExpCorrect;//Range3

			if(XYZ_CRI_calibr==true)	sprintf(Out.GetBuffer(32),"Energy: uW/cm^2");
			else				sprintf(Out.GetBuffer(32),"Energy:");
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+20,Out);

			sprintf(Out.GetBuffer(32),"Total Range: %.2E",Integral_TotRange);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+50,Out);
			sprintf(Out.GetBuffer(32),"%.0f-%0.f",LowRange,UpperRange);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+70,Out);

			sprintf(Out.GetBuffer(32),"Range1: %.2E",Integral_Range1);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+100,Out);
			sprintf(Out.GetBuffer(32),"%.0f-%0.f",LowRange1,UpperRange1);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+120,Out);

			sprintf(Out.GetBuffer(32),"Range2: %.2E",Integral_Range2);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+150,Out);
			sprintf(Out.GetBuffer(32),"%.0f-%0.f",LowRange2,UpperRange2);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+170,Out);

			sprintf(Out.GetBuffer(32),"Range3: %.2E",Integral_Range3);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+200,Out);
			sprintf(Out.GetBuffer(32),"%.0f-%0.f",LowRange3,UpperRange3);
			Out.ReleaseBuffer();
			dc.TextOut(width-Xmargin_left-150,Ymargin_top+220,Out);
		}

	}

	pDC->BitBlt(0,0,rect.right,rect.bottom,&dc,0,0,SRCCOPY);

	dc.SelectObject(OldPen);

///////////////////

	dc.SelectObject(&OldBitmap1);
	dc.DeleteDC();
	dc_Frame.SelectObject(&OldBitmap2);
	dc_Frame.DeleteDC();

//	if(sendOne==true)
//	{
//		OnOne();
//		sendOne=false;
//	}	
}

/////////////////////////////////////////////////////////////////////////////
// CCheckTrView printing

BOOL CCheckTrView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CCheckTrView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCheckTrView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CCheckTrView diagnostics

#ifdef _DEBUG
void CCheckTrView::AssertValid() const
{
	CView::AssertValid();
}

void CCheckTrView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCheckTrDoc* CCheckTrView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCheckTrDoc)));
	return (CCheckTrDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCheckTrView message handlers

LRESULT CCheckTrView::Mes_Anal(WPARAM,LPARAM)	//recieve message from Thread
{
	int k1;
	int i;
	if(mesage_to==5)
	{
		if(conn_Dev==0) ::MessageBox(0,"Can not find device","Error",MB_OK|MB_SYSTEMMODAL);
		else
		{
			SendMessage(20);//read flash
		}
			
	}
	else
		if(mesage_to==20)//loading calibration
		{
			if(InfoString[5]=='.')	//all calibration is loaded
			{
				CString Out;
				CString File_Name;
				EnergyCorrect=bck_a;
				if(Xscl_lmbd[1]>Xscl_lmbd[0])
					SclDir=true;
				else
				{
					SclDir=false;
					double tmp_norm1;
					for(i=0;i<=TotPix/2;i++)
					{
						tmp_norm1=NormS[i];
						NormS[i]=NormS[TotPix-i];
						NormS[TotPix-i]=tmp_norm1;
						tmp_norm1=ColorNorm[i];
						ColorNorm[i]=ColorNorm[TotPix-i];
						ColorNorm[TotPix-i]=tmp_norm1;
						tmp_norm1=Xscl_lmbd[i];
						Xscl_lmbd[i]=Xscl_lmbd[TotPix-i];
						Xscl_lmbd[TotPix-i]=tmp_norm1;
					}
				}
					//checking calibration file
				try
				{
					File_Name.Format(".clbr");
					CFile* lpOutFile;
					for(i=15;i>=10;i--)
					{
						File_Name.Insert(0,InfoString[i]);
					}
					lpOutFile=new CFile(File_Name,CFile::modeRead|CFile::shareDenyNone);
				}
				catch(...)
				{
				//	no calibration file
					SaveCalibrationAskUser=false;
					OnSaveCalibration();
				}
			}
			else //no calibration information in FLASH
			{
				::MessageBox(0,"Calibration information was not located in your spectrometer.\n Load it from hard drive (file with '.clbr' extension)","Warning",MB_OK|MB_SYSTEMMODAL);
				OnLoadCalibration();
			}
			CMainFrame *cFrame	= reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
			CButton *pRun		= reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
			pRun->EnableWindow(true);
			if(InfoString[10]=='Y')
			{
				CButton *pXYSpace    = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_XYSPACE));
				pXYSpace->EnableWindow(true);
				XYZ_CRI_calibr=true;
			}
			else
				XYZ_CRI_calibr=false;
			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			ref_line_index=1825;
			this->Invalidate(false);//create and show BitMap
		}

	if(Run_get_spec==true)//get spectra
	{
		if(Run_get_spec==true)
		{
			OnOne();//send exposure
			this->Invalidate(false);//create and show BitMap
		}
	}
	return 0;
}

void CCheckTrView::OnMessage() //settings; exposure, show Report check
{
	bool Fst1;

	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRun   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
	if(pRun->GetCheck()==1)
	{
		pRun->SetCheck(0);
		Run_get_spec=false;//stop getting spectra
		if(AutoSave==true)
		{
			AutoSave=false;
			KillTimer(ID_CLOCK_TIMER);
			AutoNmb=0;
		}
	}

	if(AutoSave==true)
	{
		KillTimer(ID_CLOCK_TIMER);
		AutoSave=false;
	}

	Fst1=Fast;

	CString Out;
	sprintf(Out.GetBuffer(16),"%.3f",double(ExpN)/100);
	Out.ReleaseBuffer();

	CExpTime ExpDlg;
	ExpDlg.m_ExpTime=Out;
	ExpDlg.m_Check=ShowReport;
	ExpDlg.m_Test=Test;
	ExpDlg.m_Trigger=Trigger;
	ExpDlg.m_KeepTrigger=KeepTrigger;
	ExpDlg.m_Average=Average;
	ExpDlg.m_Fast=Fast;
	ExpDlg.m_ColBar=ColBar;
	ExpDlg.m_ApplNorm=applyNorm;
	ExpDlg.m_ApplCal=applyCal;
	ExpDlg.m_ShowMaxInt=ShowMaxInt;
	ExpDlg.m_CalcDistr=CalcEnDistr;
	ExpDlg.m_AutoSave=AutoSave;
	ExpDlg.m_AutoSave1=AutoSave1;
	ExpDlg.m_AutoSave2=AutoSave2;
	ExpDlg.m_AutoSave3=AutoSave3;
	ExpDlg.m_AutoSave4=AutoSave4;
	ExpDlg.m_IrradiationCorrectionSaveToFlash=false;
	ExpDlg.m_Gauss=GaussAppr;

	sprintf(Out.GetBuffer(16),"%.1f",LowRange);
	Out.ReleaseBuffer();
	ExpDlg.m_LowRange=Out;

	
	sprintf(Out.GetBuffer(16),"%d",AutoMinutes);
	Out.ReleaseBuffer();
	ExpDlg.m_AutoMinutes=Out;

	sprintf(Out.GetBuffer(16),"%.1f",UpperRange);
	Out.ReleaseBuffer();
	ExpDlg.m_UpperRange=Out;

	sprintf(Out.GetBuffer(16),"%.1f",LowRange1);
	Out.ReleaseBuffer();
	ExpDlg.m_LowRange1=Out;

	sprintf(Out.GetBuffer(16),"%.1f",UpperRange1);
	Out.ReleaseBuffer();
	ExpDlg.m_UpperRange1=Out;

	sprintf(Out.GetBuffer(16),"%.1f",LowRange2);
	Out.ReleaseBuffer();
	ExpDlg.m_LowRange2=Out;

	sprintf(Out.GetBuffer(16),"%.1f",UpperRange2);
	Out.ReleaseBuffer();
	ExpDlg.m_UpperRange2=Out;

	sprintf(Out.GetBuffer(16),"%.1f",LowRange3);
	Out.ReleaseBuffer();
	ExpDlg.m_LowRange3=Out;

	sprintf(Out.GetBuffer(16),"%.1f",UpperRange3);
	Out.ReleaseBuffer();
	ExpDlg.m_UpperRange3=Out;

	sprintf(Out.GetBuffer(16),"%.2E",EnergyCorrect);
	Out.ReleaseBuffer();
	ExpDlg.m_EnergyCorrect=Out;

	sprintf(Out.GetBuffer(16),"%d",Blank);
	Out.ReleaseBuffer();
	ExpDlg.m_Blank=Out;

	sprintf(Out.GetBuffer(16),"%d",NScans);
	Out.ReleaseBuffer();
	ExpDlg.m_NScans=Out;

	sprintf(Out.GetBuffer(16),"%d",TotStartPix);
	Out.ReleaseBuffer();
	ExpDlg.m_TotStartPix=Out;

	sprintf(Out.GetBuffer(16),"%d",TotEndPix);
	Out.ReleaseBuffer();
	ExpDlg.m_TotEndPix=Out;

	bool GaussApprOld=GaussAppr;

	if(ExpDlg.DoModal()==IDOK)
	{
		ExpN=(int)(atof(ExpDlg.m_ExpTime)*100);
		if(ExpN>10000000)	ExpN=10000000;
		if(ExpN<0)		ExpN=0;

		ShowReport=(bool)(ExpDlg.m_Check);
		Test=ExpDlg.m_Test;
		applyNorm=ExpDlg.m_ApplNorm;
		Blank=atoi(ExpDlg.m_Blank);
		NScans=atoi(ExpDlg.m_NScans);
		Trigger=ExpDlg.m_Trigger;
		ColBar=ExpDlg.m_ColBar;
		KeepTrigger=ExpDlg.m_KeepTrigger;
		TotStartPix=atoi(ExpDlg.m_TotStartPix);
		TotEndPix=atoi(ExpDlg.m_TotEndPix);
		Average=ExpDlg.m_Average;
		ShowMaxInt=ExpDlg.m_ShowMaxInt;
		if(NScans>60)	NScans=60;
		if(NScans<1)	NScans=1;
		applyCal=ExpDlg.m_ApplCal;
		if(applyCal==false)
		{
			SclDir=true;
			int i;
			for(i=0;i<=TotPix;i++)
			Xscl_lmbd[i]=i;
		}
		Fast=ExpDlg.m_Fast;
		CalcEnDistr=ExpDlg.m_CalcDistr;
		LowRange=atof(ExpDlg.m_LowRange);
		LowRange1=atof(ExpDlg.m_LowRange1);
		LowRange2=atof(ExpDlg.m_LowRange2);
		LowRange3=atof(ExpDlg.m_LowRange3);
		UpperRange=atof(ExpDlg.m_UpperRange);
		UpperRange1=atof(ExpDlg.m_UpperRange1);
		UpperRange2=atof(ExpDlg.m_UpperRange2);
		UpperRange3=atof(ExpDlg.m_UpperRange3);
		AutoSave=ExpDlg.m_AutoSave;
		AutoMinutes=atof(ExpDlg.m_AutoMinutes);
		AutoSave1=ExpDlg.m_AutoSave1;
		AutoSave2=ExpDlg.m_AutoSave2;
		AutoSave3=ExpDlg.m_AutoSave3;
		AutoSave4=ExpDlg.m_AutoSave4;
		GaussAppr=ExpDlg.m_Gauss;

		EnergyCorrect=atof(ExpDlg.m_EnergyCorrect);
		bck_a=EnergyCorrect;
		ExpCorrect=ExpN*EnergyCorrect;

		if(AutoSave==false)	KillTimer(ID_CLOCK_TIMER);
		else
		{
			::MessageBox(0,"Save First Spectra","Information",MB_OK|MB_SYSTEMMODAL);
			AutoSaveSpec();
			SetTimer(ID_CLOCK_TIMER, 1000*AutoMinutes, NULL);
		}

		CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
		CButton *pFast   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_FAST));
		pFast->SetCheck((int)(Fast));
		CButton *pAveraging   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
		pAveraging->SetCheck((int)(Average));

		CEdit *pEditExposure    = reinterpret_cast<CEdit *>(cFrame->m_wndChartBar.GetDlgItem(IDC_EXPOS));
		CEdit *pEditAverage   = reinterpret_cast<CEdit *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVEDIT));
		CString Out;
		sprintf(Out.GetBuffer(16),"%.3f",double(ExpN)/100);
		Out.ReleaseBuffer();
		pEditExposure->SetWindowText(Out);

		sprintf(Out.GetBuffer(16),"%d",NScans);
		Out.ReleaseBuffer();
		pEditAverage->SetWindowText(Out);

		if(ExpDlg.m_IrradiationCorrectionSaveToFlash==true) CalibrationCoeffToMemory();

		if(GaussAppr==true)
		{
			if(GaussApprOld==false)
			{
				int i,k=0;
				GaussIndex=0;
				while(SpectraLength_T[k]!=-1)
				{
					GaussIndex+=SpectraLength_T[k];
					k++;
				}
				SpectraLength_T[k]=3651;
				SpectraLength_T[k+1]=-1;
				SpectraColorR_T[k]=255;
				SpectraColorG_T[k]=0;
				SpectraColorB_T[k]=0;
				SpectraColorW_T[k]=1;
				for(i=0;i<=3652;i++)
				{
					Data[i]=SpectraData_T[i];
					Spec[i]=SpectraWavelength_T[i];
				}
				k=0;
				GaussT(3652);
				for(i=0;i<=3652;i++)
				{
					SpectraData_T[GaussIndex+i]=GaussData[i];
					SpectraWavelength_T[GaussIndex+i]=SpectraWavelength_T[i];
				}
			}
		}
		else
		{
			//remove gauss
		}
	}
	this->Invalidate(false);//create and show BitMap
}

void CCheckTrView::SendMessage(int mesage) //send message to Thread
{
	mesage_to=mesage;
	pThread->PostThreadMessage(WM_USRMSGTO,NULL,NULL);
}

void CCheckTrView::OnGetspeck() 
{
	if(SpecToGet==0) SpecToGet=1;//get to Spectra1
	else SpecToGet=0;//get to Spectra

	SendMessage(2);//get spactra
}

void CCheckTrView::OnOne() 
{
	int ExpNTmp=ExpN;
	int NScansTmp=NScans;

	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CEdit *pEditExposure    = reinterpret_cast<CEdit *>(cFrame->m_wndChartBar.GetDlgItem(IDC_EXPOS));
	CEdit *pEditAverage   = reinterpret_cast<CEdit *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVEDIT));
	CStatic *pExpText    = reinterpret_cast<CStatic *>(cFrame->m_wndChartBar.GetDlgItem(IDC_EXPTEXT));
	CString Out;

	ExpTimerCount=0;

	pEditExposure->GetWindowText(Out);
	ExpN=(int)(100*atof(Out));
	if(ExpN>3000000)	ExpN=3000000;
	if(ExpN<0)		ExpN=0;
	ExpCorrect=EnergyCorrect*ExpN;

		sprintf(Out.GetBuffer(16),"%.3f",double(ExpN)/100);
		Out.ReleaseBuffer();
		pExpText->SetWindowText(Out);

	pEditAverage->GetWindowText(Out);
	NScans=atoi(Out);
	if(NScans>65)	NScans=64;
	if(NScans<1)	NScans=1;
	if(NScansTmp!=NScans)
	{
		sprintf(Out.GetBuffer(16),"%d",NScans);
		Out.ReleaseBuffer();
		pEditAverage->SetWindowText(Out);
	}
	DataOut[1]=1;
	DataOut[2]=ExpN;	//low
	DataOut[7]=ExpN>>8;	//high
	DataOut[3]=NScans;	//nmbScans
	DataOut[4]=Blank;	//blanc scans number
	DataOut[5]=1;		//was average
	if(Trigger==false)
		DataOut[6]=0;
	else
		if(KeepTrigger==false)
			DataOut[6]=1;
		else DataOut[6]=3;

	SendMessage(1);//start scan and return spectra 		
}

void CCheckTrView::OnRun() 
{
	reset=true;
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRun   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
	if(pRun->GetCheck()==0)
	{
		Run_get_spec=false;//stop getting spectra
		if(AutoSave==true)
		{
			AutoSave=false;
			KillTimer(ID_CLOCK_TIMER);
			KillTimer(ID_CLOCK_TIMER+1);
			AutoNmb=0;
		}
	}
	else
	{
		toDetach=0;
		Run_get_spec=true;//start getting spectra
		ShowReport=false;
		StartEx=true;
		SetTimer(ID_CLOCK_TIMER+1, 100, NULL);
		OnOne();//start exposure
	}
}

void CCheckTrView::OnThree() 
{
	DataOut[1]=3;
	SendMessage(0);		
}

void CCheckTrView::OnTwo() 
{
	DataOut[1]=2;
	SendMessage(0);		
}

void CCheckTrView::OnZerro() 
{
	DataOut[1]=241;//0xF1;
	StartEx=false;
	SendMessage(0);	
}

void CCheckTrView::OnMoveAddress() //Eight
{
	DataOut[1]=8;
//	DataOut[2]=Move_address;
	SendMessage(0);	
}

void CCheckTrView::OnCalibration() 
{
/*	if(StartEx==false && Run_get_spec==true)//no run getting spectra
	{
		MessageBox("Stop Acquisition","Request",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		CString Out;
		CCalibration ClDlg;

		sprintf(Out.GetBuffer(16),"%e",coeff_A);
		Out.ReleaseBuffer();
		ClDlg.m_A=Out;

		sprintf(Out.GetBuffer(16),"%e",coeff_B);
		Out.ReleaseBuffer();
		ClDlg.m_B=Out;

		sprintf(Out.GetBuffer(16),"%e",coeff_C);
		Out.ReleaseBuffer();
		ClDlg.m_C=Out;
		if(ClDlg.DoModal()==IDOK)//write to memory
		{
			coeff_A=atof(ClDlg.m_A);
			coeff_B=atof(ClDlg.m_B);
			coeff_C=atof(ClDlg.m_C);
//			CalibrationCoeffToMemory();
//			Sleep(1000);
		}
	}
*/
}

void CCheckTrView::CalibrationCoeffToMemory()
{
/*	CString Out;
	int tmL,i;
			sprintf(Out.GetBuffer(16),"%.6e",coeff_A);
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<16;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[i]	=	(int)(Out.GetAt(i));
					else		Spectra1[i]	=	0;
				else
					if(i<tmL)	Spectra[i]	=	(int)(Out.GetAt(i));
					else		Spectra[i]	=	0;
			}
			sprintf(Out.GetBuffer(16),"%.6e",coeff_B);
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<16;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[16+i]	=	(int)(Out.GetAt(i));
					else		Spectra1[16+i]	=	0;
				else
					if(i<tmL)	Spectra[16+i]	=	(int)(Out.GetAt(i));
					else		Spectra[16+i]	=	0;
			}
			sprintf(Out.GetBuffer(16),"%.6e",coeff_C);
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<16;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[32+i]	=	(int)(Out.GetAt(i));
					else		Spectra1[32+i]	=	0;
				else
					if(i<tmL)	Spectra[32+i]	=	(int)(Out.GetAt(i));
					else		Spectra[32+i]	=	0;
			}
			sprintf(Out.GetBuffer(16),"%.6e",bck_a);
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<16;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[48+i]	=	(int)(Out.GetAt(i));
					else		Spectra1[48+i]	=	0;
				else
					if(i<tmL)	Spectra[48+i]	=	(int)(Out.GetAt(i));
					else		Spectra[48+i]	=	0;
			}
			sprintf(Out.GetBuffer(16),"%.6e",bck_b);
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<16;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[64+i]	=	(int)(Out.GetAt(i));
					else		Spectra1[64+i]	=	0;
				else
					if(i<tmL)	Spectra[64+i]	=	(int)(Out.GetAt(i));
					else		Spectra[64+i]	=	0;
			}
			Out=InfoString;
			Out.ReleaseBuffer();
			tmL=Out.GetLength();
			for(i=0;i<32;i++)
			{
				if(SpecToGet==0)
					if(i<tmL)	Spectra1[80+i]	=	(int)(Out.GetAt(i));
					else		Spectra1[80+i]	=	0;
				else
					if(i<tmL)	Spectra[80+i]	=	(int)(Out.GetAt(i));
					else		Spectra[80+i]	=	0;
			}

			SendMessage(3);//write coefficients

			if(coeff_B>0)
			{
				SclDir=true;
				for(i=0;i<=TotPix;i++)
				Xscl_lmbd[i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
			}
			else
			{
				SclDir=false;
				for(i=0;i<=TotPix;i++)
				Xscl_lmbd[TotPix-i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
			}
			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			ref_line_index=1825;
			this->Invalidate(false);//create and show BitMap
*/
}

void CCheckTrView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	if((point.y>(high-Ymargin_bottom))||(point.x<Xmargin_left))
		OnSetscale();
	else OnYautoscale();

	
	CView::OnLButtonDblClk(nFlags, point);
}

void CCheckTrView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if(point.x>=0&&point.x<=width&&point.y>=0&&point.y<=high)
	{
		LeftBot=true;
		zoomDownX=point.x-Xmargin_left;
		zoomDownY=point.y-Ymargin_top;
		if(zoomDownX<0) zoomDownX=0;
		if(zoomDownX+Xmargin_left>width-Xmargin_right) zoomDownX=width-(Xmargin_right+Xmargin_left);
		if(zoomDownY<0) zoomDownY=0;
		if(zoomDownY+Ymargin_top>high-Ymargin_bottom) zoomDownY=high-(Ymargin_bottom+Ymargin_top);
	}
	CView::OnLButtonDown(nFlags, point);
}

void CCheckTrView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(LeftBot==true)
	{
		if(point.x>=0&&point.x<=width&&point.y>=0&&point.y<=high)
		{
			zoomUpX=point.x-Xmargin_left;
			zoomUpY=point.y-Ymargin_top;
			if(zoomUpX<0) zoomUpX=0;
			if(zoomUpX+Xmargin_left>width-Xmargin_right) zoomUpX=width-(Xmargin_right+Xmargin_left);
			if(zoomUpY<0) zoomUpY=0;
			if(zoomUpY+Ymargin_top>high-Ymargin_bottom) zoomUpY=high-(Ymargin_bottom+Ymargin_top);

			if((abs(zoomUpX-zoomDownX)>10)&&(abs(zoomUpY-zoomDownY)>10))
			{
				int tmpXlow,tmpXhigh, tmpYlow, tmpYhigh;
				double new_lmbdMax, new_lmbdMin, new_MaxY, new_MinY;
				int tmpUpPix, tmpDwnPix;
				if(zoomUpX>zoomDownX)	
				{
					tmpXhigh=zoomUpX;
					tmpXlow=zoomDownX;
				}
				else
				{
					tmpXhigh=zoomDownX;
					tmpXlow=zoomUpX;
				}
				if(zoomUpY>zoomDownY)	
				{
					tmpYhigh=zoomUpY;
					tmpYlow=zoomDownY;
				}
				else
				{
					tmpYhigh=zoomDownY;
					tmpYlow=zoomUpY;
				}

				new_lmbdMax=lmbdMin+(lmbdMax-lmbdMin)*tmpXhigh/(width-(Xmargin_right+Xmargin_left));
				new_lmbdMin=lmbdMin+(lmbdMax-lmbdMin)*tmpXlow/(width-(Xmargin_right+Xmargin_left));
				new_MaxY=MinY+(MaxY-MinY)*(high-(Ymargin_top+Ymargin_bottom)-tmpYlow)/(high-(Ymargin_top+Ymargin_bottom));
				new_MinY=MinY+(MaxY-MinY)*(high-(Ymargin_top+Ymargin_bottom)-tmpYhigh)/(high-(Ymargin_top+Ymargin_bottom));

				tmpUpPix=Newton1(new_lmbdMax, TotPix+1,  Xscl_lmbd);//index of the new new_lmbdMax
				tmpDwnPix=Newton1(new_lmbdMin, TotPix+1,  Xscl_lmbd);//index of the new new_lmbdMin

//				if(tmpUpPix-tmpDwnPix>=30)
				{
					lmbdMax=new_lmbdMax;
					lmbdMin=new_lmbdMin;
					MaxY=new_MaxY;
					MinY=new_MinY;
				}
				LeftBot=false;
			}
		}
	}
	LeftBot=false;
	this->Invalidate(false);
	CView::OnLButtonUp(nFlags, point);
}

void CCheckTrView::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(LeftBot==true) 
	{
		if(point.x>=0&&point.x<=width&&point.y>=0&&point.y<=high)
		{
			zoomUpX=point.x-Xmargin_left;
			zoomUpY=point.y-Ymargin_top;
			if(zoomUpX<0) zoomUpX=0;
			if(zoomUpX+Xmargin_left>width-Xmargin_right) zoomUpX=width-(Xmargin_right+Xmargin_left);
			if(zoomUpY<0) zoomUpY=0;
			if(zoomUpY+Ymargin_top>high-Ymargin_bottom) zoomUpY=high-(Ymargin_bottom+Ymargin_top);
		}
		this->Invalidate(false);
	}
	CView::OnMouseMove(nFlags, point);
}

void CCheckTrView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	if(point.x>Xmargin_left&&point.x<width-Xmargin_right&&point.y>Ymargin_top&&point.y<high-Ymargin_bottom)
		botDwn=true;// TODO: Add your message handler code here and/or call default
	CView::OnRButtonDown(nFlags, point);
}

void CCheckTrView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	if(botDwn==true)
	{
		if(point.x>Xmargin_left&&point.x<width-Xmargin_right&&point.y>Ymargin_top&&point.y<high-Ymargin_bottom)
		{
			ref_line_pos=point.x;
			ref_line=lmbdMin+(lmbdMax-lmbdMin)*(ref_line_pos-Xmargin_left)/(width-Xmargin_right-Xmargin_left);
			double minDiff=10000;
				int index_add=0;
				int NumbSpecToCount=0;//number of spectra to count (0 means 1 spectra to count) to determine ref line position (for multi spectrometers connection)
				for(int i=0;i<=NumbSpecToCount;i++)
				{
					for(int j=0;j<=SpectraLength_T[i];j++)
					{
						if(fabs(ref_line-SpectraWavelength_T[j+index_add])<minDiff)
						{
							minDiff=fabs(ref_line-SpectraWavelength_T[j+index_add]);
							ref_line_index=j+index_add;
						}
					}
					index_add+=SpectraLength_T[i];
				}
				ref_line=SpectraWavelength_T[ref_line_index];
		}
		this->Invalidate(false);
		botDwn=false;
	}	
	CView::OnRButtonUp(nFlags, point);
}

void CCheckTrView::OnGetbck() 
{
	Back1=1;
	OnSbstrbck();
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pSbstrBck   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_SBSTRBCK));
	pSbstrBck->EnableWindow(true);
}

void CCheckTrView::OnFast() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pFast   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_FAST));

	RefSpectra=false;
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	pRef_min_Spec->SetCheck(0);
	pRef_min_Spec->EnableWindow(false);
	pSpec_dev_Ref->SetCheck(0);
	pSpec_dev_Ref->EnableWindow(false);
	pLog1->SetCheck(0);
	pLog1->EnableWindow(false);

	if(pFast->GetCheck()==0)
	{
		Fast=false;
	}
	else
	{
		Fast=true;
	}
	ref_line_pos=(int)(Xmargin_left+(width-Xmargin_left-Xmargin_right)*(ref_line-lmbdMin)/(lmbdMax-lmbdMin));

	this->Invalidate(false);
	Back1=0;//0 and 1 - nor assesible

	OnSbstrbck();
}

void CCheckTrView::OnSbstrbck() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pSbstrBck   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_SBSTRBCK));
	if(Back1<=1)//0 and 1 - nor assesible
	{
		pSbstrBck->SetCheck(0);
		pSbstrBck->EnableWindow(false);
		applBck=false;
	}
	else
	{
		if(pSbstrBck->GetCheck()==0)
		{
			Back1=2;
			applBck=false;
			MinRef_or_DevRef=0;
			CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
			CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
			CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
			pRef_min_Spec->SetCheck(0);
			pSpec_dev_Ref->SetCheck(0);
			pLog1->SetCheck(0);
		}
		else
		{
			Back1=3;
			applBck=true;
			MinRef_or_DevRef=0;
			CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
			CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
			CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
			pRef_min_Spec->SetCheck(0);
			pSpec_dev_Ref->SetCheck(0);
			pLog1->SetCheck(0);
		}
	}
}

void CCheckTrView::OnAveraging() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pAverage   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
	if(pAverage->GetCheck()==0)	Average=false;
	else	Average=true;
}

void CCheckTrView::OnSetscale() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRun   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
	if(pRun->GetCheck()==1)
	{
		pRun->SetCheck(0);
		Run_get_spec=false;//stop getting spectra
		if(AutoSave==true)
		{
			AutoSave=false;
			KillTimer(ID_CLOCK_TIMER);
			AutoNmb=0;
		}
	}

	double tmpYmin,tmpYmax;
	double tmpXmin,tmpXmax;
	CString Out;

//	pThread->SuspendThread();

	tmpXmin=lmbdMin;
	tmpXmax=lmbdMax;
	tmpYmin=MinY;
	tmpYmax=MaxY;

	CXYScale ExpDlg;

	sprintf(Out.GetBuffer(16),"min: %.2f nm", Xscl_lmbd[0]);
	Out.ReleaseBuffer();
	ExpDlg.m_MinXcpt=Out;

	sprintf(Out.GetBuffer(16),"max: %.2f nm", Xscl_lmbd[TotPix]);
	Out.ReleaseBuffer();
	ExpDlg.m_MaxXcpt=Out;

	sprintf(Out.GetBuffer(16),"%.2f",lmbdMax);
	Out.ReleaseBuffer();
	ExpDlg.m_MaxX=Out;

	sprintf(Out.GetBuffer(16),"%.2f",lmbdMin);
	Out.ReleaseBuffer();
	ExpDlg.m_MinX=Out;

	sprintf(Out.GetBuffer(16),"%.2f",MaxY);
	Out.ReleaseBuffer();
	ExpDlg.m_MaxY=Out;

	sprintf(Out.GetBuffer(16),"%.2f",MinY);
	Out.ReleaseBuffer();
	ExpDlg.m_MinY=Out;

	if(ExpDlg.DoModal()==IDOK)
	{
		lmbdMax=atof(ExpDlg.m_MaxX);
		lmbdMin=atof(ExpDlg.m_MinX);
		MaxY=atof(ExpDlg.m_MaxY);
		MinY=atof(ExpDlg.m_MinY);
	}
	if((tmpXmin!=lmbdMin)||(tmpXmax!=lmbdMax)||(tmpYmin!=MinY)||(tmpYmax!=MaxY))
	{
		if((tmpXmin!=lmbdMin)||(tmpXmax!=lmbdMax))	Back1=0;//0 and 1 - nor assesible
		this->Invalidate(false);
	}
//	pThread->ResumeThread();
}

void CCheckTrView::OnEditCopy() 
{
	CString Out,Out1;
	int i,j,tmp1,nmpAv2;;

//	pThread->SuspendThread();

	Out1.Empty();

	if(Average==false)	nmpAv2=NScans;
	else				nmpAv2=1;

	if(Fast==false)
	{
		for(i=0;i<=MaxX;i++)
		{
			tmp1=0;
			Out.Format("%.3f\t",Xscl_lmbd[i]);
			Out1.Insert(Out1.GetLength(),Out);

			for(j=0;j<nmpAv2;j++)
			{	
				if(SpecToGet==0)	Out.Format("%.3f\t", Spectra[j*4096+i]);
				else				Out.Format("%.3f\t", Spectra1[j*4096+i]);
				Out1.Insert(Out1.GetLength(),Out);
			}

			Out.Format("\r");//temp1='\r';
			Out1.Insert(Out1.GetLength(),Out);
			Out.Format("\n");//temp1='\n';
			Out1.Insert(Out1.GetLength(),Out);
		}
	}
	else
	{
		for(i=0;i<=(int)(MaxX/2);i++)
		{
			Out.Format("%.3f\t", Xscl_lmbd[i*2]);
			Out1.Insert(Out1.GetLength(),Out);
			tmp1=0;
			for(j=0;j<nmpAv2;j++)
			{
				if(SpecToGet==0)	Out.Format("%.3f\t", Spectra[j*4096+i]);
				else				Out.Format("%.3f\t", Spectra1[j*4096+i]);
				Out1.Insert(Out1.GetLength(),Out);
			}
			
			Out.Format("\r");//temp1='\r';
			Out1.Insert(Out1.GetLength(),Out);
			Out.Format("\n");//temp1='\n';
			Out1.Insert(Out1.GetLength(),Out);
		}
	}   
	tmp1=Out1.GetLength();

	HANDLE hglbCopy = GlobalAlloc(GMEM_MOVEABLE,tmp1);

	if(!hglbCopy)
		return;

	void* lpstr = GlobalLock(hglbCopy);
	
	if (!lpstr)
		return;

	strcpy((char*)lpstr,Out1);//strcpy((char*)lpstr,"my text bya!!!!!");

	GlobalUnlock(hglbCopy);
	lpstr=0;

	OpenClipboard();
	EmptyClipboard();

	SetClipboardData(CF_TEXT,hglbCopy);
	CloseClipboard();

//	pThread->ResumeThread();
}

void CCheckTrView::OnXyautoscale() //both x and y autoscale
{
	OnXautoscale();
	OnYautoscale();
}

void CCheckTrView::OnXautoscale() //x autoscale
{
	double mnX=10000000;//min
	double mxX=-10000000;//max
	int i;	
	int arrlength=0;
	int indT=0;
	while(SpectraLength_T[indT]!=-1)
	{
		arrlength+=SpectraLength_T[indT];
		indT++;
	}
	for(i=0;i<=arrlength;i++)
	{
		if(mnX>SpectraWavelength_T[i]) mnX=SpectraWavelength_T[i];
		if(mxX<SpectraWavelength_T[i]) mxX=SpectraWavelength_T[i];
	}
	lmbdMin=mnX;
	lmbdMax=mxX;
	//if(flag==true)
	this->Invalidate(false);
}

void CCheckTrView::OnYautoscale() //y autoscale
{
	double mnY=10000000;//min
	double mxY=-10000000;//max
	int i;	
	int arrlength=0;
	int indT=0;
	while(SpectraLength_T[indT]!=-1)
	{
		arrlength+=SpectraLength_T[indT];
		indT++;
	}
	for(i=0;i<=arrlength;i++)
	{
		if((SpectraWavelength_T[i]>=lmbdMin)&(SpectraWavelength_T[i]<=lmbdMax))
		{
			if(mnY>SpectraData_T[i]) mnY=SpectraData_T[i];
			if(mxY<SpectraData_T[i]) mxY=SpectraData_T[i];
		}
	}

	MinY=mnY-0.1*(mxY-mnY)-0.1;
	MaxY=mxY+0.1*(mxY-mnY)+0.1;
	//if(flag==true) 
	this->Invalidate(false);
}

void CCheckTrView::OnFileSave1() 
{
	OnSpecSave();
}

int CCheckTrView::Newton1(double pnt, int lng, double *arr)//find position of closest data point in double array
{
	int cnt1;
	int pos3;
	int pos1=0;
	int pos2=lng-1;
	if(arr[0]<arr[lng-1])//rising sequence
	{
		if(pnt<=arr[0])//below zerro point
		{
			cnt1=0;
		}
		else
		{
			if(pnt>=arr[lng-1])//higher lng-1 point
			{
				cnt1=lng-1;
			}
			else//between lowest and highest point
			{
				while(pos2-pos1!=1)
				{
					pos3=(pos1+pos2)/2;
					if(pnt>=arr[pos1]&&pnt<=arr[pos3])//between arr[pos1] and arr[pos3]
					{
						pos2=pos3;
					}
					else//between arr[pos3] and arr[pos2]
					{
						pos1=pos3;
					}
				}
				if(pnt-arr[pos1]<arr[pos2]-pnt)	cnt1=pos1;
				else							cnt1=pos2; 
			}
		}
	}
	else//faling sequence
	{
		if(pnt>=arr[0])//below zerro point
		{
			cnt1=0;
		}
		else
		{
			if(pnt<=arr[lng-1])//higher lng-1 point
			{
				cnt1=lng-1;
			}
			else//between lowest and highest point
			{
				while(pos2-pos1!=1)
				{
					pos3=(pos1+pos2)/2;
					if(pnt<=arr[pos1]&&pnt>=arr[pos3])//between arr[pos1] and arr[pos3]
					{
						pos2=pos3;
					}
					else//between arr[pos3] and arr[pos2]
					{
						pos1=pos3;
					}
				}
				if(arr[pos1]-pnt<pnt-arr[pos2])	cnt1=pos1;
				else							cnt1=pos2; 
			}
		}
	}
	return cnt1;
}

int CCheckTrView::Newton2(int pnt, int str1, int end1, int *arr)//find position of closest data point in int array
{
	int cnt1;
	int pos3;
	int pos1=str1;
	int pos2=end1;
	if(arr[str1]<arr[end1])//rising sequence
	{
		if(pnt<=arr[str1])//below zerro point
		{
			cnt1=str1;
		}
		else
		{
			if(pnt>=arr[end1])//higher lng-1 point
			{
				cnt1=end1;
			}
			else//between lowest and highest point
			{
				while(pos2-pos1!=1)
				{
					pos3=(pos1+pos2)/2;
					if(pnt>=arr[pos1]&&pnt<=arr[pos3])//between arr[pos1] and arr[pos3]
					{
						pos2=pos3;
					}
					else//between arr[pos3] and arr[pos2]
					{
						pos1=pos3;
					}
				}
				if(pnt-arr[pos1]<arr[pos2]-pnt)	cnt1=pos1;
				else							cnt1=pos2; 
			}
		}
	}
	else//faling sequence
	{
		if(pnt>=arr[str1])//below zerro point
		{
			cnt1=str1;
		}
		else
		{
			if(pnt<=arr[end1])//higher lng-1 point
			{
				cnt1=end1;
			}
			else//between lowest and highest point
			{
				while(pos2-pos1!=1)
				{
					pos3=(pos1+pos2)/2;
					if(pnt<=arr[pos1]&&pnt>=arr[pos3])//between arr[pos1] and arr[pos3]
					{
						pos2=pos3;
					}
					else//between arr[pos3] and arr[pos2]
					{
						pos1=pos3;
					}
				}
				if(arr[pos1]-pnt<pnt-arr[pos2])	cnt1=pos1;
				else							cnt1=pos2; 
			}
		}
	}
	return cnt1;
}

void CCheckTrView::OnSpecSave() 
{
	if(AutoSave==true)
	{
		KillTimer(ID_CLOCK_TIMER);
		AutoSave=false;
	}

	CWinApp* pApp=AfxGetApp();
	CString Out;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			int tmpTXT=File_Name.Find(".txt",0);
			if(tmpTXT==-1)
			{
				Out.Format(".txt");
				File_Name.Insert(File_Name.GetLength(),Out);
			}
			SaveSpec1(File_Name);//One nm step
		}
		catch(...)
		{
			MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	}
}

void CCheckTrView::OnFileSaveOne() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRun   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
	if(pRun->GetCheck()==1)
	{
		pRun->SetCheck(0);
		Run_get_spec=false;//stop getting spectra
		if(AutoSave==true)
		{
			AutoSave=false;
			KillTimer(ID_CLOCK_TIMER);
			AutoNmb=0;
		}
	}

	if(AutoSave==true)
	{
		KillTimer(ID_CLOCK_TIMER);
		AutoSave=false;
	}

	CWinApp* pApp=AfxGetApp();
	CString Out;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			int tmpTXT=File_Name.Find(".txt",0);
			if(tmpTXT==0)
			{
				Out.Format(".txt");
				File_Name.Insert(File_Name.GetLength(),Out);
			}
			SaveSpec3(File_Name);//One nm step
		}
		catch(...)
		{
			MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	}	
}

void CCheckTrView::SaveSpec1(CString File_Name)//OnSpecSave
{
	CFile* lpOutFile;
	int i,j,tmp1,nmpAv2;
	CString Out;
	char temp1;
	lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
	lpOutFile->SeekToBegin();

		if(Average==false)	nmpAv2=NScans;
		else				nmpAv2=1;

		if(Fast==false)
		{
			for(i=0;i<=MaxXT;i++)
			{
				tmp1=0;
				Out.Format("%.3f\t",Xscl_lmbd[i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();

				for(j=0;j<nmpAv2;j++)
				{	
					if(SpecToGet==0)	Out.Format("%.3f", Spectra[j*4096+i]);
					else				Out.Format("%.3f", Spectra1[j*4096+i]);	
					tmp1=Out.GetLength();
					lpOutFile->Write(Out,tmp1);
					Out.Empty();

					if(j<nmpAv2-1)
					{
						temp1='\t';
						lpOutFile->Write(&temp1,sizeof(char));
					}
				}

				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}
		}
		else
		{
			for(i=0;i<=(int)(MaxXT/2);i++)
			{
				Out.Format("%.3f\t", Xscl_lmbd[i*2]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				tmp1=0;
				for(j=0;j<nmpAv2;j++)
				{
					if(SpecToGet==0)	Out.Format("%.3f", Spectra[j*4096+i]);
					else				Out.Format("%.3f", Spectra1[j*4096+i]);
					tmp1=Out.GetLength();
					lpOutFile->Write(Out,tmp1);
					Out.Empty();

					if(j<nmpAv2-1)
					{
						temp1='\t';
						lpOutFile->Write(&temp1,sizeof(char));
					}
				}
			
				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}
		}   
	
	   if(lpOutFile) lpOutFile->Close();
	   delete lpOutFile;

	   //XYZ data saving
	   if(XYSpace==true)
	   {
			try
			{
				Out.Format("_CRI_data.txt");
				File_Name.Insert(File_Name.GetLength(),Out);
				lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
			}
			catch(...)
			{
				MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
			}
		
			lpOutFile->SeekToBegin();

			/*
			CRI_Results[0]=X;
			CRI_Results[1]=Y;
			CRI_Results[2]=Z;
			CRI_Results[3]=uk;
			CRI_Results[4]=vk;
			CRI_Results[5]=Tc;
			CRI_Results[6]=DC;
			CRI_Results[7]=deltaE[1];
			......
			CRI_Results[20]=deltaE[14];
			CRI_Results[21]=R[1];
			......
			CRI_Results[20]=R[14];
			*/
			
			Out.Format("x = %.3f", CRI_Results[0]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("y = %.3f", CRI_Results[1]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("z = %.3f", CRI_Results[2]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("u = %.3f", CRI_Results[3]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("v = %.3f", CRI_Results[4]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("Tc = %.0f", CRI_Results[5]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("DC = %.6f", CRI_Results[6]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			for(i=1;i<=14;i++)
			{
				Out.Format("DeltaE%d = %.6f",i,CRI_Results[6+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\t';
				lpOutFile->Write(&temp1,sizeof(char));
				Out.Format("R%d = %.6f",i,CRI_Results[20+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}
			Out.Format("CRI(1-8) = %.6f",CRI_Results[35]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
			Out.Format("CRI(1-14) = %.6f",CRI_Results[36]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);

			if(lpOutFile) lpOutFile->Close();
			delete lpOutFile;
	   }
}

void CCheckTrView::SaveSpec2(CString File_Name)//OnSpecSave save bmp
{
	CRect m_rDrawingSurface;
	//Bitmap stuff representing our drawing
	BITMAPINFOHEADER BMIH;
	//An array of drawing paths. 
	//Each path is a collection of serailly connected points
	CPtrArray m_paPathList;
	//Indicates when a new path is being created
	//Pointer to newly created path
//	CPath* m_pCurrentPath;
	BITMAPFILEHEADER bmfh;
	CStatic	DrawingSurface;
	LONG lImageSize;
	LONG lFileSize;
	int nBitsOffset;

	CFile pFile;

	pFile.Open(File_Name, CFile::modeCreate | CFile::modeWrite);
	pFile.SeekToBegin();

	memset(&BMIH, 0, sizeof(BITMAPINFOHEADER));
//	ScreenToClient(&m_rDrawingSurface);
	HWND hWnd = ::GetActiveWindow();
	HDC hScrDC = ::GetDC(hWnd);
	HDC hMemDC = NULL;
	BYTE *lpBitmapBits = NULL;
	hMemDC = ::CreateCompatibleDC(hScrDC);
//	::GetWindowRect(hWnd,m_rDrawingSurface);
	::GetClientRect(hWnd, &m_rDrawingSurface);

	BMIH.biSize = sizeof(BITMAPINFOHEADER);
	BMIH.biBitCount = 24;
	BMIH.biPlanes = 1;
	BMIH.biCompression = BI_RGB;
	BMIH.biWidth = m_rDrawingSurface.Width();
	BMIH.biHeight = m_rDrawingSurface.Height();
	BMIH.biSizeImage = ((((BMIH.biWidth * BMIH.biBitCount) + 31) & ~31) >> 3) * BMIH.biHeight;

	HBITMAP bitmap = ::CreateDIBSection(hMemDC, (CONST BITMAPINFO*)&BMIH, DIB_RGB_COLORS, (LPVOID*)&lpBitmapBits, NULL, 0);
	HGDIOBJ oldbmp = ::SelectObject(hMemDC, bitmap); 

	::BitBlt(hMemDC, 0, 0, BMIH.biWidth, BMIH.biHeight, hScrDC, 0, 0, SRCCOPY);
			
	nBitsOffset = sizeof(BITMAPFILEHEADER) + BMIH.biSize; 
	lImageSize = BMIH.biSizeImage;
	lFileSize = nBitsOffset + lImageSize;
	bmfh.bfType = 'B'+('M'<<8);			
	bmfh.bfOffBits = nBitsOffset;		
	bmfh.bfSize = lFileSize;				
	bmfh.bfReserved1 = bmfh.bfReserved2 = 0;
	//Write the bitmap file header
	pFile.Write(&bmfh,sizeof(BITMAPFILEHEADER));
	//And then the bitmap info header
	pFile.Write(&BMIH, sizeof(BITMAPINFOHEADER));
	//Finally, write the image data itself -- the data represents our drawing
	pFile.Write(lpBitmapBits, lImageSize);
	
	pFile.Close();	
}

void CCheckTrView::SaveSpec3(CString File_Name)//OnSpecSave with 1nm step
{
	CString Out;
	char temp1;
	CFile* lpOutFile;
	int i,j,tmp1;
	lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
		// TODO: Add your command handler code here
	//200-715nm, 0.5nm step;
		if(Fast==false)
		{
			double tmpMin1save;
			int tmpMin2Ind;
			for(i=0;i<=(int)(Xscl_lmbd[MaxXT]);i++)
			{
				tmpMin1save=10000;
				tmpMin2Ind=0;
				for(j=0;j<=MaxXT;j++)
				{
					
					if(abs(Xscl_lmbd[j]-(int)(Xscl_lmbd[0]+i))<=tmpMin1save)
					{
						tmpMin1save=abs(Xscl_lmbd[j]-(int)(Xscl_lmbd[0]+i));
						tmpMin2Ind=j;
					}
				}
				Out.Format("%d\t",(int)(Xscl_lmbd[0])+i);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();

				if(SpecToGet==0)	Out.Format("%.3f", Spectra[tmpMin2Ind]);
				else				Out.Format("%.3f", Spectra1[tmpMin2Ind]);	
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();

				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}

		}
		if(lpOutFile) lpOutFile->Close();
		delete lpOutFile;

		//XYZ data saving
		if(XYSpace==true)
		{
			try
			{
				Out.Format("_CRI_data.txt");
				File_Name.Insert(File_Name.GetLength(),Out);
				lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
			}
			catch(...)
			{
				MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
			}
		
			lpOutFile->SeekToBegin();

			/*
			CRI_Results[0]=X;
			CRI_Results[1]=Y;
			CRI_Results[2]=Z;
			CRI_Results[3]=uk;
			CRI_Results[4]=vk;
			CRI_Results[5]=Tc;
			CRI_Results[6]=DC;
			CRI_Results[7]=deltaE[1];
			......
			CRI_Results[20]=deltaE[14];
			CRI_Results[21]=R[1];
			......
			CRI_Results[20]=R[14];
			*/
			
			Out.Format("x = %.3f", CRI_Results[0]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("y = %.3f", CRI_Results[1]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("z = %.3f", CRI_Results[2]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("u = %.3f", CRI_Results[3]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("v = %.3f", CRI_Results[4]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("Tc = %.0f", CRI_Results[5]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("DC = %.6f", CRI_Results[6]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			for(i=1;i<=14;i++)
			{
				Out.Format("DeltaE%d = %.6f",i,CRI_Results[6+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\t';
				lpOutFile->Write(&temp1,sizeof(char));
				Out.Format("R%d = %.6f",i,CRI_Results[20+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}
			Out.Format("CRI = %.6f",CRI_Results[35]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);

			if(lpOutFile) lpOutFile->Close();
			delete lpOutFile;
	   }
}

void CCheckTrView::SaveSpec4(CString File_Name)//Save, 380-760nm normalized to sensitivity
{
	CString Out;
	char temp1;
	CFile* lpOutFile;
	int i,j,tmp1,nmpAv2;

	double umol[2][331];																
	umol[0]	[0	]	=	390	;	umol	[	1	]	[	0	]	=	0.978043627	;
	umol[0]	[1	]	=	391	;	umol	[	1	]	[	1	]	=	1.050157227	;
	umol[0]	[2	]	=	392	;	umol	[	1	]	[	2	]	=	1.117192836	;
	umol[0]	[3	]	=	393	;	umol	[	1	]	[	3	]	=	1.181580043	;
	umol[0]	[4	]	=	394	;	umol	[	1	]	[	4	]	=	1.245253243	;
	umol[0]	[5	]	=	395	;	umol	[	1	]	[	5	]	=	1.30970909	;
	umol[0]	[6	]	=	396	;	umol	[	1	]	[	6	]	=	1.376059868	;
	umol[0]	[7	]	=	397	;	umol	[	1	]	[	7	]	=	1.445082936	;
	umol[0]	[8	]	=	398	;	umol	[	1	]	[	8	]	=	1.517266392	;
	umol[0]	[9	]	=	399	;	umol	[	1	]	[	9	]	=	1.592851134	;
	umol[0]	[10	]	=	400	;	umol	[	1	]	[	10	]	=	1.671869448	;
	umol[0]	[11	]	=	401	;	umol	[	1	]	[	11	]	=	1.754180292	;
	umol[0]	[12	]	=	402	;	umol	[	1	]	[	12	]	=	1.839501421	;
	umol[0]	[13	]	=	403	;	umol	[	1	]	[	13	]	=	1.927438494	;
	umol[0]	[14	]	=	404	;	umol	[	1	]	[	14	]	=	2.01751133	;
	umol[0]	[15	]	=	405	;	umol	[	1	]	[	15	]	=	2.109177437	;
	umol[0]	[16	]	=	406	;	umol	[	1	]	[	16	]	=	2.20185297	;
	umol[0]	[17	]	=	407	;	umol	[	1	]	[	17	]	=	2.294931256	;
	umol[0]	[18	]	=	408	;	umol	[	1	]	[	18	]	=	2.387799019	;
	umol[0]	[19	]	=	409	;	umol	[	1	]	[	19	]	=	2.479850455	;
	umol[0]	[20	]	=	410	;	umol	[	1	]	[	20	]	=	2.570499276	;
	umol[0]	[21	]	=	411	;	umol	[	1	]	[	21	]	=	2.659188866	;
	umol[0]	[22	]	=	412	;	umol	[	1	]	[	22	]	=	2.745400667	;
	umol[0]	[23	]	=	413	;	umol	[	1	]	[	23	]	=	2.828660936	;
	umol[0]	[24	]	=	414	;	umol	[	1	]	[	24	]	=	2.908545979	;
	umol[0]	[25	]	=	415	;	umol	[	1	]	[	25	]	=	2.984685996	;
	umol[0]	[26	]	=	416	;	umol	[	1	]	[	26	]	=	3.056767652	;
	umol[0]	[27	]	=	417	;	umol	[	1	]	[	27	]	=	3.124535478	;
	umol[0]	[28	]	=	418	;	umol	[	1	]	[	28	]	=	3.18779223	;
	umol[0]	[29	]	=	419	;	umol	[	1	]	[	29	]	=	3.2463983	;
	umol[0]	[30	]	=	420	;	umol	[	1	]	[	30	]	=	3.30027029	;
	umol[0]	[31	]	=	421	;	umol	[	1	]	[	31	]	=	3.349378849	;
	umol[0]	[32	]	=	422	;	umol	[	1	]	[	32	]	=	3.393745871	;
	umol[0]	[33	]	=	423	;	umol	[	1	]	[	33	]	=	3.433441149	;
	umol[0]	[34	]	=	424	;	umol	[	1	]	[	34	]	=	3.468578567	;
	umol[0]	[35	]	=	425	;	umol	[	1	]	[	35	]	=	3.499311933	;
	umol[0]	[36	]	=	426	;	umol	[	1	]	[	36	]	=	3.525830519	;
	umol[0]	[37	]	=	427	;	umol	[	1	]	[	37	]	=	3.548354395	;
	umol[0]	[38	]	=	428	;	umol	[	1	]	[	38	]	=	3.567129632	;
	umol[0]	[39	]	=	429	;	umol	[	1	]	[	39	]	=	3.582423441	;
	umol[0]	[40	]	=	430	;	umol	[	1	]	[	40	]	=	3.594519313	;
	umol[0]	[41	]	=	431	;	umol	[	1	]	[	41	]	=	3.603712233	;
	umol[0]	[42	]	=	432	;	umol	[	1	]	[	42	]	=	3.610304012	;
	umol[0]	[43	]	=	433	;	umol	[	1	]	[	43	]	=	3.614598791	;
	umol[0]	[44	]	=	434	;	umol	[	1	]	[	44	]	=	3.616898781	;
	umol[0]	[45	]	=	435	;	umol	[	1	]	[	45	]	=	3.617500266	;
	umol[0]	[46	]	=	436	;	umol	[	1	]	[	46	]	=	3.616689917	;
	umol[0]	[47	]	=	437	;	umol	[	1	]	[	47	]	=	3.614741447	;
	umol[0]	[48	]	=	438	;	umol	[	1	]	[	48	]	=	3.611912641	;
	umol[0]	[49	]	=	439	;	umol	[	1	]	[	49	]	=	3.608442789	;
	umol[0]	[50	]	=	440	;	umol	[	1	]	[	50	]	=	3.604550529	;
	umol[0]	[51	]	=	441	;	umol	[	1	]	[	51	]	=	3.600518659	;
	umol[0]	[52	]	=	442	;	umol	[	1	]	[	52	]	=	3.596426276	;
	umol[0]	[53	]	=	443	;	umol	[	1	]	[	53	]	=	3.59241457	;
	umol[0]	[54	]	=	444	;	umol	[	1	]	[	54	]	=	3.588600779	;
	umol[0]	[55	]	=	445	;	umol	[	1	]	[	55	]	=	3.585078694	;
	umol[0]	[56	]	=	446	;	umol	[	1	]	[	56	]	=	3.581919526	;
	umol[0]	[57	]	=	447	;	umol	[	1	]	[	57	]	=	3.579173105	;
	umol[0]	[58	]	=	448	;	umol	[	1	]	[	58	]	=	3.576869375	;
	umol[0]	[59	]	=	449	;	umol	[	1	]	[	59	]	=	3.575020128	;
	umol[0]	[60	]	=	450	;	umol	[	1	]	[	60	]	=	3.573620945	;
	umol[0]	[61	]	=	451	;	umol	[	1	]	[	61	]	=	3.572653279	;
	umol[0]	[62	]	=	452	;	umol	[	1	]	[	62	]	=	3.572086652	;
	umol[0]	[63	]	=	453	;	umol	[	1	]	[	63	]	=	3.571880887	;
	umol[0]	[64	]	=	454	;	umol	[	1	]	[	64	]	=	3.571988353	;
	umol[0]	[65	]	=	455	;	umol	[	1	]	[	65	]	=	3.572356149	;
	umol[0]	[66	]	=	456	;	umol	[	1	]	[	66	]	=	3.572928195	;
	umol[0]	[67	]	=	457	;	umol	[	1	]	[	67	]	=	3.573647167	;
	umol[0]	[68	]	=	458	;	umol	[	1	]	[	68	]	=	3.574456244	;
	umol[0]	[69	]	=	459	;	umol	[	1	]	[	69	]	=	3.575300623	;
	umol[0]	[70	]	=	460	;	umol	[	1	]	[	70	]	=	3.576128749	;
	umol[0]	[71	]	=	461	;	umol	[	1	]	[	71	]	=	3.57653747	;
	umol[0]	[72	]	=	462	;	umol	[	1	]	[	72	]	=	3.576868802	;
	umol[0]	[73	]	=	463	;	umol	[	1	]	[	73	]	=	3.577113765	;
	umol[0]	[74	]	=	464	;	umol	[	1	]	[	74	]	=	3.577264518	;
	umol[0]	[75	]	=	465	;	umol	[	1	]	[	75	]	=	3.577312031	;
	umol[0]	[76	]	=	466	;	umol	[	1	]	[	76	]	=	3.577243633	;
	umol[0]	[77	]	=	467	;	umol	[	1	]	[	77	]	=	3.577040518	;
	umol[0]	[78	]	=	468	;	umol	[	1	]	[	78	]	=	3.576675307	;
	umol[0]	[79	]	=	469	;	umol	[	1	]	[	79	]	=	3.576109775	;
	umol[0]	[80	]	=	470	;	umol	[	1	]	[	80	]	=	3.575292814	;
	umol[0]	[81	]	=	471	;	umol	[	1	]	[	81	]	=	3.574688589	;
	umol[0]	[82	]	=	472	;	umol	[	1	]	[	82	]	=	3.57364276	;
	umol[0]	[83	]	=	473	;	umol	[	1	]	[	83	]	=	3.572014632	;
	umol[0]	[84	]	=	474	;	umol	[	1	]	[	84	]	=	3.569652308	;
	umol[0]	[85	]	=	475	;	umol	[	1	]	[	85	]	=	3.566395835	;
	umol[0]	[86	]	=	476	;	umol	[	1	]	[	86	]	=	3.56208065	;
	umol[0]	[87	]	=	477	;	umol	[	1	]	[	87	]	=	3.556541254	;
	umol[0]	[88	]	=	478	;	umol	[	1	]	[	88	]	=	3.549614995	;
	umol[0]	[89	]	=	479	;	umol	[	1	]	[	89	]	=	3.541145876	;
	umol[0]	[90	]	=	480	;	umol	[	1	]	[	90	]	=	3.530988274	;
	umol[0]	[91	]	=	481	;	umol	[	1	]	[	91	]	=	3.51864555	;
	umol[0]	[92	]	=	482	;	umol	[	1	]	[	92	]	=	3.5043977	;
	umol[0]	[93	]	=	483	;	umol	[	1	]	[	93	]	=	3.488179507	;
	umol[0]	[94	]	=	484	;	umol	[	1	]	[	94	]	=	3.469944315	;
	umol[0]	[95	]	=	485	;	umol	[	1	]	[	95	]	=	3.449664023	;
	umol[0]	[96	]	=	486	;	umol	[	1	]	[	96	]	=	3.427328696	;
	umol[0]	[97	]	=	487	;	umol	[	1	]	[	97	]	=	3.402945838	;
	umol[0]	[98	]	=	488	;	umol	[	1	]	[	98	]	=	3.376539351	;
	umol[0]	[99	]	=	489	;	umol	[	1	]	[	99	]	=	3.348148212	;
	umol[0]	[100	]	=	490	;	umol	[	1	]	[	100	]	=	3.317824919	;
	umol[0]	[101	]	=	491	;	umol	[	1	]	[	101	]	=	3.285492444	;
	umol[0]	[102	]	=	492	;	umol	[	1	]	[	102	]	=	3.251377709	;
	umol[0]	[103	]	=	493	;	umol	[	1	]	[	103	]	=	3.215574088	;
	umol[0]	[104	]	=	494	;	umol	[	1	]	[	104	]	=	3.178179308	;
	umol[0]	[105	]	=	495	;	umol	[	1	]	[	105	]	=	3.139292708	;
	umol[0]	[106	]	=	496	;	umol	[	1	]	[	106	]	=	3.099012662	;
	umol[0]	[107	]	=	497	;	umol	[	1	]	[	107	]	=	3.057434251	;
	umol[0]	[108	]	=	498	;	umol	[	1	]	[	108	]	=	3.01464728	;
	umol[0]	[109	]	=	499	;	umol	[	1	]	[	109	]	=	2.9707347	;
	umol[0]	[110	]	=	500	;	umol	[	1	]	[	110	]	=	2.925771534	;
	umol[0]	[111	]	=	501	;	umol	[	1	]	[	111	]	=	2.880741813	;
	umol[0]	[112	]	=	502	;	umol	[	1	]	[	112	]	=	2.834711584	;
	umol[0]	[113	]	=	503	;	umol	[	1	]	[	113	]	=	2.787657663	;
	umol[0]	[114	]	=	504	;	umol	[	1	]	[	114	]	=	2.739560292	;
	umol[0]	[115	]	=	505	;	umol	[	1	]	[	115	]	=	2.690409868	;
	umol[0]	[116	]	=	506	;	umol	[	1	]	[	116	]	=	2.640213708	;
	umol[0]	[117	]	=	507	;	umol	[	1	]	[	117	]	=	2.589002595	;
	umol[0]	[118	]	=	508	;	umol	[	1	]	[	118	]	=	2.536836872	;
	umol[0]	[119	]	=	509	;	umol	[	1	]	[	119	]	=	2.483811845	;
	umol[0]	[120	]	=	510	;	umol	[	1	]	[	120	]	=	2.430062242	;
	umol[0]	[121	]	=	511	;	umol	[	1	]	[	121	]	=	2.374081137	;
	umol[0]	[122	]	=	512	;	umol	[	1	]	[	122	]	=	2.317912353	;
	umol[0]	[123	]	=	513	;	umol	[	1	]	[	123	]	=	2.261958581	;
	umol[0]	[124	]	=	514	;	umol	[	1	]	[	124	]	=	2.206648682	;
	umol[0]	[125	]	=	515	;	umol	[	1	]	[	125	]	=	2.152426153	;
	umol[0]	[126	]	=	516	;	umol	[	1	]	[	126	]	=	2.099736915	;
	umol[0]	[127	]	=	517	;	umol	[	1	]	[	127	]	=	2.049016777	;
	umol[0]	[128	]	=	518	;	umol	[	1	]	[	128	]	=	2.000678958	;
	umol[0]	[129	]	=	519	;	umol	[	1	]	[	129	]	=	1.955102027	;
	umol[0]	[130	]	=	520	;	umol	[	1	]	[	130	]	=	1.912618648	;
	umol[0]	[131	]	=	521	;	umol	[	1	]	[	131	]	=	1.875454554	;
	umol[0]	[132	]	=	522	;	umol	[	1	]	[	132	]	=	1.841713791	;
	umol[0]	[133	]	=	523	;	umol	[	1	]	[	133	]	=	1.811380455	;
	umol[0]	[134	]	=	524	;	umol	[	1	]	[	134	]	=	1.784383154	;
	umol[0]	[135	]	=	525	;	umol	[	1	]	[	135	]	=	1.76060253	;
	umol[0]	[136	]	=	526	;	umol	[	1	]	[	136	]	=	1.739879968	;
	umol[0]	[137	]	=	527	;	umol	[	1	]	[	137	]	=	1.722027164	;
	umol[0]	[138	]	=	528	;	umol	[	1	]	[	138	]	=	1.706836243	;
	umol[0]	[139	]	=	529	;	umol	[	1	]	[	139	]	=	1.694090087	;
	umol[0]	[140	]	=	530	;	umol	[	1	]	[	140	]	=	1.683572534	;
	umol[0]	[141	]	=	531	;	umol	[	1	]	[	141	]	=	1.673508366	;
	umol[0]	[142	]	=	532	;	umol	[	1	]	[	142	]	=	1.665409582	;
	umol[0]	[143	]	=	533	;	umol	[	1	]	[	143	]	=	1.659243863	;
	umol[0]	[144	]	=	534	;	umol	[	1	]	[	144	]	=	1.654996203	;
	umol[0]	[145	]	=	535	;	umol	[	1	]	[	145	]	=	1.652665762	;
	umol[0]	[146	]	=	536	;	umol	[	1	]	[	146	]	=	1.652261944	;
	umol[0]	[147	]	=	537	;	umol	[	1	]	[	147	]	=	1.65379989	;
	umol[0]	[148	]	=	538	;	umol	[	1	]	[	148	]	=	1.657295569	;
	umol[0]	[149	]	=	539	;	umol	[	1	]	[	149	]	=	1.662760682	;
	umol[0]	[150	]	=	540	;	umol	[	1	]	[	150	]	=	1.670197578	;
	umol[0]	[151	]	=	541	;	umol	[	1	]	[	151	]	=	1.68057097	;
	umol[0]	[152	]	=	542	;	umol	[	1	]	[	152	]	=	1.692794045	;
	umol[0]	[153	]	=	543	;	umol	[	1	]	[	153	]	=	1.706735475	;
	umol[0]	[154	]	=	544	;	umol	[	1	]	[	154	]	=	1.72224885	;
	umol[0]	[155	]	=	545	;	umol	[	1	]	[	155	]	=	1.739175605	;
	umol[0]	[156	]	=	546	;	umol	[	1	]	[	156	]	=	1.757348381	;
	umol[0]	[157	]	=	547	;	umol	[	1	]	[	157	]	=	1.776594712	;
	umol[0]	[158	]	=	548	;	umol	[	1	]	[	158	]	=	1.796740936	;
	umol[0]	[159	]	=	549	;	umol	[	1	]	[	159	]	=	1.817616191	;
	umol[0]	[160	]	=	550	;	umol	[	1	]	[	160	]	=	1.839056393	;
	umol[0]	[161	]	=	551	;	umol	[	1	]	[	161	]	=	1.860403541	;
	umol[0]	[162	]	=	552	;	umol	[	1	]	[	162	]	=	1.882064065	;
	umol[0]	[163	]	=	553	;	umol	[	1	]	[	163	]	=	1.903956465	;
	umol[0]	[164	]	=	554	;	umol	[	1	]	[	164	]	=	1.926013895	;
	umol[0]	[165	]	=	555	;	umol	[	1	]	[	165	]	=	1.948183687	;
	umol[0]	[166	]	=	556	;	umol	[	1	]	[	166	]	=	1.970426546	;
	umol[0]	[167	]	=	557	;	umol	[	1	]	[	167	]	=	1.992715456	;
	umol[0]	[168	]	=	558	;	umol	[	1	]	[	168	]	=	2.015034344	;
	umol[0]	[169	]	=	559	;	umol	[	1	]	[	169	]	=	2.037376551	;
	umol[0]	[170	]	=	560	;	umol	[	1	]	[	170	]	=	2.05974316	;
	umol[0]	[171	]	=	561	;	umol	[	1	]	[	171	]	=	2.082310026	;
	umol[0]	[172	]	=	562	;	umol	[	1	]	[	172	]	=	2.104905852	;
	umol[0]	[173	]	=	563	;	umol	[	1	]	[	173	]	=	2.127530831	;
	umol[0]	[174	]	=	564	;	umol	[	1	]	[	174	]	=	2.150187725	;
	umol[0]	[175	]	=	565	;	umol	[	1	]	[	175	]	=	2.172881177	;
	umol[0]	[176	]	=	566	;	umol	[	1	]	[	176	]	=	2.195617079	;
	umol[0]	[177	]	=	567	;	umol	[	1	]	[	177	]	=	2.218402013	;
	umol[0]	[178	]	=	568	;	umol	[	1	]	[	178	]	=	2.241242762	;
	umol[0]	[179	]	=	569	;	umol	[	1	]	[	179	]	=	2.264145891	;
	umol[0]	[180	]	=	570	;	umol	[	1	]	[	180	]	=	2.287117405	;
	umol[0]	[181	]	=	571	;	umol	[	1	]	[	181	]	=	2.310169946	;
	umol[0]	[182	]	=	572	;	umol	[	1	]	[	182	]	=	2.333299581	;
	umol[0]	[183	]	=	573	;	umol	[	1	]	[	183	]	=	2.356508702	;
	umol[0]	[184	]	=	574	;	umol	[	1	]	[	184	]	=	2.379798561	;
	umol[0]	[185	]	=	575	;	umol	[	1	]	[	185	]	=	2.403169312	;
	umol[0]	[186	]	=	576	;	umol	[	1	]	[	186	]	=	2.426620093	;
	umol[0]	[187	]	=	577	;	umol	[	1	]	[	187	]	=	2.450149164	;
	umol[0]	[188	]	=	578	;	umol	[	1	]	[	188	]	=	2.473754067	;
	umol[0]	[189	]	=	579	;	umol	[	1	]	[	189	]	=	2.49743182	;
	umol[0]	[190	]	=	580	;	umol	[	1	]	[	190	]	=	2.521179127	;
	umol[0]	[191	]	=	581	;	umol	[	1	]	[	191	]	=	2.544962193	;
	umol[0]	[192	]	=	582	;	umol	[	1	]	[	192	]	=	2.568810629	;
	umol[0]	[193	]	=	583	;	umol	[	1	]	[	193	]	=	2.592723915	;
	umol[0]	[194	]	=	584	;	umol	[	1	]	[	194	]	=	2.61670172	;
	umol[0]	[195	]	=	585	;	umol	[	1	]	[	195	]	=	2.640743909	;
	umol[0]	[196	]	=	586	;	umol	[	1	]	[	196	]	=	2.664850539	;
	umol[0]	[197	]	=	587	;	umol	[	1	]	[	197	]	=	2.689021844	;
	umol[0]	[198	]	=	588	;	umol	[	1	]	[	198	]	=	2.713258217	;
	umol[0]	[199	]	=	589	;	umol	[	1	]	[	199	]	=	2.737560176	;
	umol[0]	[200	]	=	590	;	umol	[	1	]	[	200	]	=	2.761928328	;
	umol[0]	[201	]	=	591	;	umol	[	1	]	[	201	]	=	2.786371059	;
	umol[0]	[202	]	=	592	;	umol	[	1	]	[	202	]	=	2.810880665	;
	umol[0]	[203	]	=	593	;	umol	[	1	]	[	203	]	=	2.835457146	;
	umol[0]	[204	]	=	594	;	umol	[	1	]	[	204	]	=	2.860100502	;
	umol[0]	[205	]	=	595	;	umol	[	1	]	[	205	]	=	2.884810732	;
	umol[0]	[206	]	=	596	;	umol	[	1	]	[	206	]	=	2.909587837	;
	umol[0]	[207	]	=	597	;	umol	[	1	]	[	207	]	=	2.934431817	;
	umol[0]	[208	]	=	598	;	umol	[	1	]	[	208	]	=	2.959342672	;
	umol[0]	[209	]	=	599	;	umol	[	1	]	[	209	]	=	2.984320402	;
	umol[0]	[210	]	=	600	;	umol	[	1	]	[	210	]	=	3.009365006	;
	umol[0]	[211	]	=	601	;	umol	[	1	]	[	211	]	=	3.034476485	;
	umol[0]	[212	]	=	602	;	umol	[	1	]	[	212	]	=	3.059654839	;
	umol[0]	[213	]	=	603	;	umol	[	1	]	[	213	]	=	3.084900068	;
	umol[0]	[214	]	=	604	;	umol	[	1	]	[	214	]	=	3.110212171	;
	umol[0]	[215	]	=	605	;	umol	[	1	]	[	215	]	=	3.135591149	;
	umol[0]	[216	]	=	606	;	umol	[	1	]	[	216	]	=	3.161037002	;
	umol[0]	[217	]	=	607	;	umol	[	1	]	[	217	]	=	3.18654973	;
	umol[0]	[218	]	=	608	;	umol	[	1	]	[	218	]	=	3.212129333	;
	umol[0]	[219	]	=	609	;	umol	[	1	]	[	219	]	=	3.23777581	;
	umol[0]	[220	]	=	610	;	umol	[	1	]	[	220	]	=	3.263489162	;
	umol[0]	[221	]	=	611	;	umol	[	1	]	[	221	]	=	3.289261397	;
	umol[0]	[222	]	=	612	;	umol	[	1	]	[	222	]	=	3.315101162	;
	umol[0]	[223	]	=	613	;	umol	[	1	]	[	223	]	=	3.341009099	;
	umol[0]	[224	]	=	614	;	umol	[	1	]	[	224	]	=	3.366985764	;
	umol[0]	[225	]	=	615	;	umol	[	1	]	[	225	]	=	3.393031588	;
	umol[0]	[226	]	=	616	;	umol	[	1	]	[	226	]	=	3.419146843	;
	umol[0]	[227	]	=	617	;	umol	[	1	]	[	227	]	=	3.445331613	;
	umol[0]	[228	]	=	618	;	umol	[	1	]	[	228	]	=	3.471585781	;
	umol[0]	[229	]	=	619	;	umol	[	1	]	[	229	]	=	3.497909019	;
	umol[0]	[230	]	=	620	;	umol	[	1	]	[	230	]	=	3.524300796	;
	umol[0]	[231	]	=	621	;	umol	[	1	]	[	231	]	=	3.550792885	;
	umol[0]	[232	]	=	622	;	umol	[	1	]	[	232	]	=	3.577349254	;
	umol[0]	[233	]	=	623	;	umol	[	1	]	[	233	]	=	3.603966316	;
	umol[0]	[234	]	=	624	;	umol	[	1	]	[	234	]	=	3.630640778	;
	umol[0]	[235	]	=	625	;	umol	[	1	]	[	235	]	=	3.657369873	;
	umol[0]	[236	]	=	626	;	umol	[	1	]	[	236	]	=	3.684151577	;
	umol[0]	[237	]	=	627	;	umol	[	1	]	[	237	]	=	3.710984806	;
	umol[0]	[238	]	=	628	;	umol	[	1	]	[	238	]	=	3.737869574	;
	umol[0]	[239	]	=	629	;	umol	[	1	]	[	239	]	=	3.764807107	;
	umol[0]	[240	]	=	630	;	umol	[	1	]	[	240	]	=	3.791799908	;
	umol[0]	[241	]	=	631	;	umol	[	1	]	[	241	]	=	3.818843499	;
	umol[0]	[242	]	=	632	;	umol	[	1	]	[	242	]	=	3.845951789	;
	umol[0]	[243	]	=	633	;	umol	[	1	]	[	243	]	=	3.873131461	;
	umol[0]	[244	]	=	634	;	umol	[	1	]	[	244	]	=	3.900389917	;
	umol[0]	[245	]	=	635	;	umol	[	1	]	[	245	]	=	3.927734902	;
	umol[0]	[246	]	=	636	;	umol	[	1	]	[	246	]	=	3.955174037	;
	umol[0]	[247	]	=	637	;	umol	[	1	]	[	247	]	=	3.982714267	;
	umol[0]	[248	]	=	638	;	umol	[	1	]	[	248	]	=	4.010361204	;
	umol[0]	[249	]	=	639	;	umol	[	1	]	[	249	]	=	4.038118396	;
	umol[0]	[250	]	=	640	;	umol	[	1	]	[	250	]	=	4.065986497	;
	umol[0]	[251	]	=	641	;	umol	[	1	]	[	251	]	=	4.093786292	;
	umol[0]	[252	]	=	642	;	umol	[	1	]	[	252	]	=	4.121700425	;
	umol[0]	[253	]	=	643	;	umol	[	1	]	[	253	]	=	4.149729296	;
	umol[0]	[254	]	=	644	;	umol	[	1	]	[	254	]	=	4.177864533	;
	umol[0]	[255	]	=	645	;	umol	[	1	]	[	255	]	=	4.206086987	;
	umol[0]	[256	]	=	646	;	umol	[	1	]	[	256	]	=	4.234364837	;
	umol[0]	[257	]	=	647	;	umol	[	1	]	[	257	]	=	4.262651863	;
	umol[0]	[258	]	=	648	;	umol	[	1	]	[	258	]	=	4.290885956	;
	umol[0]	[259	]	=	649	;	umol	[	1	]	[	259	]	=	4.31898791	;
	umol[0]	[260	]	=	650	;	umol	[	1	]	[	260	]	=	4.346860564	;
	umol[0]	[261	]	=	651	;	umol	[	1	]	[	261	]	=	4.374814109	;
	umol[0]	[262	]	=	652	;	umol	[	1	]	[	262	]	=	4.402253713	;
	umol[0]	[263	]	=	653	;	umol	[	1	]	[	263	]	=	4.428993211	;
	umol[0]	[264	]	=	654	;	umol	[	1	]	[	264	]	=	4.454833933	;
	umol[0]	[265	]	=	655	;	umol	[	1	]	[	265	]	=	4.47956832	;
	umol[0]	[266	]	=	656	;	umol	[	1	]	[	266	]	=	4.502983772	;
	umol[0]	[267	]	=	657	;	umol	[	1	]	[	267	]	=	4.524866625	;
	umol[0]	[268	]	=	658	;	umol	[	1	]	[	268	]	=	4.545006155	;
	umol[0]	[269	]	=	659	;	umol	[	1	]	[	269	]	=	4.563198502	;
	umol[0]	[270	]	=	660	;	umol	[	1	]	[	270	]	=	4.579250417	;
	umol[0]	[271	]	=	661	;	umol	[	1	]	[	271	]	=	4.592524471	;
	umol[0]	[272	]	=	662	;	umol	[	1	]	[	272	]	=	4.60335461	;
	umol[0]	[273	]	=	663	;	umol	[	1	]	[	273	]	=	4.611635309	;
	umol[0]	[274	]	=	664	;	umol	[	1	]	[	274	]	=	4.617277986	;
	umol[0]	[275	]	=	665	;	umol	[	1	]	[	275	]	=	4.620210135	;
	umol[0]	[276	]	=	666	;	umol	[	1	]	[	276	]	=	4.620374117	;
	umol[0]	[277	]	=	667	;	umol	[	1	]	[	277	]	=	4.617725646	;
	umol[0]	[278	]	=	668	;	umol	[	1	]	[	278	]	=	4.612232052	;
	umol[0]	[279	]	=	669	;	umol	[	1	]	[	279	]	=	4.603870375	;
	umol[0]	[280	]	=	670	;	umol	[	1	]	[	280	]	=	4.592625373	;
	umol[0]	[281	]	=	671	;	umol	[	1	]	[	281	]	=	4.578680603	;
	umol[0]	[282	]	=	672	;	umol	[	1	]	[	282	]	=	4.56182127	;
	umol[0]	[283	]	=	673	;	umol	[	1	]	[	283	]	=	4.542027998	;
	umol[0]	[284	]	=	674	;	umol	[	1	]	[	284	]	=	4.519283722	;
	umol[0]	[285	]	=	675	;	umol	[	1	]	[	285	]	=	4.493573256	;
	umol[0]	[286	]	=	676	;	umol	[	1	]	[	286	]	=	4.464883035	;
	umol[0]	[287	]	=	677	;	umol	[	1	]	[	287	]	=	4.433201033	;
	umol[0]	[288	]	=	678	;	umol	[	1	]	[	288	]	=	4.398516869	;
	umol[0]	[289	]	=	679	;	umol	[	1	]	[	289	]	=	4.360822095	;
	umol[0]	[290	]	=	680	;	umol	[	1	]	[	290	]	=	4.320110653	;
	umol[0]	[291	]	=	681	;	umol	[	1	]	[	291	]	=	4.276372856	;
	umol[0]	[292	]	=	682	;	umol	[	1	]	[	292	]	=	4.229616731	;
	umol[0]	[293	]	=	683	;	umol	[	1	]	[	293	]	=	4.179848408	;
	umol[0]	[294	]	=	684	;	umol	[	1	]	[	294	]	=	4.127079811	;
	umol[0]	[295	]	=	685	;	umol	[	1	]	[	295	]	=	4.071329811	;
	umol[0]	[296	]	=	686	;	umol	[	1	]	[	296	]	=	4.012625479	;
	umol[0]	[297	]	=	687	;	umol	[	1	]	[	297	]	=	3.951003395	;
	umol[0]	[298	]	=	688	;	umol	[	1	]	[	298	]	=	3.886510993	;
	umol[0]	[299	]	=	689	;	umol	[	1	]	[	299	]	=	3.8192079	;
	umol[0]	[300	]	=	690	;	umol	[	1	]	[	300	]	=	3.749167237	;
	umol[0]	[301	]	=	691	;	umol	[	1	]	[	301	]	=	3.676476833	;
	umol[0]	[302	]	=	692	;	umol	[	1	]	[	302	]	=	3.601240312	;
	umol[0]	[303	]	=	693	;	umol	[	1	]	[	303	]	=	3.523577982	;
	umol[0]	[304	]	=	694	;	umol	[	1	]	[	304	]	=	3.443627502	;
	umol[0]	[305	]	=	695	;	umol	[	1	]	[	305	]	=	3.361544231	;
	umol[0]	[306	]	=	696	;	umol	[	1	]	[	306	]	=	3.277501216	;
	umol[0]	[307	]	=	697	;	umol	[	1	]	[	307	]	=	3.191688745	;
	umol[0]	[308	]	=	698	;	umol	[	1	]	[	308	]	=	3.104313378	;
	umol[0]	[309	]	=	699	;	umol	[	1	]	[	309	]	=	3.015596391	;
	umol[0]	[310	]	=	700	;	umol	[	1	]	[	310	]	=	2.925771534	;
	umol[0]	[311	]	=	701	;	umol	[	1	]	[	311	]	=	2.835082026	;
	umol[0]	[312	]	=	702	;	umol	[	1	]	[	312	]	=	2.743776678	;
	umol[0]	[313	]	=	703	;	umol	[	1	]	[	313	]	=	2.652105051	;
	umol[0]	[314	]	=	704	;	umol	[	1	]	[	314	]	=	2.560311538	;
	umol[0]	[315	]	=	705	;	umol	[	1	]	[	315	]	=	2.468628259	;
	umol[0]	[316	]	=	706	;	umol	[	1	]	[	316	]	=	2.377266655	;
	umol[0]	[317	]	=	707	;	umol	[	1	]	[	317	]	=	2.286407651	;
	umol[0]	[318	]	=	708	;	umol	[	1	]	[	318	]	=	2.196190258	;
	umol[0]	[319	]	=	709	;	umol	[	1	]	[	319	]	=	2.106698488	;
	umol[0]	[320	]	=	710	;	umol	[	1	]	[	320	]	=	2.017946423	;
	umol[0]	[321	]	=	711	;	umol	[	1	]	[	321	]	=	1.929861317	;
	umol[0]	[322	]	=	712	;	umol	[	1	]	[	322	]	=	1.84226454	;
	umol[0]	[323	]	=	713	;	umol	[	1	]	[	323	]	=	1.75485024	;
	umol[0]	[324	]	=	714	;	umol	[	1	]	[	324	]	=	1.667161534	;
	umol[0]	[325	]	=	715	;	umol	[	1	]	[	325	]	=	1.578564058	;
	umol[0]	[326	]	=	716	;	umol	[	1	]	[	326	]	=	1.4882167	;
	umol[0]	[327	]	=	717	;	umol	[	1	]	[	327	]	=	1.395039324	;
	umol[0]	[328	]	=	718	;	umol	[	1	]	[	328	]	=	1.297677297	;
	umol[0]	[329	]	=	719	;	umol	[	1	]	[	329	]	=	1.194462614	;
	umol[0]	[330	]	=	720	;	umol	[	1	]	[	330	]	=	1.083371402	;

	lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
	lpOutFile->SeekToBegin();

		if(Average==false)	nmpAv2=NScans;
		else				nmpAv2=1;

		if(Fast==false)
		{
			double tmpMin1save;
			int tmpMin2Ind;

			Out.Format("Wavelength    uW/cm^2/nm    umol/m2");
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			for(i=0;i<=(int)(Xscl_lmbd[MaxXT])-(int)(Xscl_lmbd[0]);i++)
			{
				if(((int)(Xscl_lmbd[0])+i>=380)&((int)(Xscl_lmbd[0])+i<=760))
				{
					tmp1=0;
					tmpMin1save=10000;
					tmpMin2Ind=0;
					for(j=0;j<=MaxXT;j++)
					{
						
						if(abs(Xscl_lmbd[j]-(int)(Xscl_lmbd[0]+i))<=tmpMin1save)
						{
							tmpMin1save=abs(Xscl_lmbd[j]-(int)(Xscl_lmbd[0]+i));
							tmpMin2Ind=j;
						}
					}
					Out.Format("%d\t",(int)(Xscl_lmbd[0])+i);
					tmp1=Out.GetLength();
					lpOutFile->Write(Out,tmp1);
					Out.Empty();


					for(j=0;j<nmpAv2;j++)
					{	
						if(SpecToGet==0)	Out.Format("%.3f", Spectra[j*4096+tmpMin2Ind]*ColorNorm[tmpMin2Ind]/ExpCorrect);
						else				Out.Format("%.3f", Spectra1[j*4096+tmpMin2Ind]*ColorNorm[tmpMin2Ind]/ExpCorrect);	
						tmp1=Out.GetLength();
						lpOutFile->Write(Out,tmp1);
						Out.Empty();

						if(j<nmpAv2-1)
						{
							temp1='\t';
							lpOutFile->Write(&temp1,sizeof(char));
						}
					}

					temp1='\t';
					lpOutFile->Write(&temp1,sizeof(char));

					tmp1=-1;
					for(j=0;j<=330;j++)
						if(((int)(Xscl_lmbd[0])+i)==umol[0][j]) tmp1=j;	
					if(tmp1!=-1)
					{
						if(SpecToGet==0)	Out.Format("%.3f", Spectra[tmpMin2Ind]*ColorNorm[tmpMin2Ind]/ExpCorrect/100*umol[1][tmp1]);
						else				Out.Format("%.3f", Spectra1[tmpMin2Ind]*ColorNorm[tmpMin2Ind]/ExpCorrect/100*umol[1][tmp1]);	
						tmp1=Out.GetLength();
						lpOutFile->Write(Out,tmp1);
						Out.Empty();
					}

					temp1='\r';
					lpOutFile->Write(&temp1,sizeof(char));
					temp1='\n';
					lpOutFile->Write(&temp1,sizeof(char));
				}
			}
		}
		else
		{
			
			for(i=0;i<=(int)(MaxXT/2);i++)
			{
				if((Xscl_lmbd[i]>=380)&(Xscl_lmbd[i]<=760))
				{
					Out.Format("%.3f\t", Xscl_lmbd[i*2]);
					tmp1=Out.GetLength();
					lpOutFile->Write(Out,tmp1);
					Out.Empty();
					tmp1=0;
					for(j=0;j<nmpAv2;j++)
					{
						if(SpecToGet==0)	Out.Format("%.3f", Spectra[j*4096+i]*ColorNorm[2*i]);
						else				Out.Format("%.3f", Spectra1[j*4096+i]*ColorNorm[2*i]);
						tmp1=Out.GetLength();
						lpOutFile->Write(Out,tmp1);
						Out.Empty();

						if(j<nmpAv2-1)
						{
							temp1='\t';
							lpOutFile->Write(&temp1,sizeof(char));
						}
					}
				
					temp1='\r';
					lpOutFile->Write(&temp1,sizeof(char));
					temp1='\n';
					lpOutFile->Write(&temp1,sizeof(char));
				}
			}
		}   
	
	   if(lpOutFile) lpOutFile->Close();
	   delete lpOutFile;

	   //XYZ data saving
	   if(XYSpace==true)
	   {
			try
			{
				Out.Format("_CRI_data.txt");
				File_Name.Insert(File_Name.GetLength(),Out);
				lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
			}
			catch(...)
			{
				MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
			}
		
			lpOutFile->SeekToBegin();

			/*
			CRI_Results[0]=X;
			CRI_Results[1]=Y;
			CRI_Results[2]=Z;
			CRI_Results[3]=uk;
			CRI_Results[4]=vk;
			CRI_Results[5]=Tc;
			CRI_Results[6]=DC;
			CRI_Results[7]=deltaE[1];
			......
			CRI_Results[20]=deltaE[14];
			CRI_Results[21]=R[1];
			......
			CRI_Results[20]=R[14];
			*/
			
			Out.Format("x = %.3f", CRI_Results[0]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("y = %.3f", CRI_Results[1]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("z = %.3f", CRI_Results[2]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("u = %.3f", CRI_Results[3]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("v = %.3f", CRI_Results[4]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("Tc = %.0f", CRI_Results[5]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			Out.Format("DC = %.6f", CRI_Results[6]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));

			for(i=1;i<=14;i++)
			{
				Out.Format("DeltaE%d = %.6f",i,CRI_Results[6+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\t';
				lpOutFile->Write(&temp1,sizeof(char));
				Out.Format("R%d = %.6f",i,CRI_Results[20+i]);
				tmp1=Out.GetLength();
				lpOutFile->Write(Out,tmp1);
				Out.Empty();
				temp1='\r';
				lpOutFile->Write(&temp1,sizeof(char));
				temp1='\n';
				lpOutFile->Write(&temp1,sizeof(char));
			}
			Out.Format("CRI(1-8) = %.6f",CRI_Results[35]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
			Out.Format("CRI(1-14) = %.6f",CRI_Results[36]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);

			if(lpOutFile) lpOutFile->Close();
			delete lpOutFile;
	   }
}

void CCheckTrView::OnSavescreen() 
{
		CRect m_rDrawingSurface;
	//Bitmap stuff representing our drawing
	BITMAPINFOHEADER BMIH;
	//An array of drawing paths. 
	//Each path is a collection of serailly connected points
	CPtrArray m_paPathList;
	//Indicates when a new path is being created
	//Pointer to newly created path
//	CPath* m_pCurrentPath;
	BITMAPFILEHEADER bmfh;
	CStatic	DrawingSurface;
	LONG lImageSize;
	LONG lFileSize;
	int nBitsOffset;

	memset(&BMIH, 0, sizeof(BITMAPINFOHEADER));
//	ScreenToClient(&m_rDrawingSurface);
	HWND hWnd = ::GetActiveWindow();
	HDC hScrDC = ::GetDC(hWnd);
	HDC hMemDC = NULL;
	BYTE *lpBitmapBits = NULL;
	hMemDC = ::CreateCompatibleDC(hScrDC);
//	::GetWindowRect(hWnd,m_rDrawingSurface);
	::GetClientRect(hWnd, &m_rDrawingSurface);

	BMIH.biSize = sizeof(BITMAPINFOHEADER);
	BMIH.biBitCount = 24;
	BMIH.biPlanes = 1;
	BMIH.biCompression = BI_RGB;
	BMIH.biWidth = m_rDrawingSurface.Width();
	BMIH.biHeight = m_rDrawingSurface.Height();
	BMIH.biSizeImage = ((((BMIH.biWidth * BMIH.biBitCount) + 31) & ~31) >> 3) * BMIH.biHeight;

	HBITMAP bitmap = ::CreateDIBSection(hMemDC, (CONST BITMAPINFO*)&BMIH, DIB_RGB_COLORS, (LPVOID*)&lpBitmapBits, NULL, 0);
	HGDIOBJ oldbmp = ::SelectObject(hMemDC, bitmap); 

	::BitBlt(hMemDC, 0, 0, BMIH.biWidth, BMIH.biHeight, hScrDC, 0, 0, SRCCOPY);
			
	nBitsOffset = sizeof(BITMAPFILEHEADER) + BMIH.biSize; 
	lImageSize = BMIH.biSizeImage;
	lFileSize = nBitsOffset + lImageSize;
	bmfh.bfType = 'B'+('M'<<8);			
	bmfh.bfOffBits = nBitsOffset;		
	bmfh.bfSize = lFileSize;				
	bmfh.bfReserved1 = bmfh.bfReserved2 = 0;

	CString Out, File_Name;
	CWinApp* pApp=AfxGetApp();
	VERIFY(pApp->m_pDocManager!=NULL);
	char Cur_Dir[_MAX_DIR];
	bool flagBMP=false;
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
	}
	try
	{
		int tmpBMP=File_Name.Find(".bmp",0);
		if(tmpBMP==-1)
		{
			Out.Format(".bmp");
			File_Name.Insert(File_Name.GetLength(),Out);
		}
		flagBMP=true;
	}
	catch(...)
	{
		MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
	}
	if(flagBMP==true) 
	{
		CFile pFile;
		pFile.Open(File_Name, CFile::modeCreate | CFile::modeWrite);
		pFile.SeekToBegin();
		//Write the bitmap file header
		pFile.Write(&bmfh,sizeof(BITMAPFILEHEADER));
		//And then the bitmap info header
		pFile.Write(&BMIH, sizeof(BITMAPINFOHEADER));
		//Finally, write the image data itself -- the data represents our drawing
		pFile.Write(lpBitmapBits, lImageSize);	
		pFile.Close();	
	}

}

void CCheckTrView::OnFileSaveXyz() 
{
//	pThread->SuspendThread();

	CWinApp* pApp=AfxGetApp();
	CString Out;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			int tmpTXT=File_Name.Find(".txt",0);
			if(tmpTXT==-1)
			{
				Out.Format(".txt");
				File_Name.Insert(File_Name.GetLength(),Out);
			}
			SaveSpec4(File_Name);
		}
		catch(...)
		{
			MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	}
//	pThread->ResumeThread();
}

void CCheckTrView::OnGetspectra() 
{
	int i,numb_points;
	if(Fast==true)	numb_points=1826;
	else			numb_points=4095;
	
	for(i=0;i<=numb_points;i++)
	{
		if(SpecToGet==0)	SourceSpectra[i]=Spectra[i];
		else				SourceSpectra[i]=Spectra1[i];
	}
	RefSpectra=true;
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	pRef_min_Spec->SetCheck(0);
	pRef_min_Spec->EnableWindow(true);
	pSpec_dev_Ref->SetCheck(0);
	pSpec_dev_Ref->EnableWindow(true);
	pLog1->SetCheck(0);
	pLog1->EnableWindow(true);
}

void CCheckTrView::OnLoadsourcespectra() 
{
//	pThread->SuspendThread();

	CWinApp* pApp=AfxGetApp();
	CString Out;
	char temp1;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];
	CFile* lpOutFile;
	int i,j,tmp1;

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_OPENFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,TRUE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			lpOutFile=new CFile(File_Name,CFile::modeRead|CFile::shareDenyNone);
		}
		catch(...)
		{
			MessageBox("UNABLE TO OPEN FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	
		lpOutFile->SeekToBegin();
		tmp1=lpOutFile->GetLength();
		j=-1;

		lpOutFile->Read(&temp1,sizeof(char));
		while(lpOutFile->GetPosition()<tmp1)
		{
			j++;
			if(j==3652)
				i=0;
			while((temp1!='	')&&(lpOutFile->GetPosition()<tmp1))
				lpOutFile->Read(&temp1,sizeof(char));
			lpOutFile->Read(&temp1,sizeof(char));
			while((temp1!='\r')&&(lpOutFile->GetPosition()<tmp1))
			{
				Out.Insert(Out.GetLength()+1,temp1);
				lpOutFile->Read(&temp1,sizeof(char));
			}
			lpOutFile->Read(&temp1,sizeof(char));
			temp1=0;
			Out.Insert(Out.GetLength()+1,temp1);
			if(Out.GetLength()>1)
			{
				SourceSpectra[j]=atof(Out);
			}
			else
			{
				j--;
			}
			Out.Empty();
		}

	   if(lpOutFile) lpOutFile->Close();
	   delete lpOutFile;

	   if(j!=MaxX) ::MessageBox(0,"Number of spectral points is not correct","Warning",MB_OK|MB_SYSTEMMODAL);
	}

	RefSpectra=true;
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	pRef_min_Spec->SetCheck(0);
	pRef_min_Spec->EnableWindow(true);
	pSpec_dev_Ref->SetCheck(0);
	pSpec_dev_Ref->EnableWindow(true);
	pLog1->SetCheck(0);
	pLog1->EnableWindow(true);

//	pThread->ResumeThread();
}

void CCheckTrView::OnRef_min_Sp()
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	CButton *pFast   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_FAST));
	CButton *pAverage   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
	if(RefSpectra==false)
	{
		pRef_min_Spec->SetCheck(0);
		::MessageBox(0,"Get Reference spectra fist","Message",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		if(MinRef_or_DevRef==1)//already checked, remove
		{
			pRef_min_Spec->SetCheck(0);//uncheck
			MinRef_or_DevRef=0;
		}
		else//set
		{
			pSpec_dev_Ref	->	SetCheck(0);//uncheck
			pLog1			->	SetCheck(0);//uncheck
			pRef_min_Spec	->	SetCheck(1);//check
			pFast->SetCheck(0);
			Fast=false;
			pAverage->SetCheck(1);
			Average=true;
			MinRef_or_DevRef=1;

			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			this->Invalidate(false);
		}
	}
}

void CCheckTrView::OnSp_dev_Ref()
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	CButton *pFast   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_FAST));
	CButton *pAverage   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
	if(RefSpectra==false)
	{
		pSpec_dev_Ref->SetCheck(0);
		::MessageBox(0,"Get Reference spectra fist","Message",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		if(MinRef_or_DevRef==2)//already checked, remove
		{
			pSpec_dev_Ref->SetCheck(0);//uncheck
			MinRef_or_DevRef=0;
		}
		else//set
		{
			pSpec_dev_Ref	->	SetCheck(1);//uncheck
			pLog1			->	SetCheck(0);//uncheck
			pRef_min_Spec	->	SetCheck(0);//check
			pFast->SetCheck(0);
			Fast=false;
			pAverage->SetCheck(1);
			Average=true;
			MinRef_or_DevRef=2;

			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			MaxY=1;
			MinY=0;
			this->Invalidate(false);
		}
	}
}

void CCheckTrView::OnRadLog1() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRef_min_Spec = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_REF_M_SP));
	CButton *pSpec_dev_Ref = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_SP_DEV_REF));
	CButton *pLog1 = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RAD_LOG1));
	CButton *pFast   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_FAST));
	CButton *pAverage   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AVERAGING));
	if(RefSpectra==false)
	{
		pSpec_dev_Ref->SetCheck(0);
		::MessageBox(0,"Get Reference spectra fist","Message",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		if(MinRef_or_DevRef==3)//already checked, remove
		{
			pLog1->SetCheck(0);//uncheck
			MinRef_or_DevRef=0;
		}
		else//set
		{
			pSpec_dev_Ref	->	SetCheck(0);//uncheck
			pLog1			->	SetCheck(1);//check
			pRef_min_Spec	->	SetCheck(0);//uncheck
			pFast->SetCheck(0);
			Fast=false;
			pAverage->SetCheck(1);
			Average=true;
			MinRef_or_DevRef=3;

			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			MaxY=3;
			MinY=-0.25;
			this->Invalidate(false);
		}
	}
}

void CCheckTrView::BoxCarF(int param1, int lng, int *DataArray)
{
	//param1	-	BoxCar parameter (pixels number)
	//lng		-	length of array
	//DataArray	-	DataArray
	int i,j,tmp;
	tmp=0;
	for(i=0;i<=param1;i++)
	{
		for(j=0;j<=i+param1;j++) tmp+=DataArray[j];
		tmp/=i+param1+1;
		DataArray[i]=tmp;
		tmp=0;
	}
	for(i=param1;i<=lng-param1;i++)
	{
		for(j=-param1;j<=param1;j++)	tmp+=DataArray[i+j];
		tmp/=2*param1+1;
		DataArray[i]=tmp;
		tmp=0;
	}
	for(i=lng-param1;i<=lng;i++)
	{
		for(j=i-param1;j<=lng;j++)	tmp+=DataArray[j];
		tmp/=lng-i+param1+1;
		DataArray[i]=tmp;
		tmp=0;
	}
}


void CCheckTrView::OnOpenSpectra() 
{
//	pThread->SuspendThread();

	CWinApp* pApp=AfxGetApp();
	CString Out;
	char temp1;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];
	CFile* lpOutFile;
	int i,j,tmp1,pixNmb;

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_OPENFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,TRUE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			lpOutFile=new CFile(File_Name,CFile::modeRead|CFile::shareDenyNone);
		}
		catch(...)
		{
			MessageBox("UNABLE TO OPEN FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	
		lpOutFile->SeekToBegin();
		tmp1=lpOutFile->GetLength();
		j=-1;

		lpOutFile->Read(&temp1,sizeof(char));
		lpOutFile->SeekToBegin();
		pixNmb=0;
		while(lpOutFile->GetPosition()<tmp1)
		{
			j++;
			if(j==3652)
				i=0;
			Out.Empty();
			while((temp1!='	')&&(lpOutFile->GetPosition()<tmp1))
			{
				lpOutFile->Read(&temp1,sizeof(char));
				Out.Insert(Out.GetLength()+1,temp1);
			}
			temp1=0;
			Out.Insert(Out.GetLength()+1,temp1);
			if(Out.GetLength()>1)
			{
				LoadedXSpectra[j]=atof(Out);
			}
			lpOutFile->Read(&temp1,sizeof(char));
			Out.Empty();
			while((temp1!='\r')&&(lpOutFile->GetPosition()<tmp1))
			{
				Out.Insert(Out.GetLength()+1,temp1);
				lpOutFile->Read(&temp1,sizeof(char));
			}
			lpOutFile->Read(&temp1,sizeof(char));
			temp1=0;
			Out.Insert(Out.GetLength()+1,temp1);
			if(Out.GetLength()>1)
			{
				LoadedSpectra[j]=atof(Out);
			}
			else
			{
				j--;
			}
			pixNmb++;
		}
		
		pixNmb--;
	   if(lpOutFile) lpOutFile->Close();
	   delete lpOutFile;

//	   if(j!=MaxXT) ::MessageBox(0,"Number of spectral points is not correct","Warning",MB_OK|MB_SYSTEMMODAL);
//	   else
	   {
		   int TotLength=0;
		   i=0;
		   while(SpectraLength_T[i]!=-1) i++;
		   LoadSpecFlag=i;
		   for(i=0;i<LoadSpecFlag;i++) TotLength+=SpectraLength_T[i]+1;
		   for (i=0;i<=pixNmb;i++)
		   {
					SpectraData_T[i+TotLength]=LoadedSpectra[i];
					SpectraWavelength_T[i+TotLength]=LoadedXSpectra[i];
			}
		   	SpectraLength_T[LoadSpecFlag]=pixNmb;
			SpectraColorR_T[LoadSpecFlag]=100*(LoadSpecFlag+1);
			SpectraColorG_T[LoadSpecFlag]=100*(LoadSpecFlag+2);
			SpectraColorB_T[LoadSpecFlag]=100*(LoadSpecFlag+3);
			SpectraColorW_T[LoadSpecFlag]=1;
			SpectraLength_T[LoadSpecFlag+1]=-1;
//			OnXyautoscale();
	   }
	}
	this->Invalidate(false);
//	pThread->ResumeThread();
}

void CCheckTrView::OnSnap() 
{
	int pixNmb=MaxXT;
	int TotLength=0;
	int i=0;
	while(SpectraLength_T[i]!=-1) i++;
	LoadSpecFlag=i;
	for(i=0;i<LoadSpecFlag;i++) TotLength+=SpectraLength_T[i]+1;
	for (i=0;i<=pixNmb;i++)
	{
		if(SpecToGet==0)	SpectraData_T[i+TotLength]=Spectra[i];
		else				SpectraData_T[i+TotLength]=Spectra1[i];
		SpectraWavelength_T[i+TotLength]=Xscl_lmbd[i];
	}
	SpectraLength_T[LoadSpecFlag]=pixNmb;
	SpectraColorR_T[LoadSpecFlag]=100*(LoadSpecFlag+1);
	SpectraColorG_T[LoadSpecFlag]=100*(LoadSpecFlag+2);
	SpectraColorB_T[LoadSpecFlag]=100*(LoadSpecFlag+3);
	SpectraColorW_T[LoadSpecFlag]=1;
	SpectraLength_T[LoadSpecFlag+1]=-1;
	LoadSpecFlag++;
	this->Invalidate(false);
}

void CCheckTrView::OnClearall() 
{
	LoadSpecFlag=0;
	SpectraLength_T[LoadSpecFlag+1]=-1;
	GaussAppr=false;
	this->Invalidate(false);
}

void CCheckTrView::OnFileOpen1() 
{
	OnOpenSpectra();
}

void CCheckTrView::OnVIEW400to700() 
{
	lmbdMin=390;
	lmbdMax=710;
	this->Invalidate(false);	
}

void CCheckTrView::OnAbout() 
{
	CAboutB ClDlg;
	CString Out,Out1;
	Out1=InfoString;
	sprintf(Out.GetBuffer(48),"device info: ");
	Out.ReleaseBuffer();
	Out.Insert(Out.GetLength(),Out1);

	ClDlg.m_DeviceInfo=Out;
	if(ClDlg.DoModal()==IDOK)//write to memory
	{
	}
}

void CCheckTrView::OnXyspace() 
{
	CString Out;
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pXYSpace = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_XYSPACE));
	
	if(XYSpace==true)
	{
		XYSpace=false;
		pXYSpace->SetCheck(0);
	}
	else
	{
		XYSpace=true;
		pXYSpace->SetCheck(1);
	}
	this->Invalidate(false);//create and show BitMap
}

void CCheckTrView::OnFilePrintPreview() 
{
//	CView::OnFilePrintPreview();
}

void CCheckTrView::OnFilePrint() 
{
      CPrintDialog dlgPrint(FALSE,PD_ALLPAGES,this);

      if (dlgPrint.DoModal()==IDOK)
      {
         // ** Attach the printer DC from the dialog
          // ** to a CDC object
          CDC dcPrint;
          dcPrint.Attach(dlgPrint.GetPrinterDC());

          // ** Create and fill a DOCINFO structure
          DOCINFO myPrintJob;
          myPrintJob.cbSize = sizeof(myPrintJob);
          myPrintJob.lpszDocName = "MyPrintJob";
          myPrintJob.lpszOutput = NULL;
          myPrintJob.lpszDatatype = NULL;
          myPrintJob.fwType = NULL;

          // ** Start the printing document
          if (dcPrint.StartDoc(&myPrintJob)>=0)
          {
              // ** Start a page
              dcPrint.StartPage();
			  CRect RectT1;
			  dcPrint.GetClipBox(RectT1);

			CRect rect;
			this->GetClientRect( rect );
			CDC memDC2;

			CClientDC dc( this );
			memDC2.CreateCompatibleDC( &dc );
			CBitmap bitmap;
			bitmap.CreateCompatibleBitmap( &dc, rect.Width(), rect.Height() );
			LocalGDI local( &memDC2, &bitmap );

			CDC *memDC = CDC::FromHandle(dc);

			memDC2.StretchBlt(0,0,rect.Width(), rect.Height(),memDC, 0,0,rect.Width(), rect.Height(),SRCCOPY);

			if(  (double)(RectT1.Width())  /  (double)(RectT1.Height())   >  (double)(rect.Width())  /  (double)(rect.Height())  ) //use printer hight for maximul filling
				dcPrint.StretchBlt( 0, 0, RectT1.Height()*rect.Width()/rect.Height(),RectT1.Height(),&memDC2, 0, 0, rect.Width(), rect.Height(),SRCCOPY );
			else //use  printer width for maximul filling
				dcPrint.StretchBlt( 0, 0, RectT1.Width(),RectT1.Width()*rect.Height()/rect.Width(),&memDC2, 0, 0, rect.Width(), rect.Height(),SRCCOPY );

              // ** Throw the page
              dcPrint.EndPage();
              // ** Close the document
              dcPrint.EndDoc();

			  memDC2.DeleteDC();
			  memDC->DeleteDC();
			  bitmap.DeleteObject();
          }
          // ** Delete the printer device context
          dcPrint.DeleteDC();
      }
}

void CCheckTrView::OnChoosespectr() 
{
	if(Run_get_spec==false)
	{
		firstStart=false;
//		CMainFrame *cFrame	= reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
//		CButton *pRun		= reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
//		pRun->EnableWindow(false);
		conn_Dev=0;
		SendMessage(5);//get number of connected devices
//		Sleep(1000);
	}
	else ::MessageBox(0,"Stop Acquisition first","Message",MB_OK|MB_SYSTEMMODAL);
}

void CCheckTrView::OnXyzminus() 
{
	if(XYSpace==true)
	{
		colorSize+=0.25;
		this->Invalidate(false);
	}
}

void CCheckTrView::OnXyzplus() 
{
	if(XYSpace==true)
	{
		colorSize-=0.25;
		this->Invalidate(false);
	}
}

void CCheckTrView::OnCnstr() 
{
	if(MinRef_or_DevRef!=3)	::MessageBox(0,"It can be used in ABS mode","Message",MB_OK|MB_SYSTEMMODAL);
	else
	{
		CString Out;
		CConcentration ExpDlg;

		sprintf(Out.GetBuffer(16),"%.2f", MolExt);
		Out.ReleaseBuffer();
		ExpDlg.m_MolAbs=Out;

		sprintf(Out.GetBuffer(16),"%.2f", CuvLength);
		Out.ReleaseBuffer();
		ExpDlg.m_OptLength=Out;

		sprintf(Out.GetBuffer(16),"%.2f", ref_line);
		Out.ReleaseBuffer();
		ExpDlg.m_Wavelength=Out;

		ExpDlg.m_ConcSet=true;//ConcentrationSet;

		if(ExpDlg.DoModal()==IDOK)
		{
			MolExt=atof(ExpDlg.m_MolAbs);
			if(MolExt<=0)
			{
				MolExt=1;
				::MessageBox(0,"molar absorptivity (extinction coefficient) of the absorber should be positive","Message",MB_OK|MB_SYSTEMMODAL);
			}
			CuvLength=atof(ExpDlg.m_OptLength);
			if(CuvLength<=0)
			{
				CuvLength=1;
				::MessageBox(0,"cuvette length should be positive","Message",MB_OK|MB_SYSTEMMODAL);
			}
			ref_line=atof(ExpDlg.m_Wavelength);
			if(ref_line>lmbdMax) ref_line=lmbdMax;
			if(ref_line<lmbdMin) ref_line=lmbdMin;
			ConcentrationSet=ExpDlg.m_ConcSet;
			this->Invalidate(false);
		}
	}
}

void CCheckTrView::OnLog() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());	
	CButton *pCheckLog   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_LOG));

	if(Log==false)
	{
		pCheckLog->SetCheck(1);
		Log=true;
	}
	else
	{
		pCheckLog->SetCheck(0);
		Log=false;
	}
}

void CCheckTrView::BaselineCorr1(int Speclength, int windowG, int iterations, double *SpecArray)
{
	double conv1[4096];
	double convD[4096];
	double Smoothed1[4096];
	double SpectraT[4096];
	double tmpD[4096];
	int k,m;
	int window1=6;

	if(abs(windowG-2*int(windowG/2))>0) windowG=windowG+1;

	for(k=1;k<=Speclength; k++)
	{
	    conv1[k]=0;
	    convD[k]=0;
	    Smoothed1[k]=0;
		SpectraT[k]=SpecArray[k];
	}

	for(m=1;m<=iterations;m++)
	{
        if(m==1) window1=6;
		else window1=windowG;
    
	    conv1[1]=SpectraT[1];

	    for(k=2;k<=window1/2+1;k++)	conv1[k]=(conv1[k-1]*((k-2)*2+1)+SpectraT[(k-1)*2+1]+SpectraT[(k-1)*2])/((k-1)*2+1);

	    for(k=window1/2+2;k<=Speclength-window1/2;k++)	conv1[k]=conv1[k-1]+(-SpectraT[k-window1/2-1]+SpectraT[k+window1/2])/(window1+1);
    
		for(k=1;k<=window1+1;k++)	tmpD[k]=SpectraT[Speclength-k+1];
    
	    convD[1]=tmpD[1];
	    for(k=2;k<=window1/2+1;k++)	convD[k]=(convD[k-1]*((k-2)*2+1)+tmpD[(k-1)*2+1]+tmpD[(k-1)*2])/((k-1)*2+1);
    
		for(k=1;k<=window1/2+1;k++)	conv1[Speclength-k+1]=convD[k];
    
	    if(m>1)
		{
		    for(k=1;k<=Speclength;k++)
			{
				if(conv1[k]>SpecArray[k])
				{
					conv1[k]=Smoothed1[k];
				}
			}
		}
		else
		{
			for(k=1;k<=Speclength;k++)
			{
				Smoothed1[k]=conv1[k];
			}
		}

		for(k=1;k<=Speclength;k++)
		{
			SpectraT[k]=conv1[k];
		}
	}

	for(k=1;k<=Speclength;k++)
	{
		SpecArray[k]=SpecArray[k]-SpectraT[k];
	}
	SpecArray[0]=SpecArray[1];
}

void CCheckTrView::OnBaseline() 
{
	CBaseline BaselineDlg;
	CString Out;

	sprintf(Out.GetBuffer(16),"%d", windowG);
	Out.ReleaseBuffer();
	BaselineDlg.m_WindSize=Out;

	sprintf(Out.GetBuffer(16),"%d", iterations);
	Out.ReleaseBuffer();
	BaselineDlg.m_Iterations=Out;

	BaselineDlg.loaded1=false;

	if(BaselineDlg.DoModal()==IDOK)
	{
		windowG=atof(BaselineDlg.m_WindSize);
		iterations=atof(BaselineDlg.m_Iterations);
		if(BaselineDlg.loaded1==false)//baseline correction for collected spectra
		{
			if(SpecToGet==0)	BaselineCorr1(MaxX-MinX, windowG, iterations, Spectra);
			else				BaselineCorr1(MaxX-MinX, windowG, iterations, Spectra1);
		}
		else//baseline correction for collected spectra
		{
			for (int km=0; km<=MaxX-MinX; km++)
			{
				if(SpecToGet==0) Spectra[km]=LoadedSpectra[MinX+km];
				else	Spectra1[km]=LoadedSpectra[MinX+km];
			}
			if(SpecToGet==0)	BaselineCorr1(MaxX-MinX, windowG, iterations, Spectra);
			else				BaselineCorr1(MaxX-MinX, windowG, iterations, Spectra1);
		}
	}
	OnYautoscale();
}

void CCheckTrView::OnAutoy() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pAutoY   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_AUTOY));

	if(pAutoY->GetCheck()==0)
	{
		AutoY=false;
	}
	else
	{
		AutoY=true;
	}
}

void CCheckTrView::OnViewCm() 
{
	int i;
	if(coeff_B>0)
	{
		SclDir=true;
		for(i=0;i<=TotPix;i++)
		{
			Xscl_lmbd[i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
			Xscl_lmbd[i]=10000000*(1/532.1-1/Xscl_lmbd[i]);
		}
	}
	else
	{
		SclDir=false;
		for(i=0;i<=TotPix;i++)
		{
			Xscl_lmbd[TotPix-i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
			Xscl_lmbd[TotPix-i]=10000000*(1/532.1-1/Xscl_lmbd[TotPix-i]);
		}
	}
	CMscaleView=true;
	OnXyautoscale();
}

void CCheckTrView::OnViewNm() 
{
	int i;
	if(coeff_B>0)
	{
		SclDir=true;
		for(i=0;i<=TotPix;i++)
		{
			Xscl_lmbd[i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
		}
	}
	else
	{
		SclDir=false;
		for(i=0;i<=TotPix;i++)
		{
			Xscl_lmbd[TotPix-i]=((double)((int)((coeff_C+coeff_B*i+coeff_A*i*i)*100)))/100;
		}
	}
	CMscaleView=false;
	OnXyautoscale();
}

void CCheckTrView::OnPlstClbr() //Polystyrene
{
	if(StartEx==false && Run_get_spec==true && Fast==false)//no run getting spectra
	{
		MessageBox("Stop Acquisition","Request",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		CString Out7;
		int k;
		double max1001, max621, max1602;
		double tmpInts;
		int ind1001,ind621,ind1602;
		max621=0;
		max1001=0; 
		max1602=0;
		//1001.4, 620.9, 1602.3 Xscl_lmbd// 3054.3
		double x1,x2,x3,y1,y2,y3;
		if(Xscl_lmbd[TotPix]>=3300)
		{
			for(k=0;k<=TotPix;k++)
			{
				if(SpecToGet==0)	tmpInts=Spectra[k];
				else				tmpInts=Spectra1[k];
				if((Xscl_lmbd[k]>=621-100)&(Xscl_lmbd[k]<=621+100))
				{
					if(tmpInts>max621)
					{
						max621=tmpInts;
						ind621=k;
					}
				}
				if((Xscl_lmbd[k]>=1602-100)&(Xscl_lmbd[k]<=1602+100))
				{
					if(tmpInts>max1001)
					{
						max1001=tmpInts;
						ind1001=k;
					}
				}	

				if((Xscl_lmbd[k]>=3054-100)&(Xscl_lmbd[k]<=3054+100))
				{
					if(tmpInts>max1602)
					{
						max1602=tmpInts;
						ind1602=k;
					}
				}
			}
			if(coeff_B<0)
			{
				ind621	=	TotPix-ind621;
				ind1001	=	TotPix-ind1001;
				ind1602	=	TotPix-ind1602;
			}
			y1=10000000/(10000000/532.1-620.9);		x1=ind621;//(1/532.1-1/col(C))*10^7
			y2=10000000/(10000000/532.1-1602.3);	x2=ind1001;
			y3=10000000/(10000000/532.1-3054.3);	x3=ind1602;
		}
		else
		{
			for(k=0;k<=TotPix;k++)
			{
				if(SpecToGet==0)	tmpInts=Spectra[k];
				else				tmpInts=Spectra1[k];
				if((Xscl_lmbd[k]>=621-100)&(Xscl_lmbd[k]<=621+100))
				{
					if(tmpInts>max621)
					{
						max621=tmpInts;
						ind621=k;
					}
				}
				if((Xscl_lmbd[k]>=1001-100)&(Xscl_lmbd[k]<=1001+100))
				{
					if(tmpInts>max1001)
					{
						max1001=tmpInts;
						ind1001=k;
					}
				}	

				if((Xscl_lmbd[k]>=1602-100)&(Xscl_lmbd[k]<=1602+100))
				{
					if(tmpInts>max1602)
					{
						max1602=tmpInts;
						ind1602=k;
					}
				}
			}
			if(coeff_B<0)
			{
				ind621	=	TotPix-ind621;
				ind1001	=	TotPix-ind1001;
				ind1602	=	TotPix-ind1602;
			}
			y1=10000000/(10000000/532.1-620.9);		x1=ind621;//(1/532.1-1/col(C))*10^7
			y2=10000000/(10000000/532.1-1001.4);	x2=ind1001;
			y3=10000000/(10000000/532.1-1602.3);	x3=ind1602;
		}
		double new_coeff_A,new_coeff_B,new_coeff_C;
		new_coeff_B=(y1*(x3*x3-x2*x2)+y2*(x1*x1-x3*x3)+y3*(x2*x2-x1*x1))/(x1*x2*(x1-x2)+x2*x3*(x2-x3)+x1*x3*(x3-x1));
		new_coeff_C=y1-new_coeff_B*x1-x1*x1*(y2-y1+new_coeff_B*(x1-x2))/(x2*x2-x1*x1);
		new_coeff_A=(y2-y1+new_coeff_B*(x1-x2))/(x2*x2-x1*x1);

		CThreePointsCalibration ClbrThreeDlg;

		sprintf(Out7.GetBuffer(80),"old A=%e", coeff_A);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_OldA=Out7;

		sprintf(Out7.GetBuffer(80),"old B=%e", coeff_B);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_OldB=Out7;

		sprintf(Out7.GetBuffer(80),"old C=%e", coeff_C);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_OldC=Out7;

		sprintf(Out7.GetBuffer(80),"new A=%e", new_coeff_A);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_NewA=Out7;

		sprintf(Out7.GetBuffer(80),"new B=%e", new_coeff_B);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_NewB=Out7;

		sprintf(Out7.GetBuffer(80),"new C=%e", new_coeff_C);
		Out7.ReleaseBuffer();
		ClbrThreeDlg.m_NewC=Out7;

		if(ClbrThreeDlg.DoModal()==IDOK)
		{
			coeff_A=new_coeff_A;
			coeff_B=new_coeff_B;
			coeff_C=new_coeff_C;
//			CalibrationCoeffToMemory();
			Sleep(2000);
		}
	}
}

void CCheckTrView::OnSaveCalibration() 
{
////!!!!!!!!!!! Warning NormS and ColorNorm are saved and loaded not inverced if coeff_B<0;
//	pThread->SuspendThread();

	CWinApp* pApp=AfxGetApp();
	CString Out;
	char temp1;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];
	CFile* lpOutFile;
	int i,tmp1;
	bool fileoppened=true;

	if(SaveCalibrationAskUser==true)
	{
		VERIFY(pApp->m_pDocManager!=NULL);
		if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
		{
			GetCurrentDirectory(_MAX_DIR,Cur_Dir);
			VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
			try
			{
				int tmpCLBR=File_Name.Find(".clbr",0);
				if(tmpCLBR==0)
				{
					Out.Format(".clbr");
					File_Name.Insert(File_Name.GetLength(),Out);
				}
				lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
				lpOutFile->SeekToBegin();
			}
			catch(...)
			{
				MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
				fileoppened=false;
			}
		}
	}
	else
	{
		try
		{
			File_Name.Format(".clbr");
			for(i=15;i>=10;i--)
			{
				File_Name.Insert(0,InfoString[i]);
			}
			lpOutFile=new CFile(File_Name,CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
			lpOutFile->SeekToBegin();
		}
		catch(...)
		{
			MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
			fileoppened=false;
		}
	}
	SaveCalibrationAskUser=true;
	if(fileoppened==true)
	{
		for(i=0;i<=15;i++)	lpOutFile->Write(InfoString+i,sizeof(char));
		temp1='\r';
		lpOutFile->Write(&temp1,sizeof(char));
		temp1='\n';
		lpOutFile->Write(&temp1,sizeof(char));

		tmp1=0;
		Out.Format("%e\t",EnergyCorrect);
		tmp1=Out.GetLength();
		lpOutFile->Write(Out,tmp1);
		Out.Empty();
		for(i=0;i<=10;i++)
		{
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
		}

////!!!!!!!!!!! Warning NormS and ColorNorm are saved and loaded not inverced if coeff_B<0;
		for(i=0;i<3653;i++)
		{
			tmp1=0;
			if(SclDir==true)
				Out.Format("%.3f\t",Xscl_lmbd[i]);
			else
				Out.Format("%.3f\t",Xscl_lmbd[3652-i]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
		}
		temp1='\r';
		lpOutFile->Write(&temp1,sizeof(char));
		temp1='\n';
		lpOutFile->Write(&temp1,sizeof(char));

		for(i=1;i<=3653;i++)
		{
			tmp1=0;
			if(SclDir==true)
				Out.Format("%.3f\t",NormS[i]);
			else
				Out.Format("%.3f\t",NormS[3653-i]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
		}
		lpOutFile->Write("0",sizeof(char));
		temp1='\r';
		lpOutFile->Write(&temp1,sizeof(char));
		temp1='\n';
		lpOutFile->Write(&temp1,sizeof(char));

		temp1='\r';
		lpOutFile->Write(&temp1,sizeof(char));
		temp1='\n';
		lpOutFile->Write(&temp1,sizeof(char));

		for(i=1;i<=3653;i++)
		{
			tmp1=0;
			if(SclDir==true)
				Out.Format("%.3f\t",ColorNorm[i]);
			else
				Out.Format("%.3f\t",ColorNorm[3653-i]);
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();
			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
		}
		lpOutFile->Write("0",sizeof(char));
		temp1='\r';
		lpOutFile->Write(&temp1,sizeof(char));
		temp1='\n';
		lpOutFile->Write(&temp1,sizeof(char));
		if(lpOutFile) lpOutFile->Close();
		delete lpOutFile;
	}
//	pThread->ResumeThread();
}

void CCheckTrView::OnLoadCalibration() 
{
////!!!!!!!!!!! Warning NormS and ColorNorm are saved and loaded not inverced if coeff_B<0;
//	pThread->SuspendThread();

	CWinApp* pApp=AfxGetApp();
	CString Out;
	char temp1;
	CString File_Name;
	char Cur_Dir[_MAX_DIR];
	CFile* lpOutFile;
	int i,tmp1,flag;
	bool fileoppened=true;

	VERIFY(pApp->m_pDocManager!=NULL);
	if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_OPENFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,TRUE,NULL))
	{
		GetCurrentDirectory(_MAX_DIR,Cur_Dir);
		VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
		try
		{
			lpOutFile=new CFile(File_Name,CFile::modeRead|CFile::shareDenyNone);
		}
		catch(...)
		{
			MessageBox("UNABLE TO OPEN FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
			fileoppened=false;
		}
		if(fileoppened==true)
		{
			flag=0;
			lpOutFile->SeekToBegin();
			tmp1=lpOutFile->GetLength();

			unsigned char buffer[130000];

			for(i=0;i<=tmp1;i++)
			{
				lpOutFile->Read(buffer+i,sizeof(char));
			}
			for(i=0;i<=16;i++) InfoString[i]=buffer[i];

			if(InfoString[5]=='.')
			{
				CString Out;
				int countLines=0;
				i=0;
				while(countLines<1)
				{
					if(buffer[i]==10) countLines++;
					i++;
				}
				Out.Empty();
				while(buffer[i]!=10)
				{
					Out.Insert(Out.GetLength()+1,buffer[i]);
					i++;
				}
				EnergyCorrect=atof(Out);
				bck_a=EnergyCorrect;
				Out.Empty();

				countLines=0;
				i=0;
				while(countLines<12)
				{
					if(buffer[i]==10) countLines++;
					i++;
				}
				countLines=0;
				Out.Empty();
			//	i++;
				while(countLines<3653)
				{
					Out.Insert(Out.GetLength()+1,buffer[i]);
					i++;
					if(buffer[i]==10)
					{
						Xscl_lmbd[countLines]=atof(Out);
						countLines++;
						Out.Empty();
					}
				}
				i=i+2;
				countLines=0;
				Out.Empty();
				while(countLines<3653)
				{
					Out.Insert(Out.GetLength()+1,buffer[i]);
					i++;
					if(buffer[i]==10)
					{
						NormS[countLines]=atof(Out);
						countLines++;
						Out.Empty();
					}
				}
				i=i+4;
				countLines=0;
				Out.Empty();
				while(countLines<3653)
				{
					Out.Insert(Out.GetLength()+1,buffer[i]);
					i++;
					if(buffer[i]==10)
					{
						if(Out.GetLength()>1)
						{
							ColorNorm[countLines]=atof(Out);
							countLines++;
							Out.Empty();
						}
					}
				}

				if(Xscl_lmbd[1]>Xscl_lmbd[0])
					SclDir=true;
				else
				{
					SclDir=false;
					double tmp_norm1;
					for(i=0;i<=TotPix/2;i++)
					{
						tmp_norm1=NormS[i];
						NormS[i]=NormS[TotPix-i];
						NormS[TotPix-i]=tmp_norm1;
						tmp_norm1=ColorNorm[i];
						ColorNorm[i]=ColorNorm[TotPix-i];
						ColorNorm[TotPix-i]=tmp_norm1;
						tmp_norm1=Xscl_lmbd[i];
						Xscl_lmbd[i]=Xscl_lmbd[TotPix-i];
						Xscl_lmbd[TotPix-i]=tmp_norm1;
					}
				}
			}
			else//no info string
			{
				for(i=0;i<3653;i++)
				{
					Xscl_lmbd[i]=i;
					NormS[i]=1;
					ColorNorm[i]=1;
				}
			}

			if(lpOutFile) lpOutFile->Close();
			delete lpOutFile;

			CMainFrame *cFrame	= reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
			CButton *pRun		= reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
			pRun->EnableWindow(true);
			if(InfoString[10]=='Y')
			{
				CButton *pXYSpace    = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_XYSPACE));
				pXYSpace->EnableWindow(true);
				XYZ_CRI_calibr=true;
			}
			else
				XYZ_CRI_calibr=false;
			lmbdMin=Xscl_lmbd[0];
			lmbdMax=Xscl_lmbd[TotPix];
			ref_line_index=1825;
			this->Invalidate(false);//create and show BitMap
		}
	}
	else
	{
		OnCalibrationOff();
	}
//	pThread->ResumeThread();
}

void CCheckTrView::OnPlanckcalibration() 
{
	CPlanckTemperature ExpDlg;
	CString Out;
	sprintf(Out.GetBuffer(16),"%d",3200);
	Out.ReleaseBuffer();
	ExpDlg.m_BlackBodyTemperature=Out;

	if(ExpDlg.DoModal()==IDOK)
	{
		int ind1;
		//		360 and 750nm : two wavelenghts for color edges normalization
		int highColorWvlth	=	750;
		int highWvlthIndex;
		int lowColorWvlth	=	360;
		int lowWvlthIndex;
		double highWvlth=1000;
		double lowWvlth=1000;
		for(ind1=0;ind1<=TotPix;ind1++)
		{
			if(abs(Xscl_lmbd[ind1]-highColorWvlth)<=highWvlth)
			{
				highWvlthIndex=ind1;
				highWvlth=abs(Xscl_lmbd[ind1]-highColorWvlth);
			}
			if(abs(Xscl_lmbd[ind1]-lowColorWvlth)<=lowWvlth)
			{
				lowWvlthIndex=ind1;
				lowWvlth=abs(Xscl_lmbd[ind1]-lowColorWvlth);
			}
		}

		double BlackBodyTemperature;
		double spdref[3653];
		double NormPlanck[3653];
		double MinPlanck,MaxPlanck;
		BlackBodyTemperature=atof(ExpDlg.m_BlackBodyTemperature);
		for(ind1=0;ind1<=3652;ind1++)		spdref[ind1] = 1000/(Xscl_lmbd[ind1]/1000*Xscl_lmbd[ind1]/1000*Xscl_lmbd[ind1]/1000*Xscl_lmbd[ind1]/1000*Xscl_lmbd[ind1]/1000) / (exp(14404000/Xscl_lmbd[ind1]/BlackBodyTemperature) - 1);
		MaxPlanck=spdref[0];
		for(ind1=0;ind1<=3652;ind1++)		if(spdref[ind1]>MaxPlanck) MaxPlanck=spdref[ind1];
		for(ind1=0;ind1<=3652;ind1++)		spdref[ind1]/=MaxPlanck;
		MinPlanck=100000;
		MaxPlanck=0;
		for(ind1=0;ind1<=3652;ind1++)
		{
			if(SpecToGet==0)	NormPlanck[ind1]=Spectra[ind1];
			else				NormPlanck[ind1]=Spectra1[ind1];

			if(NormPlanck[ind1]<MinPlanck) MinPlanck=NormPlanck[ind1];
			if(NormPlanck[ind1]>MaxPlanck) MaxPlanck=NormPlanck[ind1];
		}
		for(ind1=0;ind1<=3652;ind1++)
		{
			NormPlanck[ind1]-=MinPlanck;
			NormPlanck[ind1]+=0.01;
			NormPlanck[ind1]/=(MaxPlanck-MinPlanck);
			NormPlanck[ind1]=spdref[ind1]/NormPlanck[ind1];
		}
		for(ind1=0;ind1<=3652;ind1++)	ColorNorm[ind1]=NormPlanck[ind1];

		highWvlth=0;
		lowWvlth=100000000;
		for(ind1=lowWvlthIndex;ind1<=highWvlthIndex;ind1++)	if(ColorNorm[ind1]<lowWvlth) lowWvlth=ColorNorm[ind1];
		for(ind1=0;ind1<=3652;ind1++)	
		{
			ColorNorm[ind1]/=lowWvlth;
			if(ColorNorm[ind1]>300) ColorNorm[ind1]=0;
		}
	}
}

void CCheckTrView::ColorSpectraMultiplying(double *SourceSpectr,double *WlgthSpectra,int ArLength1,double *ResultsData)
{
	double isoTempLinesTable[601][4];							//0 colum - temperature; 1 - u; 2 - v; 3 - w
	double wavelength[471],xbar[471],ybar[471],zbar[471];		//XYZ curves
	double TCS[15][471];											//Test color samples
	double X,Y,Z;
	double Yknormal, Yrnormal;
	double Tc;
	double DC;
	double uk,vk,ur,vr;//k-for measured spectra; r- for reference (plancian of corresponding temperature
	double uki[15],vki[15],uri[15],vri[15];
	double deltaE[15];
	double R[15];

		//	Isoterm lines:	isoTempLinesTable = [T' u' v' m'];
	isoTempLinesTable[0][0	]=	100000000	;		isoTempLinesTable[	0	]	[	1	]=	0.180064901	;		isoTempLinesTable[	0	]	[	2	]=	0.263523499	;		isoTempLinesTable[	0	]	[	3	]=	-0.243421273	;
	isoTempLinesTable[1][0	]=	1000000		;		isoTempLinesTable[	1	]	[	1	]=	0.18012011	;		isoTempLinesTable[	1	]	[	2	]=	0.263749835	;		isoTempLinesTable[	1	]	[	3	]=	-0.244434823	;
	isoTempLinesTable[2][0	]=	500000		;		isoTempLinesTable[	2	]	[	1	]=	0.180176592	;		isoTempLinesTable[	2	]	[	2	]=	0.263980415	;		isoTempLinesTable[	2	]	[	3	]=	-0.245483727	;
	isoTempLinesTable[3][0	]=	333333.3333	;		isoTempLinesTable[	3	]	[	1	]=	0.180233802	;		isoTempLinesTable[	3	]	[	2	]=	0.264212957	;		isoTempLinesTable[	3	]	[	3	]=	-0.246557954	;
	isoTempLinesTable[4][0	]=	250000		;		isoTempLinesTable[	4	]	[	1	]=	0.180291747	;		isoTempLinesTable[	4	]	[	2	]=	0.26444745	;		isoTempLinesTable[	4	]	[	3	]=	-0.247657581	;
	isoTempLinesTable[5][0	]=	200000		;		isoTempLinesTable[	5	]	[	1	]=	0.180350434	;		isoTempLinesTable[	5	]	[	2	]=	0.264683884	;		isoTempLinesTable[	5	]	[	3	]=	-0.248782686	;
	isoTempLinesTable[6][0	]=	166666.6667	;		isoTempLinesTable[	6	]	[	1	]=	0.180409873	;		isoTempLinesTable[	6	]	[	2	]=	0.26492225	;		isoTempLinesTable[	6	]	[	3	]=	-0.249933344	;
	isoTempLinesTable[7][0	]=	142857.1429	;		isoTempLinesTable[	7	]	[	1	]=	0.180470069	;		isoTempLinesTable[	7	]	[	2	]=	0.265162537	;		isoTempLinesTable[	7	]	[	3	]=	-0.25110963	;
	isoTempLinesTable[8][0	]=	125000		;		isoTempLinesTable[	8	]	[	1	]=	0.180531032	;		isoTempLinesTable[	8	]	[	2	]=	0.265404734	;		isoTempLinesTable[	8	]	[	3	]=	-0.252311615	;
	isoTempLinesTable[9][0	]=	111111.1111	;		isoTempLinesTable[	9	]	[	1	]=	0.18059277	;		isoTempLinesTable[	9	]	[	2	]=	0.265648828	;		isoTempLinesTable[	9	]	[	3	]=	-0.253539371	;
	isoTempLinesTable[10][0	]=	100000		;		isoTempLinesTable[	10	]	[	1	]=	0.180655289	;		isoTempLinesTable[	10	]	[	2	]=	0.265894808	;		isoTempLinesTable[	10	]	[	3	]=	-0.254792966	;
	isoTempLinesTable[11][0	]=	90909.09091	;		isoTempLinesTable[	11	]	[	1	]=	0.180718598	;		isoTempLinesTable[	11	]	[	2	]=	0.266142661	;		isoTempLinesTable[	11	]	[	3	]=	-0.25607247	;
	isoTempLinesTable[12][0	]=	83333.33333	;		isoTempLinesTable[	12	]	[	1	]=	0.180782706	;		isoTempLinesTable[	12	]	[	2	]=	0.266392374	;		isoTempLinesTable[	12	]	[	3	]=	-0.257377947	;
	isoTempLinesTable[13][0	]=	76923.07692	;		isoTempLinesTable[	13	]	[	1	]=	0.180847619	;		isoTempLinesTable[	13	]	[	2	]=	0.266643933	;		isoTempLinesTable[	13	]	[	3	]=	-0.258709463	;
	isoTempLinesTable[14][0	]=	71428.57143	;		isoTempLinesTable[	14	]	[	1	]=	0.180913345	;		isoTempLinesTable[	14	]	[	2	]=	0.266897325	;		isoTempLinesTable[	14	]	[	3	]=	-0.260067082	;
	isoTempLinesTable[15][0	]=	66666.66667	;		isoTempLinesTable[	15	]	[	1	]=	0.180979893	;		isoTempLinesTable[	15	]	[	2	]=	0.267152535	;		isoTempLinesTable[	15	]	[	3	]=	-0.261450865	;
	isoTempLinesTable[16][0	]=	62500		;		isoTempLinesTable[	16	]	[	1	]=	0.181047271	;		isoTempLinesTable[	16	]	[	2	]=	0.267409549	;		isoTempLinesTable[	16	]	[	3	]=	-0.262860873	;
	isoTempLinesTable[17][0	]=	58823.52941	;		isoTempLinesTable[	17	]	[	1	]=	0.181115485	;		isoTempLinesTable[	17	]	[	2	]=	0.26766835	;		isoTempLinesTable[	17	]	[	3	]=	-0.264297164	;
	isoTempLinesTable[18][0	]=	55555.55556	;		isoTempLinesTable[	18	]	[	1	]=	0.181184544	;		isoTempLinesTable[	18	]	[	2	]=	0.267928923	;		isoTempLinesTable[	18	]	[	3	]=	-0.265759796	;
	isoTempLinesTable[19][0	]=	52631.57895	;		isoTempLinesTable[	19	]	[	1	]=	0.181254455	;		isoTempLinesTable[	19	]	[	2	]=	0.268191252	;		isoTempLinesTable[	19	]	[	3	]=	-0.267248825	;
	isoTempLinesTable[20][0	]=	50000		;		isoTempLinesTable[	20	]	[	1	]=	0.181325227	;		isoTempLinesTable[	20	]	[	2	]=	0.268455321	;		isoTempLinesTable[	20	]	[	3	]=	-0.268764307	;
	isoTempLinesTable[21][0	]=	47619.04762	;		isoTempLinesTable[	21	]	[	1	]=	0.181396866	;		isoTempLinesTable[	21	]	[	2	]=	0.268721111	;		isoTempLinesTable[	21	]	[	3	]=	-0.270306293	;
	isoTempLinesTable[22][0	]=	45454.54545	;		isoTempLinesTable[	22	]	[	1	]=	0.181469382	;		isoTempLinesTable[	22	]	[	2	]=	0.268988607	;		isoTempLinesTable[	22	]	[	3	]=	-0.271874838	;
	isoTempLinesTable[23][0	]=	43478.26087	;		isoTempLinesTable[	23	]	[	1	]=	0.18154278	;		isoTempLinesTable[	23	]	[	2	]=	0.26925779	;		isoTempLinesTable[	23	]	[	3	]=	-0.27346999	;
	isoTempLinesTable[24][0	]=	41666.66667	;		isoTempLinesTable[	24	]	[	1	]=	0.181617069	;		isoTempLinesTable[	24	]	[	2	]=	0.269528642	;		isoTempLinesTable[	24	]	[	3	]=	-0.275091799	;
	isoTempLinesTable[25][0	]=	40000		;		isoTempLinesTable[	25	]	[	1	]=	0.181692257	;		isoTempLinesTable[	25	]	[	2	]=	0.269801144	;		isoTempLinesTable[	25	]	[	3	]=	-0.276740314	;
	isoTempLinesTable[26][0	]=	38461.53846	;		isoTempLinesTable[	26	]	[	1	]=	0.18176835	;		isoTempLinesTable[	26	]	[	2	]=	0.270075278	;		isoTempLinesTable[	26	]	[	3	]=	-0.278415582	;
	isoTempLinesTable[27][0	]=	37037.03704	;		isoTempLinesTable[	27	]	[	1	]=	0.181845356	;		isoTempLinesTable[	27	]	[	2	]=	0.270351024	;		isoTempLinesTable[	27	]	[	3	]=	-0.280117646	;
	isoTempLinesTable[28][0	]=	35714.28571	;		isoTempLinesTable[	28	]	[	1	]=	0.181923283	;		isoTempLinesTable[	28	]	[	2	]=	0.270628362	;		isoTempLinesTable[	28	]	[	3	]=	-0.281846553	;
	isoTempLinesTable[29][0	]=	34482.75862	;		isoTempLinesTable[	29	]	[	1	]=	0.182002137	;		isoTempLinesTable[	29	]	[	2	]=	0.270907273	;		isoTempLinesTable[	29	]	[	3	]=	-0.283602346	;
	isoTempLinesTable[30][0	]=	33333.33333	;		isoTempLinesTable[	30	]	[	1	]=	0.182081927	;		isoTempLinesTable[	30	]	[	2	]=	0.271187737	;		isoTempLinesTable[	30	]	[	3	]=	-0.285385065	;
	isoTempLinesTable[31][0	]=	32258.06452	;		isoTempLinesTable[	31	]	[	1	]=	0.182162659	;		isoTempLinesTable[	31	]	[	2	]=	0.271469732	;		isoTempLinesTable[	31	]	[	3	]=	-0.287194752	;
	isoTempLinesTable[32][0	]=	31250		;		isoTempLinesTable[	32	]	[	1	]=	0.18224434	;		isoTempLinesTable[	32	]	[	2	]=	0.271753238	;		isoTempLinesTable[	32	]	[	3	]=	-0.289031447	;
	isoTempLinesTable[33][0	]=	30303.0303	;		isoTempLinesTable[	33	]	[	1	]=	0.182326978	;		isoTempLinesTable[	33	]	[	2	]=	0.272038233	;		isoTempLinesTable[	33	]	[	3	]=	-0.290895188	;
	isoTempLinesTable[34][0	]=	29411.76471	;		isoTempLinesTable[	34	]	[	1	]=	0.182410579	;		isoTempLinesTable[	34	]	[	2	]=	0.272324696	;		isoTempLinesTable[	34	]	[	3	]=	-0.292786012	;
	isoTempLinesTable[35][0	]=	28571.42857	;		isoTempLinesTable[	35	]	[	1	]=	0.182495151	;		isoTempLinesTable[	35	]	[	2	]=	0.272612605	;		isoTempLinesTable[	35	]	[	3	]=	-0.294703957	;
	isoTempLinesTable[36][0	]=	27777.77778	;		isoTempLinesTable[	36	]	[	1	]=	0.182580699	;		isoTempLinesTable[	36	]	[	2	]=	0.272901939	;		isoTempLinesTable[	36	]	[	3	]=	-0.296649058	;
	isoTempLinesTable[37][0	]=	27027.02703	;		isoTempLinesTable[	37	]	[	1	]=	0.182667232	;		isoTempLinesTable[	37	]	[	2	]=	0.273192673	;		isoTempLinesTable[	37	]	[	3	]=	-0.298621349	;
	isoTempLinesTable[38][0	]=	26315.78947	;		isoTempLinesTable[	38	]	[	1	]=	0.182754755	;		isoTempLinesTable[	38	]	[	2	]=	0.273484787	;		isoTempLinesTable[	38	]	[	3	]=	-0.300620865	;
	isoTempLinesTable[39][0	]=	25641.02564	;		isoTempLinesTable[	39	]	[	1	]=	0.182843275	;		isoTempLinesTable[	39	]	[	2	]=	0.273778257	;		isoTempLinesTable[	39	]	[	3	]=	-0.302647637	;
	isoTempLinesTable[40][0	]=	25000		;		isoTempLinesTable[	40	]	[	1	]=	0.182932799	;		isoTempLinesTable[	40	]	[	2	]=	0.27407306	;		isoTempLinesTable[	40	]	[	3	]=	-0.304701698	;
	isoTempLinesTable[41][0	]=	24390.2439	;		isoTempLinesTable[	41	]	[	1	]=	0.183023332	;		isoTempLinesTable[	41	]	[	2	]=	0.274369172	;		isoTempLinesTable[	41	]	[	3	]=	-0.306783078	;
	isoTempLinesTable[42][0	]=	23809.52381	;		isoTempLinesTable[	42	]	[	1	]=	0.183114882	;		isoTempLinesTable[	42	]	[	2	]=	0.274666571	;		isoTempLinesTable[	42	]	[	3	]=	-0.308891809	;
	isoTempLinesTable[43][0	]=	23255.81395	;		isoTempLinesTable[	43	]	[	1	]=	0.183207455	;		isoTempLinesTable[	43	]	[	2	]=	0.274965232	;		isoTempLinesTable[	43	]	[	3	]=	-0.311027919	;
	isoTempLinesTable[44][0	]=	22727.27273	;		isoTempLinesTable[	44	]	[	1	]=	0.183301056	;		isoTempLinesTable[	44	]	[	2	]=	0.275265131	;		isoTempLinesTable[	44	]	[	3	]=	-0.313191438	;
	isoTempLinesTable[45][0	]=	22222.22222	;		isoTempLinesTable[	45	]	[	1	]=	0.183395691	;		isoTempLinesTable[	45	]	[	2	]=	0.275566245	;		isoTempLinesTable[	45	]	[	3	]=	-0.315382393	;
	isoTempLinesTable[46][0	]=	21739.13043	;		isoTempLinesTable[	46	]	[	1	]=	0.183491367	;		isoTempLinesTable[	46	]	[	2	]=	0.275868548	;		isoTempLinesTable[	46	]	[	3	]=	-0.317600812	;
	isoTempLinesTable[47][0	]=	21276.59574	;		isoTempLinesTable[	47	]	[	1	]=	0.18358809	;		isoTempLinesTable[	47	]	[	2	]=	0.276172018	;		isoTempLinesTable[	47	]	[	3	]=	-0.319846722	;
	isoTempLinesTable[48][0	]=	20833.33333	;		isoTempLinesTable[	48	]	[	1	]=	0.183685864	;		isoTempLinesTable[	48	]	[	2	]=	0.276476628	;		isoTempLinesTable[	48	]	[	3	]=	-0.322120149	;
	isoTempLinesTable[49][0	]=	20408.16327	;		isoTempLinesTable[	49	]	[	1	]=	0.183784696	;		isoTempLinesTable[	49	]	[	2	]=	0.276782354	;		isoTempLinesTable[	49	]	[	3	]=	-0.32442112	;
	isoTempLinesTable[50][0	]=	20000		;		isoTempLinesTable[	50	]	[	1	]=	0.183884591	;		isoTempLinesTable[	50	]	[	2	]=	0.277089172	;		isoTempLinesTable[	50	]	[	3	]=	-0.326749658	;
	isoTempLinesTable[51][0	]=	19607.84314	;		isoTempLinesTable[	51	]	[	1	]=	0.183985554	;		isoTempLinesTable[	51	]	[	2	]=	0.277397056	;		isoTempLinesTable[	51	]	[	3	]=	-0.32910579	;
	isoTempLinesTable[52][0	]=	19230.76923	;		isoTempLinesTable[	52	]	[	1	]=	0.184087591	;		isoTempLinesTable[	52	]	[	2	]=	0.277705981	;		isoTempLinesTable[	52	]	[	3	]=	-0.331489539	;
	isoTempLinesTable[53][0	]=	18867.92453	;		isoTempLinesTable[	53	]	[	1	]=	0.184190706	;		isoTempLinesTable[	53	]	[	2	]=	0.278015922	;		isoTempLinesTable[	53	]	[	3	]=	-0.33390093	;
	isoTempLinesTable[54][0	]=	18518.51852	;		isoTempLinesTable[	54	]	[	1	]=	0.184294905	;		isoTempLinesTable[	54	]	[	2	]=	0.278326854	;		isoTempLinesTable[	54	]	[	3	]=	-0.336339987	;
	isoTempLinesTable[55][0	]=	18181.81818	;		isoTempLinesTable[	55	]	[	1	]=	0.184400193	;		isoTempLinesTable[	55	]	[	2	]=	0.278638752	;		isoTempLinesTable[	55	]	[	3	]=	-0.338806732	;
	isoTempLinesTable[56][0	]=	17857.14286	;		isoTempLinesTable[	56	]	[	1	]=	0.184506574	;		isoTempLinesTable[	56	]	[	2	]=	0.278951589	;		isoTempLinesTable[	56	]	[	3	]=	-0.341301189	;
	isoTempLinesTable[57][0	]=	17543.85965	;		isoTempLinesTable[	57	]	[	1	]=	0.184614053	;		isoTempLinesTable[	57	]	[	2	]=	0.279265341	;		isoTempLinesTable[	57	]	[	3	]=	-0.343823381	;
	isoTempLinesTable[58][0	]=	17241.37931	;		isoTempLinesTable[	58	]	[	1	]=	0.184722634	;		isoTempLinesTable[	58	]	[	2	]=	0.279579981	;		isoTempLinesTable[	58	]	[	3	]=	-0.346373331	;
	isoTempLinesTable[59][0	]=	16949.15254	;		isoTempLinesTable[	59	]	[	1	]=	0.184832323	;		isoTempLinesTable[	59	]	[	2	]=	0.279895485	;		isoTempLinesTable[	59	]	[	3	]=	-0.348951062	;
	isoTempLinesTable[60][0	]=	16666.66667	;		isoTempLinesTable[	60	]	[	1	]=	0.184943122	;		isoTempLinesTable[	60	]	[	2	]=	0.280211827	;		isoTempLinesTable[	60	]	[	3	]=	-0.351556595	;
	isoTempLinesTable[61][0	]=	16393.44262	;		isoTempLinesTable[	61	]	[	1	]=	0.185055036	;		isoTempLinesTable[	61	]	[	2	]=	0.28052898	;		isoTempLinesTable[	61	]	[	3	]=	-0.354189954	;
	isoTempLinesTable[62][0	]=	16129.03226	;		isoTempLinesTable[	62	]	[	1	]=	0.18516807	;		isoTempLinesTable[	62	]	[	2	]=	0.28084692	;		isoTempLinesTable[	62	]	[	3	]=	-0.356851162	;
	isoTempLinesTable[63][0	]=	15873.01587	;		isoTempLinesTable[	63	]	[	1	]=	0.185282227	;		isoTempLinesTable[	63	]	[	2	]=	0.281165621	;		isoTempLinesTable[	63	]	[	3	]=	-0.35954024	;
	isoTempLinesTable[64][0	]=	15625		;		isoTempLinesTable[	64	]	[	1	]=	0.18539751	;		isoTempLinesTable[	64	]	[	2	]=	0.281485057	;		isoTempLinesTable[	64	]	[	3	]=	-0.362257212	;
	isoTempLinesTable[65][0	]=	15384.61538	;		isoTempLinesTable[	65	]	[	1	]=	0.185513924	;		isoTempLinesTable[	65	]	[	2	]=	0.281805202	;		isoTempLinesTable[	65	]	[	3	]=	-0.3650021	;
	isoTempLinesTable[66][0	]=	15151.51515	;		isoTempLinesTable[	66	]	[	1	]=	0.185631472	;		isoTempLinesTable[	66	]	[	2	]=	0.282126032	;		isoTempLinesTable[	66	]	[	3	]=	-0.367774927	;
	isoTempLinesTable[67][0	]=	14925.37313	;		isoTempLinesTable[	67	]	[	1	]=	0.185750156	;		isoTempLinesTable[	67	]	[	2	]=	0.28244752	;		isoTempLinesTable[	67	]	[	3	]=	-0.370575717	;
	isoTempLinesTable[68][0	]=	14705.88235	;		isoTempLinesTable[	68	]	[	1	]=	0.185869981	;		isoTempLinesTable[	68	]	[	2	]=	0.28276964	;		isoTempLinesTable[	68	]	[	3	]=	-0.373404493	;
	isoTempLinesTable[69][0	]=	14492.75362	;		isoTempLinesTable[	69	]	[	1	]=	0.18599095	;		isoTempLinesTable[	69	]	[	2	]=	0.283092368	;		isoTempLinesTable[	69	]	[	3	]=	-0.376261278	;
	isoTempLinesTable[70][0	]=	14285.71429	;		isoTempLinesTable[	70	]	[	1	]=	0.186113065	;		isoTempLinesTable[	70	]	[	2	]=	0.283415678	;		isoTempLinesTable[	70	]	[	3	]=	-0.379146097	;
	isoTempLinesTable[71][0	]=	14084.50704	;		isoTempLinesTable[	71	]	[	1	]=	0.186236329	;		isoTempLinesTable[	71	]	[	2	]=	0.283739545	;		isoTempLinesTable[	71	]	[	3	]=	-0.382058974	;
	isoTempLinesTable[72][0	]=	13888.88889	;		isoTempLinesTable[	72	]	[	1	]=	0.186360744	;		isoTempLinesTable[	72	]	[	2	]=	0.284063943	;		isoTempLinesTable[	72	]	[	3	]=	-0.384999934	;
	isoTempLinesTable[73][0	]=	13698.63014	;		isoTempLinesTable[	73	]	[	1	]=	0.186486314	;		isoTempLinesTable[	73	]	[	2	]=	0.284388848	;		isoTempLinesTable[	73	]	[	3	]=	-0.387969002	;
	isoTempLinesTable[74][0	]=	13513.51351	;		isoTempLinesTable[	74	]	[	1	]=	0.186613041	;		isoTempLinesTable[	74	]	[	2	]=	0.284714234	;		isoTempLinesTable[	74	]	[	3	]=	-0.390966204	;
	isoTempLinesTable[75][0	]=	13333.33333	;		isoTempLinesTable[	75	]	[	1	]=	0.186740926	;		isoTempLinesTable[	75	]	[	2	]=	0.285040076	;		isoTempLinesTable[	75	]	[	3	]=	-0.393991566	;
	isoTempLinesTable[76][0	]=	13157.89474	;		isoTempLinesTable[	76	]	[	1	]=	0.186869973	;		isoTempLinesTable[	76	]	[	2	]=	0.285366349	;		isoTempLinesTable[	76	]	[	3	]=	-0.397045115	;
	isoTempLinesTable[77][0	]=	12987.01299	;		isoTempLinesTable[	77	]	[	1	]=	0.187000182	;		isoTempLinesTable[	77	]	[	2	]=	0.285693029	;		isoTempLinesTable[	77	]	[	3	]=	-0.400126879	;
	isoTempLinesTable[78][0	]=	12820.51282	;		isoTempLinesTable[	78	]	[	1	]=	0.187131556	;		isoTempLinesTable[	78	]	[	2	]=	0.286020091	;		isoTempLinesTable[	78	]	[	3	]=	-0.403236886	;
	isoTempLinesTable[79][0	]=	12658.22785	;		isoTempLinesTable[	79	]	[	1	]=	0.187264097	;		isoTempLinesTable[	79	]	[	2	]=	0.28634751	;		isoTempLinesTable[	79	]	[	3	]=	-0.406375165	;
	isoTempLinesTable[80][0	]=	12500		;		isoTempLinesTable[	80	]	[	1	]=	0.187397806	;		isoTempLinesTable[	80	]	[	2	]=	0.286675263	;		isoTempLinesTable[	80	]	[	3	]=	-0.409541745	;
	isoTempLinesTable[81][0	]=	12345.67901	;		isoTempLinesTable[	81	]	[	1	]=	0.187532684	;		isoTempLinesTable[	81	]	[	2	]=	0.287003324	;		isoTempLinesTable[	81	]	[	3	]=	-0.412736657	;
	isoTempLinesTable[82][0	]=	12195.12195	;		isoTempLinesTable[	82	]	[	1	]=	0.187668733	;		isoTempLinesTable[	82	]	[	2	]=	0.287331671	;		isoTempLinesTable[	82	]	[	3	]=	-0.415959932	;
	isoTempLinesTable[83][0	]=	12048.19277	;		isoTempLinesTable[	83	]	[	1	]=	0.187805954	;		isoTempLinesTable[	83	]	[	2	]=	0.287660278	;		isoTempLinesTable[	83	]	[	3	]=	-0.419211602	;
	isoTempLinesTable[84][0	]=	11904.7619	;		isoTempLinesTable[	84	]	[	1	]=	0.187944348	;		isoTempLinesTable[	84	]	[	2	]=	0.287989122	;		isoTempLinesTable[	84	]	[	3	]=	-0.4224917	;
	isoTempLinesTable[85][0	]=	11764.70588	;		isoTempLinesTable[	85	]	[	1	]=	0.188083915	;		isoTempLinesTable[	85	]	[	2	]=	0.288318179	;		isoTempLinesTable[	85	]	[	3	]=	-0.42580026	;
	isoTempLinesTable[86][0	]=	11627.90698	;		isoTempLinesTable[	86	]	[	1	]=	0.188224658	;		isoTempLinesTable[	86	]	[	2	]=	0.288647427	;		isoTempLinesTable[	86	]	[	3	]=	-0.429137317	;
	isoTempLinesTable[87][0	]=	11494.25287	;		isoTempLinesTable[	87	]	[	1	]=	0.188366575	;		isoTempLinesTable[	87	]	[	2	]=	0.288976841	;		isoTempLinesTable[	87	]	[	3	]=	-0.432502907	;
	isoTempLinesTable[88][0	]=	11363.63636	;		isoTempLinesTable[	88	]	[	1	]=	0.188509669	;		isoTempLinesTable[	88	]	[	2	]=	0.289306399	;		isoTempLinesTable[	88	]	[	3	]=	-0.435897066	;
	isoTempLinesTable[89][0	]=	11235.95506	;		isoTempLinesTable[	89	]	[	1	]=	0.188653938	;		isoTempLinesTable[	89	]	[	2	]=	0.289636078	;		isoTempLinesTable[	89	]	[	3	]=	-0.439319834	;
	isoTempLinesTable[90][0	]=	11111.11111	;		isoTempLinesTable[	90	]	[	1	]=	0.188799384	;		isoTempLinesTable[	90	]	[	2	]=	0.289965854	;		isoTempLinesTable[	90	]	[	3	]=	-0.442771249	;
	isoTempLinesTable[91][0	]=	10989.01099	;		isoTempLinesTable[	91	]	[	1	]=	0.188946006	;		isoTempLinesTable[	91	]	[	2	]=	0.290295707	;		isoTempLinesTable[	91	]	[	3	]=	-0.446251351	;
	isoTempLinesTable[92][0	]=	10869.56522	;		isoTempLinesTable[	92	]	[	1	]=	0.189093805	;		isoTempLinesTable[	92	]	[	2	]=	0.290625612	;		isoTempLinesTable[	92	]	[	3	]=	-0.449760182	;
	isoTempLinesTable[93][0	]=	10752.68817	;		isoTempLinesTable[	93	]	[	1	]=	0.18924278	;		isoTempLinesTable[	93	]	[	2	]=	0.290955548	;		isoTempLinesTable[	93	]	[	3	]=	-0.453297785	;
	isoTempLinesTable[94][0	]=	10638.29787	;		isoTempLinesTable[	94	]	[	1	]=	0.189392931	;		isoTempLinesTable[	94	]	[	2	]=	0.291285494	;		isoTempLinesTable[	94	]	[	3	]=	-0.456864204	;
	isoTempLinesTable[95][0	]=	10526.31579	;		isoTempLinesTable[	95	]	[	1	]=	0.189544258	;		isoTempLinesTable[	95	]	[	2	]=	0.291615427	;		isoTempLinesTable[	95	]	[	3	]=	-0.460459485	;
	isoTempLinesTable[96][0	]=	10416.66667	;		isoTempLinesTable[	96	]	[	1	]=	0.18969676	;		isoTempLinesTable[	96	]	[	2	]=	0.291945325	;		isoTempLinesTable[	96	]	[	3	]=	-0.464083673	;
	isoTempLinesTable[97][0	]=	10309.27835	;		isoTempLinesTable[	97	]	[	1	]=	0.189850436	;		isoTempLinesTable[	97	]	[	2	]=	0.292275169	;		isoTempLinesTable[	97	]	[	3	]=	-0.467736818	;
	isoTempLinesTable[98][0	]=	10204.08163	;		isoTempLinesTable[	98	]	[	1	]=	0.190005287	;		isoTempLinesTable[	98	]	[	2	]=	0.292604936	;		isoTempLinesTable[	98	]	[	3	]=	-0.471418969	;
	isoTempLinesTable[99][0	]=	10101.0101	;		isoTempLinesTable[	99	]	[	1	]=	0.19016131	;		isoTempLinesTable[	99	]	[	2	]=	0.292934605	;		isoTempLinesTable[	99	]	[	3	]=	-0.475130176	;
	isoTempLinesTable[100][0]=	10000		;		isoTempLinesTable[	100	]	[	1	]=	0.190318505	;		isoTempLinesTable[	100	]	[	2	]=	0.293264156	;		isoTempLinesTable[	100	]	[	3	]=	-0.478870493	;
	isoTempLinesTable[101][0]=	9900.990099	;		isoTempLinesTable[	101	]	[	1	]=	0.190476871	;		isoTempLinesTable[	101	]	[	2	]=	0.293593569	;		isoTempLinesTable[	101	]	[	3	]=	-0.482639973	;
	isoTempLinesTable[102][0]=	9803.921569	;		isoTempLinesTable[	102	]	[	1	]=	0.190636407	;		isoTempLinesTable[	102	]	[	2	]=	0.293922824	;		isoTempLinesTable[	102	]	[	3	]=	-0.486438671	;
	isoTempLinesTable[103][0]=	9708.737864	;		isoTempLinesTable[	103	]	[	1	]=	0.190797112	;		isoTempLinesTable[	103	]	[	2	]=	0.2942519	;		isoTempLinesTable[	103	]	[	3	]=	-0.490266646	;
	isoTempLinesTable[104][0]=	9615.384615	;		isoTempLinesTable[	104	]	[	1	]=	0.190958983	;		isoTempLinesTable[	104	]	[	2	]=	0.294580778	;		isoTempLinesTable[	104	]	[	3	]=	-0.494123956	;
	isoTempLinesTable[105][0]=	9523.809524	;		isoTempLinesTable[	105	]	[	1	]=	0.191122019	;		isoTempLinesTable[	105	]	[	2	]=	0.294909437	;		isoTempLinesTable[	105	]	[	3	]=	-0.498010661	;
	isoTempLinesTable[106][0]=	9433.962264	;		isoTempLinesTable[	106	]	[	1	]=	0.19128622	;		isoTempLinesTable[	106	]	[	2	]=	0.29523786	;		isoTempLinesTable[	106	]	[	3	]=	-0.501926824	;
	isoTempLinesTable[107][0]=	9345.794393	;		isoTempLinesTable[	107	]	[	1	]=	0.191451582	;		isoTempLinesTable[	107	]	[	2	]=	0.295566027	;		isoTempLinesTable[	107	]	[	3	]=	-0.505872508	;
	isoTempLinesTable[108][0]=	9259.259259	;		isoTempLinesTable[	108	]	[	1	]=	0.191618105	;		isoTempLinesTable[	108	]	[	2	]=	0.29589392	;		isoTempLinesTable[	108	]	[	3	]=	-0.509847778	;
	isoTempLinesTable[109][0]=	9174.311927	;		isoTempLinesTable[	109	]	[	1	]=	0.191785785	;		isoTempLinesTable[	109	]	[	2	]=	0.296221519	;		isoTempLinesTable[	109	]	[	3	]=	-0.513852703	;
	isoTempLinesTable[110][0]=	9090.909091	;		isoTempLinesTable[	110	]	[	1	]=	0.191954622	;		isoTempLinesTable[	110	]	[	2	]=	0.296548806	;		isoTempLinesTable[	110	]	[	3	]=	-0.517887352	;
	isoTempLinesTable[111][0]=	9009.009009	;		isoTempLinesTable[	111	]	[	1	]=	0.192124613	;		isoTempLinesTable[	111	]	[	2	]=	0.296875764	;		isoTempLinesTable[	111	]	[	3	]=	-0.521951795	;
	isoTempLinesTable[112][0]=	8928.571429	;		isoTempLinesTable[	112	]	[	1	]=	0.192295756	;		isoTempLinesTable[	112	]	[	2	]=	0.297202375	;		isoTempLinesTable[	112	]	[	3	]=	-0.526046106	;
	isoTempLinesTable[113][0]=	8849.557522	;		isoTempLinesTable[	113	]	[	1	]=	0.192468048	;		isoTempLinesTable[	113	]	[	2	]=	0.29752862	;		isoTempLinesTable[	113	]	[	3	]=	-0.530170358	;
	isoTempLinesTable[114][0]=	8771.929825	;		isoTempLinesTable[	114	]	[	1	]=	0.192641487	;		isoTempLinesTable[	114	]	[	2	]=	0.297854483	;		isoTempLinesTable[	114	]	[	3	]=	-0.53432463	;
	isoTempLinesTable[115][0]=	8695.652174	;		isoTempLinesTable[	115	]	[	1	]=	0.19281607	;		isoTempLinesTable[	115	]	[	2	]=	0.298179947	;		isoTempLinesTable[	115	]	[	3	]=	-0.538509	;
	isoTempLinesTable[116][0]=	8620.689655	;		isoTempLinesTable[	116	]	[	1	]=	0.192991795	;		isoTempLinesTable[	116	]	[	2	]=	0.298504995	;		isoTempLinesTable[	116	]	[	3	]=	-0.542723547	;
	isoTempLinesTable[117][0]=	8547.008547	;		isoTempLinesTable[	117	]	[	1	]=	0.193168659	;		isoTempLinesTable[	117	]	[	2	]=	0.29882961	;		isoTempLinesTable[	117	]	[	3	]=	-0.546968357	;
	isoTempLinesTable[118][0]=	8474.576271	;		isoTempLinesTable[	118	]	[	1	]=	0.19334666	;		isoTempLinesTable[	118	]	[	2	]=	0.299153777	;		isoTempLinesTable[	118	]	[	3	]=	-0.551243512	;
	isoTempLinesTable[119][0]=	8403.361345	;		isoTempLinesTable[	119	]	[	1	]=	0.193525794	;		isoTempLinesTable[	119	]	[	2	]=	0.299477478	;		isoTempLinesTable[	119	]	[	3	]=	-0.555549099	;
	isoTempLinesTable[120][0]=	8333.333333	;		isoTempLinesTable[	120	]	[	1	]=	0.193706058	;		isoTempLinesTable[	120	]	[	2	]=	0.299800698	;		isoTempLinesTable[	120	]	[	3	]=	-0.559885209	;
	isoTempLinesTable[121][0]=	8264.46281	;		isoTempLinesTable[	121	]	[	1	]=	0.19388745	;		isoTempLinesTable[	121	]	[	2	]=	0.300123421	;		isoTempLinesTable[	121	]	[	3	]=	-0.564251931	;
	isoTempLinesTable[122][0]=	8196.721311	;		isoTempLinesTable[	122	]	[	1	]=	0.194069966	;		isoTempLinesTable[	122	]	[	2	]=	0.300445633	;		isoTempLinesTable[	122	]	[	3	]=	-0.56864936	;
	isoTempLinesTable[123][0]=	8130.081301	;		isoTempLinesTable[	123	]	[	1	]=	0.194253603	;		isoTempLinesTable[	123	]	[	2	]=	0.300767318	;		isoTempLinesTable[	123	]	[	3	]=	-0.57307759	;
	isoTempLinesTable[124][0]=	8064.516129	;		isoTempLinesTable[	124	]	[	1	]=	0.194438358	;		isoTempLinesTable[	124	]	[	2	]=	0.301088461	;		isoTempLinesTable[	124	]	[	3	]=	-0.577536719	;
	isoTempLinesTable[125][0]=	8000		;		isoTempLinesTable[	125	]	[	1	]=	0.194624227	;		isoTempLinesTable[	125	]	[	2	]=	0.301409047	;		isoTempLinesTable[	125	]	[	3	]=	-0.582026847	;
	isoTempLinesTable[126][0]=	7936.507937	;		isoTempLinesTable[	126	]	[	1	]=	0.194811208	;		isoTempLinesTable[	126	]	[	2	]=	0.301729063	;		isoTempLinesTable[	126	]	[	3	]=	-0.586548077	;
	isoTempLinesTable[127][0]=	7874.015748	;		isoTempLinesTable[	127	]	[	1	]=	0.194999295	;		isoTempLinesTable[	127	]	[	2	]=	0.302048494	;		isoTempLinesTable[	127	]	[	3	]=	-0.591100512	;
	isoTempLinesTable[128][0]=	7812.5		;		isoTempLinesTable[	128	]	[	1	]=	0.195188487	;		isoTempLinesTable[	128	]	[	2	]=	0.302367326	;		isoTempLinesTable[	128	]	[	3	]=	-0.595684259	;
	isoTempLinesTable[129][0]=	7751.937984	;		isoTempLinesTable[	129	]	[	1	]=	0.195378779	;		isoTempLinesTable[	129	]	[	2	]=	0.302685546	;		isoTempLinesTable[	129	]	[	3	]=	-0.600299428	;
	isoTempLinesTable[130][0]=	7692.307692	;		isoTempLinesTable[	130	]	[	1	]=	0.195570167	;		isoTempLinesTable[	130	]	[	2	]=	0.30300314	;		isoTempLinesTable[	130	]	[	3	]=	-0.60494613	;
	isoTempLinesTable[131][0]=	7633.587786	;		isoTempLinesTable[	131	]	[	1	]=	0.195762648	;		isoTempLinesTable[	131	]	[	2	]=	0.303320095	;		isoTempLinesTable[	131	]	[	3	]=	-0.609624478	;
	isoTempLinesTable[132][0]=	7575.757576	;		isoTempLinesTable[	132	]	[	1	]=	0.195956218	;		isoTempLinesTable[	132	]	[	2	]=	0.303636399	;		isoTempLinesTable[	132	]	[	3	]=	-0.614334589	;
	isoTempLinesTable[133][0]=	7518.796992	;		isoTempLinesTable[	133	]	[	1	]=	0.196150873	;		isoTempLinesTable[	133	]	[	2	]=	0.303952037	;		isoTempLinesTable[	133	]	[	3	]=	-0.619076583	;
	isoTempLinesTable[134][0]=	7462.686567	;		isoTempLinesTable[	134	]	[	1	]=	0.196346609	;		isoTempLinesTable[	134	]	[	2	]=	0.304266999	;		isoTempLinesTable[	134	]	[	3	]=	-0.623850579	;
	isoTempLinesTable[135][0]=	7407.407407	;		isoTempLinesTable[	135	]	[	1	]=	0.196543422	;		isoTempLinesTable[	135	]	[	2	]=	0.304581271	;		isoTempLinesTable[	135	]	[	3	]=	-0.628656701	;
	isoTempLinesTable[136][0]=	7352.941176	;		isoTempLinesTable[	136	]	[	1	]=	0.196741308	;		isoTempLinesTable[	136	]	[	2	]=	0.304894843	;		isoTempLinesTable[	136	]	[	3	]=	-0.633495076	;
	isoTempLinesTable[137][0]=	7299.270073	;		isoTempLinesTable[	137	]	[	1	]=	0.196940263	;		isoTempLinesTable[	137	]	[	2	]=	0.305207701	;		isoTempLinesTable[	137	]	[	3	]=	-0.638365833	;
	isoTempLinesTable[138][0]=	7246.376812	;		isoTempLinesTable[	138	]	[	1	]=	0.197140283	;		isoTempLinesTable[	138	]	[	2	]=	0.305519835	;		isoTempLinesTable[	138	]	[	3	]=	-0.643269102	;
	isoTempLinesTable[139][0]=	7194.244604	;		isoTempLinesTable[	139	]	[	1	]=	0.197341363	;		isoTempLinesTable[	139	]	[	2	]=	0.305831233	;		isoTempLinesTable[	139	]	[	3	]=	-0.648205018	;
	isoTempLinesTable[140][0]=	7142.857143	;		isoTempLinesTable[	140	]	[	1	]=	0.1975435	;		isoTempLinesTable[	140	]	[	2	]=	0.306141884	;		isoTempLinesTable[	140	]	[	3	]=	-0.653173716	;
	isoTempLinesTable[141][0]=	7092.198582	;		isoTempLinesTable[	141	]	[	1	]=	0.197746688	;		isoTempLinesTable[	141	]	[	2	]=	0.306451778	;		isoTempLinesTable[	141	]	[	3	]=	-0.658175336	;
	isoTempLinesTable[142][0]=	7042.253521	;		isoTempLinesTable[	142	]	[	1	]=	0.197950923	;		isoTempLinesTable[	142	]	[	2	]=	0.306760903	;		isoTempLinesTable[	142	]	[	3	]=	-0.66321002	;
	isoTempLinesTable[143][0]=	6993.006993	;		isoTempLinesTable[	143	]	[	1	]=	0.198156202	;		isoTempLinesTable[	143	]	[	2	]=	0.30706925	;		isoTempLinesTable[	143	]	[	3	]=	-0.668277912	;
	isoTempLinesTable[144][0]=	6944.444444	;		isoTempLinesTable[	144	]	[	1	]=	0.198362519	;		isoTempLinesTable[	144	]	[	2	]=	0.307376808	;		isoTempLinesTable[	144	]	[	3	]=	-0.673379159	;
	isoTempLinesTable[145][0]=	6896.551724	;		isoTempLinesTable[	145	]	[	1	]=	0.198569871	;		isoTempLinesTable[	145	]	[	2	]=	0.307683567	;		isoTempLinesTable[	145	]	[	3	]=	-0.678513911	;
	isoTempLinesTable[146][0]=	6849.315068	;		isoTempLinesTable[	146	]	[	1	]=	0.198778252	;		isoTempLinesTable[	146	]	[	2	]=	0.307989517	;		isoTempLinesTable[	146	]	[	3	]=	-0.683682321	;
	isoTempLinesTable[147][0]=	6802.721088	;		isoTempLinesTable[	147	]	[	1	]=	0.198987658	;		isoTempLinesTable[	147	]	[	2	]=	0.308294649	;		isoTempLinesTable[	147	]	[	3	]=	-0.688884543	;
	isoTempLinesTable[148][0]=	6756.756757	;		isoTempLinesTable[	148	]	[	1	]=	0.199198084	;		isoTempLinesTable[	148	]	[	2	]=	0.308598954	;		isoTempLinesTable[	148	]	[	3	]=	-0.694120735	;
	isoTempLinesTable[149][0]=	6711.409396	;		isoTempLinesTable[	149	]	[	1	]=	0.199409526	;		isoTempLinesTable[	149	]	[	2	]=	0.308902422	;		isoTempLinesTable[	149	]	[	3	]=	-0.69939106	;
	isoTempLinesTable[150][0]=	6666.666667	;		isoTempLinesTable[	150	]	[	1	]=	0.199621979	;		isoTempLinesTable[	150	]	[	2	]=	0.309205044	;		isoTempLinesTable[	150	]	[	3	]=	-0.70469568	;
	isoTempLinesTable[151][0]=	6622.516556	;		isoTempLinesTable[	151	]	[	1	]=	0.199835438	;		isoTempLinesTable[	151	]	[	2	]=	0.309506813	;		isoTempLinesTable[	151	]	[	3	]=	-0.710034761	;
	isoTempLinesTable[152][0]=	6578.947368	;		isoTempLinesTable[	152	]	[	1	]=	0.200049899	;		isoTempLinesTable[	152	]	[	2	]=	0.309807718	;		isoTempLinesTable[	152	]	[	3	]=	-0.715408474	;
	isoTempLinesTable[153][0]=	6535.947712	;		isoTempLinesTable[	153	]	[	1	]=	0.200265356	;		isoTempLinesTable[	153	]	[	2	]=	0.310107753	;		isoTempLinesTable[	153	]	[	3	]=	-0.720816991	;
	isoTempLinesTable[154][0]=	6493.506494	;		isoTempLinesTable[	154	]	[	1	]=	0.200481805	;		isoTempLinesTable[	154	]	[	2	]=	0.310406908	;		isoTempLinesTable[	154	]	[	3	]=	-0.726260487	;
	isoTempLinesTable[155][0]=	6451.612903	;		isoTempLinesTable[	155	]	[	1	]=	0.200699242	;		isoTempLinesTable[	155	]	[	2	]=	0.310705177	;		isoTempLinesTable[	155	]	[	3	]=	-0.731739139	;
	isoTempLinesTable[156][0]=	6410.25641	;		isoTempLinesTable[	156	]	[	1	]=	0.20091766	;		isoTempLinesTable[	156	]	[	2	]=	0.311002551	;		isoTempLinesTable[	156	]	[	3	]=	-0.73725313	;
	isoTempLinesTable[157][0]=	6369.426752	;		isoTempLinesTable[	157	]	[	1	]=	0.201137056	;		isoTempLinesTable[	157	]	[	2	]=	0.311299022	;		isoTempLinesTable[	157	]	[	3	]=	-0.742802643	;
	isoTempLinesTable[158][0]=	6329.113924	;		isoTempLinesTable[	158	]	[	1	]=	0.201357424	;		isoTempLinesTable[	158	]	[	2	]=	0.311594584	;		isoTempLinesTable[	158	]	[	3	]=	-0.748387866	;
	isoTempLinesTable[159][0]=	6289.308176	;		isoTempLinesTable[	159	]	[	1	]=	0.20157876	;		isoTempLinesTable[	159	]	[	2	]=	0.311889229	;		isoTempLinesTable[	159	]	[	3	]=	-0.754008988	;
	isoTempLinesTable[160][0]=	6250		;		isoTempLinesTable[	160	]	[	1	]=	0.201801058	;		isoTempLinesTable[	160	]	[	2	]=	0.31218295	;		isoTempLinesTable[	160	]	[	3	]=	-0.759666204	;
	isoTempLinesTable[161][0]=	6211.180124	;		isoTempLinesTable[	161	]	[	1	]=	0.202024313	;		isoTempLinesTable[	161	]	[	2	]=	0.312475741	;		isoTempLinesTable[	161	]	[	3	]=	-0.765359708	;
	isoTempLinesTable[162][0]=	6172.839506	;		isoTempLinesTable[	162	]	[	1	]=	0.202248521	;		isoTempLinesTable[	162	]	[	2	]=	0.312767595	;		isoTempLinesTable[	162	]	[	3	]=	-0.7710897	;
	isoTempLinesTable[163][0]=	6134.969325	;		isoTempLinesTable[	163	]	[	1	]=	0.202473677	;		isoTempLinesTable[	163	]	[	2	]=	0.313058505	;		isoTempLinesTable[	163	]	[	3	]=	-0.776856384	;
	isoTempLinesTable[164][0]=	6097.560976	;		isoTempLinesTable[	164	]	[	1	]=	0.202699774	;		isoTempLinesTable[	164	]	[	2	]=	0.313348465	;		isoTempLinesTable[	164	]	[	3	]=	-0.782659964	;
	isoTempLinesTable[165][0]=	6060.606061	;		isoTempLinesTable[	165	]	[	1	]=	0.202926809	;		isoTempLinesTable[	165	]	[	2	]=	0.31363747	;		isoTempLinesTable[	165	]	[	3	]=	-0.78850065	;
	isoTempLinesTable[166][0]=	6024.096386	;		isoTempLinesTable[	166	]	[	1	]=	0.203154777	;		isoTempLinesTable[	166	]	[	2	]=	0.313925513	;		isoTempLinesTable[	166	]	[	3	]=	-0.794378653	;
	isoTempLinesTable[167][0]=	5988.023952	;		isoTempLinesTable[	167	]	[	1	]=	0.203383671	;		isoTempLinesTable[	167	]	[	2	]=	0.314212589	;		isoTempLinesTable[	167	]	[	3	]=	-0.800294188	;
	isoTempLinesTable[168][0]=	5952.380952	;		isoTempLinesTable[	168	]	[	1	]=	0.203613487	;		isoTempLinesTable[	168	]	[	2	]=	0.314498691	;		isoTempLinesTable[	168	]	[	3	]=	-0.806247474	;
	isoTempLinesTable[169][0]=	5917.159763	;		isoTempLinesTable[	169	]	[	1	]=	0.203844221	;		isoTempLinesTable[	169	]	[	2	]=	0.314783815	;		isoTempLinesTable[	169	]	[	3	]=	-0.812238733	;
	isoTempLinesTable[170][0]=	5882.352941	;		isoTempLinesTable[	170	]	[	1	]=	0.204075866	;		isoTempLinesTable[	170	]	[	2	]=	0.315067956	;		isoTempLinesTable[	170	]	[	3	]=	-0.81826819	;
	isoTempLinesTable[171][0]=	5847.953216	;		isoTempLinesTable[	171	]	[	1	]=	0.204308418	;		isoTempLinesTable[	171	]	[	2	]=	0.315351108	;		isoTempLinesTable[	171	]	[	3	]=	-0.824336072	;
	isoTempLinesTable[172][0]=	5813.953488	;		isoTempLinesTable[	172	]	[	1	]=	0.204541871	;		isoTempLinesTable[	172	]	[	2	]=	0.315633266	;		isoTempLinesTable[	172	]	[	3	]=	-0.830442611	;
	isoTempLinesTable[173][0]=	5780.346821	;		isoTempLinesTable[	173	]	[	1	]=	0.204776221	;		isoTempLinesTable[	173	]	[	2	]=	0.315914426	;		isoTempLinesTable[	173	]	[	3	]=	-0.836588042	;
	isoTempLinesTable[174][0]=	5747.126437	;		isoTempLinesTable[	174	]	[	1	]=	0.205011461	;		isoTempLinesTable[	174	]	[	2	]=	0.316194583	;		isoTempLinesTable[	174	]	[	3	]=	-0.842772604	;
	isoTempLinesTable[175][0]=	5714.285714	;		isoTempLinesTable[	175	]	[	1	]=	0.205247588	;		isoTempLinesTable[	175	]	[	2	]=	0.316473732	;		isoTempLinesTable[	175	]	[	3	]=	-0.848996539	;
	isoTempLinesTable[176][0]=	5681.818182	;		isoTempLinesTable[	176	]	[	1	]=	0.205484596	;		isoTempLinesTable[	176	]	[	2	]=	0.31675187	;		isoTempLinesTable[	176	]	[	3	]=	-0.85526009	;
	isoTempLinesTable[177][0]=	5649.717514	;		isoTempLinesTable[	177	]	[	1	]=	0.205722479	;		isoTempLinesTable[	177	]	[	2	]=	0.317028992	;		isoTempLinesTable[	177	]	[	3	]=	-0.861563507	;
	isoTempLinesTable[178][0]=	5617.977528	;		isoTempLinesTable[	178	]	[	1	]=	0.205961233	;		isoTempLinesTable[	178	]	[	2	]=	0.317305094	;		isoTempLinesTable[	178	]	[	3	]=	-0.867907042	;
	isoTempLinesTable[179][0]=	5586.592179	;		isoTempLinesTable[	179	]	[	1	]=	0.206200852	;		isoTempLinesTable[	179	]	[	2	]=	0.317580173	;		isoTempLinesTable[	179	]	[	3	]=	-0.874290951	;
	isoTempLinesTable[180][0]=	5555.555556	;		isoTempLinesTable[	180	]	[	1	]=	0.206441332	;		isoTempLinesTable[	180	]	[	2	]=	0.317854224	;		isoTempLinesTable[	180	]	[	3	]=	-0.880715492	;
	isoTempLinesTable[181][0]=	5524.861878	;		isoTempLinesTable[	181	]	[	1	]=	0.206682666	;		isoTempLinesTable[	181	]	[	2	]=	0.318127244	;		isoTempLinesTable[	181	]	[	3	]=	-0.887180928	;
	isoTempLinesTable[182][0]=	5494.505495	;		isoTempLinesTable[	182	]	[	1	]=	0.20692485	;		isoTempLinesTable[	182	]	[	2	]=	0.31839923	;		isoTempLinesTable[	182	]	[	3	]=	-0.893687525	;
	isoTempLinesTable[183][0]=	5464.480874	;		isoTempLinesTable[	183	]	[	1	]=	0.207167878	;		isoTempLinesTable[	183	]	[	2	]=	0.318670178	;		isoTempLinesTable[	183	]	[	3	]=	-0.900235553	;
	isoTempLinesTable[184][0]=	5434.782609	;		isoTempLinesTable[	184	]	[	1	]=	0.207411746	;		isoTempLinesTable[	184	]	[	2	]=	0.318940085	;		isoTempLinesTable[	184	]	[	3	]=	-0.906825286	;
	isoTempLinesTable[185][0]=	5405.405405	;		isoTempLinesTable[	185	]	[	1	]=	0.207656448	;		isoTempLinesTable[	185	]	[	2	]=	0.319208948	;		isoTempLinesTable[	185	]	[	3	]=	-0.913457	;
	isoTempLinesTable[186][0]=	5376.344086	;		isoTempLinesTable[	186	]	[	1	]=	0.207901979	;		isoTempLinesTable[	186	]	[	2	]=	0.319476764	;		isoTempLinesTable[	186	]	[	3	]=	-0.920130977	;
	isoTempLinesTable[187][0]=	5347.593583	;		isoTempLinesTable[	187	]	[	1	]=	0.208148333	;		isoTempLinesTable[	187	]	[	2	]=	0.319743531	;		isoTempLinesTable[	187	]	[	3	]=	-0.9268475	;
	isoTempLinesTable[188][0]=	5319.148936	;		isoTempLinesTable[	188	]	[	1	]=	0.208395507	;		isoTempLinesTable[	188	]	[	2	]=	0.320009246	;		isoTempLinesTable[	188	]	[	3	]=	-0.933606858	;
	isoTempLinesTable[189][0]=	5291.005291	;		isoTempLinesTable[	189	]	[	1	]=	0.208643493	;		isoTempLinesTable[	189	]	[	2	]=	0.320273905	;		isoTempLinesTable[	189	]	[	3	]=	-0.940409343	;
	isoTempLinesTable[190][0]=	5263.157895	;		isoTempLinesTable[	190	]	[	1	]=	0.208892288	;		isoTempLinesTable[	190	]	[	2	]=	0.320537508	;		isoTempLinesTable[	190	]	[	3	]=	-0.947255252	;
	isoTempLinesTable[191][0]=	5235.602094	;		isoTempLinesTable[	191	]	[	1	]=	0.209141886	;		isoTempLinesTable[	191	]	[	2	]=	0.32080005	;		isoTempLinesTable[	191	]	[	3	]=	-0.954144882	;
	isoTempLinesTable[192][0]=	5208.333333	;		isoTempLinesTable[	192	]	[	1	]=	0.209392282	;		isoTempLinesTable[	192	]	[	2	]=	0.321061532	;		isoTempLinesTable[	192	]	[	3	]=	-0.961078539	;
	isoTempLinesTable[193][0]=	5181.34715	;		isoTempLinesTable[	193	]	[	1	]=	0.209643471	;		isoTempLinesTable[	193	]	[	2	]=	0.321321949	;		isoTempLinesTable[	193	]	[	3	]=	-0.968056529	;
	isoTempLinesTable[194][0]=	5154.639175	;		isoTempLinesTable[	194	]	[	1	]=	0.209895447	;		isoTempLinesTable[	194	]	[	2	]=	0.321581301	;		isoTempLinesTable[	194	]	[	3	]=	-0.975079164	;
	isoTempLinesTable[195][0]=	5128.205128	;		isoTempLinesTable[	195	]	[	1	]=	0.210148205	;		isoTempLinesTable[	195	]	[	2	]=	0.321839585	;		isoTempLinesTable[	195	]	[	3	]=	-0.982146759	;
	isoTempLinesTable[196][0]=	5102.040816	;		isoTempLinesTable[	196	]	[	1	]=	0.210401741	;		isoTempLinesTable[	196	]	[	2	]=	0.3220968	;		isoTempLinesTable[	196	]	[	3	]=	-0.989259633	;
	isoTempLinesTable[197][0]=	5076.142132	;		isoTempLinesTable[	197	]	[	1	]=	0.210656049	;		isoTempLinesTable[	197	]	[	2	]=	0.322352944	;		isoTempLinesTable[	197	]	[	3	]=	-0.99641811	;
	isoTempLinesTable[198][0]=	5050.505051	;		isoTempLinesTable[	198	]	[	1	]=	0.210911125	;		isoTempLinesTable[	198	]	[	2	]=	0.322608016	;		isoTempLinesTable[	198	]	[	3	]=	-1.003622517	;
	isoTempLinesTable[199][0]=	5025.125628	;		isoTempLinesTable[	199	]	[	1	]=	0.211166962	;		isoTempLinesTable[	199	]	[	2	]=	0.322862013	;		isoTempLinesTable[	199	]	[	3	]=	-1.010873186	;
	isoTempLinesTable[200][0]=	5000		;		isoTempLinesTable[	200	]	[	1	]=	0.211423556	;		isoTempLinesTable[	200	]	[	2	]=	0.323114936	;		isoTempLinesTable[	200	]	[	3	]=	-1.018170451	;
	isoTempLinesTable[201][0]=	4975.124378	;		isoTempLinesTable[	201	]	[	1	]=	0.211680901	;		isoTempLinesTable[	201	]	[	2	]=	0.323366782	;		isoTempLinesTable[	201	]	[	3	]=	-1.025514654	;
	isoTempLinesTable[202][0]=	4950.49505	;		isoTempLinesTable[	202	]	[	1	]=	0.211938994	;		isoTempLinesTable[	202	]	[	2	]=	0.323617551	;		isoTempLinesTable[	202	]	[	3	]=	-1.032906138	;
	isoTempLinesTable[203][0]=	4926.108374	;		isoTempLinesTable[	203	]	[	1	]=	0.212197828	;		isoTempLinesTable[	203	]	[	2	]=	0.323867242	;		isoTempLinesTable[	203	]	[	3	]=	-1.040345251	;
	isoTempLinesTable[204][0]=	4901.960784	;		isoTempLinesTable[	204	]	[	1	]=	0.212457398	;		isoTempLinesTable[	204	]	[	2	]=	0.324115853	;		isoTempLinesTable[	204	]	[	3	]=	-1.047832345	;
	isoTempLinesTable[205][0]=	4878.04878	;		isoTempLinesTable[	205	]	[	1	]=	0.2127177	;		isoTempLinesTable[	205	]	[	2	]=	0.324363384	;		isoTempLinesTable[	205	]	[	3	]=	-1.055367778	;
	isoTempLinesTable[206][0]=	4854.368932	;		isoTempLinesTable[	206	]	[	1	]=	0.212978729	;		isoTempLinesTable[	206	]	[	2	]=	0.324609834	;		isoTempLinesTable[	206	]	[	3	]=	-1.062951911	;
	isoTempLinesTable[207][0]=	4830.917874	;		isoTempLinesTable[	207	]	[	1	]=	0.213240479	;		isoTempLinesTable[	207	]	[	2	]=	0.324855203	;		isoTempLinesTable[	207	]	[	3	]=	-1.070585109	;
	isoTempLinesTable[208][0]=	4807.692308	;		isoTempLinesTable[	208	]	[	1	]=	0.213502945	;		isoTempLinesTable[	208	]	[	2	]=	0.32509949	;		isoTempLinesTable[	208	]	[	3	]=	-1.078267742	;
	isoTempLinesTable[209][0]=	4784.688995	;		isoTempLinesTable[	209	]	[	1	]=	0.213766123	;		isoTempLinesTable[	209	]	[	2	]=	0.325342694	;		isoTempLinesTable[	209	]	[	3	]=	-1.086000184	;
	isoTempLinesTable[210][0]=	4761.904762	;		isoTempLinesTable[	210	]	[	1	]=	0.214030007	;		isoTempLinesTable[	210	]	[	2	]=	0.325584815	;		isoTempLinesTable[	210	]	[	3	]=	-1.093782815	;
	isoTempLinesTable[211][0]=	4739.336493	;		isoTempLinesTable[	211	]	[	1	]=	0.214294593	;		isoTempLinesTable[	211	]	[	2	]=	0.325825853	;		isoTempLinesTable[	211	]	[	3	]=	-1.101616018	;
	isoTempLinesTable[212][0]=	4716.981132	;		isoTempLinesTable[	212	]	[	1	]=	0.214559875	;		isoTempLinesTable[	212	]	[	2	]=	0.326065808	;		isoTempLinesTable[	212	]	[	3	]=	-1.109500181	;
	isoTempLinesTable[213][0]=	4694.835681	;		isoTempLinesTable[	213	]	[	1	]=	0.214825848	;		isoTempLinesTable[	213	]	[	2	]=	0.326304679	;		isoTempLinesTable[	213	]	[	3	]=	-1.117435697	;
	isoTempLinesTable[214][0]=	4672.897196	;		isoTempLinesTable[	214	]	[	1	]=	0.215092509	;		isoTempLinesTable[	214	]	[	2	]=	0.326542467	;		isoTempLinesTable[	214	]	[	3	]=	-1.125422964	;
	isoTempLinesTable[215][0]=	4651.162791	;		isoTempLinesTable[	215	]	[	1	]=	0.215359851	;		isoTempLinesTable[	215	]	[	2	]=	0.326779171	;		isoTempLinesTable[	215	]	[	3	]=	-1.133462382	;
	isoTempLinesTable[216][0]=	4629.62963	;		isoTempLinesTable[	216	]	[	1	]=	0.215627869	;		isoTempLinesTable[	216	]	[	2	]=	0.327014792	;		isoTempLinesTable[	216	]	[	3	]=	-1.141554361	;
	isoTempLinesTable[217][0]=	4608.294931	;		isoTempLinesTable[	217	]	[	1	]=	0.21589656	;		isoTempLinesTable[	217	]	[	2	]=	0.327249329	;		isoTempLinesTable[	217	]	[	3	]=	-1.14969931	;
	isoTempLinesTable[218][0]=	4587.155963	;		isoTempLinesTable[	218	]	[	1	]=	0.216165918	;		isoTempLinesTable[	218	]	[	2	]=	0.327482784	;		isoTempLinesTable[	218	]	[	3	]=	-1.157897647	;
	isoTempLinesTable[219][0]=	4566.210046	;		isoTempLinesTable[	219	]	[	1	]=	0.216435938	;		isoTempLinesTable[	219	]	[	2	]=	0.327715156	;		isoTempLinesTable[	219	]	[	3	]=	-1.166149794	;
	isoTempLinesTable[220][0]=	4545.454545	;		isoTempLinesTable[	220	]	[	1	]=	0.216706615	;		isoTempLinesTable[	220	]	[	2	]=	0.327946446	;		isoTempLinesTable[	220	]	[	3	]=	-1.174456176	;
	isoTempLinesTable[221][0]=	4524.886878	;		isoTempLinesTable[	221	]	[	1	]=	0.216977945	;		isoTempLinesTable[	221	]	[	2	]=	0.328176654	;		isoTempLinesTable[	221	]	[	3	]=	-1.182817226	;
	isoTempLinesTable[222][0]=	4504.504505	;		isoTempLinesTable[	222	]	[	1	]=	0.217249923	;		isoTempLinesTable[	222	]	[	2	]=	0.328405781	;		isoTempLinesTable[	222	]	[	3	]=	-1.191233379	;
	isoTempLinesTable[223][0]=	4484.304933	;		isoTempLinesTable[	223	]	[	1	]=	0.217522543	;		isoTempLinesTable[	223	]	[	2	]=	0.328633827	;		isoTempLinesTable[	223	]	[	3	]=	-1.199705079	;
	isoTempLinesTable[224][0]=	4464.285714	;		isoTempLinesTable[	224	]	[	1	]=	0.217795802	;		isoTempLinesTable[	224	]	[	2	]=	0.328860793	;		isoTempLinesTable[	224	]	[	3	]=	-1.208232771	;
	isoTempLinesTable[225][0]=	4444.444444	;		isoTempLinesTable[	225	]	[	1	]=	0.218069694	;		isoTempLinesTable[	225	]	[	2	]=	0.329086681	;		isoTempLinesTable[	225	]	[	3	]=	-1.216816907	;
	isoTempLinesTable[226][0]=	4424.778761	;		isoTempLinesTable[	226	]	[	1	]=	0.218344215	;		isoTempLinesTable[	226	]	[	2	]=	0.32931149	;		isoTempLinesTable[	226	]	[	3	]=	-1.225457946	;
	isoTempLinesTable[227][0]=	4405.286344	;		isoTempLinesTable[	227	]	[	1	]=	0.21861936	;		isoTempLinesTable[	227	]	[	2	]=	0.329535221	;		isoTempLinesTable[	227	]	[	3	]=	-1.234156349	;
	isoTempLinesTable[228][0]=	4385.964912	;		isoTempLinesTable[	228	]	[	1	]=	0.218895124	;		isoTempLinesTable[	228	]	[	2	]=	0.329757877	;		isoTempLinesTable[	228	]	[	3	]=	-1.242912586	;
	isoTempLinesTable[229][0]=	4366.812227	;		isoTempLinesTable[	229	]	[	1	]=	0.219171503	;		isoTempLinesTable[	229	]	[	2	]=	0.329979456	;		isoTempLinesTable[	229	]	[	3	]=	-1.251727128	;
	isoTempLinesTable[230][0]=	4347.826087	;		isoTempLinesTable[	230	]	[	1	]=	0.219448492	;		isoTempLinesTable[	230	]	[	2	]=	0.330199961	;		isoTempLinesTable[	230	]	[	3	]=	-1.260600457	;
	isoTempLinesTable[231][0]=	4329.004329	;		isoTempLinesTable[	231	]	[	1	]=	0.219726085	;		isoTempLinesTable[	231	]	[	2	]=	0.330419393	;		isoTempLinesTable[	231	]	[	3	]=	-1.269533055	;
	isoTempLinesTable[232][0]=	4310.344828	;		isoTempLinesTable[	232	]	[	1	]=	0.22000428	;		isoTempLinesTable[	232	]	[	2	]=	0.330637752	;		isoTempLinesTable[	232	]	[	3	]=	-1.278525414	;
	isoTempLinesTable[233][0]=	4291.845494	;		isoTempLinesTable[	233	]	[	1	]=	0.22028307	;		isoTempLinesTable[	233	]	[	2	]=	0.330855041	;		isoTempLinesTable[	233	]	[	3	]=	-1.287578029	;
	isoTempLinesTable[234][0]=	4273.504274	;		isoTempLinesTable[	234	]	[	1	]=	0.220562452	;		isoTempLinesTable[	234	]	[	2	]=	0.331071259	;		isoTempLinesTable[	234	]	[	3	]=	-1.296691402	;
	isoTempLinesTable[235][0]=	4255.319149	;		isoTempLinesTable[	235	]	[	1	]=	0.220842421	;		isoTempLinesTable[	235	]	[	2	]=	0.33128641	;		isoTempLinesTable[	235	]	[	3	]=	-1.305866041	;
	isoTempLinesTable[236][0]=	4237.288136	;		isoTempLinesTable[	236	]	[	1	]=	0.221122972	;		isoTempLinesTable[	236	]	[	2	]=	0.331500493	;		isoTempLinesTable[	236	]	[	3	]=	-1.315102459	;
	isoTempLinesTable[237][0]=	4219.409283	;		isoTempLinesTable[	237	]	[	1	]=	0.2214041	;		isoTempLinesTable[	237	]	[	2	]=	0.331713511	;		isoTempLinesTable[	237	]	[	3	]=	-1.324401176	;
	isoTempLinesTable[238][0]=	4201.680672	;		isoTempLinesTable[	238	]	[	1	]=	0.221685802	;		isoTempLinesTable[	238	]	[	2	]=	0.331925465	;		isoTempLinesTable[	238	]	[	3	]=	-1.333762716	;
	isoTempLinesTable[239][0]=	4184.100418	;		isoTempLinesTable[	239	]	[	1	]=	0.221968073	;		isoTempLinesTable[	239	]	[	2	]=	0.332136356	;		isoTempLinesTable[	239	]	[	3	]=	-1.343187612	;
	isoTempLinesTable[240][0]=	4166.666667	;		isoTempLinesTable[	240	]	[	1	]=	0.222250908	;		isoTempLinesTable[	240	]	[	2	]=	0.332346186	;		isoTempLinesTable[	240	]	[	3	]=	-1.3526764	;
	isoTempLinesTable[241][0]=	4149.377593	;		isoTempLinesTable[	241	]	[	1	]=	0.222534302	;		isoTempLinesTable[	241	]	[	2	]=	0.332554957	;		isoTempLinesTable[	241	]	[	3	]=	-1.362229625	;
	isoTempLinesTable[242][0]=	4132.231405	;		isoTempLinesTable[	242	]	[	1	]=	0.222818252	;		isoTempLinesTable[	242	]	[	2	]=	0.33276267	;		isoTempLinesTable[	242	]	[	3	]=	-1.371847837	;
	isoTempLinesTable[243][0]=	4115.226337	;		isoTempLinesTable[	243	]	[	1	]=	0.223102753	;		isoTempLinesTable[	243	]	[	2	]=	0.332969327	;		isoTempLinesTable[	243	]	[	3	]=	-1.381531593	;
	isoTempLinesTable[244][0]=	4098.360656	;		isoTempLinesTable[	244	]	[	1	]=	0.2233878	;		isoTempLinesTable[	244	]	[	2	]=	0.33317493	;		isoTempLinesTable[	244	]	[	3	]=	-1.391281455	;
	isoTempLinesTable[245][0]=	4081.632653	;		isoTempLinesTable[	245	]	[	1	]=	0.223673389	;		isoTempLinesTable[	245	]	[	2	]=	0.33337948	;		isoTempLinesTable[	245	]	[	3	]=	-1.401097993	;
	isoTempLinesTable[246][0]=	4065.04065	;		isoTempLinesTable[	246	]	[	1	]=	0.223959516	;		isoTempLinesTable[	246	]	[	2	]=	0.33358298	;		isoTempLinesTable[	246	]	[	3	]=	-1.410981783	;
	isoTempLinesTable[247][0]=	4048.582996	;		isoTempLinesTable[	247	]	[	1	]=	0.224246176	;		isoTempLinesTable[	247	]	[	2	]=	0.333785431	;		isoTempLinesTable[	247	]	[	3	]=	-1.420933408	;
	isoTempLinesTable[248][0]=	4032.258065	;		isoTempLinesTable[	248	]	[	1	]=	0.224533365	;		isoTempLinesTable[	248	]	[	2	]=	0.333986835	;		isoTempLinesTable[	248	]	[	3	]=	-1.430953457	;
	isoTempLinesTable[249][0]=	4016.064257	;		isoTempLinesTable[	249	]	[	1	]=	0.224821079	;		isoTempLinesTable[	249	]	[	2	]=	0.334187195	;		isoTempLinesTable[	249	]	[	3	]=	-1.441042527	;
	isoTempLinesTable[250][0]=	4000		;		isoTempLinesTable[	250	]	[	1	]=	0.225109313	;		isoTempLinesTable[	250	]	[	2	]=	0.334386511	;		isoTempLinesTable[	250	]	[	3	]=	-1.451201222	;
	isoTempLinesTable[251][0]=	3984.063745	;		isoTempLinesTable[	251	]	[	1	]=	0.225398063	;		isoTempLinesTable[	251	]	[	2	]=	0.334584787	;		isoTempLinesTable[	251	]	[	3	]=	-1.461430151	;
	isoTempLinesTable[252][0]=	3968.253968	;		isoTempLinesTable[	252	]	[	1	]=	0.225687326	;		isoTempLinesTable[	252	]	[	2	]=	0.334782025	;		isoTempLinesTable[	252	]	[	3	]=	-1.471729932	;
	isoTempLinesTable[253][0]=	3952.56917	;		isoTempLinesTable[	253	]	[	1	]=	0.225977095	;		isoTempLinesTable[	253	]	[	2	]=	0.334978225	;		isoTempLinesTable[	253	]	[	3	]=	-1.48210119	;
	isoTempLinesTable[254][0]=	3937.007874	;		isoTempLinesTable[	254	]	[	1	]=	0.226267368	;		isoTempLinesTable[	254	]	[	2	]=	0.335173392	;		isoTempLinesTable[	254	]	[	3	]=	-1.492544557	;
	isoTempLinesTable[255][0]=	3921.568627	;		isoTempLinesTable[	255	]	[	1	]=	0.226558141	;		isoTempLinesTable[	255	]	[	2	]=	0.335367526	;		isoTempLinesTable[	255	]	[	3	]=	-1.503060671	;
	isoTempLinesTable[256][0]=	3906.25		;		isoTempLinesTable[	256	]	[	1	]=	0.226849408	;		isoTempLinesTable[	256	]	[	2	]=	0.33556063	;		isoTempLinesTable[	256	]	[	3	]=	-1.513650181	;
	isoTempLinesTable[257][0]=	3891.050584	;		isoTempLinesTable[	257	]	[	1	]=	0.227141166	;		isoTempLinesTable[	257	]	[	2	]=	0.335752706	;		isoTempLinesTable[	257	]	[	3	]=	-1.524313739	;
	isoTempLinesTable[258][0]=	3875.968992	;		isoTempLinesTable[	258	]	[	1	]=	0.227433411	;		isoTempLinesTable[	258	]	[	2	]=	0.335943756	;		isoTempLinesTable[	258	]	[	3	]=	-1.535052009	;
	isoTempLinesTable[259][0]=	3861.003861	;		isoTempLinesTable[	259	]	[	1	]=	0.227726138	;		isoTempLinesTable[	259	]	[	2	]=	0.336133784	;		isoTempLinesTable[	259	]	[	3	]=	-1.54586566	;
	isoTempLinesTable[260][0]=	3846.153846	;		isoTempLinesTable[	260	]	[	1	]=	0.228019344	;		isoTempLinesTable[	260	]	[	2	]=	0.33632279	;		isoTempLinesTable[	260	]	[	3	]=	-1.55675537	;
	isoTempLinesTable[261][0]=	3831.417625	;		isoTempLinesTable[	261	]	[	1	]=	0.228313024	;		isoTempLinesTable[	261	]	[	2	]=	0.336510779	;		isoTempLinesTable[	261	]	[	3	]=	-1.567721824	;
	isoTempLinesTable[262][0]=	3816.793893	;		isoTempLinesTable[	262	]	[	1	]=	0.228607175	;		isoTempLinesTable[	262	]	[	2	]=	0.336697751	;		isoTempLinesTable[	262	]	[	3	]=	-1.578765716	;
	isoTempLinesTable[263][0]=	3802.281369	;		isoTempLinesTable[	263	]	[	1	]=	0.228901792	;		isoTempLinesTable[	263	]	[	2	]=	0.336883709	;		isoTempLinesTable[	263	]	[	3	]=	-1.589887748	;
	isoTempLinesTable[264][0]=	3787.878788	;		isoTempLinesTable[	264	]	[	1	]=	0.229196871	;		isoTempLinesTable[	264	]	[	2	]=	0.337068656	;		isoTempLinesTable[	264	]	[	3	]=	-1.60108863	;
	isoTempLinesTable[265][0]=	3773.584906	;		isoTempLinesTable[	265	]	[	1	]=	0.229492408	;		isoTempLinesTable[	265	]	[	2	]=	0.337252595	;		isoTempLinesTable[	265	]	[	3	]=	-1.61236908	;
	isoTempLinesTable[266][0]=	3759.398496	;		isoTempLinesTable[	266	]	[	1	]=	0.2297884	;		isoTempLinesTable[	266	]	[	2	]=	0.337435527	;		isoTempLinesTable[	266	]	[	3	]=	-1.623729827	;
	isoTempLinesTable[267][0]=	3745.318352	;		isoTempLinesTable[	267	]	[	1	]=	0.230084841	;		isoTempLinesTable[	267	]	[	2	]=	0.337617456	;		isoTempLinesTable[	267	]	[	3	]=	-1.635171604	;
	isoTempLinesTable[268][0]=	3731.343284	;		isoTempLinesTable[	268	]	[	1	]=	0.230381729	;		isoTempLinesTable[	268	]	[	2	]=	0.337798384	;		isoTempLinesTable[	268	]	[	3	]=	-1.646695158	;
	isoTempLinesTable[269][0]=	3717.472119	;		isoTempLinesTable[	269	]	[	1	]=	0.23067906	;		isoTempLinesTable[	269	]	[	2	]=	0.337978313	;		isoTempLinesTable[	269	]	[	3	]=	-1.65830124	;
	isoTempLinesTable[270][0]=	3703.703704	;		isoTempLinesTable[	270	]	[	1	]=	0.230976829	;		isoTempLinesTable[	270	]	[	2	]=	0.338157246	;		isoTempLinesTable[	270	]	[	3	]=	-1.669990613	;
	isoTempLinesTable[271][0]=	3690.0369	;		isoTempLinesTable[	271	]	[	1	]=	0.231275032	;		isoTempLinesTable[	271	]	[	2	]=	0.338335186	;		isoTempLinesTable[	271	]	[	3	]=	-1.68176405	;
	isoTempLinesTable[272][0]=	3676.470588	;		isoTempLinesTable[	272	]	[	1	]=	0.231573666	;		isoTempLinesTable[	272	]	[	2	]=	0.338512136	;		isoTempLinesTable[	272	]	[	3	]=	-1.693622329	;
	isoTempLinesTable[273][0]=	3663.003663	;		isoTempLinesTable[	273	]	[	1	]=	0.231872727	;		isoTempLinesTable[	273	]	[	2	]=	0.338688097	;		isoTempLinesTable[	273	]	[	3	]=	-1.705566241	;
	isoTempLinesTable[274][0]=	3649.635036	;		isoTempLinesTable[	274	]	[	1	]=	0.232172211	;		isoTempLinesTable[	274	]	[	2	]=	0.338863074	;		isoTempLinesTable[	274	]	[	3	]=	-1.717596586	;
	isoTempLinesTable[275][0]=	3636.363636	;		isoTempLinesTable[	275	]	[	1	]=	0.232472114	;		isoTempLinesTable[	275	]	[	2	]=	0.339037068	;		isoTempLinesTable[	275	]	[	3	]=	-1.729714173	;
	isoTempLinesTable[276][0]=	3623.188406	;		isoTempLinesTable[	276	]	[	1	]=	0.232772433	;		isoTempLinesTable[	276	]	[	2	]=	0.339210082	;		isoTempLinesTable[	276	]	[	3	]=	-1.74191982	;
	isoTempLinesTable[277][0]=	3610.108303	;		isoTempLinesTable[	277	]	[	1	]=	0.233073163	;		isoTempLinesTable[	277	]	[	2	]=	0.339382119	;		isoTempLinesTable[	277	]	[	3	]=	-1.754214356	;
	isoTempLinesTable[278][0]=	3597.122302	;		isoTempLinesTable[	278	]	[	1	]=	0.233374301	;		isoTempLinesTable[	278	]	[	2	]=	0.339553182	;		isoTempLinesTable[	278	]	[	3	]=	-1.766598619	;
	isoTempLinesTable[279][0]=	3584.229391	;		isoTempLinesTable[	279	]	[	1	]=	0.233675843	;		isoTempLinesTable[	279	]	[	2	]=	0.339723273	;		isoTempLinesTable[	279	]	[	3	]=	-1.779073459	;
	isoTempLinesTable[280][0]=	3571.428571	;		isoTempLinesTable[	280	]	[	1	]=	0.233977786	;		isoTempLinesTable[	280	]	[	2	]=	0.339892396	;		isoTempLinesTable[	280	]	[	3	]=	-1.791639735	;
	isoTempLinesTable[281][0]=	3558.718861	;		isoTempLinesTable[	281	]	[	1	]=	0.234280125	;		isoTempLinesTable[	281	]	[	2	]=	0.340060553	;		isoTempLinesTable[	281	]	[	3	]=	-1.804298316	;
	isoTempLinesTable[282][0]=	3546.099291	;		isoTempLinesTable[	282	]	[	1	]=	0.234582857	;		isoTempLinesTable[	282	]	[	2	]=	0.340227748	;		isoTempLinesTable[	282	]	[	3	]=	-1.817050082	;
	isoTempLinesTable[283][0]=	3533.568905	;		isoTempLinesTable[	283	]	[	1	]=	0.234885978	;		isoTempLinesTable[	283	]	[	2	]=	0.340393982	;		isoTempLinesTable[	283	]	[	3	]=	-1.829895926	;
	isoTempLinesTable[284][0]=	3521.126761	;		isoTempLinesTable[	284	]	[	1	]=	0.235189485	;		isoTempLinesTable[	284	]	[	2	]=	0.340559259	;		isoTempLinesTable[	284	]	[	3	]=	-1.842836747	;
	isoTempLinesTable[285][0]=	3508.77193	;		isoTempLinesTable[	285	]	[	1	]=	0.235493374	;		isoTempLinesTable[	285	]	[	2	]=	0.340723582	;		isoTempLinesTable[	285	]	[	3	]=	-1.855873461	;
	isoTempLinesTable[286][0]=	3496.503497	;		isoTempLinesTable[	286	]	[	1	]=	0.235797642	;		isoTempLinesTable[	286	]	[	2	]=	0.340886954	;		isoTempLinesTable[	286	]	[	3	]=	-1.86900699	;
	isoTempLinesTable[287][0]=	3484.320557	;		isoTempLinesTable[	287	]	[	1	]=	0.236102284	;		isoTempLinesTable[	287	]	[	2	]=	0.341049377	;		isoTempLinesTable[	287	]	[	3	]=	-1.88223827	;
	isoTempLinesTable[288][0]=	3472.222222	;		isoTempLinesTable[	288	]	[	1	]=	0.236407298	;		isoTempLinesTable[	288	]	[	2	]=	0.341210855	;		isoTempLinesTable[	288	]	[	3	]=	-1.89556825	;
	isoTempLinesTable[289][0]=	3460.207612	;		isoTempLinesTable[	289	]	[	1	]=	0.236712679	;		isoTempLinesTable[	289	]	[	2	]=	0.34137139	;		isoTempLinesTable[	289	]	[	3	]=	-1.908997887	;
	isoTempLinesTable[290][0]=	3448.275862	;		isoTempLinesTable[	290	]	[	1	]=	0.237018424	;		isoTempLinesTable[	290	]	[	2	]=	0.341530986	;		isoTempLinesTable[	290	]	[	3	]=	-1.922528153	;
	isoTempLinesTable[291][0]=	3436.426117	;		isoTempLinesTable[	291	]	[	1	]=	0.23732453	;		isoTempLinesTable[	291	]	[	2	]=	0.341689645	;		isoTempLinesTable[	291	]	[	3	]=	-1.936160031	;
	isoTempLinesTable[292][0]=	3424.657534	;		isoTempLinesTable[	292	]	[	1	]=	0.237630994	;		isoTempLinesTable[	292	]	[	2	]=	0.341847371	;		isoTempLinesTable[	292	]	[	3	]=	-1.949894516	;
	isoTempLinesTable[293][0]=	3412.969283	;		isoTempLinesTable[	293	]	[	1	]=	0.23793781	;		isoTempLinesTable[	293	]	[	2	]=	0.342004166	;		isoTempLinesTable[	293	]	[	3	]=	-1.963732615	;
	isoTempLinesTable[294][0]=	3401.360544	;		isoTempLinesTable[	294	]	[	1	]=	0.238244977	;		isoTempLinesTable[	294	]	[	2	]=	0.342160034	;		isoTempLinesTable[	294	]	[	3	]=	-1.977675351	;
	isoTempLinesTable[295][0]=	3389.830508	;		isoTempLinesTable[	295	]	[	1	]=	0.238552491	;		isoTempLinesTable[	295	]	[	2	]=	0.342314978	;		isoTempLinesTable[	295	]	[	3	]=	-1.991723754	;
	isoTempLinesTable[296][0]=	3378.378378	;		isoTempLinesTable[	296	]	[	1	]=	0.238860348	;		isoTempLinesTable[	296	]	[	2	]=	0.342469	;		isoTempLinesTable[	296	]	[	3	]=	-2.005878873	;
	isoTempLinesTable[297][0]=	3367.003367	;		isoTempLinesTable[	297	]	[	1	]=	0.239168545	;		isoTempLinesTable[	297	]	[	2	]=	0.342622103	;		isoTempLinesTable[	297	]	[	3	]=	-2.020141767	;
	isoTempLinesTable[298][0]=	3355.704698	;		isoTempLinesTable[	298	]	[	1	]=	0.239477078	;		isoTempLinesTable[	298	]	[	2	]=	0.342774292	;		isoTempLinesTable[	298	]	[	3	]=	-2.034513508	;
	isoTempLinesTable[299][0]=	3344.481605	;		isoTempLinesTable[	299	]	[	1	]=	0.239785944	;		isoTempLinesTable[	299	]	[	2	]=	0.342925568	;		isoTempLinesTable[	299	]	[	3	]=	-2.048995184	;
	isoTempLinesTable[300][0]=	3333.333333	;		isoTempLinesTable[	300	]	[	1	]=	0.24009514	;		isoTempLinesTable[	300	]	[	2	]=	0.343075935	;		isoTempLinesTable[	300	]	[	3	]=	-2.063587895	;
	isoTempLinesTable[301][0]=	3322.259136	;		isoTempLinesTable[	301	]	[	1	]=	0.240404663	;		isoTempLinesTable[	301	]	[	2	]=	0.343225396	;		isoTempLinesTable[	301	]	[	3	]=	-2.078292755	;
	isoTempLinesTable[302][0]=	3311.258278	;		isoTempLinesTable[	302	]	[	1	]=	0.240714508	;		isoTempLinesTable[	302	]	[	2	]=	0.343373954	;		isoTempLinesTable[	302	]	[	3	]=	-2.093110895	;
	isoTempLinesTable[303][0]=	3300.330033	;		isoTempLinesTable[	303	]	[	1	]=	0.241024674	;		isoTempLinesTable[	303	]	[	2	]=	0.343521612	;		isoTempLinesTable[	303	]	[	3	]=	-2.108043456	;
	isoTempLinesTable[304][0]=	3289.473684	;		isoTempLinesTable[	304	]	[	1	]=	0.241335155	;		isoTempLinesTable[	304	]	[	2	]=	0.343668374	;		isoTempLinesTable[	304	]	[	3	]=	-2.123091598	;
	isoTempLinesTable[305][0]=	3278.688525	;		isoTempLinesTable[	305	]	[	1	]=	0.24164595	;		isoTempLinesTable[	305	]	[	2	]=	0.343814242	;		isoTempLinesTable[	305	]	[	3	]=	-2.138256495	;
	isoTempLinesTable[306][0]=	3267.973856	;		isoTempLinesTable[	306	]	[	1	]=	0.241957055	;		isoTempLinesTable[	306	]	[	2	]=	0.34395922	;		isoTempLinesTable[	306	]	[	3	]=	-2.153539333	;
	isoTempLinesTable[307][0]=	3257.32899	;		isoTempLinesTable[	307	]	[	1	]=	0.242268467	;		isoTempLinesTable[	307	]	[	2	]=	0.344103311	;		isoTempLinesTable[	307	]	[	3	]=	-2.168941318	;
	isoTempLinesTable[308][0]=	3246.753247	;		isoTempLinesTable[	308	]	[	1	]=	0.242580182	;		isoTempLinesTable[	308	]	[	2	]=	0.344246517	;		isoTempLinesTable[	308	]	[	3	]=	-2.18446367	;
	isoTempLinesTable[309][0]=	3236.245955	;		isoTempLinesTable[	309	]	[	1	]=	0.242892197	;		isoTempLinesTable[	309	]	[	2	]=	0.344388842	;		isoTempLinesTable[	309	]	[	3	]=	-2.200107623	;
	isoTempLinesTable[310][0]=	3225.806452	;		isoTempLinesTable[	310	]	[	1	]=	0.243204509	;		isoTempLinesTable[	310	]	[	2	]=	0.34453029	;		isoTempLinesTable[	310	]	[	3	]=	-2.21587443	;
	isoTempLinesTable[311][0]=	3215.434084	;		isoTempLinesTable[	311	]	[	1	]=	0.243517116	;		isoTempLinesTable[	311	]	[	2	]=	0.344670863	;		isoTempLinesTable[	311	]	[	3	]=	-2.231765359	;
	isoTempLinesTable[312][0]=	3205.128205	;		isoTempLinesTable[	312	]	[	1	]=	0.243830013	;		isoTempLinesTable[	312	]	[	2	]=	0.344810564	;		isoTempLinesTable[	312	]	[	3	]=	-2.247781696	;
	isoTempLinesTable[313][0]=	3194.888179	;		isoTempLinesTable[	313	]	[	1	]=	0.244143197	;		isoTempLinesTable[	313	]	[	2	]=	0.344949397	;		isoTempLinesTable[	313	]	[	3	]=	-2.263924742	;
	isoTempLinesTable[314][0]=	3184.713376	;		isoTempLinesTable[	314	]	[	1	]=	0.244456666	;		isoTempLinesTable[	314	]	[	2	]=	0.345087366	;		isoTempLinesTable[	314	]	[	3	]=	-2.280195818	;
	isoTempLinesTable[315][0]=	3174.603175	;		isoTempLinesTable[	315	]	[	1	]=	0.244770417	;		isoTempLinesTable[	315	]	[	2	]=	0.345224472	;		isoTempLinesTable[	315	]	[	3	]=	-2.296596261	;
	isoTempLinesTable[316][0]=	3164.556962	;		isoTempLinesTable[	316	]	[	1	]=	0.245084446	;		isoTempLinesTable[	316	]	[	2	]=	0.345360719	;		isoTempLinesTable[	316	]	[	3	]=	-2.313127425	;
	isoTempLinesTable[317][0]=	3154.574132	;		isoTempLinesTable[	317	]	[	1	]=	0.24539875	;		isoTempLinesTable[	317	]	[	2	]=	0.345496111	;		isoTempLinesTable[	317	]	[	3	]=	-2.329790684	;
	isoTempLinesTable[318][0]=	3144.654088	;		isoTempLinesTable[	318	]	[	1	]=	0.245713326	;		isoTempLinesTable[	318	]	[	2	]=	0.345630651	;		isoTempLinesTable[	318	]	[	3	]=	-2.346587429	;
	isoTempLinesTable[319][0]=	3134.796238	;		isoTempLinesTable[	319	]	[	1	]=	0.246028171	;		isoTempLinesTable[	319	]	[	2	]=	0.345764341	;		isoTempLinesTable[	319	]	[	3	]=	-2.363519072	;
	isoTempLinesTable[320][0]=	3125		;		isoTempLinesTable[	320	]	[	1	]=	0.246343283	;		isoTempLinesTable[	320	]	[	2	]=	0.345897186	;		isoTempLinesTable[	320	]	[	3	]=	-2.380587041	;
	isoTempLinesTable[321][0]=	3115.264798	;		isoTempLinesTable[	321	]	[	1	]=	0.246658658	;		isoTempLinesTable[	321	]	[	2	]=	0.346029187	;		isoTempLinesTable[	321	]	[	3	]=	-2.397792787	;
	isoTempLinesTable[322][0]=	3105.590062	;		isoTempLinesTable[	322	]	[	1	]=	0.246974292	;		isoTempLinesTable[	322	]	[	2	]=	0.34616035	;		isoTempLinesTable[	322	]	[	3	]=	-2.415137777	;
	isoTempLinesTable[323][0]=	3095.975232	;		isoTempLinesTable[	323	]	[	1	]=	0.247290184	;		isoTempLinesTable[	323	]	[	2	]=	0.346290676	;		isoTempLinesTable[	323	]	[	3	]=	-2.432623501	;
	isoTempLinesTable[324][0]=	3086.419753	;		isoTempLinesTable[	324	]	[	1	]=	0.24760633	;		isoTempLinesTable[	324	]	[	2	]=	0.346420169	;		isoTempLinesTable[	324	]	[	3	]=	-2.450251468	;
	isoTempLinesTable[325][0]=	3076.923077	;		isoTempLinesTable[	325	]	[	1	]=	0.247922728	;		isoTempLinesTable[	325	]	[	2	]=	0.346548832	;		isoTempLinesTable[	325	]	[	3	]=	-2.468023209	;
	isoTempLinesTable[326][0]=	3067.484663	;		isoTempLinesTable[	326	]	[	1	]=	0.248239373	;		isoTempLinesTable[	326	]	[	2	]=	0.346676668	;		isoTempLinesTable[	326	]	[	3	]=	-2.485940275	;
	isoTempLinesTable[327][0]=	3058.103976	;		isoTempLinesTable[	327	]	[	1	]=	0.248556264	;		isoTempLinesTable[	327	]	[	2	]=	0.346803681	;		isoTempLinesTable[	327	]	[	3	]=	-2.504004238	;
	isoTempLinesTable[328][0]=	3048.780488	;		isoTempLinesTable[	328	]	[	1	]=	0.248873398	;		isoTempLinesTable[	328	]	[	2	]=	0.346929874	;		isoTempLinesTable[	328	]	[	3	]=	-2.522216693	;
	isoTempLinesTable[329][0]=	3039.513678	;		isoTempLinesTable[	329	]	[	1	]=	0.249190771	;		isoTempLinesTable[	329	]	[	2	]=	0.34705525	;		isoTempLinesTable[	329	]	[	3	]=	-2.540579259	;
	isoTempLinesTable[330][0]=	3030.30303	;		isoTempLinesTable[	330	]	[	1	]=	0.249508381	;		isoTempLinesTable[	330	]	[	2	]=	0.347179812	;		isoTempLinesTable[	330	]	[	3	]=	-2.559093573	;
	isoTempLinesTable[331][0]=	3021.148036	;		isoTempLinesTable[	331	]	[	1	]=	0.249826226	;		isoTempLinesTable[	331	]	[	2	]=	0.347303563	;		isoTempLinesTable[	331	]	[	3	]=	-2.577761299	;
	isoTempLinesTable[332][0]=	3012.048193	;		isoTempLinesTable[	332	]	[	1	]=	0.250144301	;		isoTempLinesTable[	332	]	[	2	]=	0.347426507	;		isoTempLinesTable[	332	]	[	3	]=	-2.596584123	;
	isoTempLinesTable[333][0]=	3003.003003	;		isoTempLinesTable[	333	]	[	1	]=	0.250462604	;		isoTempLinesTable[	333	]	[	2	]=	0.347548648	;		isoTempLinesTable[	333	]	[	3	]=	-2.615563755	;
	isoTempLinesTable[334][0]=	2994.011976	;		isoTempLinesTable[	334	]	[	1	]=	0.250781133	;		isoTempLinesTable[	334	]	[	2	]=	0.347669987	;		isoTempLinesTable[	334	]	[	3	]=	-2.634701929	;
	isoTempLinesTable[335][0]=	2985.074627	;		isoTempLinesTable[	335	]	[	1	]=	0.251099885	;		isoTempLinesTable[	335	]	[	2	]=	0.347790529	;		isoTempLinesTable[	335	]	[	3	]=	-2.654000404	;
	isoTempLinesTable[336][0]=	2976.190476	;		isoTempLinesTable[	336	]	[	1	]=	0.251418856	;		isoTempLinesTable[	336	]	[	2	]=	0.347910276	;		isoTempLinesTable[	336	]	[	3	]=	-2.673460965	;
	isoTempLinesTable[337][0]=	2967.35905	;		isoTempLinesTable[	337	]	[	1	]=	0.251738045	;		isoTempLinesTable[	337	]	[	2	]=	0.348029232	;		isoTempLinesTable[	337	]	[	3	]=	-2.693085422	;
	isoTempLinesTable[338][0]=	2958.579882	;		isoTempLinesTable[	338	]	[	1	]=	0.252057448	;		isoTempLinesTable[	338	]	[	2	]=	0.3481474	;		isoTempLinesTable[	338	]	[	3	]=	-2.712875609	;
	isoTempLinesTable[339][0]=	2949.852507	;		isoTempLinesTable[	339	]	[	1	]=	0.252377063	;		isoTempLinesTable[	339	]	[	2	]=	0.348264784	;		isoTempLinesTable[	339	]	[	3	]=	-2.73283339	;
	isoTempLinesTable[340][0]=	2941.176471	;		isoTempLinesTable[	340	]	[	1	]=	0.252696888	;		isoTempLinesTable[	340	]	[	2	]=	0.348381386	;		isoTempLinesTable[	340	]	[	3	]=	-2.752960654	;
	isoTempLinesTable[341][0]=	2932.55132	;		isoTempLinesTable[	341	]	[	1	]=	0.253016918	;		isoTempLinesTable[	341	]	[	2	]=	0.348497209	;		isoTempLinesTable[	341	]	[	3	]=	-2.773259317	;
	isoTempLinesTable[342][0]=	2923.976608	;		isoTempLinesTable[	342	]	[	1	]=	0.253337152	;		isoTempLinesTable[	342	]	[	2	]=	0.348612258	;		isoTempLinesTable[	342	]	[	3	]=	-2.793731325	;
	isoTempLinesTable[343][0]=	2915.451895	;		isoTempLinesTable[	343	]	[	1	]=	0.253657587	;		isoTempLinesTable[	343	]	[	2	]=	0.348726534	;		isoTempLinesTable[	343	]	[	3	]=	-2.814378652	;
	isoTempLinesTable[344][0]=	2906.976744	;		isoTempLinesTable[	344	]	[	1	]=	0.25397822	;		isoTempLinesTable[	344	]	[	2	]=	0.348840042	;		isoTempLinesTable[	344	]	[	3	]=	-2.835203298	;
	isoTempLinesTable[345][0]=	2898.550725	;		isoTempLinesTable[	345	]	[	1	]=	0.254299049	;		isoTempLinesTable[	345	]	[	2	]=	0.348952785	;		isoTempLinesTable[	345	]	[	3	]=	-2.856207297	;
	isoTempLinesTable[346][0]=	2890.17341	;		isoTempLinesTable[	346	]	[	1	]=	0.254620072	;		isoTempLinesTable[	346	]	[	2	]=	0.349064765	;		isoTempLinesTable[	346	]	[	3	]=	-2.877392711	;
	isoTempLinesTable[347][0]=	2881.84438	;		isoTempLinesTable[	347	]	[	1	]=	0.254941284	;		isoTempLinesTable[	347	]	[	2	]=	0.349175987	;		isoTempLinesTable[	347	]	[	3	]=	-2.898761632	;
	isoTempLinesTable[348][0]=	2873.563218	;		isoTempLinesTable[	348	]	[	1	]=	0.255262685	;		isoTempLinesTable[	348	]	[	2	]=	0.349286452	;		isoTempLinesTable[	348	]	[	3	]=	-2.920316184	;
	isoTempLinesTable[349][0]=	2865.329513	;		isoTempLinesTable[	349	]	[	1	]=	0.255584271	;		isoTempLinesTable[	349	]	[	2	]=	0.349396165	;		isoTempLinesTable[	349	]	[	3	]=	-2.942058524	;
	isoTempLinesTable[350][0]=	2857.142857	;		isoTempLinesTable[	350	]	[	1	]=	0.255906039	;		isoTempLinesTable[	350	]	[	2	]=	0.349505128	;		isoTempLinesTable[	350	]	[	3	]=	-2.963990839	;
	isoTempLinesTable[351][0]=	2849.002849	;		isoTempLinesTable[	351	]	[	1	]=	0.256227988	;		isoTempLinesTable[	351	]	[	2	]=	0.349613346	;		isoTempLinesTable[	351	]	[	3	]=	-2.986115351	;
	isoTempLinesTable[352][0]=	2840.909091	;		isoTempLinesTable[	352	]	[	1	]=	0.256550115	;		isoTempLinesTable[	352	]	[	2	]=	0.34972082	;		isoTempLinesTable[	352	]	[	3	]=	-3.008434315	;
	isoTempLinesTable[353][0]=	2832.86119	;		isoTempLinesTable[	353	]	[	1	]=	0.256872416	;		isoTempLinesTable[	353	]	[	2	]=	0.349827554	;		isoTempLinesTable[	353	]	[	3	]=	-3.030950021	;
	isoTempLinesTable[354][0]=	2824.858757	;		isoTempLinesTable[	354	]	[	1	]=	0.257194891	;		isoTempLinesTable[	354	]	[	2	]=	0.349933552	;		isoTempLinesTable[	354	]	[	3	]=	-3.053664792	;
	isoTempLinesTable[355][0]=	2816.901408	;		isoTempLinesTable[	355	]	[	1	]=	0.257517535	;		isoTempLinesTable[	355	]	[	2	]=	0.350038816	;		isoTempLinesTable[	355	]	[	3	]=	-3.076580989	;
	isoTempLinesTable[356][0]=	2808.988764	;		isoTempLinesTable[	356	]	[	1	]=	0.257840347	;		isoTempLinesTable[	356	]	[	2	]=	0.35014335	;		isoTempLinesTable[	356	]	[	3	]=	-3.099701008	;
	isoTempLinesTable[357][0]=	2801.120448	;		isoTempLinesTable[	357	]	[	1	]=	0.258163325	;		isoTempLinesTable[	357	]	[	2	]=	0.350247157	;		isoTempLinesTable[	357	]	[	3	]=	-3.123027282	;
	isoTempLinesTable[358][0]=	2793.296089	;		isoTempLinesTable[	358	]	[	1	]=	0.258486465	;		isoTempLinesTable[	358	]	[	2	]=	0.350350239	;		isoTempLinesTable[	358	]	[	3	]=	-3.146562281	;
	isoTempLinesTable[359][0]=	2785.51532	;		isoTempLinesTable[	359	]	[	1	]=	0.258809766	;		isoTempLinesTable[	359	]	[	2	]=	0.350452601	;		isoTempLinesTable[	359	]	[	3	]=	-3.170308517	;
	isoTempLinesTable[360][0]=	2777.777778	;		isoTempLinesTable[	360	]	[	1	]=	0.259133224	;		isoTempLinesTable[	360	]	[	2	]=	0.350554246	;		isoTempLinesTable[	360	]	[	3	]=	-3.194268537	;
	isoTempLinesTable[361][0]=	2770.083102	;		isoTempLinesTable[	361	]	[	1	]=	0.259456838	;		isoTempLinesTable[	361	]	[	2	]=	0.350655176	;		isoTempLinesTable[	361	]	[	3	]=	-3.21844493	;
	isoTempLinesTable[362][0]=	2762.430939	;		isoTempLinesTable[	362	]	[	1	]=	0.259780605	;		isoTempLinesTable[	362	]	[	2	]=	0.350755394	;		isoTempLinesTable[	362	]	[	3	]=	-3.242840326	;
	isoTempLinesTable[363][0]=	2754.820937	;		isoTempLinesTable[	363	]	[	1	]=	0.260104523	;		isoTempLinesTable[	363	]	[	2	]=	0.350854905	;		isoTempLinesTable[	363	]	[	3	]=	-3.267457395	;
	isoTempLinesTable[364][0]=	2747.252747	;		isoTempLinesTable[	364	]	[	1	]=	0.260428589	;		isoTempLinesTable[	364	]	[	2	]=	0.35095371	;		isoTempLinesTable[	364	]	[	3	]=	-3.292298851	;
	isoTempLinesTable[365][0]=	2739.726027	;		isoTempLinesTable[	365	]	[	1	]=	0.260752802	;		isoTempLinesTable[	365	]	[	2	]=	0.351051814	;		isoTempLinesTable[	365	]	[	3	]=	-3.317367451	;
	isoTempLinesTable[366][0]=	2732.240437	;		isoTempLinesTable[	366	]	[	1	]=	0.261077158	;		isoTempLinesTable[	366	]	[	2	]=	0.351149218	;		isoTempLinesTable[	366	]	[	3	]=	-3.342665997	;
	isoTempLinesTable[367][0]=	2724.79564	;		isoTempLinesTable[	367	]	[	1	]=	0.261401655	;		isoTempLinesTable[	367	]	[	2	]=	0.351245927	;		isoTempLinesTable[	367	]	[	3	]=	-3.368197332	;
	isoTempLinesTable[368][0]=	2717.391304	;		isoTempLinesTable[	368	]	[	1	]=	0.261726291	;		isoTempLinesTable[	368	]	[	2	]=	0.351341944	;		isoTempLinesTable[	368	]	[	3	]=	-3.393964351	;
	isoTempLinesTable[369][0]=	2710.0271	;		isoTempLinesTable[	369	]	[	1	]=	0.262051064	;		isoTempLinesTable[	369	]	[	2	]=	0.351437271	;		isoTempLinesTable[	369	]	[	3	]=	-3.41996999	;
	isoTempLinesTable[370][0]=	2702.702703	;		isoTempLinesTable[	370	]	[	1	]=	0.262375972	;		isoTempLinesTable[	370	]	[	2	]=	0.351531912	;		isoTempLinesTable[	370	]	[	3	]=	-3.446217238	;
	isoTempLinesTable[371][0]=	2695.41779	;		isoTempLinesTable[	371	]	[	1	]=	0.262701012	;		isoTempLinesTable[	371	]	[	2	]=	0.35162587	;		isoTempLinesTable[	371	]	[	3	]=	-3.472709128	;
	isoTempLinesTable[372][0]=	2688.172043	;		isoTempLinesTable[	372	]	[	1	]=	0.263026181	;		isoTempLinesTable[	372	]	[	2	]=	0.351719147	;		isoTempLinesTable[	372	]	[	3	]=	-3.499448746	;
	isoTempLinesTable[373][0]=	2680.965147	;		isoTempLinesTable[	373	]	[	1	]=	0.263351479	;		isoTempLinesTable[	373	]	[	2	]=	0.351811748	;		isoTempLinesTable[	373	]	[	3	]=	-3.526439229	;
	isoTempLinesTable[374][0]=	2673.796791	;		isoTempLinesTable[	374	]	[	1	]=	0.263676901	;		isoTempLinesTable[	374	]	[	2	]=	0.351903675	;		isoTempLinesTable[	374	]	[	3	]=	-3.553683763	;
	isoTempLinesTable[375][0]=	2666.666667	;		isoTempLinesTable[	375	]	[	1	]=	0.264002447	;		isoTempLinesTable[	375	]	[	2	]=	0.35199493	;		isoTempLinesTable[	375	]	[	3	]=	-3.58118559	;
	isoTempLinesTable[376][0]=	2659.574468	;		isoTempLinesTable[	376	]	[	1	]=	0.264328114	;		isoTempLinesTable[	376	]	[	2	]=	0.352085519	;		isoTempLinesTable[	376	]	[	3	]=	-3.608948003	;
	isoTempLinesTable[377][0]=	2652.519894	;		isoTempLinesTable[	377	]	[	1	]=	0.2646539	;		isoTempLinesTable[	377	]	[	2	]=	0.352175442	;		isoTempLinesTable[	377	]	[	3	]=	-3.636974354	;
	isoTempLinesTable[378][0]=	2645.502646	;		isoTempLinesTable[	378	]	[	1	]=	0.264979803	;		isoTempLinesTable[	378	]	[	2	]=	0.352264704	;		isoTempLinesTable[	378	]	[	3	]=	-3.665268049	;
	isoTempLinesTable[379][0]=	2638.522427	;		isoTempLinesTable[	379	]	[	1	]=	0.26530582	;		isoTempLinesTable[	379	]	[	2	]=	0.352353307	;		isoTempLinesTable[	379	]	[	3	]=	-3.69383255	;
	isoTempLinesTable[380][0]=	2631.578947	;		isoTempLinesTable[	380	]	[	1	]=	0.265631949	;		isoTempLinesTable[	380	]	[	2	]=	0.352441255	;		isoTempLinesTable[	380	]	[	3	]=	-3.722671382	;
	isoTempLinesTable[381][0]=	2624.671916	;		isoTempLinesTable[	381	]	[	1	]=	0.265958188	;		isoTempLinesTable[	381	]	[	2	]=	0.352528551	;		isoTempLinesTable[	381	]	[	3	]=	-3.751788126	;
	isoTempLinesTable[382][0]=	2617.801047	;		isoTempLinesTable[	382	]	[	1	]=	0.266284535	;		isoTempLinesTable[	382	]	[	2	]=	0.352615197	;		isoTempLinesTable[	382	]	[	3	]=	-3.781186426	;
	isoTempLinesTable[383][0]=	2610.966057	;		isoTempLinesTable[	383	]	[	1	]=	0.266610989	;		isoTempLinesTable[	383	]	[	2	]=	0.352701196	;		isoTempLinesTable[	383	]	[	3	]=	-3.810869989	;
	isoTempLinesTable[384][0]=	2604.166667	;		isoTempLinesTable[	384	]	[	1	]=	0.266937546	;		isoTempLinesTable[	384	]	[	2	]=	0.352786552	;		isoTempLinesTable[	384	]	[	3	]=	-3.840842585	;
	isoTempLinesTable[385][0]=	2597.402597	;		isoTempLinesTable[	385	]	[	1	]=	0.267264204	;		isoTempLinesTable[	385	]	[	2	]=	0.352871268	;		isoTempLinesTable[	385	]	[	3	]=	-3.87110805	;
	isoTempLinesTable[386][0]=	2590.673575	;		isoTempLinesTable[	386	]	[	1	]=	0.267590962	;		isoTempLinesTable[	386	]	[	2	]=	0.352955347	;		isoTempLinesTable[	386	]	[	3	]=	-3.901670288	;
	isoTempLinesTable[387][0]=	2583.979328	;		isoTempLinesTable[	387	]	[	1	]=	0.267917818	;		isoTempLinesTable[	387	]	[	2	]=	0.353038791	;		isoTempLinesTable[	387	]	[	3	]=	-3.932533267	;
	isoTempLinesTable[388][0]=	2577.319588	;		isoTempLinesTable[	388	]	[	1	]=	0.26824477	;		isoTempLinesTable[	388	]	[	2	]=	0.353121604	;		isoTempLinesTable[	388	]	[	3	]=	-3.96370103	;
	isoTempLinesTable[389][0]=	2570.694087	;		isoTempLinesTable[	389	]	[	1	]=	0.268571814	;		isoTempLinesTable[	389	]	[	2	]=	0.353203788	;		isoTempLinesTable[	389	]	[	3	]=	-3.995177689	;
	isoTempLinesTable[390][0]=	2564.102564	;		isoTempLinesTable[	390	]	[	1	]=	0.26889895	;		isoTempLinesTable[	390	]	[	2	]=	0.353285348	;		isoTempLinesTable[	390	]	[	3	]=	-4.026967427	;
	isoTempLinesTable[391][0]=	2557.544757	;		isoTempLinesTable[	391	]	[	1	]=	0.269226176	;		isoTempLinesTable[	391	]	[	2	]=	0.353366284	;		isoTempLinesTable[	391	]	[	3	]=	-4.059074504	;
	isoTempLinesTable[392][0]=	2551.020408	;		isoTempLinesTable[	392	]	[	1	]=	0.269553488	;		isoTempLinesTable[	392	]	[	2	]=	0.353446602	;		isoTempLinesTable[	392	]	[	3	]=	-4.091503256	;
	isoTempLinesTable[393][0]=	2544.529262	;		isoTempLinesTable[	393	]	[	1	]=	0.269880886	;		isoTempLinesTable[	393	]	[	2	]=	0.353526303	;		isoTempLinesTable[	393	]	[	3	]=	-4.124258096	;
	isoTempLinesTable[394][0]=	2538.071066	;		isoTempLinesTable[	394	]	[	1	]=	0.270208368	;		isoTempLinesTable[	394	]	[	2	]=	0.35360539	;		isoTempLinesTable[	394	]	[	3	]=	-4.157343517	;
	isoTempLinesTable[395][0]=	2531.64557	;		isoTempLinesTable[	395	]	[	1	]=	0.27053593	;		isoTempLinesTable[	395	]	[	2	]=	0.353683867	;		isoTempLinesTable[	395	]	[	3	]=	-4.190764093	;
	isoTempLinesTable[396][0]=	2525.252525	;		isoTempLinesTable[	396	]	[	1	]=	0.270863572	;		isoTempLinesTable[	396	]	[	2	]=	0.353761736	;		isoTempLinesTable[	396	]	[	3	]=	-4.224524482	;
	isoTempLinesTable[397][0]=	2518.891688	;		isoTempLinesTable[	397	]	[	1	]=	0.271191292	;		isoTempLinesTable[	397	]	[	2	]=	0.353839001	;		isoTempLinesTable[	397	]	[	3	]=	-4.258629427	;
	isoTempLinesTable[398][0]=	2512.562814	;		isoTempLinesTable[	398	]	[	1	]=	0.271519087	;		isoTempLinesTable[	398	]	[	2	]=	0.353915664	;		isoTempLinesTable[	398	]	[	3	]=	-4.293083757	;
	isoTempLinesTable[399][0]=	2506.265664	;		isoTempLinesTable[	399	]	[	1	]=	0.271846956	;		isoTempLinesTable[	399	]	[	2	]=	0.353991727	;		isoTempLinesTable[	399	]	[	3	]=	-4.327892393	;
	isoTempLinesTable[400][0]=	2500		;		isoTempLinesTable[	400	]	[	1	]=	0.272174896	;		isoTempLinesTable[	400	]	[	2	]=	0.354067195	;		isoTempLinesTable[	400	]	[	3	]=	-4.363060344	;
	isoTempLinesTable[401][0]=	2493.765586	;		isoTempLinesTable[	401	]	[	1	]=	0.272502906	;		isoTempLinesTable[	401	]	[	2	]=	0.35414207	;		isoTempLinesTable[	401	]	[	3	]=	-4.398592715	;
	isoTempLinesTable[402][0]=	2487.562189	;		isoTempLinesTable[	402	]	[	1	]=	0.272830983	;		isoTempLinesTable[	402	]	[	2	]=	0.354216355	;		isoTempLinesTable[	402	]	[	3	]=	-4.434494705	;
	isoTempLinesTable[403][0]=	2481.389578	;		isoTempLinesTable[	403	]	[	1	]=	0.273159127	;		isoTempLinesTable[	403	]	[	2	]=	0.354290053	;		isoTempLinesTable[	403	]	[	3	]=	-4.470771611	;
	isoTempLinesTable[404][0]=	2475.247525	;		isoTempLinesTable[	404	]	[	1	]=	0.273487335	;		isoTempLinesTable[	404	]	[	2	]=	0.354363166	;		isoTempLinesTable[	404	]	[	3	]=	-4.507428831	;
	isoTempLinesTable[405][0]=	2469.135802	;		isoTempLinesTable[	405	]	[	1	]=	0.273815605	;		isoTempLinesTable[	405	]	[	2	]=	0.354435697	;		isoTempLinesTable[	405	]	[	3	]=	-4.544471864	;
	isoTempLinesTable[406][0]=	2463.054187	;		isoTempLinesTable[	406	]	[	1	]=	0.274143935	;		isoTempLinesTable[	406	]	[	2	]=	0.35450765	;		isoTempLinesTable[	406	]	[	3	]=	-4.581906316	;
	isoTempLinesTable[407][0]=	2457.002457	;		isoTempLinesTable[	407	]	[	1	]=	0.274472324	;		isoTempLinesTable[	407	]	[	2	]=	0.354579027	;		isoTempLinesTable[	407	]	[	3	]=	-4.619737898	;
	isoTempLinesTable[408][0]=	2450.980392	;		isoTempLinesTable[	408	]	[	1	]=	0.274800769	;		isoTempLinesTable[	408	]	[	2	]=	0.354649831	;		isoTempLinesTable[	408	]	[	3	]=	-4.657972434	;
	isoTempLinesTable[409][0]=	2444.987775	;		isoTempLinesTable[	409	]	[	1	]=	0.27512927	;		isoTempLinesTable[	409	]	[	2	]=	0.354720065	;		isoTempLinesTable[	409	]	[	3	]=	-4.696615859	;
	isoTempLinesTable[410][0]=	2439.02439	;		isoTempLinesTable[	410	]	[	1	]=	0.275457823	;		isoTempLinesTable[	410	]	[	2	]=	0.354789731	;		isoTempLinesTable[	410	]	[	3	]=	-4.735674223	;
	isoTempLinesTable[411][0]=	2433.090024	;		isoTempLinesTable[	411	]	[	1	]=	0.275786427	;		isoTempLinesTable[	411	]	[	2	]=	0.354858833	;		isoTempLinesTable[	411	]	[	3	]=	-4.775153696	;
	isoTempLinesTable[412][0]=	2427.184466	;		isoTempLinesTable[	412	]	[	1	]=	0.276115081	;		isoTempLinesTable[	412	]	[	2	]=	0.354927374	;		isoTempLinesTable[	412	]	[	3	]=	-4.815060568	;
	isoTempLinesTable[413][0]=	2421.307506	;		isoTempLinesTable[	413	]	[	1	]=	0.276443783	;		isoTempLinesTable[	413	]	[	2	]=	0.354995355	;		isoTempLinesTable[	413	]	[	3	]=	-4.855401253	;
	isoTempLinesTable[414][0]=	2415.458937	;		isoTempLinesTable[	414	]	[	1	]=	0.27677253	;		isoTempLinesTable[	414	]	[	2	]=	0.355062781	;		isoTempLinesTable[	414	]	[	3	]=	-4.896182294	;
	isoTempLinesTable[415][0]=	2409.638554	;		isoTempLinesTable[	415	]	[	1	]=	0.277101322	;		isoTempLinesTable[	415	]	[	2	]=	0.355129653	;		isoTempLinesTable[	415	]	[	3	]=	-4.937410362	;
	isoTempLinesTable[416][0]=	2403.846154	;		isoTempLinesTable[	416	]	[	1	]=	0.277430156	;		isoTempLinesTable[	416	]	[	2	]=	0.355195974	;		isoTempLinesTable[	416	]	[	3	]=	-4.979092265	;
	isoTempLinesTable[417][0]=	2398.081535	;		isoTempLinesTable[	417	]	[	1	]=	0.27775903	;		isoTempLinesTable[	417	]	[	2	]=	0.355261748	;		isoTempLinesTable[	417	]	[	3	]=	-5.021234945	;
	isoTempLinesTable[418][0]=	2392.344498	;		isoTempLinesTable[	418	]	[	1	]=	0.278087944	;		isoTempLinesTable[	418	]	[	2	]=	0.355326976	;		isoTempLinesTable[	418	]	[	3	]=	-5.063845486	;
	isoTempLinesTable[419][0]=	2386.634845	;		isoTempLinesTable[	419	]	[	1	]=	0.278416894	;		isoTempLinesTable[	419	]	[	2	]=	0.355391663	;		isoTempLinesTable[	419	]	[	3	]=	-5.106931118	;
	isoTempLinesTable[420][0]=	2380.952381	;		isoTempLinesTable[	420	]	[	1	]=	0.278745881	;		isoTempLinesTable[	420	]	[	2	]=	0.355455809	;		isoTempLinesTable[	420	]	[	3	]=	-5.150499215	;
	isoTempLinesTable[421][0]=	2375.296912	;		isoTempLinesTable[	421	]	[	1	]=	0.279074901	;		isoTempLinesTable[	421	]	[	2	]=	0.355519419	;		isoTempLinesTable[	421	]	[	3	]=	-5.194557306	;
	isoTempLinesTable[422][0]=	2369.668246	;		isoTempLinesTable[	422	]	[	1	]=	0.279403953	;		isoTempLinesTable[	422	]	[	2	]=	0.355582495	;		isoTempLinesTable[	422	]	[	3	]=	-5.239113074	;
	isoTempLinesTable[423][0]=	2364.066194	;		isoTempLinesTable[	423	]	[	1	]=	0.279733035	;		isoTempLinesTable[	423	]	[	2	]=	0.35564504	;		isoTempLinesTable[	423	]	[	3	]=	-5.284174364	;
	isoTempLinesTable[424][0]=	2358.490566	;		isoTempLinesTable[	424	]	[	1	]=	0.280062146	;		isoTempLinesTable[	424	]	[	2	]=	0.355707056	;		isoTempLinesTable[	424	]	[	3	]=	-5.329749181	;
	isoTempLinesTable[425][0]=	2352.941176	;		isoTempLinesTable[	425	]	[	1	]=	0.280391284	;		isoTempLinesTable[	425	]	[	2	]=	0.355768546	;		isoTempLinesTable[	425	]	[	3	]=	-5.375845702	;
	isoTempLinesTable[426][0]=	2347.41784	;		isoTempLinesTable[	426	]	[	1	]=	0.280720448	;		isoTempLinesTable[	426	]	[	2	]=	0.355829512	;		isoTempLinesTable[	426	]	[	3	]=	-5.422472273	;
	isoTempLinesTable[427][0]=	2341.920375	;		isoTempLinesTable[	427	]	[	1	]=	0.281049636	;		isoTempLinesTable[	427	]	[	2	]=	0.355889958	;		isoTempLinesTable[	427	]	[	3	]=	-5.469637422	;
	isoTempLinesTable[428][0]=	2336.448598	;		isoTempLinesTable[	428	]	[	1	]=	0.281378845	;		isoTempLinesTable[	428	]	[	2	]=	0.355949886	;		isoTempLinesTable[	428	]	[	3	]=	-5.517349854	;
	isoTempLinesTable[429][0]=	2331.002331	;		isoTempLinesTable[	429	]	[	1	]=	0.281708076	;		isoTempLinesTable[	429	]	[	2	]=	0.356009299	;		isoTempLinesTable[	429	]	[	3	]=	-5.565618464	;
	isoTempLinesTable[430][0]=	2325.581395	;		isoTempLinesTable[	430	]	[	1	]=	0.282037325	;		isoTempLinesTable[	430	]	[	2	]=	0.356068199	;		isoTempLinesTable[	430	]	[	3	]=	-5.614452337	;
	isoTempLinesTable[431][0]=	2320.185615	;		isoTempLinesTable[	431	]	[	1	]=	0.282366591	;		isoTempLinesTable[	431	]	[	2	]=	0.35612659	;		isoTempLinesTable[	431	]	[	3	]=	-5.663860758	;
	isoTempLinesTable[432][0]=	2314.814815	;		isoTempLinesTable[	432	]	[	1	]=	0.282695874	;		isoTempLinesTable[	432	]	[	2	]=	0.356184472	;		isoTempLinesTable[	432	]	[	3	]=	-5.713853211	;
	isoTempLinesTable[433][0]=	2309.468822	;		isoTempLinesTable[	433	]	[	1	]=	0.28302517	;		isoTempLinesTable[	433	]	[	2	]=	0.356241851	;		isoTempLinesTable[	433	]	[	3	]=	-5.76443939	;
	isoTempLinesTable[434][0]=	2304.147465	;		isoTempLinesTable[	434	]	[	1	]=	0.283354479	;		isoTempLinesTable[	434	]	[	2	]=	0.356298727	;		isoTempLinesTable[	434	]	[	3	]=	-5.815629203	;
	isoTempLinesTable[435][0]=	2298.850575	;		isoTempLinesTable[	435	]	[	1	]=	0.2836838	;		isoTempLinesTable[	435	]	[	2	]=	0.356355103	;		isoTempLinesTable[	435	]	[	3	]=	-5.867432776	;
	isoTempLinesTable[436][0]=	2293.577982	;		isoTempLinesTable[	436	]	[	1	]=	0.284013129	;		isoTempLinesTable[	436	]	[	2	]=	0.356410983	;		isoTempLinesTable[	436	]	[	3	]=	-5.919860463	;
	isoTempLinesTable[437][0]=	2288.329519	;		isoTempLinesTable[	437	]	[	1	]=	0.284342467	;		isoTempLinesTable[	437	]	[	2	]=	0.356466368	;		isoTempLinesTable[	437	]	[	3	]=	-5.972922849	;
	isoTempLinesTable[438][0]=	2283.105023	;		isoTempLinesTable[	438	]	[	1	]=	0.284671811	;		isoTempLinesTable[	438	]	[	2	]=	0.356521262	;		isoTempLinesTable[	438	]	[	3	]=	-6.026630758	;
	isoTempLinesTable[439][0]=	2277.904328	;		isoTempLinesTable[	439	]	[	1	]=	0.28500116	;		isoTempLinesTable[	439	]	[	2	]=	0.356575666	;		isoTempLinesTable[	439	]	[	3	]=	-6.080995259	;
	isoTempLinesTable[440][0]=	2272.727273	;		isoTempLinesTable[	440	]	[	1	]=	0.285330512	;		isoTempLinesTable[	440	]	[	2	]=	0.356629584	;		isoTempLinesTable[	440	]	[	3	]=	-6.136027675	;
	isoTempLinesTable[441][0]=	2267.573696	;		isoTempLinesTable[	441	]	[	1	]=	0.285659867	;		isoTempLinesTable[	441	]	[	2	]=	0.356683018	;		isoTempLinesTable[	441	]	[	3	]=	-6.191739587	;
	isoTempLinesTable[442][0]=	2262.443439	;		isoTempLinesTable[	442	]	[	1	]=	0.285989221	;		isoTempLinesTable[	442	]	[	2	]=	0.35673597	;		isoTempLinesTable[	442	]	[	3	]=	-6.248142845	;
	isoTempLinesTable[443][0]=	2257.336343	;		isoTempLinesTable[	443	]	[	1	]=	0.286318575	;		isoTempLinesTable[	443	]	[	2	]=	0.356788443	;		isoTempLinesTable[	443	]	[	3	]=	-6.305249572	;
	isoTempLinesTable[444][0]=	2252.252252	;		isoTempLinesTable[	444	]	[	1	]=	0.286647926	;		isoTempLinesTable[	444	]	[	2	]=	0.35684044	;		isoTempLinesTable[	444	]	[	3	]=	-6.363072176	;
	isoTempLinesTable[445][0]=	2247.191011	;		isoTempLinesTable[	445	]	[	1	]=	0.286977273	;		isoTempLinesTable[	445	]	[	2	]=	0.356891963	;		isoTempLinesTable[	445	]	[	3	]=	-6.421623357	;
	isoTempLinesTable[446][0]=	2242.152466	;		isoTempLinesTable[	446	]	[	1	]=	0.287306614	;		isoTempLinesTable[	446	]	[	2	]=	0.356943014	;		isoTempLinesTable[	446	]	[	3	]=	-6.480916112	;
	isoTempLinesTable[447][0]=	2237.136465	;		isoTempLinesTable[	447	]	[	1	]=	0.287635948	;		isoTempLinesTable[	447	]	[	2	]=	0.356993597	;		isoTempLinesTable[	447	]	[	3	]=	-6.540963749	;
	isoTempLinesTable[448][0]=	2232.142857	;		isoTempLinesTable[	448	]	[	1	]=	0.287965274	;		isoTempLinesTable[	448	]	[	2	]=	0.357043713	;		isoTempLinesTable[	448	]	[	3	]=	-6.601779895	;
	isoTempLinesTable[449][0]=	2227.171492	;		isoTempLinesTable[	449	]	[	1	]=	0.288294591	;		isoTempLinesTable[	449	]	[	2	]=	0.357093365	;		isoTempLinesTable[	449	]	[	3	]=	-6.663378503	;
	isoTempLinesTable[450][0]=	2222.222222	;		isoTempLinesTable[	450	]	[	1	]=	0.288623896	;		isoTempLinesTable[	450	]	[	2	]=	0.357142556	;		isoTempLinesTable[	450	]	[	3	]=	-6.725773865	;
	isoTempLinesTable[451][0]=	2217.2949	;		isoTempLinesTable[	451	]	[	1	]=	0.288953188	;		isoTempLinesTable[	451	]	[	2	]=	0.357191288	;		isoTempLinesTable[	451	]	[	3	]=	-6.788980621	;
	isoTempLinesTable[452][0]=	2212.389381	;		isoTempLinesTable[	452	]	[	1	]=	0.289282466	;		isoTempLinesTable[	452	]	[	2	]=	0.357239563	;		isoTempLinesTable[	452	]	[	3	]=	-6.853013767	;
	isoTempLinesTable[453][0]=	2207.505519	;		isoTempLinesTable[	453	]	[	1	]=	0.289611729	;		isoTempLinesTable[	453	]	[	2	]=	0.357287383	;		isoTempLinesTable[	453	]	[	3	]=	-6.917888674	;
	isoTempLinesTable[454][0]=	2202.643172	;		isoTempLinesTable[	454	]	[	1	]=	0.289940975	;		isoTempLinesTable[	454	]	[	2	]=	0.357334753	;		isoTempLinesTable[	454	]	[	3	]=	-6.983621088	;
	isoTempLinesTable[455][0]=	2197.802198	;		isoTempLinesTable[	455	]	[	1	]=	0.290270202	;		isoTempLinesTable[	455	]	[	2	]=	0.357381673	;		isoTempLinesTable[	455	]	[	3	]=	-7.050227154	;
	isoTempLinesTable[456][0]=	2192.982456	;		isoTempLinesTable[	456	]	[	1	]=	0.29059941	;		isoTempLinesTable[	456	]	[	2	]=	0.357428146	;		isoTempLinesTable[	456	]	[	3	]=	-7.117723417	;
	isoTempLinesTable[457][0]=	2188.183807	;		isoTempLinesTable[	457	]	[	1	]=	0.290928597	;		isoTempLinesTable[	457	]	[	2	]=	0.357474174	;		isoTempLinesTable[	457	]	[	3	]=	-7.186126846	;
	isoTempLinesTable[458][0]=	2183.406114	;		isoTempLinesTable[	458	]	[	1	]=	0.291257762	;		isoTempLinesTable[	458	]	[	2	]=	0.357519761	;		isoTempLinesTable[	458	]	[	3	]=	-7.255454836	;
	isoTempLinesTable[459][0]=	2178.649237	;		isoTempLinesTable[	459	]	[	1	]=	0.291586902	;		isoTempLinesTable[	459	]	[	2	]=	0.357564908	;		isoTempLinesTable[	459	]	[	3	]=	-7.325725232	;
	isoTempLinesTable[460][0]=	2173.913043	;		isoTempLinesTable[	460	]	[	1	]=	0.291916018	;		isoTempLinesTable[	460	]	[	2	]=	0.357609617	;		isoTempLinesTable[	460	]	[	3	]=	-7.396956336	;
	isoTempLinesTable[461][0]=	2169.197397	;		isoTempLinesTable[	461	]	[	1	]=	0.292245108	;		isoTempLinesTable[	461	]	[	2	]=	0.357653892	;		isoTempLinesTable[	461	]	[	3	]=	-7.469166926	;
	isoTempLinesTable[462][0]=	2164.502165	;		isoTempLinesTable[	462	]	[	1	]=	0.292574169	;		isoTempLinesTable[	462	]	[	2	]=	0.357697734	;		isoTempLinesTable[	462	]	[	3	]=	-7.542376268	;
	isoTempLinesTable[463][0]=	2159.827214	;		isoTempLinesTable[	463	]	[	1	]=	0.292903202	;		isoTempLinesTable[	463	]	[	2	]=	0.357741145	;		isoTempLinesTable[	463	]	[	3	]=	-7.616604139	;
	isoTempLinesTable[464][0]=	2155.172414	;		isoTempLinesTable[	464	]	[	1	]=	0.293232205	;		isoTempLinesTable[	464	]	[	2	]=	0.357784129	;		isoTempLinesTable[	464	]	[	3	]=	-7.691870834	;
	isoTempLinesTable[465][0]=	2150.537634	;		isoTempLinesTable[	465	]	[	1	]=	0.293561175	;		isoTempLinesTable[	465	]	[	2	]=	0.357826688	;		isoTempLinesTable[	465	]	[	3	]=	-7.768197191	;
	isoTempLinesTable[466][0]=	2145.922747	;		isoTempLinesTable[	466	]	[	1	]=	0.293890113	;		isoTempLinesTable[	466	]	[	2	]=	0.357868823	;		isoTempLinesTable[	466	]	[	3	]=	-7.845604607	;
	isoTempLinesTable[467][0]=	2141.327623	;		isoTempLinesTable[	467	]	[	1	]=	0.294219017	;		isoTempLinesTable[	467	]	[	2	]=	0.357910537	;		isoTempLinesTable[	467	]	[	3	]=	-7.924115056	;
	isoTempLinesTable[468][0]=	2136.752137	;		isoTempLinesTable[	468	]	[	1	]=	0.294547885	;		isoTempLinesTable[	468	]	[	2	]=	0.357951832	;		isoTempLinesTable[	468	]	[	3	]=	-8.003751108	;
	isoTempLinesTable[469][0]=	2132.196162	;		isoTempLinesTable[	469	]	[	1	]=	0.294876716	;		isoTempLinesTable[	469	]	[	2	]=	0.357992712	;		isoTempLinesTable[	469	]	[	3	]=	-8.084535953	;
	isoTempLinesTable[470][0]=	2127.659574	;		isoTempLinesTable[	470	]	[	1	]=	0.29520551	;		isoTempLinesTable[	470	]	[	2	]=	0.358033177	;		isoTempLinesTable[	470	]	[	3	]=	-8.166493416	;
	isoTempLinesTable[471][0]=	2123.142251	;		isoTempLinesTable[	471	]	[	1	]=	0.295534264	;		isoTempLinesTable[	471	]	[	2	]=	0.35807323	;		isoTempLinesTable[	471	]	[	3	]=	-8.249647988	;
	isoTempLinesTable[472][0]=	2118.644068	;		isoTempLinesTable[	472	]	[	1	]=	0.295862978	;		isoTempLinesTable[	472	]	[	2	]=	0.358112874	;		isoTempLinesTable[	472	]	[	3	]=	-8.33402484	;
	isoTempLinesTable[473][0]=	2114.164905	;		isoTempLinesTable[	473	]	[	1	]=	0.296191649	;		isoTempLinesTable[	473	]	[	2	]=	0.358152111	;		isoTempLinesTable[	473	]	[	3	]=	-8.419649852	;
	isoTempLinesTable[474][0]=	2109.704641	;		isoTempLinesTable[	474	]	[	1	]=	0.296520278	;		isoTempLinesTable[	474	]	[	2	]=	0.358190942	;		isoTempLinesTable[	474	]	[	3	]=	-8.50654964	;
	isoTempLinesTable[475][0]=	2105.263158	;		isoTempLinesTable[	475	]	[	1	]=	0.296848863	;		isoTempLinesTable[	475	]	[	2	]=	0.358229371	;		isoTempLinesTable[	475	]	[	3	]=	-8.594751576	;
	isoTempLinesTable[476][0]=	2100.840336	;		isoTempLinesTable[	476	]	[	1	]=	0.297177402	;		isoTempLinesTable[	476	]	[	2	]=	0.3582674	;		isoTempLinesTable[	476	]	[	3	]=	-8.68428382	;
	isoTempLinesTable[477][0]=	2096.436059	;		isoTempLinesTable[	477	]	[	1	]=	0.297505895	;		isoTempLinesTable[	477	]	[	2	]=	0.35830503	;		isoTempLinesTable[	477	]	[	3	]=	-8.775175348	;
	isoTempLinesTable[478][0]=	2092.050209	;		isoTempLinesTable[	478	]	[	1	]=	0.29783434	;		isoTempLinesTable[	478	]	[	2	]=	0.358342263	;		isoTempLinesTable[	478	]	[	3	]=	-8.86745598	;
	isoTempLinesTable[479][0]=	2087.682672	;		isoTempLinesTable[	479	]	[	1	]=	0.298162735	;		isoTempLinesTable[	479	]	[	2	]=	0.358379103	;		isoTempLinesTable[	479	]	[	3	]=	-8.961156413	;
	isoTempLinesTable[480][0]=	2083.333333	;		isoTempLinesTable[	480	]	[	1	]=	0.298491081	;		isoTempLinesTable[	480	]	[	2	]=	0.358415552	;		isoTempLinesTable[	480	]	[	3	]=	-9.05630825	;
	isoTempLinesTable[481][0]=	2079.002079	;		isoTempLinesTable[	481	]	[	1	]=	0.298819375	;		isoTempLinesTable[	481	]	[	2	]=	0.358451611	;		isoTempLinesTable[	481	]	[	3	]=	-9.15294404	;
	isoTempLinesTable[482][0]=	2074.688797	;		isoTempLinesTable[	482	]	[	1	]=	0.299147617	;		isoTempLinesTable[	482	]	[	2	]=	0.358487282	;		isoTempLinesTable[	482	]	[	3	]=	-9.251097307	;
	isoTempLinesTable[483][0]=	2070.393375	;		isoTempLinesTable[	483	]	[	1	]=	0.299475805	;		isoTempLinesTable[	483	]	[	2	]=	0.358522568	;		isoTempLinesTable[	483	]	[	3	]=	-9.350802591	;
	isoTempLinesTable[484][0]=	2066.115702	;		isoTempLinesTable[	484	]	[	1	]=	0.299803938	;		isoTempLinesTable[	484	]	[	2	]=	0.358557472	;		isoTempLinesTable[	484	]	[	3	]=	-9.452095485	;
	isoTempLinesTable[485][0]=	2061.85567	;		isoTempLinesTable[	485	]	[	1	]=	0.300132015	;		isoTempLinesTable[	485	]	[	2	]=	0.358591994	;		isoTempLinesTable[	485	]	[	3	]=	-9.555012674	;
	isoTempLinesTable[486][0]=	2057.613169	;		isoTempLinesTable[	486	]	[	1	]=	0.300460035	;		isoTempLinesTable[	486	]	[	2	]=	0.358626137	;		isoTempLinesTable[	486	]	[	3	]=	-9.659591983	;
	isoTempLinesTable[487][0]=	2053.38809	;		isoTempLinesTable[	487	]	[	1	]=	0.300787996	;		isoTempLinesTable[	487	]	[	2	]=	0.358659904	;		isoTempLinesTable[	487	]	[	3	]=	-9.765872416	;
	isoTempLinesTable[488][0]=	2049.180328	;		isoTempLinesTable[	488	]	[	1	]=	0.301115898	;		isoTempLinesTable[	488	]	[	2	]=	0.358693297	;		isoTempLinesTable[	488	]	[	3	]=	-9.873894203	;
	isoTempLinesTable[489][0]=	2044.989775	;		isoTempLinesTable[	489	]	[	1	]=	0.30144374	;		isoTempLinesTable[	489	]	[	2	]=	0.358726317	;		isoTempLinesTable[	489	]	[	3	]=	-9.98369885	;
	isoTempLinesTable[490][0]=	2040.816327	;		isoTempLinesTable[	490	]	[	1	]=	0.30177152	;		isoTempLinesTable[	490	]	[	2	]=	0.358758967	;		isoTempLinesTable[	490	]	[	3	]=	-10.09532919	;
	isoTempLinesTable[491][0]=	2036.659878	;		isoTempLinesTable[	491	]	[	1	]=	0.302099237	;		isoTempLinesTable[	491	]	[	2	]=	0.358791249	;		isoTempLinesTable[	491	]	[	3	]=	-10.20882944	;
	isoTempLinesTable[492][0]=	2032.520325	;		isoTempLinesTable[	492	]	[	1	]=	0.30242689	;		isoTempLinesTable[	492	]	[	2	]=	0.358823164	;		isoTempLinesTable[	492	]	[	3	]=	-10.32424525	;
	isoTempLinesTable[493][0]=	2028.397566	;		isoTempLinesTable[	493	]	[	1	]=	0.302754478	;		isoTempLinesTable[	493	]	[	2	]=	0.358854716	;		isoTempLinesTable[	493	]	[	3	]=	-10.44162376	;
	isoTempLinesTable[494][0]=	2024.291498	;		isoTempLinesTable[	494	]	[	1	]=	0.303082	;		isoTempLinesTable[	494	]	[	2	]=	0.358885905	;		isoTempLinesTable[	494	]	[	3	]=	-10.56101367	;
	isoTempLinesTable[495][0]=	2020.20202	;		isoTempLinesTable[	495	]	[	1	]=	0.303409456	;		isoTempLinesTable[	495	]	[	2	]=	0.358916735	;		isoTempLinesTable[	495	]	[	3	]=	-10.68246531	;
	isoTempLinesTable[496][0]=	2016.129032	;		isoTempLinesTable[	496	]	[	1	]=	0.303736842	;		isoTempLinesTable[	496	]	[	2	]=	0.358947206	;		isoTempLinesTable[	496	]	[	3	]=	-10.80603069	;
	isoTempLinesTable[497][0]=	2012.072435	;		isoTempLinesTable[	497	]	[	1	]=	0.30406416	;		isoTempLinesTable[	497	]	[	2	]=	0.358977322	;		isoTempLinesTable[	497	]	[	3	]=	-10.93176358	;
	isoTempLinesTable[498][0]=	2008.032129	;		isoTempLinesTable[	498	]	[	1	]=	0.304391407	;		isoTempLinesTable[	498	]	[	2	]=	0.359007084	;		isoTempLinesTable[	498	]	[	3	]=	-11.0597196	;
	isoTempLinesTable[499][0]=	2004.008016	;		isoTempLinesTable[	499	]	[	1	]=	0.304718583	;		isoTempLinesTable[	499	]	[	2	]=	0.359036495	;		isoTempLinesTable[	499	]	[	3	]=	-11.18995627	;
	isoTempLinesTable[500][0]=	2000		;		isoTempLinesTable[	500	]	[	1	]=	0.305045686	;		isoTempLinesTable[	500	]	[	2	]=	0.359065555	;		isoTempLinesTable[	500	]	[	3	]=	-11.32253312	;
	isoTempLinesTable[501][0]=	1996.007984	;		isoTempLinesTable[	501	]	[	1	]=	0.305372716	;		isoTempLinesTable[	501	]	[	2	]=	0.359094268	;		isoTempLinesTable[	501	]	[	3	]=	-11.45751176	;
	isoTempLinesTable[502][0]=	1992.031873	;		isoTempLinesTable[	502	]	[	1	]=	0.305699672	;		isoTempLinesTable[	502	]	[	2	]=	0.359122635	;		isoTempLinesTable[	502	]	[	3	]=	-11.59495597	;
	isoTempLinesTable[503][0]=	1988.071571	;		isoTempLinesTable[	503	]	[	1	]=	0.306026551	;		isoTempLinesTable[	503	]	[	2	]=	0.359150658	;		isoTempLinesTable[	503	]	[	3	]=	-11.73493183	;
	isoTempLinesTable[504][0]=	1984.126984	;		isoTempLinesTable[	504	]	[	1	]=	0.306353355	;		isoTempLinesTable[	504	]	[	2	]=	0.35917834	;		isoTempLinesTable[	504	]	[	3	]=	-11.87750778	;
	isoTempLinesTable[505][0]=	1980.19802	;		isoTempLinesTable[	505	]	[	1	]=	0.30668008	;		isoTempLinesTable[	505	]	[	2	]=	0.359205682	;		isoTempLinesTable[	505	]	[	3	]=	-12.02275474	;
	isoTempLinesTable[506][0]=	1976.284585	;		isoTempLinesTable[	506	]	[	1	]=	0.307006727	;		isoTempLinesTable[	506	]	[	2	]=	0.359232685	;		isoTempLinesTable[	506	]	[	3	]=	-12.17074626	;
	isoTempLinesTable[507][0]=	1972.386588	;		isoTempLinesTable[	507	]	[	1	]=	0.307333295	;		isoTempLinesTable[	507	]	[	2	]=	0.359259353	;		isoTempLinesTable[	507	]	[	3	]=	-12.32155858	;
	isoTempLinesTable[508][0]=	1968.503937	;		isoTempLinesTable[	508	]	[	1	]=	0.307659782	;		isoTempLinesTable[	508	]	[	2	]=	0.359285687	;		isoTempLinesTable[	508	]	[	3	]=	-12.4752708	;
	isoTempLinesTable[509][0]=	1964.636542	;		isoTempLinesTable[	509	]	[	1	]=	0.307986187	;		isoTempLinesTable[	509	]	[	2	]=	0.359311689	;		isoTempLinesTable[	509	]	[	3	]=	-12.631965	;
	isoTempLinesTable[510][0]=	1960.784314	;		isoTempLinesTable[	510	]	[	1	]=	0.30831251	;		isoTempLinesTable[	510	]	[	2	]=	0.35933736	;		isoTempLinesTable[	510	]	[	3	]=	-12.79172638	;
	isoTempLinesTable[511][0]=	1956.947162	;		isoTempLinesTable[	511	]	[	1	]=	0.308638749	;		isoTempLinesTable[	511	]	[	2	]=	0.359362704	;		isoTempLinesTable[	511	]	[	3	]=	-12.95464343	;
	isoTempLinesTable[512][0]=	1953.125	;		isoTempLinesTable[	512	]	[	1	]=	0.308964904	;		isoTempLinesTable[	512	]	[	2	]=	0.359387721	;		isoTempLinesTable[	512	]	[	3	]=	-13.12080805	;
	isoTempLinesTable[513][0]=	1949.317739	;		isoTempLinesTable[	513	]	[	1	]=	0.309290973	;		isoTempLinesTable[	513	]	[	2	]=	0.359412413	;		isoTempLinesTable[	513	]	[	3	]=	-13.29031575	;
	isoTempLinesTable[514][0]=	1945.525292	;		isoTempLinesTable[	514	]	[	1	]=	0.309616956	;		isoTempLinesTable[	514	]	[	2	]=	0.359436784	;		isoTempLinesTable[	514	]	[	3	]=	-13.46326583	;
	isoTempLinesTable[515][0]=	1941.747573	;		isoTempLinesTable[	515	]	[	1	]=	0.309942851	;		isoTempLinesTable[	515	]	[	2	]=	0.359460833	;		isoTempLinesTable[	515	]	[	3	]=	-13.63976154	;
	isoTempLinesTable[516][0]=	1937.984496	;		isoTempLinesTable[	516	]	[	1	]=	0.310268658	;		isoTempLinesTable[	516	]	[	2	]=	0.359484564	;		isoTempLinesTable[	516	]	[	3	]=	-13.81991031	;
	isoTempLinesTable[517][0]=	1934.235977	;		isoTempLinesTable[	517	]	[	1	]=	0.310594376	;		isoTempLinesTable[	517	]	[	2	]=	0.359507978	;		isoTempLinesTable[	517	]	[	3	]=	-14.00382393	;
	isoTempLinesTable[518][0]=	1930.501931	;		isoTempLinesTable[	518	]	[	1	]=	0.310920003	;		isoTempLinesTable[	518	]	[	2	]=	0.359531076	;		isoTempLinesTable[	518	]	[	3	]=	-14.19161883	;
	isoTempLinesTable[519][0]=	1926.782274	;		isoTempLinesTable[	519	]	[	1	]=	0.31124554	;		isoTempLinesTable[	519	]	[	2	]=	0.359553862	;		isoTempLinesTable[	519	]	[	3	]=	-14.38341625	;
	isoTempLinesTable[520][0]=	1923.076923	;		isoTempLinesTable[	520	]	[	1	]=	0.311570984	;		isoTempLinesTable[	520	]	[	2	]=	0.359576336	;		isoTempLinesTable[	520	]	[	3	]=	-14.57934256	;
	isoTempLinesTable[521][0]=	1919.385797	;		isoTempLinesTable[	521	]	[	1	]=	0.311896335	;		isoTempLinesTable[	521	]	[	2	]=	0.359598501	;		isoTempLinesTable[	521	]	[	3	]=	-14.77952947	;
	isoTempLinesTable[522][0]=	1915.708812	;		isoTempLinesTable[	522	]	[	1	]=	0.312221593	;		isoTempLinesTable[	522	]	[	2	]=	0.359620358	;		isoTempLinesTable[	522	]	[	3	]=	-14.98411438	;
	isoTempLinesTable[523][0]=	1912.045889	;		isoTempLinesTable[	523	]	[	1	]=	0.312546755	;		isoTempLinesTable[	523	]	[	2	]=	0.359641909	;		isoTempLinesTable[	523	]	[	3	]=	-15.19324064	;
	isoTempLinesTable[524][0]=	1908.396947	;		isoTempLinesTable[	524	]	[	1	]=	0.312871822	;		isoTempLinesTable[	524	]	[	2	]=	0.359663156	;		isoTempLinesTable[	524	]	[	3	]=	-15.4070579	;
	isoTempLinesTable[525][0]=	1904.761905	;		isoTempLinesTable[	525	]	[	1	]=	0.313196792	;		isoTempLinesTable[	525	]	[	2	]=	0.3596841	;		isoTempLinesTable[	525	]	[	3	]=	-15.62572245	;
	isoTempLinesTable[526][0]=	1901.140684	;		isoTempLinesTable[	526	]	[	1	]=	0.313521665	;		isoTempLinesTable[	526	]	[	2	]=	0.359704744	;		isoTempLinesTable[	526	]	[	3	]=	-15.84939759	;
	isoTempLinesTable[527][0]=	1897.533207	;		isoTempLinesTable[	527	]	[	1	]=	0.313846439	;		isoTempLinesTable[	527	]	[	2	]=	0.35972509	;		isoTempLinesTable[	527	]	[	3	]=	-16.07825406	;
	isoTempLinesTable[528][0]=	1893.939394	;		isoTempLinesTable[	528	]	[	1	]=	0.314171115	;		isoTempLinesTable[	528	]	[	2	]=	0.359745138	;		isoTempLinesTable[	528	]	[	3	]=	-16.31247041	;
	isoTempLinesTable[529][0]=	1890.359168	;		isoTempLinesTable[	529	]	[	1	]=	0.31449569	;		isoTempLinesTable[	529	]	[	2	]=	0.359764891	;		isoTempLinesTable[	529	]	[	3	]=	-16.55223351	;
	isoTempLinesTable[530][0]=	1886.792453	;		isoTempLinesTable[	530	]	[	1	]=	0.314820163	;		isoTempLinesTable[	530	]	[	2	]=	0.359784351	;		isoTempLinesTable[	530	]	[	3	]=	-16.797739	;
	isoTempLinesTable[531][0]=	1883.239171	;		isoTempLinesTable[	531	]	[	1	]=	0.315144536	;		isoTempLinesTable[	531	]	[	2	]=	0.359803519	;		isoTempLinesTable[	531	]	[	3	]=	-17.04919183	;
	isoTempLinesTable[532][0]=	1879.699248	;		isoTempLinesTable[	532	]	[	1	]=	0.315468805	;		isoTempLinesTable[	532	]	[	2	]=	0.359822397	;		isoTempLinesTable[	532	]	[	3	]=	-17.30680682	;
	isoTempLinesTable[533][0]=	1876.172608	;		isoTempLinesTable[	533	]	[	1	]=	0.315792971	;		isoTempLinesTable[	533	]	[	2	]=	0.359840986	;		isoTempLinesTable[	533	]	[	3	]=	-17.57080924	;
	isoTempLinesTable[534][0]=	1872.659176	;		isoTempLinesTable[	534	]	[	1	]=	0.316117032	;		isoTempLinesTable[	534	]	[	2	]=	0.359859289	;		isoTempLinesTable[	534	]	[	3	]=	-17.8414355	;
	isoTempLinesTable[535][0]=	1869.158879	;		isoTempLinesTable[	535	]	[	1	]=	0.316440988	;		isoTempLinesTable[	535	]	[	2	]=	0.359877308	;		isoTempLinesTable[	535	]	[	3	]=	-18.1189338	;
	isoTempLinesTable[536][0]=	1865.671642	;		isoTempLinesTable[	536	]	[	1	]=	0.316764838	;		isoTempLinesTable[	536	]	[	2	]=	0.359895043	;		isoTempLinesTable[	536	]	[	3	]=	-18.40356489	;
	isoTempLinesTable[537][0]=	1862.197393	;		isoTempLinesTable[	537	]	[	1	]=	0.317088581	;		isoTempLinesTable[	537	]	[	2	]=	0.359912497	;		isoTempLinesTable[	537	]	[	3	]=	-18.69560288	;
	isoTempLinesTable[538][0]=	1858.736059	;		isoTempLinesTable[	538	]	[	1	]=	0.317412216	;		isoTempLinesTable[	538	]	[	2	]=	0.359929671	;		isoTempLinesTable[	538	]	[	3	]=	-18.99533611	;
	isoTempLinesTable[539][0]=	1855.28757	;		isoTempLinesTable[	539	]	[	1	]=	0.317735743	;		isoTempLinesTable[	539	]	[	2	]=	0.359946567	;		isoTempLinesTable[	539	]	[	3	]=	-19.30306805	;
	isoTempLinesTable[540][0]=	1851.851852	;		isoTempLinesTable[	540	]	[	1	]=	0.31805916	;		isoTempLinesTable[	540	]	[	2	]=	0.359963187	;		isoTempLinesTable[	540	]	[	3	]=	-19.61911838	;
	isoTempLinesTable[541][0]=	1848.428835	;		isoTempLinesTable[	541	]	[	1	]=	0.318382467	;		isoTempLinesTable[	541	]	[	2	]=	0.359979532	;		isoTempLinesTable[	541	]	[	3	]=	-19.94382401	;
	isoTempLinesTable[542][0]=	1845.01845	;		isoTempLinesTable[	542	]	[	1	]=	0.318705663	;		isoTempLinesTable[	542	]	[	2	]=	0.359995603	;		isoTempLinesTable[	542	]	[	3	]=	-20.27754028	;
	isoTempLinesTable[543][0]=	1841.620626	;		isoTempLinesTable[	543	]	[	1	]=	0.319028748	;		isoTempLinesTable[	543	]	[	2	]=	0.360011404	;		isoTempLinesTable[	543	]	[	3	]=	-20.62064227	;
	isoTempLinesTable[544][0]=	1838.235294	;		isoTempLinesTable[	544	]	[	1	]=	0.319351719	;		isoTempLinesTable[	544	]	[	2	]=	0.360026934	;		isoTempLinesTable[	544	]	[	3	]=	-20.97352615	;
	isoTempLinesTable[545][0]=	1834.862385	;		isoTempLinesTable[	545	]	[	1	]=	0.319674578	;		isoTempLinesTable[	545	]	[	2	]=	0.360042197	;		isoTempLinesTable[	545	]	[	3	]=	-21.3366107	;
	isoTempLinesTable[546][0]=	1831.501832	;		isoTempLinesTable[	546	]	[	1	]=	0.319997322	;		isoTempLinesTable[	546	]	[	2	]=	0.360057193	;		isoTempLinesTable[	546	]	[	3	]=	-21.71033896	;
	isoTempLinesTable[547][0]=	1828.153565	;		isoTempLinesTable[	547	]	[	1	]=	0.320319951	;		isoTempLinesTable[	547	]	[	2	]=	0.360071924	;		isoTempLinesTable[	547	]	[	3	]=	-22.09517998	;
	isoTempLinesTable[548][0]=	1824.817518	;		isoTempLinesTable[	548	]	[	1	]=	0.320642464	;		isoTempLinesTable[	548	]	[	2	]=	0.360086392	;		isoTempLinesTable[	548	]	[	3	]=	-22.49163079	;
	isoTempLinesTable[549][0]=	1821.493625	;		isoTempLinesTable[	549	]	[	1	]=	0.320964861	;		isoTempLinesTable[	549	]	[	2	]=	0.360100598	;		isoTempLinesTable[	549	]	[	3	]=	-22.90021848	;
	isoTempLinesTable[550][0]=	1818.181818	;		isoTempLinesTable[	550	]	[	1	]=	0.321287141	;		isoTempLinesTable[	550	]	[	2	]=	0.360114544	;		isoTempLinesTable[	550	]	[	3	]=	-23.32150255	;
	isoTempLinesTable[551][0]=	1814.882033	;		isoTempLinesTable[	551	]	[	1	]=	0.321609302	;		isoTempLinesTable[	551	]	[	2	]=	0.360128231	;		isoTempLinesTable[	551	]	[	3	]=	-23.75607743	;
	isoTempLinesTable[552][0]=	1811.594203	;		isoTempLinesTable[	552	]	[	1	]=	0.321931345	;		isoTempLinesTable[	552	]	[	2	]=	0.360141662	;		isoTempLinesTable[	552	]	[	3	]=	-24.20457521	;
	isoTempLinesTable[553][0]=	1808.318264	;		isoTempLinesTable[	553	]	[	1	]=	0.322253268	;		isoTempLinesTable[	553	]	[	2	]=	0.360154837	;		isoTempLinesTable[	553	]	[	3	]=	-24.66766873	;
	isoTempLinesTable[554][0]=	1805.054152	;		isoTempLinesTable[	554	]	[	1	]=	0.322575071	;		isoTempLinesTable[	554	]	[	2	]=	0.360167758	;		isoTempLinesTable[	554	]	[	3	]=	-25.14607487	;
	isoTempLinesTable[555][0]=	1801.801802	;		isoTempLinesTable[	555	]	[	1	]=	0.322896753	;		isoTempLinesTable[	555	]	[	2	]=	0.360180427	;		isoTempLinesTable[	555	]	[	3	]=	-25.64055824	;
	isoTempLinesTable[556][0]=	1798.561151	;		isoTempLinesTable[	556	]	[	1	]=	0.323218313	;		isoTempLinesTable[	556	]	[	2	]=	0.360192846	;		isoTempLinesTable[	556	]	[	3	]=	-26.15193522	;
	isoTempLinesTable[557][0]=	1795.332136	;		isoTempLinesTable[	557	]	[	1	]=	0.323539751	;		isoTempLinesTable[	557	]	[	2	]=	0.360205015	;		isoTempLinesTable[	557	]	[	3	]=	-26.68107838	;
	isoTempLinesTable[558][0]=	1792.114695	;		isoTempLinesTable[	558	]	[	1	]=	0.323861065	;		isoTempLinesTable[	558	]	[	2	]=	0.360216937	;		isoTempLinesTable[	558	]	[	3	]=	-27.22892145	;
	isoTempLinesTable[559][0]=	1788.908766	;		isoTempLinesTable[	559	]	[	1	]=	0.324182256	;		isoTempLinesTable[	559	]	[	2	]=	0.360228612	;		isoTempLinesTable[	559	]	[	3	]=	-27.79646475	;
	isoTempLinesTable[560][0]=	1785.714286	;		isoTempLinesTable[	560	]	[	1	]=	0.324503322	;		isoTempLinesTable[	560	]	[	2	]=	0.360240043	;		isoTempLinesTable[	560	]	[	3	]=	-28.38478123	;
	isoTempLinesTable[561][0]=	1782.531194	;		isoTempLinesTable[	561	]	[	1	]=	0.324824262	;		isoTempLinesTable[	561	]	[	2	]=	0.36025123	;		isoTempLinesTable[	561	]	[	3	]=	-28.9950232	;
	isoTempLinesTable[562][0]=	1779.359431	;		isoTempLinesTable[	562	]	[	1	]=	0.325145076	;		isoTempLinesTable[	562	]	[	2	]=	0.360262177	;		isoTempLinesTable[	562	]	[	3	]=	-29.62842977	;
	isoTempLinesTable[563][0]=	1776.198934	;		isoTempLinesTable[	563	]	[	1	]=	0.325465764	;		isoTempLinesTable[	563	]	[	2	]=	0.360272882	;		isoTempLinesTable[	563	]	[	3	]=	-30.28633524	;
	isoTempLinesTable[564][0]=	1773.049645	;		isoTempLinesTable[	564	]	[	1	]=	0.325786324	;		isoTempLinesTable[	564	]	[	2	]=	0.36028335	;		isoTempLinesTable[	564	]	[	3	]=	-30.97017836	;
	isoTempLinesTable[565][0]=	1769.911504	;		isoTempLinesTable[	565	]	[	1	]=	0.326106756	;		isoTempLinesTable[	565	]	[	2	]=	0.36029358	;		isoTempLinesTable[	565	]	[	3	]=	-31.68151279	;
	isoTempLinesTable[566][0]=	1766.784452	;		isoTempLinesTable[	566	]	[	1	]=	0.326427059	;		isoTempLinesTable[	566	]	[	2	]=	0.360303575	;		isoTempLinesTable[	566	]	[	3	]=	-32.42201879	;
	isoTempLinesTable[567][0]=	1763.66843	;		isoTempLinesTable[	567	]	[	1	]=	0.326747232	;		isoTempLinesTable[	567	]	[	2	]=	0.360313335	;		isoTempLinesTable[	567	]	[	3	]=	-33.19351639	;
	isoTempLinesTable[568][0]=	1760.56338	;		isoTempLinesTable[	568	]	[	1	]=	0.327067276	;		isoTempLinesTable[	568	]	[	2	]=	0.360322862	;		isoTempLinesTable[	568	]	[	3	]=	-33.99798023	;
	isoTempLinesTable[569][0]=	1757.469244	;		isoTempLinesTable[	569	]	[	1	]=	0.327387188	;		isoTempLinesTable[	569	]	[	2	]=	0.360332159	;		isoTempLinesTable[	569	]	[	3	]=	-34.83755635	;
	isoTempLinesTable[570][0]=	1754.385965	;		isoTempLinesTable[	570	]	[	1	]=	0.327706968	;		isoTempLinesTable[	570	]	[	2	]=	0.360341225	;		isoTempLinesTable[	570	]	[	3	]=	-35.71458117	;
	isoTempLinesTable[571][0]=	1751.313485	;		isoTempLinesTable[	571	]	[	1	]=	0.328026617	;		isoTempLinesTable[	571	]	[	2	]=	0.360350063	;		isoTempLinesTable[	571	]	[	3	]=	-36.63160308	;
	isoTempLinesTable[572][0]=	1748.251748	;		isoTempLinesTable[	572	]	[	1	]=	0.328346132	;		isoTempLinesTable[	572	]	[	2	]=	0.360358674	;		isoTempLinesTable[	572	]	[	3	]=	-37.59140709	;
	isoTempLinesTable[573][0]=	1745.200698	;		isoTempLinesTable[	573	]	[	1	]=	0.328665514	;		isoTempLinesTable[	573	]	[	2	]=	0.360367059	;		isoTempLinesTable[	573	]	[	3	]=	-38.59704288	;
	isoTempLinesTable[574][0]=	1742.160279	;		isoTempLinesTable[	574	]	[	1	]=	0.328984762	;		isoTempLinesTable[	574	]	[	2	]=	0.360375221	;		isoTempLinesTable[	574	]	[	3	]=	-39.65185703	;
	isoTempLinesTable[575][0]=	1739.130435	;		isoTempLinesTable[	575	]	[	1	]=	0.329303874	;		isoTempLinesTable[	575	]	[	2	]=	0.360383159	;		isoTempLinesTable[	575	]	[	3	]=	-40.75953007	;
	isoTempLinesTable[576][0]=	1736.111111	;		isoTempLinesTable[	576	]	[	1	]=	0.329622851	;		isoTempLinesTable[	576	]	[	2	]=	0.360390876	;		isoTempLinesTable[	576	]	[	3	]=	-41.92411919	;
	isoTempLinesTable[577][0]=	1733.102253	;		isoTempLinesTable[	577	]	[	1	]=	0.329941692	;		isoTempLinesTable[	577	]	[	2	]=	0.360398373	;		isoTempLinesTable[	577	]	[	3	]=	-43.15010768	;
	isoTempLinesTable[578][0]=	1730.103806	;		isoTempLinesTable[	578	]	[	1	]=	0.330260396	;		isoTempLinesTable[	578	]	[	2	]=	0.360405652	;		isoTempLinesTable[	578	]	[	3	]=	-44.44246237	;
	isoTempLinesTable[579][0]=	1727.115717	;		isoTempLinesTable[	579	]	[	1	]=	0.330578963	;		isoTempLinesTable[	579	]	[	2	]=	0.360412713	;		isoTempLinesTable[	579	]	[	3	]=	-45.80670065	;
	isoTempLinesTable[580][0]=	1724.137931	;		isoTempLinesTable[	580	]	[	1	]=	0.330897391	;		isoTempLinesTable[	580	]	[	2	]=	0.360419558	;		isoTempLinesTable[	580	]	[	3	]=	-47.24896894	;
	isoTempLinesTable[581][0]=	1721.170396	;		isoTempLinesTable[	581	]	[	1	]=	0.331215681	;		isoTempLinesTable[	581	]	[	2	]=	0.360426189	;		isoTempLinesTable[	581	]	[	3	]=	-48.77613489	;
	isoTempLinesTable[582][0]=	1718.213058	;		isoTempLinesTable[	582	]	[	1	]=	0.331533831	;		isoTempLinesTable[	582	]	[	2	]=	0.360432607	;		isoTempLinesTable[	582	]	[	3	]=	-50.39589648	;
	isoTempLinesTable[583][0]=	1715.265866	;		isoTempLinesTable[	583	]	[	1	]=	0.331851841	;		isoTempLinesTable[	583	]	[	2	]=	0.360438813	;		isoTempLinesTable[	583	]	[	3	]=	-52.11691131	;
	isoTempLinesTable[584][0]=	1712.328767	;		isoTempLinesTable[	584	]	[	1	]=	0.332169711	;		isoTempLinesTable[	584	]	[	2	]=	0.360444808	;		isoTempLinesTable[	584	]	[	3	]=	-53.94895101	;
	isoTempLinesTable[585][0]=	1709.401709	;		isoTempLinesTable[	585	]	[	1	]=	0.332487439	;		isoTempLinesTable[	585	]	[	2	]=	0.360450595	;		isoTempLinesTable[	585	]	[	3	]=	-55.90308636	;
	isoTempLinesTable[586][0]=	1706.484642	;		isoTempLinesTable[	586	]	[	1	]=	0.332805026	;		isoTempLinesTable[	586	]	[	2	]=	0.360456173	;		isoTempLinesTable[	586	]	[	3	]=	-57.99191062	;
	isoTempLinesTable[587][0]=	1703.577513	;		isoTempLinesTable[	587	]	[	1	]=	0.33312247	;		isoTempLinesTable[	587	]	[	2	]=	0.360461545	;		isoTempLinesTable[	587	]	[	3	]=	-60.22981057	;
	isoTempLinesTable[588][0]=	1700.680272	;		isoTempLinesTable[	588	]	[	1	]=	0.333439771	;		isoTempLinesTable[	588	]	[	2	]=	0.360466712	;		isoTempLinesTable[	588	]	[	3	]=	-62.63329758	;
	isoTempLinesTable[589][0]=	1697.792869	;		isoTempLinesTable[	589	]	[	1	]=	0.333756929	;		isoTempLinesTable[	589	]	[	2	]=	0.360471676	;		isoTempLinesTable[	589	]	[	3	]=	-65.22141485	;
	isoTempLinesTable[590][0]=	1694.915254	;		isoTempLinesTable[	590	]	[	1	]=	0.334073942	;		isoTempLinesTable[	590	]	[	2	]=	0.360476436	;		isoTempLinesTable[	590	]	[	3	]=	-68.01624203	;
	isoTempLinesTable[591][0]=	1692.047377	;		isoTempLinesTable[	591	]	[	1	]=	0.334390811	;		isoTempLinesTable[	591	]	[	2	]=	0.360480996	;		isoTempLinesTable[	591	]	[	3	]=	-71.04352553	;
	isoTempLinesTable[592][0]=	1689.189189	;		isoTempLinesTable[	592	]	[	1	]=	0.334707534	;		isoTempLinesTable[	592	]	[	2	]=	0.360485355	;		isoTempLinesTable[	592	]	[	3	]=	-74.33347271	;
	isoTempLinesTable[593][0]=	1686.340641	;		isoTempLinesTable[	593	]	[	1	]=	0.335024111	;		isoTempLinesTable[	593	]	[	2	]=	0.360489516	;		isoTempLinesTable[	593	]	[	3	]=	-77.92176176	;
	isoTempLinesTable[594][0]=	1683.501684	;		isoTempLinesTable[	594	]	[	1	]=	0.335340541	;		isoTempLinesTable[	594	]	[	2	]=	0.360493479	;		isoTempLinesTable[	594	]	[	3	]=	-81.85083896	;
	isoTempLinesTable[595][0]=	1680.672269	;		isoTempLinesTable[	595	]	[	1	]=	0.335656824	;		isoTempLinesTable[	595	]	[	2	]=	0.360497246	;		isoTempLinesTable[	595	]	[	3	]=	-86.17160341	;
	isoTempLinesTable[596][0]=	1677.852349	;		isoTempLinesTable[	596	]	[	1	]=	0.33597296	;		isoTempLinesTable[	596	]	[	2	]=	0.360500819	;		isoTempLinesTable[	596	]	[	3	]=	-90.94562151	;
	isoTempLinesTable[597][0]=	1675.041876	;		isoTempLinesTable[	597	]	[	1	]=	0.336288947	;		isoTempLinesTable[	597	]	[	2	]=	0.360504197	;		isoTempLinesTable[	597	]	[	3	]=	-96.24807588	;
	isoTempLinesTable[598][0]=	1672.240803	;		isoTempLinesTable[	598	]	[	1	]=	0.336604786	;		isoTempLinesTable[	598	]	[	2	]=	0.360507384	;		isoTempLinesTable[	598	]	[	3	]=	-102.17175	;
	isoTempLinesTable[599][0]=	1669.449082	;		isoTempLinesTable[	599	]	[	1	]=	0.336920475	;		isoTempLinesTable[	599	]	[	2	]=	0.360510379	;		isoTempLinesTable[	599	]	[	3	]=	-108.8324992	;
	isoTempLinesTable[600][0]=	1666.666667	;		isoTempLinesTable[	600	]	[	1	]=	0.337236014	;		isoTempLinesTable[	600	]	[	2	]=	0.360513184	;		isoTempLinesTable[	600	]	[	3	]=	-116.3768969	;
	//////////////////////

	wavelength[	0	]=	360	;		xbar[	0	]=	0.00013		;		ybar[	0	]=	4.00E-06	;		zbar[	0	]=	0.000606	;
	wavelength[	1	]=	361	;		xbar[	1	]=	0.000146	;		ybar[	1	]=	4.00E-06	;		zbar[	1	]=	0.000681	;
	wavelength[	2	]=	362	;		xbar[	2	]=	0.000164	;		ybar[	2	]=	5.00E-06	;		zbar[	2	]=	0.000765	;
	wavelength[	3	]=	363	;		xbar[	3	]=	0.000184	;		ybar[	3	]=	6.00E-06	;		zbar[	3	]=	0.00086	;
	wavelength[	4	]=	364	;		xbar[	4	]=	0.000207	;		ybar[	4	]=	6.00E-06	;		zbar[	4	]=	0.000967	;
	wavelength[	5	]=	365	;		xbar[	5	]=	0.000232	;		ybar[	5	]=	7.00E-06	;		zbar[	5	]=	0.001086	;
	wavelength[	6	]=	366	;		xbar[	6	]=	0.000261	;		ybar[	6	]=	8.00E-06	;		zbar[	6	]=	0.001221	;
	wavelength[	7	]=	367	;		xbar[	7	]=	0.000293	;		ybar[	7	]=	9.00E-06	;		zbar[	7	]=	0.001373	;
	wavelength[	8	]=	368	;		xbar[	8	]=	0.000329	;		ybar[	8	]=	1.00E-05	;		zbar[	8	]=	0.001544	;
	wavelength[	9	]=	369	;		xbar[	9	]=	0.00037		;		ybar[	9	]=	1.10E-05	;		zbar[	9	]=	0.001734	;
	wavelength[	10	]=	370	;		xbar[	10	]=	0.000415	;		ybar[	10	]=	1.20E-05	;		zbar[	10	]=	0.001946	;
	wavelength[	11	]=	371	;		xbar[	11	]=	0.000464	;		ybar[	11	]=	1.40E-05	;		zbar[	11	]=	0.002178	;
	wavelength[	12	]=	372	;		xbar[	12	]=	0.000519	;		ybar[	12	]=	1.60E-05	;		zbar[	12	]=	0.002436	;
	wavelength[	13	]=	373	;		xbar[	13	]=	0.000582	;		ybar[	13	]=	1.70E-05	;		zbar[	13	]=	0.002732	;
	wavelength[	14	]=	374	;		xbar[	14	]=	0.000655	;		ybar[	14	]=	2.00E-05	;		zbar[	14	]=	0.003078	;
	wavelength[	15	]=	375	;		xbar[	15	]=	0.000742	;		ybar[	15	]=	2.20E-05	;		zbar[	15	]=	0.003486	;
	wavelength[	16	]=	376	;		xbar[	16	]=	0.000845	;		ybar[	16	]=	2.50E-05	;		zbar[	16	]=	0.003975	;
	wavelength[	17	]=	377	;		xbar[	17	]=	0.000965	;		ybar[	17	]=	2.80E-05	;		zbar[	17	]=	0.004541	;
	wavelength[	18	]=	378	;		xbar[	18	]=	0.001095	;		ybar[	18	]=	3.20E-05	;		zbar[	18	]=	0.005158	;
	wavelength[	19	]=	379	;		xbar[	19	]=	0.001231	;		ybar[	19	]=	3.50E-05	;		zbar[	19	]=	0.005803	;
	wavelength[	20	]=	380	;		xbar[	20	]=	0.001368	;		ybar[	20	]=	3.90E-05	;		zbar[	20	]=	0.00645	;
	wavelength[	21	]=	381	;		xbar[	21	]=	0.001502	;		ybar[	21	]=	4.30E-05	;		zbar[	21	]=	0.007083	;
	wavelength[	22	]=	382	;		xbar[	22	]=	0.001642	;		ybar[	22	]=	4.70E-05	;		zbar[	22	]=	0.007745	;
	wavelength[	23	]=	383	;		xbar[	23	]=	0.001802	;		ybar[	23	]=	5.20E-05	;		zbar[	23	]=	0.008501	;
	wavelength[	24	]=	384	;		xbar[	24	]=	0.001996	;		ybar[	24	]=	5.70E-05	;		zbar[	24	]=	0.009415	;
	wavelength[	25	]=	385	;		xbar[	25	]=	0.002236	;		ybar[	25	]=	6.40E-05	;		zbar[	25	]=	0.01055	;
	wavelength[	26	]=	386	;		xbar[	26	]=	0.002535	;		ybar[	26	]=	7.20E-05	;		zbar[	26	]=	0.011966	;
	wavelength[	27	]=	387	;		xbar[	27	]=	0.002893	;		ybar[	27	]=	8.20E-05	;		zbar[	27	]=	0.013656	;
	wavelength[	28	]=	388	;		xbar[	28	]=	0.003301	;		ybar[	28	]=	9.40E-05	;		zbar[	28	]=	0.015588	;
	wavelength[	29	]=	389	;		xbar[	29	]=	0.003753	;		ybar[	29	]=	0.000106	;		zbar[	29	]=	0.01773	;
	wavelength[	30	]=	390	;		xbar[	30	]=	0.004243	;		ybar[	30	]=	0.00012		;		zbar[	30	]=	0.02005	;
	wavelength[	31	]=	391	;		xbar[	31	]=	0.004762	;		ybar[	31	]=	0.000135	;		zbar[	31	]=	0.022511	;
	wavelength[	32	]=	392	;		xbar[	32	]=	0.00533		;		ybar[	32	]=	0.000151	;		zbar[	32	]=	0.025203	;
	wavelength[	33	]=	393	;		xbar[	33	]=	0.005979	;		ybar[	33	]=	0.00017		;		zbar[	33	]=	0.02828	;
	wavelength[	34	]=	394	;		xbar[	34	]=	0.006741	;		ybar[	34	]=	0.000192	;		zbar[	34	]=	0.031897	;
	wavelength[	35	]=	395	;		xbar[	35	]=	0.00765		;		ybar[	35	]=	0.000217	;		zbar[	35	]=	0.03621	;
	wavelength[	36	]=	396	;		xbar[	36	]=	0.008751	;		ybar[	36	]=	0.000247	;		zbar[	36	]=	0.041438	;
	wavelength[	37	]=	397	;		xbar[	37	]=	0.010029	;		ybar[	37	]=	0.000281	;		zbar[	37	]=	0.047504	;
	wavelength[	38	]=	398	;		xbar[	38	]=	0.011422	;		ybar[	38	]=	0.000319	;		zbar[	38	]=	0.05412	;
	wavelength[	39	]=	399	;		xbar[	39	]=	0.012869	;		ybar[	39	]=	0.000357	;		zbar[	39	]=	0.060998	;
	wavelength[	40	]=	400	;		xbar[	40	]=	0.01431		;		ybar[	40	]=	0.000396	;		zbar[	40	]=	0.06785	;
	wavelength[	41	]=	401	;		xbar[	41	]=	0.015704	;		ybar[	41	]=	0.000434	;		zbar[	41	]=	0.074486	;
	wavelength[	42	]=	402	;		xbar[	42	]=	0.017147	;		ybar[	42	]=	0.000473	;		zbar[	42	]=	0.081362	;
	wavelength[	43	]=	403	;		xbar[	43	]=	0.018781	;		ybar[	43	]=	0.000518	;		zbar[	43	]=	0.089154	;
	wavelength[	44	]=	404	;		xbar[	44	]=	0.020748	;		ybar[	44	]=	0.000572	;		zbar[	44	]=	0.09854	;
	wavelength[	45	]=	405	;		xbar[	45	]=	0.02319		;		ybar[	45	]=	0.00064		;		zbar[	45	]=	0.1102	;
	wavelength[	46	]=	406	;		xbar[	46	]=	0.026207	;		ybar[	46	]=	0.000725	;		zbar[	46	]=	0.124613	;
	wavelength[	47	]=	407	;		xbar[	47	]=	0.029782	;		ybar[	47	]=	0.000825	;		zbar[	47	]=	0.141702	;
	wavelength[	48	]=	408	;		xbar[	48	]=	0.033881	;		ybar[	48	]=	0.000941	;		zbar[	48	]=	0.161303	;
	wavelength[	49	]=	409	;		xbar[	49	]=	0.038468	;		ybar[	49	]=	0.00107		;		zbar[	49	]=	0.183257	;
	wavelength[	50	]=	410	;		xbar[	50	]=	0.04351		;		ybar[	50	]=	0.00121		;		zbar[	50	]=	0.2074	;
	wavelength[	51	]=	411	;		xbar[	51	]=	0.048996	;		ybar[	51	]=	0.001362	;		zbar[	51	]=	0.233692	;
	wavelength[	52	]=	412	;		xbar[	52	]=	0.055023	;		ybar[	52	]=	0.001531	;		zbar[	52	]=	0.262611	;
	wavelength[	53	]=	413	;		xbar[	53	]=	0.061719	;		ybar[	53	]=	0.00172		;		zbar[	53	]=	0.294775	;
	wavelength[	54	]=	414	;		xbar[	54	]=	0.069212	;		ybar[	54	]=	0.001935	;		zbar[	54	]=	0.330799	;
	wavelength[	55	]=	415	;		xbar[	55	]=	0.07763		;		ybar[	55	]=	0.00218		;		zbar[	55	]=	0.3713	;
	wavelength[	56	]=	416	;		xbar[	56	]=	0.086958	;		ybar[	56	]=	0.002455	;		zbar[	56	]=	0.416209	;
	wavelength[	57	]=	417	;		xbar[	57	]=	0.097177	;		ybar[	57	]=	0.002764	;		zbar[	57	]=	0.465464	;
	wavelength[	58	]=	418	;		xbar[	58	]=	0.108406	;		ybar[	58	]=	0.003118	;		zbar[	58	]=	0.519695	;
	wavelength[	59	]=	419	;		xbar[	59	]=	0.120767	;		ybar[	59	]=	0.003526	;		zbar[	59	]=	0.57953	;
	wavelength[	60	]=	420	;		xbar[	60	]=	0.13438		;		ybar[	60	]=	0.004		;		zbar[	60	]=	0.6456	;
	wavelength[	61	]=	421	;		xbar[	61	]=	0.149358	;		ybar[	61	]=	0.004546	;		zbar[	61	]=	0.718484	;
	wavelength[	62	]=	422	;		xbar[	62	]=	0.165396	;		ybar[	62	]=	0.005159	;		zbar[	62	]=	0.796713	;
	wavelength[	63	]=	423	;		xbar[	63	]=	0.181983	;		ybar[	63	]=	0.005829	;		zbar[	63	]=	0.877846	;
	wavelength[	64	]=	424	;		xbar[	64	]=	0.198611	;		ybar[	64	]=	0.006546	;		zbar[	64	]=	0.959439	;
	wavelength[	65	]=	425	;		xbar[	65	]=	0.21477		;		ybar[	65	]=	0.0073		;		zbar[	65	]=	1.03905	;
	wavelength[	66	]=	426	;		xbar[	66	]=	0.230187	;		ybar[	66	]=	0.008087	;		zbar[	66	]=	1.115367	;
	wavelength[	67	]=	427	;		xbar[	67	]=	0.24488		;		ybar[	67	]=	0.008909	;		zbar[	67	]=	1.188497	;
	wavelength[	68	]=	428	;		xbar[	68	]=	0.258777	;		ybar[	68	]=	0.009768	;		zbar[	68	]=	1.258123	;
	wavelength[	69	]=	429	;		xbar[	69	]=	0.271808	;		ybar[	69	]=	0.010664	;		zbar[	69	]=	1.32393	;
	wavelength[	70	]=	430	;		xbar[	70	]=	0.2839		;		ybar[	70	]=	0.0116		;		zbar[	70	]=	1.3856	;
	wavelength[	71	]=	431	;		xbar[	71	]=	0.294944	;		ybar[	71	]=	0.012573	;		zbar[	71	]=	1.442635	;
	wavelength[	72	]=	432	;		xbar[	72	]=	0.304897	;		ybar[	72	]=	0.013583	;		zbar[	72	]=	1.494804	;
	wavelength[	73	]=	433	;		xbar[	73	]=	0.313787	;		ybar[	73	]=	0.01463		;		zbar[	73	]=	1.54219	;
	wavelength[	74	]=	434	;		xbar[	74	]=	0.321645	;		ybar[	74	]=	0.015715	;		zbar[	74	]=	1.584881	;
	wavelength[	75	]=	435	;		xbar[	75	]=	0.3285		;		ybar[	75	]=	0.01684		;		zbar[	75	]=	1.62296	;
	wavelength[	76	]=	436	;		xbar[	76	]=	0.334351	;		ybar[	76	]=	0.018007	;		zbar[	76	]=	1.656405	;
	wavelength[	77	]=	437	;		xbar[	77	]=	0.33921		;		ybar[	77	]=	0.019214	;		zbar[	77	]=	1.685296	;
	wavelength[	78	]=	438	;		xbar[	78	]=	0.343121	;		ybar[	78	]=	0.020454	;		zbar[	78	]=	1.709875	;
	wavelength[	79	]=	439	;		xbar[	79	]=	0.34613		;		ybar[	79	]=	0.021718	;		zbar[	79	]=	1.730382	;
	wavelength[	80	]=	440	;		xbar[	80	]=	0.34828		;		ybar[	80	]=	0.023		;		zbar[	80	]=	1.74706	;
	wavelength[	81	]=	441	;		xbar[	81	]=	0.3496		;		ybar[	81	]=	0.024295	;		zbar[	81	]=	1.760045	;
	wavelength[	82	]=	442	;		xbar[	82	]=	0.350147	;		ybar[	82	]=	0.02561		;		zbar[	82	]=	1.769623	;
	wavelength[	83	]=	443	;		xbar[	83	]=	0.350013	;		ybar[	83	]=	0.026959	;		zbar[	83	]=	1.776264	;
	wavelength[	84	]=	444	;		xbar[	84	]=	0.349287	;		ybar[	84	]=	0.028351	;		zbar[	84	]=	1.780433	;
	wavelength[	85	]=	445	;		xbar[	85	]=	0.34806		;		ybar[	85	]=	0.0298		;		zbar[	85	]=	1.7826	;
	wavelength[	86	]=	446	;		xbar[	86	]=	0.346373	;		ybar[	86	]=	0.031311	;		zbar[	86	]=	1.782968	;
	wavelength[	87	]=	447	;		xbar[	87	]=	0.344262	;		ybar[	87	]=	0.032884	;		zbar[	87	]=	1.7817	;
	wavelength[	88	]=	448	;		xbar[	88	]=	0.341809	;		ybar[	88	]=	0.034521	;		zbar[	88	]=	1.779198	;
	wavelength[	89	]=	449	;		xbar[	89	]=	0.339094	;		ybar[	89	]=	0.036226	;		zbar[	89	]=	1.775867	;
	wavelength[	90	]=	450	;		xbar[	90	]=	0.3362		;		ybar[	90	]=	0.038		;		zbar[	90	]=	1.77211	;
	wavelength[	91	]=	451	;		xbar[	91	]=	0.333198	;		ybar[	91	]=	0.039847	;		zbar[	91	]=	1.768259	;
	wavelength[	92	]=	452	;		xbar[	92	]=	0.330041	;		ybar[	92	]=	0.041768	;		zbar[	92	]=	1.764039	;
	wavelength[	93	]=	453	;		xbar[	93	]=	0.326636	;		ybar[	93	]=	0.043766	;		zbar[	93	]=	1.758944	;
	wavelength[	94	]=	454	;		xbar[	94	]=	0.322887	;		ybar[	94	]=	0.045843	;		zbar[	94	]=	1.752466	;
	wavelength[	95	]=	455	;		xbar[	95	]=	0.3187		;		ybar[	95	]=	0.048		;		zbar[	95	]=	1.7441	;
	wavelength[	96	]=	456	;		xbar[	96	]=	0.314025	;		ybar[	96	]=	0.050244	;		zbar[	96	]=	1.733559	;
	wavelength[	97	]=	457	;		xbar[	97	]=	0.308884	;		ybar[	97	]=	0.052573	;		zbar[	97	]=	1.720858	;
	wavelength[	98	]=	458	;		xbar[	98	]=	0.30329		;		ybar[	98	]=	0.054981	;		zbar[	98	]=	1.705937	;
	wavelength[	99	]=	459	;		xbar[	99	]=	0.297258	;		ybar[	99	]=	0.057459	;		zbar[	99	]=	1.688737	;
	wavelength[	100	]=	460	;		xbar[	100	]=	0.2908		;		ybar[	100	]=	0.06		;		zbar[	100	]=	1.6692	;
	wavelength[	101	]=	461	;		xbar[	101	]=	0.28397		;		ybar[	101	]=	0.062602	;		zbar[	101	]=	1.647529	;
	wavelength[	102	]=	462	;		xbar[	102	]=	0.276721	;		ybar[	102	]=	0.065278	;		zbar[	102	]=	1.623413	;
	wavelength[	103	]=	463	;		xbar[	103	]=	0.268918	;		ybar[	103	]=	0.068042	;		zbar[	103	]=	1.596022	;
	wavelength[	104	]=	464	;		xbar[	104	]=	0.260423	;		ybar[	104	]=	0.070911	;		zbar[	104	]=	1.564528	;
	wavelength[	105	]=	465	;		xbar[	105	]=	0.2511		;		ybar[	105	]=	0.0739		;		zbar[	105	]=	1.5281	;
	wavelength[	106	]=	466	;		xbar[	106	]=	0.240847	;		ybar[	106	]=	0.077016	;		zbar[	106	]=	1.486111	;
	wavelength[	107	]=	467	;		xbar[	107	]=	0.229851	;		ybar[	107	]=	0.080266	;		zbar[	107	]=	1.439521	;
	wavelength[	108	]=	468	;		xbar[	108	]=	0.218407	;		ybar[	108	]=	0.083667	;		zbar[	108	]=	1.38988	;
	wavelength[	109	]=	469	;		xbar[	109	]=	0.206812	;		ybar[	109	]=	0.087233	;		zbar[	109	]=	1.338736	;
	wavelength[	110	]=	470	;		xbar[	110	]=	0.19536		;		ybar[	110	]=	0.09098		;		zbar[	110	]=	1.28764	;
	wavelength[	111	]=	471	;		xbar[	111	]=	0.184214	;		ybar[	111	]=	0.094918	;		zbar[	111	]=	1.237422	;
	wavelength[	112	]=	472	;		xbar[	112	]=	0.173327	;		ybar[	112	]=	0.099046	;		zbar[	112	]=	1.187824	;
	wavelength[	113	]=	473	;		xbar[	113	]=	0.162688	;		ybar[	113	]=	0.103367	;		zbar[	113	]=	1.138761	;
	wavelength[	114	]=	474	;		xbar[	114	]=	0.152283	;		ybar[	114	]=	0.107885	;		zbar[	114	]=	1.090148	;
	wavelength[	115	]=	475	;		xbar[	115	]=	0.1421		;		ybar[	115	]=	0.1126		;		zbar[	115	]=	1.0419	;
	wavelength[	116	]=	476	;		xbar[	116	]=	0.132179	;		ybar[	116	]=	0.117532	;		zbar[	116	]=	0.994198	;
	wavelength[	117	]=	477	;		xbar[	117	]=	0.12257		;		ybar[	117	]=	0.122674	;		zbar[	117	]=	0.947347	;
	wavelength[	118	]=	478	;		xbar[	118	]=	0.113275	;		ybar[	118	]=	0.127993	;		zbar[	118	]=	0.901453	;
	wavelength[	119	]=	479	;		xbar[	119	]=	0.104298	;		ybar[	119	]=	0.133453	;		zbar[	119	]=	0.856619	;
	wavelength[	120	]=	480	;		xbar[	120	]=	0.09564		;		ybar[	120	]=	0.13902		;		zbar[	120	]=	0.81295	;
	wavelength[	121	]=	481	;		xbar[	121	]=	0.0873		;		ybar[	121	]=	0.144676	;		zbar[	121	]=	0.770517	;
	wavelength[	122	]=	482	;		xbar[	122	]=	0.079308	;		ybar[	122	]=	0.150469	;		zbar[	122	]=	0.729445	;
	wavelength[	123	]=	483	;		xbar[	123	]=	0.071718	;		ybar[	123	]=	0.156462	;		zbar[	123	]=	0.689914	;
	wavelength[	124	]=	484	;		xbar[	124	]=	0.064581	;		ybar[	124	]=	0.162718	;		zbar[	124	]=	0.652105	;
	wavelength[	125	]=	485	;		xbar[	125	]=	0.05795		;		ybar[	125	]=	0.1693		;		zbar[	125	]=	0.6162	;
	wavelength[	126	]=	486	;		xbar[	126	]=	0.051862	;		ybar[	126	]=	0.176243	;		zbar[	126	]=	0.582329	;
	wavelength[	127	]=	487	;		xbar[	127	]=	0.046282	;		ybar[	127	]=	0.183558	;		zbar[	127	]=	0.550416	;
	wavelength[	128	]=	488	;		xbar[	128	]=	0.041151	;		ybar[	128	]=	0.191274	;		zbar[	128	]=	0.520338	;
	wavelength[	129	]=	489	;		xbar[	129	]=	0.036413	;		ybar[	129	]=	0.199418	;		zbar[	129	]=	0.491967	;
	wavelength[	130	]=	490	;		xbar[	130	]=	0.03201		;		ybar[	130	]=	0.20802		;		zbar[	130	]=	0.46518	;
	wavelength[	131	]=	491	;		xbar[	131	]=	0.027917	;		ybar[	131	]=	0.21712		;		zbar[	131	]=	0.439925	;
	wavelength[	132	]=	492	;		xbar[	132	]=	0.024144	;		ybar[	132	]=	0.226735	;		zbar[	132	]=	0.416184	;
	wavelength[	133	]=	493	;		xbar[	133	]=	0.020687	;		ybar[	133	]=	0.236857	;		zbar[	133	]=	0.393882	;
	wavelength[	134	]=	494	;		xbar[	134	]=	0.01754		;		ybar[	134	]=	0.247481	;		zbar[	134	]=	0.372946	;
	wavelength[	135	]=	495	;		xbar[	135	]=	0.0147		;		ybar[	135	]=	0.2586		;		zbar[	135	]=	0.3533	;
	wavelength[	136	]=	496	;		xbar[	136	]=	0.012162	;		ybar[	136	]=	0.270185	;		zbar[	136	]=	0.334858	;
	wavelength[	137	]=	497	;		xbar[	137	]=	0.00992		;		ybar[	137	]=	0.282294	;		zbar[	137	]=	0.317552	;
	wavelength[	138	]=	498	;		xbar[	138	]=	0.007967	;		ybar[	138	]=	0.29505		;		zbar[	138	]=	0.301337	;
	wavelength[	139	]=	499	;		xbar[	139	]=	0.006296	;		ybar[	139	]=	0.308578	;		zbar[	139	]=	0.286169	;
	wavelength[	140	]=	500	;		xbar[	140	]=	0.0049		;		ybar[	140	]=	0.323		;		zbar[	140	]=	0.272	;
	wavelength[	141	]=	501	;		xbar[	141	]=	0.003777	;		ybar[	141	]=	0.338402	;		zbar[	141	]=	0.258817	;
	wavelength[	142	]=	502	;		xbar[	142	]=	0.002945	;		ybar[	142	]=	0.354686	;		zbar[	142	]=	0.246484	;
	wavelength[	143	]=	503	;		xbar[	143	]=	0.002425	;		ybar[	143	]=	0.371699	;		zbar[	143	]=	0.234772	;
	wavelength[	144	]=	504	;		xbar[	144	]=	0.002236	;		ybar[	144	]=	0.389288	;		zbar[	144	]=	0.223453	;
	wavelength[	145	]=	505	;		xbar[	145	]=	0.0024		;		ybar[	145	]=	0.4073		;		zbar[	145	]=	0.2123	;
	wavelength[	146	]=	506	;		xbar[	146	]=	0.002926	;		ybar[	146	]=	0.42563		;		zbar[	146	]=	0.201169	;
	wavelength[	147	]=	507	;		xbar[	147	]=	0.003837	;		ybar[	147	]=	0.44431		;		zbar[	147	]=	0.19012	;
	wavelength[	148	]=	508	;		xbar[	148	]=	0.005175	;		ybar[	148	]=	0.463394	;		zbar[	148	]=	0.179225	;
	wavelength[	149	]=	509	;		xbar[	149	]=	0.006982	;		ybar[	149	]=	0.48294		;		zbar[	149	]=	0.168561	;
	wavelength[	150	]=	510	;		xbar[	150	]=	0.0093		;		ybar[	150	]=	0.503		;		zbar[	150	]=	0.1582	;
	wavelength[	151	]=	511	;		xbar[	151	]=	0.012149	;		ybar[	151	]=	0.523569	;		zbar[	151	]=	0.148138	;
	wavelength[	152	]=	512	;		xbar[	152	]=	0.015536	;		ybar[	152	]=	0.544512	;		zbar[	152	]=	0.138376	;
	wavelength[	153	]=	513	;		xbar[	153	]=	0.019478	;		ybar[	153	]=	0.56569		;		zbar[	153	]=	0.128994	;
	wavelength[	154	]=	514	;		xbar[	154	]=	0.023993	;		ybar[	154	]=	0.586965	;		zbar[	154	]=	0.120075	;
	wavelength[	155	]=	515	;		xbar[	155	]=	0.0291		;		ybar[	155	]=	0.6082		;		zbar[	155	]=	0.1117	;
	wavelength[	156	]=	516	;		xbar[	156	]=	0.034815	;		ybar[	156	]=	0.629346	;		zbar[	156	]=	0.103905	;
	wavelength[	157	]=	517	;		xbar[	157	]=	0.04112		;		ybar[	157	]=	0.650307	;		zbar[	157	]=	0.096667	;
	wavelength[	158	]=	518	;		xbar[	158	]=	0.047985	;		ybar[	158	]=	0.670875	;		zbar[	158	]=	0.089983	;
	wavelength[	159	]=	519	;		xbar[	159	]=	0.055379	;		ybar[	159	]=	0.690842	;		zbar[	159	]=	0.083845	;
	wavelength[	160	]=	520	;		xbar[	160	]=	0.06327		;		ybar[	160	]=	0.71		;		zbar[	160	]=	0.07825	;
	wavelength[	161	]=	521	;		xbar[	161	]=	0.071635	;		ybar[	161	]=	0.728185	;		zbar[	161	]=	0.073209	;
	wavelength[	162	]=	522	;		xbar[	162	]=	0.080462	;		ybar[	162	]=	0.745464	;		zbar[	162	]=	0.068678	;
	wavelength[	163	]=	523	;		xbar[	163	]=	0.08974		;		ybar[	163	]=	0.761969	;		zbar[	163	]=	0.064568	;
	wavelength[	164	]=	524	;		xbar[	164	]=	0.099456	;		ybar[	164	]=	0.777837	;		zbar[	164	]=	0.060788	;
	wavelength[	165	]=	525	;		xbar[	165	]=	0.1096		;		ybar[	165	]=	0.7932		;		zbar[	165	]=	0.05725	;
	wavelength[	166	]=	526	;		xbar[	166	]=	0.120167	;		ybar[	166	]=	0.80811		;		zbar[	166	]=	0.053904	;
	wavelength[	167	]=	527	;		xbar[	167	]=	0.131114	;		ybar[	167	]=	0.822496	;		zbar[	167	]=	0.050747	;
	wavelength[	168	]=	528	;		xbar[	168	]=	0.142368	;		ybar[	168	]=	0.836307	;		zbar[	168	]=	0.047753	;
	wavelength[	169	]=	529	;		xbar[	169	]=	0.153854	;		ybar[	169	]=	0.849492	;		zbar[	169	]=	0.044899	;
	wavelength[	170	]=	530	;		xbar[	170	]=	0.1655		;		ybar[	170	]=	0.862		;		zbar[	170	]=	0.04216	;
	wavelength[	171	]=	531	;		xbar[	171	]=	0.177257	;		ybar[	171	]=	0.873811	;		zbar[	171	]=	0.039507	;
	wavelength[	172	]=	532	;		xbar[	172	]=	0.18914		;		ybar[	172	]=	0.884962	;		zbar[	172	]=	0.036936	;
	wavelength[	173	]=	533	;		xbar[	173	]=	0.201169	;		ybar[	173	]=	0.895494	;		zbar[	173	]=	0.034458	;
	wavelength[	174	]=	534	;		xbar[	174	]=	0.213366	;		ybar[	174	]=	0.905443	;		zbar[	174	]=	0.032089	;
	wavelength[	175	]=	535	;		xbar[	175	]=	0.22575		;		ybar[	175	]=	0.91485		;		zbar[	175	]=	0.02984	;
	wavelength[	176	]=	536	;		xbar[	176	]=	0.238321	;		ybar[	176	]=	0.923735	;		zbar[	176	]=	0.027712	;
	wavelength[	177	]=	537	;		xbar[	177	]=	0.251067	;		ybar[	177	]=	0.932092	;		zbar[	177	]=	0.025694	;
	wavelength[	178	]=	538	;		xbar[	178	]=	0.263992	;		ybar[	178	]=	0.939923	;		zbar[	178	]=	0.023787	;
	wavelength[	179	]=	539	;		xbar[	179	]=	0.277102	;		ybar[	179	]=	0.947225	;		zbar[	179	]=	0.021989	;
	wavelength[	180	]=	540	;		xbar[	180	]=	0.2904		;		ybar[	180	]=	0.954		;		zbar[	180	]=	0.0203	;
	wavelength[	181	]=	541	;		xbar[	181	]=	0.303891	;		ybar[	181	]=	0.960256	;		zbar[	181	]=	0.018718	;
	wavelength[	182	]=	542	;		xbar[	182	]=	0.317573	;		ybar[	182	]=	0.966007	;		zbar[	182	]=	0.01724	;
	wavelength[	183	]=	543	;		xbar[	183	]=	0.331438	;		ybar[	183	]=	0.971261	;		zbar[	183	]=	0.015864	;
	wavelength[	184	]=	544	;		xbar[	184	]=	0.345483	;		ybar[	184	]=	0.976023	;		zbar[	184	]=	0.014585	;
	wavelength[	185	]=	545	;		xbar[	185	]=	0.3597		;		ybar[	185	]=	0.9803		;		zbar[	185	]=	0.0134	;
	wavelength[	186	]=	546	;		xbar[	186	]=	0.374084	;		ybar[	186	]=	0.984092	;		zbar[	186	]=	0.012307	;
	wavelength[	187	]=	547	;		xbar[	187	]=	0.38864		;		ybar[	187	]=	0.987418	;		zbar[	187	]=	0.011302	;
	wavelength[	188	]=	548	;		xbar[	188	]=	0.403378	;		ybar[	188	]=	0.990313	;		zbar[	188	]=	0.010378	;
	wavelength[	189	]=	549	;		xbar[	189	]=	0.418312	;		ybar[	189	]=	0.992812	;		zbar[	189	]=	0.009529	;
	wavelength[	190	]=	550	;		xbar[	190	]=	0.43345		;		ybar[	190	]=	0.99495		;		zbar[	190	]=	0.00875	;
	wavelength[	191	]=	551	;		xbar[	191	]=	0.448795	;		ybar[	191	]=	0.996711	;		zbar[	191	]=	0.008035	;
	wavelength[	192	]=	552	;		xbar[	192	]=	0.464336	;		ybar[	192	]=	0.998098	;		zbar[	192	]=	0.007382	;
	wavelength[	193	]=	553	;		xbar[	193	]=	0.480064	;		ybar[	193	]=	0.999112	;		zbar[	193	]=	0.006785	;
	wavelength[	194	]=	554	;		xbar[	194	]=	0.495971	;		ybar[	194	]=	0.999748	;		zbar[	194	]=	0.006243	;
	wavelength[	195	]=	555	;		xbar[	195	]=	0.51205		;		ybar[	195	]=	1			;		zbar[	195	]=	0.00575	;
	wavelength[	196	]=	556	;		xbar[	196	]=	0.528296	;		ybar[	196	]=	0.999857	;		zbar[	196	]=	0.005304	;
	wavelength[	197	]=	557	;		xbar[	197	]=	0.544692	;		ybar[	197	]=	0.999305	;		zbar[	197	]=	0.0049	;
	wavelength[	198	]=	558	;		xbar[	198	]=	0.561209	;		ybar[	198	]=	0.998325	;		zbar[	198	]=	0.004534	;
	wavelength[	199	]=	559	;		xbar[	199	]=	0.577821	;		ybar[	199	]=	0.996899	;		zbar[	199	]=	0.004202	;
	wavelength[	200	]=	560	;		xbar[	200	]=	0.5945		;		ybar[	200	]=	0.995		;		zbar[	200	]=	0.0039	;
	wavelength[	201	]=	561	;		xbar[	201	]=	0.611221	;		ybar[	201	]=	0.992601	;		zbar[	201	]=	0.003623	;
	wavelength[	202	]=	562	;		xbar[	202	]=	0.627976	;		ybar[	202	]=	0.989743	;		zbar[	202	]=	0.003371	;
	wavelength[	203	]=	563	;		xbar[	203	]=	0.64476		;		ybar[	203	]=	0.986444	;		zbar[	203	]=	0.003141	;
	wavelength[	204	]=	564	;		xbar[	204	]=	0.66157		;		ybar[	204	]=	0.982724	;		zbar[	204	]=	0.002935	;
	wavelength[	205	]=	565	;		xbar[	205	]=	0.6784		;		ybar[	205	]=	0.9786		;		zbar[	205	]=	0.00275	;
	wavelength[	206	]=	566	;		xbar[	206	]=	0.695239	;		ybar[	206	]=	0.974084	;		zbar[	206	]=	0.002585	;
	wavelength[	207	]=	567	;		xbar[	207	]=	0.712059	;		ybar[	207	]=	0.969171	;		zbar[	207	]=	0.002439	;
	wavelength[	208	]=	568	;		xbar[	208	]=	0.728828	;		ybar[	208	]=	0.963857	;		zbar[	208	]=	0.002309	;
	wavelength[	209	]=	569	;		xbar[	209	]=	0.745519	;		ybar[	209	]=	0.958135	;		zbar[	209	]=	0.002197	;
	wavelength[	210	]=	570	;		xbar[	210	]=	0.7621		;		ybar[	210	]=	0.952		;		zbar[	210	]=	0.0021	;
	wavelength[	211	]=	571	;		xbar[	211	]=	0.778543	;		ybar[	211	]=	0.94545		;		zbar[	211	]=	0.002018	;
	wavelength[	212	]=	572	;		xbar[	212	]=	0.794826	;		ybar[	212	]=	0.938499	;		zbar[	212	]=	0.001948	;
	wavelength[	213	]=	573	;		xbar[	213	]=	0.810926	;		ybar[	213	]=	0.931163	;		zbar[	213	]=	0.00189	;
	wavelength[	214	]=	574	;		xbar[	214	]=	0.826825	;		ybar[	214	]=	0.923458	;		zbar[	214	]=	0.001841	;
	wavelength[	215	]=	575	;		xbar[	215	]=	0.8425		;		ybar[	215	]=	0.9154		;		zbar[	215	]=	0.0018	;
	wavelength[	216	]=	576	;		xbar[	216	]=	0.857932	;		ybar[	216	]=	0.907006	;		zbar[	216	]=	0.001766	;
	wavelength[	217	]=	577	;		xbar[	217	]=	0.873082	;		ybar[	217	]=	0.898277	;		zbar[	217	]=	0.001738	;
	wavelength[	218	]=	578	;		xbar[	218	]=	0.887894	;		ybar[	218	]=	0.889205	;		zbar[	218	]=	0.001711	;
	wavelength[	219	]=	579	;		xbar[	219	]=	0.902318	;		ybar[	219	]=	0.879782	;		zbar[	219	]=	0.001683	;
	wavelength[	220	]=	580	;		xbar[	220	]=	0.9163		;		ybar[	220	]=	0.87		;		zbar[	220	]=	0.00165	;
	wavelength[	221	]=	581	;		xbar[	221	]=	0.9298		;		ybar[	221	]=	0.859861	;		zbar[	221	]=	0.00161	;
	wavelength[	222	]=	582	;		xbar[	222	]=	0.942798	;		ybar[	222	]=	0.849392	;		zbar[	222	]=	0.001564	;
	wavelength[	223	]=	583	;		xbar[	223	]=	0.955278	;		ybar[	223	]=	0.838622	;		zbar[	223	]=	0.001514	;
	wavelength[	224	]=	584	;		xbar[	224	]=	0.967218	;		ybar[	224	]=	0.827581	;		zbar[	224	]=	0.001459	;
	wavelength[	225	]=	585	;		xbar[	225	]=	0.9786		;		ybar[	225	]=	0.8163		;		zbar[	225	]=	0.0014	;
	wavelength[	226	]=	586	;		xbar[	226	]=	0.989386	;		ybar[	226	]=	0.804795	;		zbar[	226	]=	0.001337	;
	wavelength[	227	]=	587	;		xbar[	227	]=	0.999549	;		ybar[	227	]=	0.793082	;		zbar[	227	]=	0.00127	;
	wavelength[	228	]=	588	;		xbar[	228	]=	1.009089	;		ybar[	228	]=	0.781192	;		zbar[	228	]=	0.001205	;
	wavelength[	229	]=	589	;		xbar[	229	]=	1.018006	;		ybar[	229	]=	0.769155	;		zbar[	229	]=	0.001147	;
	wavelength[	230	]=	590	;		xbar[	230	]=	1.0263		;		ybar[	230	]=	0.757		;		zbar[	230	]=	0.0011	;
	wavelength[	231	]=	591	;		xbar[	231	]=	1.033983	;		ybar[	231	]=	0.744754	;		zbar[	231	]=	0.001069	;
	wavelength[	232	]=	592	;		xbar[	232	]=	1.040986	;		ybar[	232	]=	0.732422	;		zbar[	232	]=	0.001049	;
	wavelength[	233	]=	593	;		xbar[	233	]=	1.047188	;		ybar[	233	]=	0.720004	;		zbar[	233	]=	0.001036	;
	wavelength[	234	]=	594	;		xbar[	234	]=	1.052467	;		ybar[	234	]=	0.707496	;		zbar[	234	]=	0.001021	;
	wavelength[	235	]=	595	;		xbar[	235	]=	1.0567		;		ybar[	235	]=	0.6949		;		zbar[	235	]=	0.001	;
	wavelength[	236	]=	596	;		xbar[	236	]=	1.059794	;		ybar[	236	]=	0.682219	;		zbar[	236	]=	0.000969	;
	wavelength[	237	]=	597	;		xbar[	237	]=	1.061799	;		ybar[	237	]=	0.669472	;		zbar[	237	]=	0.00093	;
	wavelength[	238	]=	598	;		xbar[	238	]=	1.062807	;		ybar[	238	]=	0.656674	;		zbar[	238	]=	0.000887	;
	wavelength[	239	]=	599	;		xbar[	239	]=	1.06291		;		ybar[	239	]=	0.643845	;		zbar[	239	]=	0.000843	;
	wavelength[	240	]=	600	;		xbar[	240	]=	1.0622		;		ybar[	240	]=	0.631		;		zbar[	240	]=	0.0008	;
	wavelength[	241	]=	601	;		xbar[	241	]=	1.060735	;		ybar[	241	]=	0.618155	;		zbar[	241	]=	0.000761	;
	wavelength[	242	]=	602	;		xbar[	242	]=	1.058444	;		ybar[	242	]=	0.605314	;		zbar[	242	]=	0.000724	;
	wavelength[	243	]=	603	;		xbar[	243	]=	1.055224	;		ybar[	243	]=	0.592476	;		zbar[	243	]=	0.000686	;
	wavelength[	244	]=	604	;		xbar[	244	]=	1.050977	;		ybar[	244	]=	0.579638	;		zbar[	244	]=	0.000645	;
	wavelength[	245	]=	605	;		xbar[	245	]=	1.0456		;		ybar[	245	]=	0.5668		;		zbar[	245	]=	0.0006	;
	wavelength[	246	]=	606	;		xbar[	246	]=	1.039037	;		ybar[	246	]=	0.553961	;		zbar[	246	]=	0.000548	;
	wavelength[	247	]=	607	;		xbar[	247	]=	1.031361	;		ybar[	247	]=	0.541137	;		zbar[	247	]=	0.000492	;
	wavelength[	248	]=	608	;		xbar[	248	]=	1.022666	;		ybar[	248	]=	0.528353	;		zbar[	248	]=	0.000435	;
	wavelength[	249	]=	609	;		xbar[	249	]=	1.013048	;		ybar[	249	]=	0.515632	;		zbar[	249	]=	0.000383	;
	wavelength[	250	]=	610	;		xbar[	250	]=	1.0026		;		ybar[	250	]=	0.503		;		zbar[	250	]=	0.00034	;
	wavelength[	251	]=	611	;		xbar[	251	]=	0.991367	;		ybar[	251	]=	0.490469	;		zbar[	251	]=	0.000307	;
	wavelength[	252	]=	612	;		xbar[	252	]=	0.979331	;		ybar[	252	]=	0.47803		;		zbar[	252	]=	0.000283	;
	wavelength[	253	]=	613	;		xbar[	253	]=	0.966492	;		ybar[	253	]=	0.465678	;		zbar[	253	]=	0.000265	;
	wavelength[	254	]=	614	;		xbar[	254	]=	0.952848	;		ybar[	254	]=	0.453403	;		zbar[	254	]=	0.000252	;
	wavelength[	255	]=	615	;		xbar[	255	]=	0.9384		;		ybar[	255	]=	0.4412		;		zbar[	255	]=	0.00024	;
	wavelength[	256	]=	616	;		xbar[	256	]=	0.923194	;		ybar[	256	]=	0.42908		;		zbar[	256	]=	0.00023	;
	wavelength[	257	]=	617	;		xbar[	257	]=	0.907244	;		ybar[	257	]=	0.417036	;		zbar[	257	]=	0.000221	;
	wavelength[	258	]=	618	;		xbar[	258	]=	0.890502	;		ybar[	258	]=	0.405032	;		zbar[	258	]=	0.000212	;
	wavelength[	259	]=	619	;		xbar[	259	]=	0.87292		;		ybar[	259	]=	0.393032	;		zbar[	259	]=	0.000202	;
	wavelength[	260	]=	620	;		xbar[	260	]=	0.85445		;		ybar[	260	]=	0.381		;		zbar[	260	]=	0.00019	;
	wavelength[	261	]=	621	;		xbar[	261	]=	0.835084	;		ybar[	261	]=	0.368918	;		zbar[	261	]=	0.000174	;
	wavelength[	262	]=	622	;		xbar[	262	]=	0.814946	;		ybar[	262	]=	0.356827	;		zbar[	262	]=	0.000156	;
	wavelength[	263	]=	623	;		xbar[	263	]=	0.794186	;		ybar[	263	]=	0.344777	;		zbar[	263	]=	0.000136	;
	wavelength[	264	]=	624	;		xbar[	264	]=	0.772954	;		ybar[	264	]=	0.332818	;		zbar[	264	]=	0.000117	;
	wavelength[	265	]=	625	;		xbar[	265	]=	0.7514		;		ybar[	265	]=	0.321		;		zbar[	265	]=	0.0001	;
	wavelength[	266	]=	626	;		xbar[	266	]=	0.729584	;		ybar[	266	]=	0.309338	;		zbar[	266	]=	8.60E-05	;
	wavelength[	267	]=	627	;		xbar[	267	]=	0.707589	;		ybar[	267	]=	0.29785		;		zbar[	267	]=	7.50E-05	;
	wavelength[	268	]=	628	;		xbar[	268	]=	0.685602	;		ybar[	268	]=	0.286594	;		zbar[	268	]=	6.50E-05	;
	wavelength[	269	]=	629	;		xbar[	269	]=	0.66381		;		ybar[	269	]=	0.275624	;		zbar[	269	]=	5.70E-05	;
	wavelength[	270	]=	630	;		xbar[	270	]=	0.6424		;		ybar[	270	]=	0.265		;		zbar[	270	]=	5.00E-05	;
	wavelength[	271	]=	631	;		xbar[	271	]=	0.621515	;		ybar[	271	]=	0.254763	;		zbar[	271	]=	4.40E-05	;
	wavelength[	272	]=	632	;		xbar[	272	]=	0.601114	;		ybar[	272	]=	0.24489		;		zbar[	272	]=	3.90E-05	;
	wavelength[	273	]=	633	;		xbar[	273	]=	0.581105	;		ybar[	273	]=	0.235334	;		zbar[	273	]=	3.60E-05	;
	wavelength[	274	]=	634	;		xbar[	274	]=	0.561398	;		ybar[	274	]=	0.226053	;		zbar[	274	]=	3.30E-05	;
	wavelength[	275	]=	635	;		xbar[	275	]=	0.5419		;		ybar[	275	]=	0.217		;		zbar[	275	]=	3.00E-05	;
	wavelength[	276	]=	636	;		xbar[	276	]=	0.522599	;		ybar[	276	]=	0.208162	;		zbar[	276	]=	2.80E-05	;
	wavelength[	277	]=	637	;		xbar[	277	]=	0.503546	;		ybar[	277	]=	0.199549	;		zbar[	277	]=	2.60E-05	;
	wavelength[	278	]=	638	;		xbar[	278	]=	0.484744	;		ybar[	278	]=	0.191155	;		zbar[	278	]=	2.40E-05	;
	wavelength[	279	]=	639	;		xbar[	279	]=	0.466194	;		ybar[	279	]=	0.182974	;		zbar[	279	]=	2.20E-05	;
	wavelength[	280	]=	640	;		xbar[	280	]=	0.4479		;		ybar[	280	]=	0.175		;		zbar[	280	]=	2.00E-05	;
	wavelength[	281	]=	641	;		xbar[	281	]=	0.429861	;		ybar[	281	]=	0.167224	;		zbar[	281	]=	1.80E-05	;
	wavelength[	282	]=	642	;		xbar[	282	]=	0.412098	;		ybar[	282	]=	0.159646	;		zbar[	282	]=	1.60E-05	;
	wavelength[	283	]=	643	;		xbar[	283	]=	0.394644	;		ybar[	283	]=	0.152278	;		zbar[	283	]=	1.40E-05	;
	wavelength[	284	]=	644	;		xbar[	284	]=	0.377533	;		ybar[	284	]=	0.145126	;		zbar[	284	]=	1.20E-05	;
	wavelength[	285	]=	645	;		xbar[	285	]=	0.3608		;		ybar[	285	]=	0.1382		;		zbar[	285	]=	1.00E-05	;
	wavelength[	286	]=	646	;		xbar[	286	]=	0.344456	;		ybar[	286	]=	0.1315		;		zbar[	286	]=	8.00E-06	;
	wavelength[	287	]=	647	;		xbar[	287	]=	0.328517	;		ybar[	287	]=	0.125025	;		zbar[	287	]=	5.00E-06	;
	wavelength[	288	]=	648	;		xbar[	288	]=	0.313019	;		ybar[	288	]=	0.118779	;		zbar[	288	]=	3.00E-06	;
	wavelength[	289	]=	649	;		xbar[	289	]=	0.298001	;		ybar[	289	]=	0.112769	;		zbar[	289	]=	1.00E-06	;
	wavelength[	290	]=	650	;		xbar[	290	]=	0.2835		;		ybar[	290	]=	0.107		;		zbar[	290	]=	0	;
	wavelength[	291	]=	651	;		xbar[	291	]=	0.269545	;		ybar[	291	]=	0.101476	;		zbar[	291	]=	0	;
	wavelength[	292	]=	652	;		xbar[	292	]=	0.256118	;		ybar[	292	]=	0.096189	;		zbar[	292	]=	0	;
	wavelength[	293	]=	653	;		xbar[	293	]=	0.24319		;		ybar[	293	]=	0.091123	;		zbar[	293	]=	0	;
	wavelength[	294	]=	654	;		xbar[	294	]=	0.230727	;		ybar[	294	]=	0.086265	;		zbar[	294	]=	0	;
	wavelength[	295	]=	655	;		xbar[	295	]=	0.2187		;		ybar[	295	]=	0.0816		;		zbar[	295	]=	0	;
	wavelength[	296	]=	656	;		xbar[	296	]=	0.207097	;		ybar[	296	]=	0.077121	;		zbar[	296	]=	0	;
	wavelength[	297	]=	657	;		xbar[	297	]=	0.195923	;		ybar[	297	]=	0.072826	;		zbar[	297	]=	0	;
	wavelength[	298	]=	658	;		xbar[	298	]=	0.185171	;		ybar[	298	]=	0.06871		;		zbar[	298	]=	0	;
	wavelength[	299	]=	659	;		xbar[	299	]=	0.174832	;		ybar[	299	]=	0.06477		;		zbar[	299	]=	0	;
	wavelength[	300	]=	660	;		xbar[	300	]=	0.1649		;		ybar[	300	]=	0.061		;		zbar[	300	]=	0	;
	wavelength[	301	]=	661	;		xbar[	301	]=	0.155367	;		ybar[	301	]=	0.057396	;		zbar[	301	]=	0	;
	wavelength[	302	]=	662	;		xbar[	302	]=	0.14623		;		ybar[	302	]=	0.053955	;		zbar[	302	]=	0	;
	wavelength[	303	]=	663	;		xbar[	303	]=	0.13749		;		ybar[	303	]=	0.050674	;		zbar[	303	]=	0	;
	wavelength[	304	]=	664	;		xbar[	304	]=	0.129147	;		ybar[	304	]=	0.04755		;		zbar[	304	]=	0	;
	wavelength[	305	]=	665	;		xbar[	305	]=	0.1212		;		ybar[	305	]=	0.04458		;		zbar[	305	]=	0	;
	wavelength[	306	]=	666	;		xbar[	306	]=	0.11364		;		ybar[	306	]=	0.041759	;		zbar[	306	]=	0	;
	wavelength[	307	]=	667	;		xbar[	307	]=	0.106465	;		ybar[	307	]=	0.039085	;		zbar[	307	]=	0	;
	wavelength[	308	]=	668	;		xbar[	308	]=	0.09969		;		ybar[	308	]=	0.036564	;		zbar[	308	]=	0	;
	wavelength[	309	]=	669	;		xbar[	309	]=	0.093331	;		ybar[	309	]=	0.0342		;		zbar[	309	]=	0	;
	wavelength[	310	]=	670	;		xbar[	310	]=	0.0874		;		ybar[	310	]=	0.032		;		zbar[	310	]=	0	;
	wavelength[	311	]=	671	;		xbar[	311	]=	0.081901	;		ybar[	311	]=	0.029963	;		zbar[	311	]=	0	;
	wavelength[	312	]=	672	;		xbar[	312	]=	0.076804	;		ybar[	312	]=	0.028077	;		zbar[	312	]=	0	;
	wavelength[	313	]=	673	;		xbar[	313	]=	0.072077	;		ybar[	313	]=	0.026329	;		zbar[	313	]=	0	;
	wavelength[	314	]=	674	;		xbar[	314	]=	0.067687	;		ybar[	314	]=	0.024708	;		zbar[	314	]=	0	;
	wavelength[	315	]=	675	;		xbar[	315	]=	0.0636		;		ybar[	315	]=	0.0232		;		zbar[	315	]=	0	;
	wavelength[	316	]=	676	;		xbar[	316	]=	0.059807	;		ybar[	316	]=	0.021801	;		zbar[	316	]=	0	;
	wavelength[	317	]=	677	;		xbar[	317	]=	0.056282	;		ybar[	317	]=	0.020501	;		zbar[	317	]=	0	;
	wavelength[	318	]=	678	;		xbar[	318	]=	0.052971	;		ybar[	318	]=	0.019281	;		zbar[	318	]=	0	;
	wavelength[	319	]=	679	;		xbar[	319	]=	0.049819	;		ybar[	319	]=	0.018121	;		zbar[	319	]=	0	;
	wavelength[	320	]=	680	;		xbar[	320	]=	0.04677		;		ybar[	320	]=	0.017		;		zbar[	320	]=	0	;
	wavelength[	321	]=	681	;		xbar[	321	]=	0.043784	;		ybar[	321	]=	0.015904	;		zbar[	321	]=	0	;
	wavelength[	322	]=	682	;		xbar[	322	]=	0.040875	;		ybar[	322	]=	0.014837	;		zbar[	322	]=	0	;
	wavelength[	323	]=	683	;		xbar[	323	]=	0.038073	;		ybar[	323	]=	0.013811	;		zbar[	323	]=	0	;
	wavelength[	324	]=	684	;		xbar[	324	]=	0.035405	;		ybar[	324	]=	0.012835	;		zbar[	324	]=	0	;
	wavelength[	325	]=	685	;		xbar[	325	]=	0.0329		;		ybar[	325	]=	0.01192		;		zbar[	325	]=	0	;
	wavelength[	326	]=	686	;		xbar[	326	]=	0.030564	;		ybar[	326	]=	0.011068	;		zbar[	326	]=	0	;
	wavelength[	327	]=	687	;		xbar[	327	]=	0.028381	;		ybar[	327	]=	0.010273	;		zbar[	327	]=	0	;
	wavelength[	328	]=	688	;		xbar[	328	]=	0.026345	;		ybar[	328	]=	0.009533	;		zbar[	328	]=	0	;
	wavelength[	329	]=	689	;		xbar[	329	]=	0.024453	;		ybar[	329	]=	0.008846	;		zbar[	329	]=	0	;
	wavelength[	330	]=	690	;		xbar[	330	]=	0.0227		;		ybar[	330	]=	0.00821		;		zbar[	330	]=	0	;
	wavelength[	331	]=	691	;		xbar[	331	]=	0.021084	;		ybar[	331	]=	0.007624	;		zbar[	331	]=	0	;
	wavelength[	332	]=	692	;		xbar[	332	]=	0.0196		;		ybar[	332	]=	0.007085	;		zbar[	332	]=	0	;
	wavelength[	333	]=	693	;		xbar[	333	]=	0.018237	;		ybar[	333	]=	0.006591	;		zbar[	333	]=	0	;
	wavelength[	334	]=	694	;		xbar[	334	]=	0.016987	;		ybar[	334	]=	0.006138	;		zbar[	334	]=	0	;
	wavelength[	335	]=	695	;		xbar[	335	]=	0.01584		;		ybar[	335	]=	0.005723	;		zbar[	335	]=	0	;
	wavelength[	336	]=	696	;		xbar[	336	]=	0.014791	;		ybar[	336	]=	0.005343	;		zbar[	336	]=	0	;
	wavelength[	337	]=	697	;		xbar[	337	]=	0.013831	;		ybar[	337	]=	0.004996	;		zbar[	337	]=	0	;
	wavelength[	338	]=	698	;		xbar[	338	]=	0.012949	;		ybar[	338	]=	0.004676	;		zbar[	338	]=	0	;
	wavelength[	339	]=	699	;		xbar[	339	]=	0.012129	;		ybar[	339	]=	0.00438		;		zbar[	339	]=	0	;
	wavelength[	340	]=	700	;		xbar[	340	]=	0.011359	;		ybar[	340	]=	0.004102	;		zbar[	340	]=	0	;
	wavelength[	341	]=	701	;		xbar[	341	]=	0.010629	;		ybar[	341	]=	0.003838	;		zbar[	341	]=	0	;
	wavelength[	342	]=	702	;		xbar[	342	]=	0.009939	;		ybar[	342	]=	0.003589	;		zbar[	342	]=	0	;
	wavelength[	343	]=	703	;		xbar[	343	]=	0.009288	;		ybar[	343	]=	0.003354	;		zbar[	343	]=	0	;
	wavelength[	344	]=	704	;		xbar[	344	]=	0.008679	;		ybar[	344	]=	0.003134	;		zbar[	344	]=	0	;
	wavelength[	345	]=	705	;		xbar[	345	]=	0.008111	;		ybar[	345	]=	0.002929	;		zbar[	345	]=	0	;
	wavelength[	346	]=	706	;		xbar[	346	]=	0.007582	;		ybar[	346	]=	0.002738	;		zbar[	346	]=	0	;
	wavelength[	347	]=	707	;		xbar[	347	]=	0.007089	;		ybar[	347	]=	0.00256		;		zbar[	347	]=	0	;
	wavelength[	348	]=	708	;		xbar[	348	]=	0.006627	;		ybar[	348	]=	0.002393	;		zbar[	348	]=	0	;
	wavelength[	349	]=	709	;		xbar[	349	]=	0.006195	;		ybar[	349	]=	0.002237	;		zbar[	349	]=	0	;
	wavelength[	350	]=	710	;		xbar[	350	]=	0.00579		;		ybar[	350	]=	0.002091	;		zbar[	350	]=	0	;
	wavelength[	351	]=	711	;		xbar[	351	]=	0.00541		;		ybar[	351	]=	0.001954	;		zbar[	351	]=	0	;
	wavelength[	352	]=	712	;		xbar[	352	]=	0.005053	;		ybar[	352	]=	0.001825	;		zbar[	352	]=	0	;
	wavelength[	353	]=	713	;		xbar[	353	]=	0.004718	;		ybar[	353	]=	0.001704	;		zbar[	353	]=	0	;
	wavelength[	354	]=	714	;		xbar[	354	]=	0.004404	;		ybar[	354	]=	0.00159		;		zbar[	354	]=	0	;
	wavelength[	355	]=	715	;		xbar[	355	]=	0.004109	;		ybar[	355	]=	0.001484	;		zbar[	355	]=	0	;
	wavelength[	356	]=	716	;		xbar[	356	]=	0.003834	;		ybar[	356	]=	0.001384	;		zbar[	356	]=	0	;
	wavelength[	357	]=	717	;		xbar[	357	]=	0.003576	;		ybar[	357	]=	0.001291	;		zbar[	357	]=	0	;
	wavelength[	358	]=	718	;		xbar[	358	]=	0.003334	;		ybar[	358	]=	0.001204	;		zbar[	358	]=	0	;
	wavelength[	359	]=	719	;		xbar[	359	]=	0.003109	;		ybar[	359	]=	0.001123	;		zbar[	359	]=	0	;
	wavelength[	360	]=	720	;		xbar[	360	]=	0.002899	;		ybar[	360	]=	0.001047	;		zbar[	360	]=	0	;
	wavelength[	361	]=	721	;		xbar[	361	]=	0.002704	;		ybar[	361	]=	0.000977	;		zbar[	361	]=	0	;
	wavelength[	362	]=	722	;		xbar[	362	]=	0.002523	;		ybar[	362	]=	0.000911	;		zbar[	362	]=	0	;
	wavelength[	363	]=	723	;		xbar[	363	]=	0.002354	;		ybar[	363	]=	0.00085		;		zbar[	363	]=	0	;
	wavelength[	364	]=	724	;		xbar[	364	]=	0.002197	;		ybar[	364	]=	0.000793	;		zbar[	364	]=	0	;
	wavelength[	365	]=	725	;		xbar[	365	]=	0.002049	;		ybar[	365	]=	0.00074		;		zbar[	365	]=	0	;
	wavelength[	366	]=	726	;		xbar[	366	]=	0.001911	;		ybar[	366	]=	0.00069		;		zbar[	366	]=	0	;
	wavelength[	367	]=	727	;		xbar[	367	]=	0.001781	;		ybar[	367	]=	0.000643	;		zbar[	367	]=	0	;
	wavelength[	368	]=	728	;		xbar[	368	]=	0.00166		;		ybar[	368	]=	0.000599	;		zbar[	368	]=	0	;
	wavelength[	369	]=	729	;		xbar[	369	]=	0.001546	;		ybar[	369	]=	0.000558	;		zbar[	369	]=	0	;
	wavelength[	370	]=	730	;		xbar[	370	]=	0.00144		;		ybar[	370	]=	0.00052		;		zbar[	370	]=	0	;
	wavelength[	371	]=	731	;		xbar[	371	]=	0.00134		;		ybar[	371	]=	0.000484	;		zbar[	371	]=	0	;
	wavelength[	372	]=	732	;		xbar[	372	]=	0.001246	;		ybar[	372	]=	0.00045		;		zbar[	372	]=	0	;
	wavelength[	373	]=	733	;		xbar[	373	]=	0.001158	;		ybar[	373	]=	0.000418	;		zbar[	373	]=	0	;
	wavelength[	374	]=	734	;		xbar[	374	]=	0.001076	;		ybar[	374	]=	0.000389	;		zbar[	374	]=	0	;
	wavelength[	375	]=	735	;		xbar[	375	]=	0.001		;		ybar[	375	]=	0.000361	;		zbar[	375	]=	0	;
	wavelength[	376	]=	736	;		xbar[	376	]=	0.000929	;		ybar[	376	]=	0.000335	;		zbar[	376	]=	0	;
	wavelength[	377	]=	737	;		xbar[	377	]=	0.000862	;		ybar[	377	]=	0.000311	;		zbar[	377	]=	0	;
	wavelength[	378	]=	738	;		xbar[	378	]=	0.000801	;		ybar[	378	]=	0.000289	;		zbar[	378	]=	0	;
	wavelength[	379	]=	739	;		xbar[	379	]=	0.000743	;		ybar[	379	]=	0.000268	;		zbar[	379	]=	0	;
	wavelength[	380	]=	740	;		xbar[	380	]=	0.00069		;		ybar[	380	]=	0.000249	;		zbar[	380	]=	0	;
	wavelength[	381	]=	741	;		xbar[	381	]=	0.000641	;		ybar[	381	]=	0.000231	;		zbar[	381	]=	0	;
	wavelength[	382	]=	742	;		xbar[	382	]=	0.000595	;		ybar[	382	]=	0.000215	;		zbar[	382	]=	0	;
	wavelength[	383	]=	743	;		xbar[	383	]=	0.000552	;		ybar[	383	]=	0.000199	;		zbar[	383	]=	0	;
	wavelength[	384	]=	744	;		xbar[	384	]=	0.000512	;		ybar[	384	]=	0.000185	;		zbar[	384	]=	0	;
	wavelength[	385	]=	745	;		xbar[	385	]=	0.000476	;		ybar[	385	]=	0.000172	;		zbar[	385	]=	0	;
	wavelength[	386	]=	746	;		xbar[	386	]=	0.000442	;		ybar[	386	]=	0.00016		;		zbar[	386	]=	0	;
	wavelength[	387	]=	747	;		xbar[	387	]=	0.000412	;		ybar[	387	]=	0.000149	;		zbar[	387	]=	0	;
	wavelength[	388	]=	748	;		xbar[	388	]=	0.000383	;		ybar[	388	]=	0.000138	;		zbar[	388	]=	0	;
	wavelength[	389	]=	749	;		xbar[	389	]=	0.000357	;		ybar[	389	]=	0.000129	;		zbar[	389	]=	0	;
	wavelength[	390	]=	750	;		xbar[	390	]=	0.000332	;		ybar[	390	]=	0.00012		;		zbar[	390	]=	0	;
	wavelength[	391	]=	751	;		xbar[	391	]=	0.00031		;		ybar[	391	]=	0.000112	;		zbar[	391	]=	0	;
	wavelength[	392	]=	752	;		xbar[	392	]=	0.000289	;		ybar[	392	]=	0.000104	;		zbar[	392	]=	0	;
	wavelength[	393	]=	753	;		xbar[	393	]=	0.00027		;		ybar[	393	]=	9.70E-05	;		zbar[	393	]=	0	;
	wavelength[	394	]=	754	;		xbar[	394	]=	0.000252	;		ybar[	394	]=	9.10E-05	;		zbar[	394	]=	0	;
	wavelength[	395	]=	755	;		xbar[	395	]=	0.000235	;		ybar[	395	]=	8.50E-05	;		zbar[	395	]=	0	;
	wavelength[	396	]=	756	;		xbar[	396	]=	0.000219	;		ybar[	396	]=	7.90E-05	;		zbar[	396	]=	0	;
	wavelength[	397	]=	757	;		xbar[	397	]=	0.000205	;		ybar[	397	]=	7.40E-05	;		zbar[	397	]=	0	;
	wavelength[	398	]=	758	;		xbar[	398	]=	0.000191	;		ybar[	398	]=	6.90E-05	;		zbar[	398	]=	0	;
	wavelength[	399	]=	759	;		xbar[	399	]=	0.000178	;		ybar[	399	]=	6.40E-05	;		zbar[	399	]=	0	;
	wavelength[	400	]=	760	;		xbar[	400	]=	0.000166	;		ybar[	400	]=	6.00E-05	;		zbar[	400	]=	0	;
	wavelength[	401	]=	761	;		xbar[	401	]=	0.000155	;		ybar[	401	]=	5.60E-05	;		zbar[	401	]=	0	;
	wavelength[	402	]=	762	;		xbar[	402	]=	0.000145	;		ybar[	402	]=	5.20E-05	;		zbar[	402	]=	0	;
	wavelength[	403	]=	763	;		xbar[	403	]=	0.000135	;		ybar[	403	]=	4.90E-05	;		zbar[	403	]=	0	;
	wavelength[	404	]=	764	;		xbar[	404	]=	0.000126	;		ybar[	404	]=	4.50E-05	;		zbar[	404	]=	0	;
	wavelength[	405	]=	765	;		xbar[	405	]=	0.000117	;		ybar[	405	]=	4.20E-05	;		zbar[	405	]=	0	;
	wavelength[	406	]=	766	;		xbar[	406	]=	0.00011		;		ybar[	406	]=	4.00E-05	;		zbar[	406	]=	0	;
	wavelength[	407	]=	767	;		xbar[	407	]=	0.000102	;		ybar[	407	]=	3.70E-05	;		zbar[	407	]=	0	;
	wavelength[	408	]=	768	;		xbar[	408	]=	9.50E-05	;		ybar[	408	]=	3.40E-05	;		zbar[	408	]=	0	;
	wavelength[	409	]=	769	;		xbar[	409	]=	8.90E-05	;		ybar[	409	]=	3.20E-05	;		zbar[	409	]=	0	;
	wavelength[	410	]=	770	;		xbar[	410	]=	8.30E-05	;		ybar[	410	]=	3.00E-05	;		zbar[	410	]=	0	;
	wavelength[	411	]=	771	;		xbar[	411	]=	7.80E-05	;		ybar[	411	]=	2.80E-05	;		zbar[	411	]=	0	;
	wavelength[	412	]=	772	;		xbar[	412	]=	7.20E-05	;		ybar[	412	]=	2.60E-05	;		zbar[	412	]=	0	;
	wavelength[	413	]=	773	;		xbar[	413	]=	6.70E-05	;		ybar[	413	]=	2.40E-05	;		zbar[	413	]=	0	;
	wavelength[	414	]=	774	;		xbar[	414	]=	6.30E-05	;		ybar[	414	]=	2.30E-05	;		zbar[	414	]=	0	;
	wavelength[	415	]=	775	;		xbar[	415	]=	5.90E-05	;		ybar[	415	]=	2.10E-05	;		zbar[	415	]=	0	;
	wavelength[	416	]=	776	;		xbar[	416	]=	5.50E-05	;		ybar[	416	]=	2.00E-05	;		zbar[	416	]=	0	;
	wavelength[	417	]=	777	;		xbar[	417	]=	5.10E-05	;		ybar[	417	]=	1.80E-05	;		zbar[	417	]=	0	;
	wavelength[	418	]=	778	;		xbar[	418	]=	4.80E-05	;		ybar[	418	]=	1.70E-05	;		zbar[	418	]=	0	;
	wavelength[	419	]=	779	;		xbar[	419	]=	4.40E-05	;		ybar[	419	]=	1.60E-05	;		zbar[	419	]=	0	;
	wavelength[	420	]=	780	;		xbar[	420	]=	4.20E-05	;		ybar[	420	]=	1.50E-05	;		zbar[	420	]=	0	;
	wavelength[	421	]=	781	;		xbar[	421	]=	3.90E-05	;		ybar[	421	]=	1.40E-05	;		zbar[	421	]=	0	;
	wavelength[	422	]=	782	;		xbar[	422	]=	3.60E-05	;		ybar[	422	]=	1.30E-05	;		zbar[	422	]=	0	;
	wavelength[	423	]=	783	;		xbar[	423	]=	3.40E-05	;		ybar[	423	]=	1.20E-05	;		zbar[	423	]=	0	;
	wavelength[	424	]=	784	;		xbar[	424	]=	3.10E-05	;		ybar[	424	]=	1.10E-05	;		zbar[	424	]=	0	;
	wavelength[	425	]=	785	;		xbar[	425	]=	2.90E-05	;		ybar[	425	]=	1.10E-05	;		zbar[	425	]=	0	;
	wavelength[	426	]=	786	;		xbar[	426	]=	2.70E-05	;		ybar[	426	]=	1.00E-05	;		zbar[	426	]=	0	;
	wavelength[	427	]=	787	;		xbar[	427	]=	2.60E-05	;		ybar[	427	]=	9.00E-06	;		zbar[	427	]=	0	;
	wavelength[	428	]=	788	;		xbar[	428	]=	2.40E-05	;		ybar[	428	]=	9.00E-06	;		zbar[	428	]=	0	;
	wavelength[	429	]=	789	;		xbar[	429	]=	2.20E-05	;		ybar[	429	]=	8.00E-06	;		zbar[	429	]=	0	;
	wavelength[	430	]=	790	;		xbar[	430	]=	2.10E-05	;		ybar[	430	]=	7.00E-06	;		zbar[	430	]=	0	;
	wavelength[	431	]=	791	;		xbar[	431	]=	1.90E-05	;		ybar[	431	]=	7.00E-06	;		zbar[	431	]=	0	;
	wavelength[	432	]=	792	;		xbar[	432	]=	1.80E-05	;		ybar[	432	]=	6.00E-06	;		zbar[	432	]=	0	;
	wavelength[	433	]=	793	;		xbar[	433	]=	1.70E-05	;		ybar[	433	]=	6.00E-06	;		zbar[	433	]=	0	;
	wavelength[	434	]=	794	;		xbar[	434	]=	1.60E-05	;		ybar[	434	]=	6.00E-06	;		zbar[	434	]=	0	;
	wavelength[	435	]=	795	;		xbar[	435	]=	1.50E-05	;		ybar[	435	]=	5.00E-06	;		zbar[	435	]=	0	;
	wavelength[	436	]=	796	;		xbar[	436	]=	1.40E-05	;		ybar[	436	]=	5.00E-06	;		zbar[	436	]=	0	;
	wavelength[	437	]=	797	;		xbar[	437	]=	1.30E-05	;		ybar[	437	]=	5.00E-06	;		zbar[	437	]=	0	;
	wavelength[	438	]=	798	;		xbar[	438	]=	1.20E-05	;		ybar[	438	]=	4.00E-06	;		zbar[	438	]=	0	;
	wavelength[	439	]=	799	;		xbar[	439	]=	1.10E-05	;		ybar[	439	]=	4.00E-06	;		zbar[	439	]=	0	;
	wavelength[	440	]=	800	;		xbar[	440	]=	1.00E-05	;		ybar[	440	]=	4.00E-06	;		zbar[	440	]=	0	;
	wavelength[	441	]=	801	;		xbar[	441	]=	1.00E-05	;		ybar[	441	]=	3.00E-06	;		zbar[	441	]=	0	;
	wavelength[	442	]=	802	;		xbar[	442	]=	9.00E-06	;		ybar[	442	]=	3.00E-06	;		zbar[	442	]=	0	;
	wavelength[	443	]=	803	;		xbar[	443	]=	8.00E-06	;		ybar[	443	]=	3.00E-06	;		zbar[	443	]=	0	;
	wavelength[	444	]=	804	;		xbar[	444	]=	8.00E-06	;		ybar[	444	]=	3.00E-06	;		zbar[	444	]=	0	;
	wavelength[	445	]=	805	;		xbar[	445	]=	7.00E-06	;		ybar[	445	]=	3.00E-06	;		zbar[	445	]=	0	;
	wavelength[	446	]=	806	;		xbar[	446	]=	7.00E-06	;		ybar[	446	]=	2.00E-06	;		zbar[	446	]=	0	;
	wavelength[	447	]=	807	;		xbar[	447	]=	6.00E-06	;		ybar[	447	]=	2.00E-06	;		zbar[	447	]=	0	;
	wavelength[	448	]=	808	;		xbar[	448	]=	6.00E-06	;		ybar[	448	]=	2.00E-06	;		zbar[	448	]=	0	;
	wavelength[	449	]=	809	;		xbar[	449	]=	5.00E-06	;		ybar[	449	]=	2.00E-06	;		zbar[	449	]=	0	;
	wavelength[	450	]=	810	;		xbar[	450	]=	5.00E-06	;		ybar[	450	]=	2.00E-06	;		zbar[	450	]=	0	;
	wavelength[	451	]=	811	;		xbar[	451	]=	5.00E-06	;		ybar[	451	]=	2.00E-06	;		zbar[	451	]=	0	;
	wavelength[	452	]=	812	;		xbar[	452	]=	4.00E-06	;		ybar[	452	]=	2.00E-06	;		zbar[	452	]=	0	;
	wavelength[	453	]=	813	;		xbar[	453	]=	4.00E-06	;		ybar[	453	]=	1.00E-06	;		zbar[	453	]=	0	;
	wavelength[	454	]=	814	;		xbar[	454	]=	4.00E-06	;		ybar[	454	]=	1.00E-06	;		zbar[	454	]=	0	;
	wavelength[	455	]=	815	;		xbar[	455	]=	4.00E-06	;		ybar[	455	]=	1.00E-06	;		zbar[	455	]=	0	;
	wavelength[	456	]=	816	;		xbar[	456	]=	3.00E-06	;		ybar[	456	]=	1.00E-06	;		zbar[	456	]=	0	;
	wavelength[	457	]=	817	;		xbar[	457	]=	3.00E-06	;		ybar[	457	]=	1.00E-06	;		zbar[	457	]=	0	;
	wavelength[	458	]=	818	;		xbar[	458	]=	3.00E-06	;		ybar[	458	]=	1.00E-06	;		zbar[	458	]=	0	;
	wavelength[	459	]=	819	;		xbar[	459	]=	3.00E-06	;		ybar[	459	]=	1.00E-06	;		zbar[	459	]=	0	;
	wavelength[	460	]=	820	;		xbar[	460	]=	3.00E-06	;		ybar[	460	]=	1.00E-06	;		zbar[	460	]=	0	;
	wavelength[	461	]=	821	;		xbar[	461	]=	2.00E-06	;		ybar[	461	]=	1.00E-06	;		zbar[	461	]=	0	;
	wavelength[	462	]=	822	;		xbar[	462	]=	2.00E-06	;		ybar[	462	]=	1.00E-06	;		zbar[	462	]=	0	;
	wavelength[	463	]=	823	;		xbar[	463	]=	2.00E-06	;		ybar[	463	]=	1.00E-06	;		zbar[	463	]=	0	;
	wavelength[	464	]=	824	;		xbar[	464	]=	2.00E-06	;		ybar[	464	]=	1.00E-06	;		zbar[	464	]=	0	;
	wavelength[	465	]=	825	;		xbar[	465	]=	2.00E-06	;		ybar[	465	]=	1.00E-06	;		zbar[	465	]=	0	;
	wavelength[	466	]=	826	;		xbar[	466	]=	2.00E-06	;		ybar[	466	]=	1.00E-06	;		zbar[	466	]=	0	;
	wavelength[	467	]=	827	;		xbar[	467	]=	2.00E-06	;		ybar[	467	]=	1.00E-06	;		zbar[	467	]=	0	;
	wavelength[	468	]=	828	;		xbar[	468	]=	1.00E-06	;		ybar[	468	]=	1.00E-06	;		zbar[	468	]=	0	;
	wavelength[	469	]=	829	;		xbar[	469	]=	1.00E-06	;		ybar[	469	]=	0			;		zbar[	469	]=	0	;
	wavelength[	470	]=	830	;		xbar[	470	]=	1.00E-06	;		ybar[	470	]=	0			;		zbar[	470	]=	0	;
//////////////
	TCS[0][	0	]=	360	;		TCS[1][	0	]=	0.116	;		TCS[2][	0	]=	0.053	;		TCS[3][	0	]=	0.058	;		TCS[4][	0	]=	0.057	;		TCS[5][	0	]=	0.143	;		TCS[6][	0	]=	0.079	;		TCS[7][	0	]=	0.15	;		TCS[8][	0	]=	0.075	;		TCS[9][	0	]=	0.069	;		TCS[10][	0	]=	0.042	;		TCS[11][	0	]=	0.074	;		TCS[12][	0	]=	0.189	;		TCS[13][	0	]=	0.071	;		TCS[14][	0	]=	0.036	;
	TCS[0][	1	]=	361	;		TCS[1][	1	]=	0.120193438	;		TCS[2][	1	]=	0.053190795	;		TCS[3][	1	]=	0.058066232	;		TCS[4][	1	]=	0.057382463	;		TCS[5][	1	]=	0.150879964	;		TCS[6][	1	]=	0.079567563	;		TCS[7][	1	]=	0.155831185	;		TCS[8][	1	]=	0.075060621	;		TCS[9][	1	]=	0.069594214	;		TCS[10][	1	]=	0.042042169	;		TCS[11][	1	]=	0.075071478	;		TCS[12][	1	]=	0.186475083	;		TCS[13][	1	]=	0.071929005	;		TCS[14][	1	]=	0.035998479	;
	TCS[0][	2	]=	362	;		TCS[1][	2	]=	0.124217917	;		TCS[2][	2	]=	0.053494394	;		TCS[3][	2	]=	0.058208309	;		TCS[4][	2	]=	0.057763284	;		TCS[5][	2	]=	0.159346619	;		TCS[6][	2	]=	0.079943417	;		TCS[7][	2	]=	0.161188246	;		TCS[8][	2	]=	0.075440828	;		TCS[9][	2	]=	0.070218951	;		TCS[10][	2	]=	0.042176226	;		TCS[11][	2	]=	0.076068638	;		TCS[12][	2	]=	0.183806777	;		TCS[13][	2	]=	0.072892006	;		TCS[14][	2	]=	0.035997972	;
	TCS[0][	3	]=	363	;		TCS[1][	3	]=	0.128145677	;		TCS[2][	3	]=	0.053902594	;		TCS[3][	3	]=	0.05841727	;		TCS[4][	3	]=	0.058152873	;		TCS[5][	3	]=	0.168273291	;		TCS[6][	3	]=	0.08023549	;		TCS[7][	3	]=	0.166329716	;		TCS[8][	3	]=	0.076090724	;		TCS[9][	3	]=	0.070846582	;		TCS[10][	3	]=	0.042389197	;		TCS[11][	3	]=	0.077030058	;		TCS[12][	3	]=	0.18100093	;		TCS[13][	3	]=	0.073890505	;		TCS[14][	3	]=	0.035998226	;
	TCS[0][	4	]=	364	;		TCS[1][	4	]=	0.132048958	;		TCS[2][	4	]=	0.054407197	;		TCS[3][	4	]=	0.058684154	;		TCS[4][	4	]=	0.058561642	;		TCS[5][	4	]=	0.177533309	;		TCS[6][	4	]=	0.080551709	;		TCS[7][	4	]=	0.171514123	;		TCS[8][	4	]=	0.076960414	;		TCS[9][	4	]=	0.071449476	;		TCS[10][	4	]=	0.042668113	;		TCS[11][	4	]=	0.077994319	;		TCS[12][	4	]=	0.178063389	;		TCS[13][	4	]=	0.074926003	;		TCS[14][	4	]=	0.035998986	;
	TCS[0][	5	]=	365	;		TCS[1][	5	]=	0.136	;		TCS[2][	5	]=	0.055	;		TCS[3][	5	]=	0.059	;		TCS[4][	5	]=	0.059	;		TCS[5][	5	]=	0.187	;		TCS[6][	5	]=	0.081	;		TCS[7][	5	]=	0.177	;		TCS[8][	5	]=	0.078	;		TCS[9][	5	]=	0.072	;		TCS[10][	5	]=	0.043	;		TCS[11][	5	]=	0.079	;		TCS[12][	5	]=	0.175	;		TCS[13][	5	]=	0.076	;		TCS[14][	5	]=	0.036	;
	TCS[0][	6	]=	366	;		TCS[1][	6	]=	0.140071042	;		TCS[2][	6	]=	0.055672803	;		TCS[3][	6	]=	0.059355846	;		TCS[4][	6	]=	0.059478358	;		TCS[5][	6	]=	0.196546691	;		TCS[6][	6	]=	0.081688291	;		TCS[7][	6	]=	0.183045877	;		TCS[8][	6	]=	0.079159586	;		TCS[9][	6	]=	0.072470524	;		TCS[10][	6	]=	0.043371887	;		TCS[11][	6	]=	0.080085681	;		TCS[12][	6	]=	0.171816611	;		TCS[13][	6	]=	0.077113997	;		TCS[14][	6	]=	0.036001014	;
	TCS[0][	7	]=	367	;		TCS[1][	7	]=	0.144334323	;		TCS[2][	7	]=	0.056417406	;		TCS[3][	7	]=	0.05974273	;		TCS[4][	7	]=	0.060007127	;		TCS[5][	7	]=	0.206046709	;		TCS[6][	7	]=	0.08272451	;		TCS[7][	7	]=	0.189910284	;		TCS[8][	7	]=	0.080389276	;		TCS[9][	7	]=	0.072833418	;		TCS[10][	7	]=	0.043770803	;		TCS[11][	7	]=	0.081289942	;		TCS[12][	7	]=	0.16851907	;		TCS[13][	7	]=	0.078269495	;		TCS[14][	7	]=	0.036001774	;
	TCS[0][	8	]=	368	;		TCS[1][	8	]=	0.148862083	;		TCS[2][	8	]=	0.057225606	;		TCS[3][	8	]=	0.060151691	;		TCS[4][	8	]=	0.060596716	;		TCS[5][	8	]=	0.215373381	;		TCS[6][	8	]=	0.084216583	;		TCS[7][	8	]=	0.197851754	;		TCS[8][	8	]=	0.081639172	;		TCS[9][	8	]=	0.073061049	;		TCS[10][	8	]=	0.044183774	;		TCS[11][	8	]=	0.082651362	;		TCS[12][	8	]=	0.165113223	;		TCS[13][	8	]=	0.079467994	;		TCS[14][	8	]=	0.036002028	;
	TCS[0][	9	]=	369	;		TCS[1][	9	]=	0.153726562	;		TCS[2][	9	]=	0.058089205	;		TCS[3][	9	]=	0.060573768	;		TCS[4][	9	]=	0.061257537	;		TCS[5][	9	]=	0.224400036	;		TCS[6][	9	]=	0.086272437	;		TCS[7][	9	]=	0.207128815	;		TCS[8][	9	]=	0.082859379	;		TCS[9][	9	]=	0.073125786	;		TCS[10][	9	]=	0.044597831	;		TCS[11][	9	]=	0.084208522	;		TCS[12][	9	]=	0.161604917	;		TCS[13][	9	]=	0.080710995	;		TCS[14][	9	]=	0.036001521	;
	TCS[0][	10	]=	370	;		TCS[1][	10	]=	0.159	;		TCS[2][	10	]=	0.059	;		TCS[3][	10	]=	0.061	;		TCS[4][	10	]=	0.062	;		TCS[5][	10	]=	0.233	;		TCS[6][	10	]=	0.089	;		TCS[7][	10	]=	0.218	;		TCS[8][	10	]=	0.084	;		TCS[9][	10	]=	0.073	;		TCS[10][	10	]=	0.045	;		TCS[11][	10	]=	0.086	;		TCS[12][	10	]=	0.158	;		TCS[13][	10	]=	0.082	;		TCS[14][	10	]=	0.036	;
	TCS[0][	11	]=	371	;		TCS[1][	11	]=	0.164722396	;		TCS[2][	11	]=	0.059949992	;		TCS[3][	11	]=	0.061422386	;		TCS[4][	11	]=	0.062832105	;		TCS[5][	11	]=	0.241077273	;		TCS[6][	11	]=	0.092479272	;		TCS[7][	11	]=	0.230625308	;		TCS[8][	11	]=	0.085037035	;		TCS[9][	11	]=	0.072667689	;		TCS[10][	11	]=	0.045382282	;		TCS[11][	11	]=	0.088049797	;		TCS[12][	11	]=	0.154306471	;		TCS[13][	11	]=	0.083343008	;		TCS[14][	11	]=	0.035997465	;
	TCS[0][	12	]=	372	;		TCS[1][	12	]=	0.170804792	;		TCS[2][	12	]=	0.060931984	;		TCS[3][	12	]=	0.061836772	;		TCS[4][	12	]=	0.06375221	;		TCS[5][	12	]=	0.248658546	;		TCS[6][	12	]=	0.096678543	;		TCS[7][	12	]=	0.244770616	;		TCS[8][	12	]=	0.08605007	;		TCS[9][	12	]=	0.072159378	;		TCS[10][	12	]=	0.045756564	;		TCS[11][	12	]=	0.090323595	;		TCS[12][	12	]=	0.150540943	;		TCS[13][	12	]=	0.084774015	;		TCS[14][	12	]=	0.03599493	;
	TCS[0][	13	]=	373	;		TCS[1][	13	]=	0.17712599	;		TCS[2][	13	]=	0.06193898	;		TCS[3][	13	]=	0.062239965	;		TCS[4][	13	]=	0.064756262	;		TCS[5][	13	]=	0.255801183	;		TCS[6][	13	]=	0.101538179	;		TCS[7][	13	]=	0.26010327	;		TCS[8][	13	]=	0.087144587	;		TCS[9][	13	]=	0.071517223	;		TCS[10][	13	]=	0.046139705	;		TCS[11][	13	]=	0.092772493	;		TCS[12][	13	]=	0.146722178	;		TCS[13][	13	]=	0.086333519	;		TCS[14][	13	]=	0.035993663	;
	TCS[0][	14	]=	374	;		TCS[1][	14	]=	0.183564792	;		TCS[2][	14	]=	0.062963984	;		TCS[3][	14	]=	0.062628772	;		TCS[4][	14	]=	0.06584021	;		TCS[5][	14	]=	0.262562546	;		TCS[6][	14	]=	0.106998543	;		TCS[7][	14	]=	0.276290616	;		TCS[8][	14	]=	0.08842607	;		TCS[9][	14	]=	0.070783378	;		TCS[10][	14	]=	0.046548564	;		TCS[11][	14	]=	0.095347595	;		TCS[12][	14	]=	0.142868943	;		TCS[13][	14	]=	0.088062015	;		TCS[14][	14	]=	0.03599493	;
	TCS[0][	15	]=	375	;		TCS[1][	15	]=	0.19	;		TCS[2][	15	]=	0.064	;		TCS[3][	15	]=	0.063	;		TCS[4][	15	]=	0.067	;		TCS[5][	15	]=	0.269	;		TCS[6][	15	]=	0.113	;		TCS[7][	15	]=	0.293	;		TCS[8][	15	]=	0.09	;		TCS[9][	15	]=	0.07	;		TCS[10][	15	]=	0.047	;		TCS[11][	15	]=	0.098	;		TCS[12][	15	]=	0.139	;		TCS[13][	15	]=	0.09	;		TCS[14][	15	]=	0.036	;
	TCS[0][	16	]=	376	;		TCS[1][	16	]=	0.196319375	;		TCS[2][	16	]=	0.065047229	;		TCS[3][	16	]=	0.06335461	;		TCS[4][	16	]=	0.068233223	;		TCS[5][	16	]=	0.275144216	;		TCS[6][	16	]=	0.119498622	;		TCS[7][	16	]=	0.309940892	;		TCS[8][	16	]=	0.091956274	;		TCS[9][	16	]=	0.069202719	;		TCS[10][	16	]=	0.047506985	;		TCS[11][	16	]=	0.100683129	;		TCS[12][	16	]=	0.135133503	;		TCS[13][	16	]=	0.092185973	;		TCS[14][	16	]=	0.036009126	;
	TCS[0][	17	]=	377	;		TCS[1][	17	]=	0.20244651	;		TCS[2][	17	]=	0.066134658	;		TCS[3][	17	]=	0.063710181	;		TCS[4][	17	]=	0.069544035	;		TCS[5][	17	]=	0.280919106	;		TCS[6][	17	]=	0.126513317	;		TCS[7][	17	]=	0.326991253	;		TCS[8][	17	]=	0.094322445	;		TCS[9][	17	]=	0.068401068	;		TCS[10][	17	]=	0.048066941	;		TCS[11][	17	]=	0.103359679	;		TCS[12][	17	]=	0.13128516	;		TCS[13][	17	]=	0.094650445	;		TCS[14][	17	]=	0.036018505	;
	TCS[0][	18	]=	378	;		TCS[1][	18	]=	0.208313957	;		TCS[2][	18	]=	0.067298473	;		TCS[3][	18	]=	0.064088448	;		TCS[4][	18	]=	0.070938236	;		TCS[5][	18	]=	0.286221886	;		TCS[6][	18	]=	0.134078701	;		TCS[7][	18	]=	0.344071168	;		TCS[8][	18	]=	0.097110479	;		TCS[9][	18	]=	0.067598059	;		TCS[10][	18	]=	0.048673405	;		TCS[11][	18	]=	0.105994664	;		TCS[12][	18	]=	0.127470064	;		TCS[13][	18	]=	0.097421931	;		TCS[14][	18	]=	0.036023322	;
	TCS[0][	19	]=	379	;		TCS[1][	19	]=	0.21385427	;		TCS[2][	19	]=	0.068574859	;		TCS[3][	19	]=	0.064511143	;		TCS[4][	19	]=	0.072421625	;		TCS[5][	19	]=	0.290949778	;		TCS[6][	19	]=	0.14222939	;		TCS[7][	19	]=	0.361100722	;		TCS[8][	19	]=	0.100332342	;		TCS[9][	19	]=	0.0667967	;		TCS[10][	19	]=	0.049319913	;		TCS[11][	19	]=	0.108553099	;		TCS[12][	19	]=	0.123703312	;		TCS[13][	19	]=	0.100528944	;		TCS[14][	19	]=	0.036018759	;
	TCS[0][	20	]=	380	;		TCS[1][	20	]=	0.219	;		TCS[2][	20	]=	0.07	;		TCS[3][	20	]=	0.065	;		TCS[4][	20	]=	0.074	;		TCS[5][	20	]=	0.295	;		TCS[6][	20	]=	0.151	;		TCS[7][	20	]=	0.378	;		TCS[8][	20	]=	0.104	;		TCS[9][	20	]=	0.066	;		TCS[10][	20	]=	0.05	;		TCS[11][	20	]=	0.111	;		TCS[12][	20	]=	0.12	;		TCS[13][	20	]=	0.104	;		TCS[14][	20	]=	0.036	;
	TCS[0][	21	]=	381	;		TCS[1][	21	]=	0.223704106	;		TCS[2][	21	]=	0.071597094	;		TCS[3][	21	]=	0.065567174	;		TCS[4][	21	]=	0.075675004	;		TCS[5][	21	]=	0.298305861	;		TCS[6][	21	]=	0.16040624	;		TCS[7][	21	]=	0.394699125	;		TCS[8][	21	]=	0.108121867	;		TCS[9][	21	]=	0.065209436	;		TCS[10][	21	]=	0.050709779	;		TCS[11][	21	]=	0.113305685	;		TCS[12][	21	]=	0.116375515	;		TCS[13][	21	]=	0.107857101	;		TCS[14][	21	]=	0.035966032	;
	TCS[0][	22	]=	382	;		TCS[1][	22	]=	0.22800117	;		TCS[2][	22	]=	0.073337384	;		TCS[3][	22	]=	0.066186502	;		TCS[4][	22	]=	0.077431649	;		TCS[5][	22	]=	0.300945031	;		TCS[6][	22	]=	0.170388189	;		TCS[7][	22	]=	0.411168374	;		TCS[8][	22	]=	0.112692149	;		TCS[9][	22	]=	0.064420348	;		TCS[10][	22	]=	0.051455671	;		TCS[11][	22	]=	0.115461689	;		TCS[12][	22	]=	0.112846419	;		TCS[13][	22	]=	0.112096205	;		TCS[14][	22	]=	0.035931049	;
	TCS[0][	23	]=	383	;		TCS[1][	23	]=	0.231946181	;		TCS[2][	23	]=	0.075179128	;		TCS[3][	23	]=	0.066822243	;		TCS[4][	23	]=	0.079250793	;		TCS[5][	23	]=	0.303031271	;		TCS[6][	23	]=	0.180867017	;		TCS[7][	23	]=	0.42738806	;		TCS[8][	23	]=	0.117701496	;		TCS[9][	23	]=	0.063626541	;		TCS[10][	23	]=	0.052246674	;		TCS[11][	23	]=	0.11746485	;		TCS[12][	23	]=	0.109429565	;		TCS[13][	23	]=	0.116706758	;		TCS[14][	23	]=	0.035913051	;
	TCS[0][	24	]=	384	;		TCS[1][	24	]=	0.235594128	;		TCS[2][	24	]=	0.077080581	;		TCS[3][	24	]=	0.067438657	;		TCS[4][	24	]=	0.081113291	;		TCS[5][	24	]=	0.304678341	;		TCS[6][	24	]=	0.191763897	;		TCS[7][	24	]=	0.443338497	;		TCS[8][	24	]=	0.123140563	;		TCS[9][	24	]=	0.062821823	;		TCS[10][	24	]=	0.053091784	;		TCS[11][	24	]=	0.119312008	;		TCS[12][	24	]=	0.106141808	;		TCS[13][	24	]=	0.121678208	;		TCS[14][	24	]=	0.035930035	;
	TCS[0][	25	]=	385	;		TCS[1][	25	]=	0.239	;		TCS[2][	25	]=	0.079	;		TCS[3][	25	]=	0.068	;		TCS[4][	25	]=	0.083	;		TCS[5][	25	]=	0.306	;		TCS[6][	25	]=	0.203	;		TCS[7][	25	]=	0.459	;		TCS[8][	25	]=	0.129	;		TCS[9][	25	]=	0.062	;		TCS[10][	25	]=	0.054	;		TCS[11][	25	]=	0.121	;		TCS[12][	25	]=	0.103	;		TCS[13][	25	]=	0.127	;		TCS[14][	25	]=	0.036	;
	TCS[0][	26	]=	386	;		TCS[1][	26	]=	0.242200203	;		TCS[2][	26	]=	0.080908397	;		TCS[3][	26	]=	0.068480695	;		TCS[4][	26	]=	0.084898762	;		TCS[5][	26	]=	0.30709634	;		TCS[6][	26	]=	0.214524418	;		TCS[7][	26	]=	0.474286607	;		TCS[8][	26	]=	0.135316256	;		TCS[9][	26	]=	0.061159538	;		TCS[10][	26	]=	0.054973898	;		TCS[11][	26	]=	0.122526131	;		TCS[12][	26	]=	0.100020435	;		TCS[13][	26	]=	0.132681623	;		TCS[14][	26	]=	0.036134748	;
	TCS[0][	27	]=	387	;		TCS[1][	27	]=	0.245156812	;		TCS[2][	27	]=	0.082827806	;		TCS[3][	27	]=	0.06889581	;		TCS[4][	27	]=	0.086825368	;		TCS[5][	27	]=	0.30801277	;		TCS[6][	27	]=	0.226397928	;		TCS[7][	27	]=	0.488847251	;		TCS[8][	27	]=	0.14230896	;		TCS[9][	27	]=	0.060317541	;		TCS[10][	27	]=	0.055990373	;		TCS[11][	27	]=	0.123889565	;		TCS[12][	27	]=	0.097217164	;		TCS[13][	27	]=	0.138812735	;		TCS[14][	27	]=	0.036321298	;
	TCS[0][	28	]=	388	;		TCS[1][	28	]=	0.24781332	;		TCS[2][	28	]=	0.084793017	;		TCS[3][	28	]=	0.069270579	;		TCS[4][	28	]=	0.088802592	;		TCS[5][	28	]=	0.30878103	;		TCS[6][	28	]=	0.238709229	;		TCS[7][	28	]=	0.502264593	;		TCS[8][	28	]=	0.150243536	;		TCS[9][	28	]=	0.059495776	;		TCS[10][	28	]=	0.057019899	;		TCS[11][	28	]=	0.125089934	;		TCS[12][	28	]=	0.094603674	;		TCS[13][	28	]=	0.145503036	;		TCS[14][	28	]=	0.036540474	;
	TCS[0][	29	]=	389	;		TCS[1][	29	]=	0.250113218	;		TCS[2][	29	]=	0.086838818	;		TCS[3][	29	]=	0.069630231	;		TCS[4][	29	]=	0.090853211	;		TCS[5][	29	]=	0.30943286	;		TCS[6][	29	]=	0.25154702	;		TCS[7][	29	]=	0.51412129	;		TCS[8][	29	]=	0.159385408	;		TCS[9][	29	]=	0.058716007	;		TCS[10][	29	]=	0.05803295	;		TCS[11][	29	]=	0.126126869	;		TCS[12][	29	]=	0.092193457	;		TCS[13][	29	]=	0.152862224	;		TCS[14][	29	]=	0.0367731	;
	TCS[0][	30	]=	390	;		TCS[1][	30	]=	0.252	;		TCS[2][	30	]=	0.089	;		TCS[3][	30	]=	0.07	;		TCS[4][	30	]=	0.093	;		TCS[5][	30	]=	0.31	;		TCS[6][	30	]=	0.265	;		TCS[7][	30	]=	0.524	;		TCS[8][	30	]=	0.17	;		TCS[9][	30	]=	0.058	;		TCS[10][	30	]=	0.059	;		TCS[11][	30	]=	0.127	;		TCS[12][	30	]=	0.09	;		TCS[13][	30	]=	0.161	;		TCS[14][	30	]=	0.037	;
	TCS[0][	31	]=	391	;		TCS[1][	31	]=	0.253439082	;		TCS[2][	31	]=	0.091297318	;		TCS[3][	31	]=	0.070398047	;		TCS[4][	31	]=	0.095257947	;		TCS[5][	31	]=	0.31050878	;		TCS[6][	31	]=	0.279112089	;		TCS[7][	31	]=	0.531618448	;		TCS[8][	31	]=	0.182237107	;		TCS[9][	31	]=	0.057360414	;		TCS[10][	31	]=	0.059898628	;		TCS[11][	31	]=	0.127709793	;		TCS[12][	31	]=	0.088030744	;		TCS[13][	31	]=	0.169976406	;		TCS[14][	31	]=	0.037206978	;
	TCS[0][	32	]=	392	;		TCS[1][	32	]=	0.254483581	;		TCS[2][	32	]=	0.093695391	;		TCS[3][	32	]=	0.070814257	;		TCS[4][	32	]=	0.09761088	;		TCS[5][	32	]=	0.310963891	;		TCS[6][	32	]=	0.2937481	;		TCS[7][	32	]=	0.53723462	;		TCS[8][	32	]=	0.19578401	;		TCS[9][	32	]=	0.056773487	;		TCS[10][	32	]=	0.060734835	;		TCS[11][	32	]=	0.128260051	;		TCS[12][	32	]=	0.086268927	;		TCS[13][	32	]=	0.179652854	;		TCS[14][	32	]=	0.03739976	;
	TCS[0][	33	]=	393	;		TCS[1][	33	]=	0.25520854	;		TCS[2][	33	]=	0.096144805	;		TCS[3][	33	]=	0.071231442	;		TCS[4][	33	]=	0.10003484	;		TCS[5][	33	]=	0.311364611	;		TCS[6][	33	]=	0.308728066	;		TCS[7][	33	]=	0.541241569	;		TCS[8][	33	]=	0.210212359	;		TCS[9][	33	]=	0.056206354	;		TCS[10][	33	]=	0.061521728	;		TCS[11][	33	]=	0.128655413	;		TCS[12][	33	]=	0.084691738	;		TCS[13][	33	]=	0.189841099	;		TCS[14][	33	]=	0.037589054	;
	TCS[0][	34	]=	394	;		TCS[1][	34	]=	0.255688999	;		TCS[2][	34	]=	0.098596146	;		TCS[3][	34	]=	0.071632419	;		TCS[4][	34	]=	0.102505866	;		TCS[5][	34	]=	0.311710221	;		TCS[6][	34	]=	0.323872021	;		TCS[7][	34	]=	0.544032345	;		TCS[8][	34	]=	0.225093805	;		TCS[9][	34	]=	0.055626147	;		TCS[10][	34	]=	0.062272414	;		TCS[11][	34	]=	0.128900517	;		TCS[12][	34	]=	0.083276366	;		TCS[13][	34	]=	0.200352896	;		TCS[14][	34	]=	0.037785565	;
	TCS[0][	35	]=	395	;		TCS[1][	35	]=	0.256	;		TCS[2][	35	]=	0.101	;		TCS[3][	35	]=	0.072	;		TCS[4][	35	]=	0.105	;		TCS[5][	35	]=	0.312	;		TCS[6][	35	]=	0.339	;		TCS[7][	35	]=	0.546	;		TCS[8][	35	]=	0.24	;		TCS[9][	35	]=	0.055	;		TCS[10][	35	]=	0.063	;		TCS[11][	35	]=	0.129	;		TCS[12][	35	]=	0.082	;		TCS[13][	35	]=	0.211	;		TCS[14][	35	]=	0.038	;
	TCS[0][	36	]=	396	;		TCS[1][	36	]=	0.256203469	;		TCS[2][	36	]=	0.103310332	;		TCS[3][	36	]=	0.072319116	;		TCS[4][	36	]=	0.107485451	;		TCS[5][	36	]=	0.312236539	;		TCS[6][	36	]=	0.353947225	;		TCS[7][	36	]=	0.547487601	;		TCS[8][	36	]=	0.254655314	;		TCS[9][	36	]=	0.054310808	;		TCS[10][	36	]=	0.063711591	;		TCS[11][	36	]=	0.128954698	;		TCS[12][	36	]=	0.08083259	;		TCS[13][	36	]=	0.221628753	;		TCS[14][	36	]=	0.03823734	;
	TCS[0][	37	]=	397	;		TCS[1][	37	]=	0.256308862	;		TCS[2][	37	]=	0.10549463	;		TCS[3][	37	]=	0.072583163	;		TCS[4][	37	]=	0.109899113	;		TCS[5][	37	]=	0.312435668	;		TCS[6][	37	]=	0.368609673	;		TCS[7][	37	]=	0.548638267	;		TCS[8][	37	]=	0.269395	;		TCS[9][	37	]=	0.05360451	;		TCS[10][	37	]=	0.064390287	;		TCS[11][	37	]=	0.12875023	;		TCS[12][	37	]=	0.07971513	;		TCS[13][	37	]=	0.232223848	;		TCS[14][	37	]=	0.038479661	;
	TCS[0][	38	]=	398	;		TCS[1][	38	]=	0.256312521	;		TCS[2][	38	]=	0.107523762	;		TCS[3][	38	]=	0.072787652	;		TCS[4][	38	]=	0.112170049	;		TCS[5][	38	]=	0.312616527	;		TCS[6][	38	]=	0.382898508	;		TCS[7][	38	]=	0.549545133	;		TCS[8][	38	]=	0.284707028	;		TCS[9][	38	]=	0.052942808	;		TCS[10][	38	]=	0.065013188	;		TCS[11][	38	]=	0.128368414	;		TCS[12][	38	]=	0.078581375	;		TCS[13][	38	]=	0.242804567	;		TCS[14][	38	]=	0.038703312	;
	TCS[0][	39	]=	399	;		TCS[1][	39	]=	0.256210787	;		TCS[2][	39	]=	0.109368596	;		TCS[3][	39	]=	0.072928093	;		TCS[4][	39	]=	0.114227324	;		TCS[5][	39	]=	0.312798258	;		TCS[6][	39	]=	0.396724895	;		TCS[7][	39	]=	0.550301332	;		TCS[8][	39	]=	0.301079371	;		TCS[9][	39	]=	0.052387405	;		TCS[10][	39	]=	0.065557392	;		TCS[11][	39	]=	0.127791065	;		TCS[12][	39	]=	0.07736508	;		TCS[13][	39	]=	0.253390191	;		TCS[14][	39	]=	0.038884642	;
	TCS[0][	40	]=	400	;		TCS[1][	40	]=	0.256	;		TCS[2][	40	]=	0.111	;		TCS[3][	40	]=	0.073	;		TCS[4][	40	]=	0.116	;		TCS[5][	40	]=	0.313	;		TCS[6][	40	]=	0.41	;		TCS[7][	40	]=	0.551	;		TCS[8][	40	]=	0.319	;		TCS[9][	40	]=	0.052	;		TCS[10][	40	]=	0.066	;		TCS[11][	40	]=	0.127	;		TCS[12][	40	]=	0.076	;		TCS[13][	40	]=	0.264	;		TCS[14][	40	]=	0.039	;
	TCS[0][	41	]=	401	;		TCS[1][	41	]=	0.255683044	;		TCS[2][	41	]=	0.112397354	;		TCS[3][	41	]=	0.073005488	;		TCS[4][	41	]=	0.117440249	;		TCS[5][	41	]=	0.313241064	;		TCS[6][	41	]=	0.42262701	;		TCS[7][	41	]=	0.551719149	;		TCS[8][	41	]=	0.338693636	;		TCS[9][	41	]=	0.051820356	;		TCS[10][	41	]=	0.06632701	;		TCS[11][	41	]=	0.125991416	;		TCS[12][	41	]=	0.074446895	;		TCS[13][	41	]=	0.274612582	;		TCS[14][	41	]=	0.03903566	;
	TCS[0][	42	]=	402	;		TCS[1][	42	]=	0.255288971	;		TCS[2][	42	]=	0.113574089	;		TCS[3][	42	]=	0.072973091	;		TCS[4][	42	]=	0.118592668	;		TCS[5][	42	]=	0.313541438	;		TCS[6][	42	]=	0.434477209	;		TCS[7][	42	]=	0.552476312	;		TCS[8][	42	]=	0.359331991	;		TCS[9][	42	]=	0.051800473	;		TCS[10][	42	]=	0.066560018	;		TCS[11][	42	]=	0.124819028	;		TCS[12][	42	]=	0.072774552	;		TCS[13][	42	]=	0.285043752	;		TCS[14][	42	]=	0.039017594	;
	TCS[0][	43	]=	403	;		TCS[1][	43	]=	0.254853376	;		TCS[2][	43	]=	0.114552146	;		TCS[3][	43	]=	0.072937951	;		TCS[4][	43	]=	0.119524963	;		TCS[5][	43	]=	0.31392128	;		TCS[6][	43	]=	0.445413903	;		TCS[7][	43	]=	0.553273901	;		TCS[8][	43	]=	0.379823529	;		TCS[9][	43	]=	0.051870413	;		TCS[10][	43	]=	0.066729522	;		TCS[11][	43	]=	0.123550932	;		TCS[12][	43	]=	0.07107876	;		TCS[13][	43	]=	0.295068631	;		TCS[14][	43	]=	0.038981698	;
	TCS[0][	44	]=	404	;		TCS[1][	44	]=	0.254411854	;		TCS[2][	44	]=	0.115353469	;		TCS[3][	44	]=	0.072935208	;		TCS[4][	44	]=	0.120304838	;		TCS[5][	44	]=	0.314400748	;		TCS[6][	44	]=	0.455300398	;		TCS[7][	44	]=	0.554114326	;		TCS[8][	44	]=	0.399076711	;		TCS[9][	44	]=	0.051960235	;		TCS[10][	44	]=	0.066866017	;		TCS[11][	44	]=	0.122255224	;		TCS[12][	44	]=	0.069455313	;		TCS[13][	44	]=	0.30446234	;		TCS[14][	44	]=	0.038963868	;
	TCS[0][	45	]=	405	;		TCS[1][	45	]=	0.254	;		TCS[2][	45	]=	0.116	;		TCS[3][	45	]=	0.073	;		TCS[4][	45	]=	0.121	;		TCS[5][	45	]=	0.315	;		TCS[6][	45	]=	0.464	;		TCS[7][	45	]=	0.555	;		TCS[8][	45	]=	0.416	;		TCS[9][	45	]=	0.052	;		TCS[10][	45	]=	0.067	;		TCS[11][	45	]=	0.121	;		TCS[12][	45	]=	0.068	;		TCS[13][	45	]=	0.313	;		TCS[14][	45	]=	0.039	;
	TCS[0][	46	]=	406	;		TCS[1][	46	]=	0.253640356	;		TCS[2][	46	]=	0.116516252	;		TCS[3][	46	]=	0.073154933	;		TCS[4][	46	]=	0.121665555	;		TCS[5][	46	]=	0.315727205	;		TCS[6][	46	]=	0.471432734	;		TCS[7][	46	]=	0.555923802	;		TCS[8][	46	]=	0.429778143	;		TCS[9][	46	]=	0.051935769	;		TCS[10][	46	]=	0.067156371	;		TCS[11][	46	]=	0.11983964	;		TCS[12][	46	]=	0.066787828	;		TCS[13][	46	]=	0.320504918	;		TCS[14][	46	]=	0.039116019	;
	TCS[0][	47	]=	407	;		TCS[1][	47	]=	0.253303255	;		TCS[2][	47	]=	0.116937016	;		TCS[3][	47	]=	0.073372471	;		TCS[4][	47	]=	0.122306216	;		TCS[5][	47	]=	0.316542579	;		TCS[6][	47	]=	0.477745491	;		TCS[7][	47	]=	0.556840483	;		TCS[8][	47	]=	0.440701035	;		TCS[9][	47	]=	0.051777597	;		TCS[10][	47	]=	0.067337641	;		TCS[11][	47	]=	0.118773659	;		TCS[12][	47	]=	0.065810662	;		TCS[13][	47	]=	0.326993143	;		TCS[14][	47	]=	0.039297962	;
	TCS[0][	48	]=	408	;		TCS[1][	48	]=	0.252945976	;		TCS[2][	48	]=	0.117299654	;		TCS[3][	48	]=	0.073612543	;		TCS[4][	48	]=	0.1229141	;		TCS[5][	48	]=	0.317394351	;		TCS[6][	48	]=	0.483141881	;		TCS[7][	48	]=	0.557695264	;		TCS[8][	48	]=	0.449334855	;		TCS[9][	48	]=	0.051551541	;		TCS[10][	48	]=	0.067540726	;		TCS[11][	48	]=	0.117787859	;		TCS[12][	48	]=	0.065039583	;		TCS[13][	48	]=	0.332528909	;		TCS[14][	48	]=	0.039521896	;
	TCS[0][	49	]=	409	;		TCS[1][	49	]=	0.252525798	;		TCS[2][	49	]=	0.117641528	;		TCS[3][	49	]=	0.073835076	;		TCS[4][	49	]=	0.123481323	;		TCS[5][	49	]=	0.318230749	;		TCS[6][	49	]=	0.487825514	;		TCS[7][	49	]=	0.558433363	;		TCS[8][	49	]=	0.456245783	;		TCS[9][	49	]=	0.051283657	;		TCS[10][	49	]=	0.067762541	;		TCS[11][	49	]=	0.116868039	;		TCS[12][	49	]=	0.064445668	;		TCS[13][	49	]=	0.33717645	;		TCS[14][	49	]=	0.039763887	;
	TCS[0][	50	]=	410	;		TCS[1][	50	]=	0.252	;		TCS[2][	50	]=	0.118	;		TCS[3][	50	]=	0.074	;		TCS[4][	50	]=	0.124	;		TCS[5][	50	]=	0.319	;		TCS[6][	50	]=	0.492	;		TCS[7][	50	]=	0.559	;		TCS[8][	50	]=	0.462	;		TCS[9][	50	]=	0.051	;		TCS[10][	50	]=	0.068	;		TCS[11][	50	]=	0.116	;		TCS[12][	50	]=	0.064	;		TCS[13][	50	]=	0.341	;		TCS[14][	50	]=	0.04	;
	TCS[0][	51	]=	411	;		TCS[1][	51	]=	0.25133953	;		TCS[2][	51	]=	0.118401639	;		TCS[3][	51	]=	0.074078779	;		TCS[4][	51	]=	0.124465533	;		TCS[5][	51	]=	0.319666116	;		TCS[6][	51	]=	0.495834055	;		TCS[7][	51	]=	0.559361643	;		TCS[8][	51	]=	0.467073791	;		TCS[9][	51	]=	0.05072457	;		TCS[10][	51	]=	0.068247507	;		TCS[11][	51	]=	0.115170026	;		TCS[12][	51	]=	0.063689792	;		TCS[13][	51	]=	0.344079745	;		TCS[14][	51	]=	0.040212265	;
	TCS[0][	52	]=	412	;		TCS[1][	52	]=	0.250570008	;		TCS[2][	52	]=	0.118829848	;		TCS[3][	52	]=	0.074089023	;		TCS[4][	52	]=	0.124886468	;		TCS[5][	52	]=	0.320256245	;		TCS[6][	52	]=	0.499356828	;		TCS[7][	52	]=	0.559569754	;		TCS[8][	52	]=	0.471583869	;		TCS[9][	52	]=	0.050473139	;		TCS[10][	52	]=	0.068489418	;		TCS[11][	52	]=	0.114366335	;		TCS[12][	52	]=	0.063566799	;		TCS[13][	52	]=	0.346559675	;		TCS[14][	52	]=	0.040406558	;
	TCS[0][	53	]=	413	;		TCS[1][	53	]=	0.249730721	;		TCS[2][	53	]=	0.119257238	;		TCS[3][	53	]=	0.074059878	;		TCS[4][	53	]=	0.125274636	;		TCS[5][	53	]=	0.320813315	;		TCS[6][	53	]=	0.502562572	;		TCS[7][	53	]=	0.559697043	;		TCS[8][	53	]=	0.475557051	;		TCS[9][	53	]=	0.050259423	;		TCS[10][	53	]=	0.068707574	;		TCS[11][	53	]=	0.113577632	;		TCS[12][	53	]=	0.063698909	;		TCS[13][	53	]=	0.348599733	;		TCS[14][	53	]=	0.040594718	;
	TCS[0][	54	]=	414	;		TCS[1][	54	]=	0.248860956	;		TCS[2][	54	]=	0.119656418	;		TCS[3][	54	]=	0.074020488	;		TCS[4][	54	]=	0.12564187	;		TCS[5][	54	]=	0.321380256	;		TCS[6][	54	]=	0.505445545	;		TCS[7][	54	]=	0.559816222	;		TCS[8][	54	]=	0.479020156	;		TCS[9][	54	]=	0.050097138	;		TCS[10][	54	]=	0.068883821	;		TCS[11][	54	]=	0.112792619	;		TCS[12][	54	]=	0.064154013	;		TCS[13][	54	]=	0.350359861	;		TCS[14][	54	]=	0.040788586	;
	TCS[0][	55	]=	415	;		TCS[1][	55	]=	0.248	;		TCS[2][	55	]=	0.12	;		TCS[3][	55	]=	0.074	;		TCS[4][	55	]=	0.126	;		TCS[5][	55	]=	0.322	;		TCS[6][	55	]=	0.508	;		TCS[7][	55	]=	0.56	;		TCS[8][	55	]=	0.482	;		TCS[9][	55	]=	0.05	;		TCS[10][	55	]=	0.069	;		TCS[11][	55	]=	0.112	;		TCS[12][	55	]=	0.065	;		TCS[13][	55	]=	0.352	;		TCS[14][	55	]=	0.041	;
	TCS[0][	56	]=	416	;		TCS[1][	56	]=	0.247177522	;		TCS[2][	56	]=	0.120269192	;		TCS[3][	56	]=	0.074017949	;		TCS[4][	56	]=	0.126360313	;		TCS[5][	56	]=	0.322704329	;		TCS[6][	56	]=	0.510231046	;		TCS[7][	56	]=	0.560293626	;		TCS[8][	56	]=	0.484518691	;		TCS[9][	56	]=	0.049973952	;		TCS[10][	56	]=	0.0690456	;		TCS[11][	56	]=	0.111192258	;		TCS[12][	56	]=	0.066285004	;		TCS[13][	56	]=	0.353640103	;		TCS[14][	56	]=	0.041234923	;
	TCS[0][	57	]=	417	;		TCS[1][	57	]=	0.246384712	;		TCS[2][	57	]=	0.120479591	;		TCS[3][	57	]=	0.074055435	;		TCS[4][	57	]=	0.126731912	;		TCS[5][	57	]=	0.323480442	;		TCS[6][	57	]=	0.512187199	;		TCS[7][	57	]=	0.560632501	;		TCS[8][	57	]=	0.486579488	;		TCS[9][	57	]=	0.049993848	;		TCS[10][	57	]=	0.069040689	;		TCS[11][	57	]=	0.110377	;		TCS[12][	57	]=	0.067978143	;		TCS[13][	57	]=	0.355240157	;		TCS[14][	57	]=	0.041475808	;
	TCS[0][	58	]=	418	;		TCS[1][	58	]=	0.245603141	;		TCS[2][	58	]=	0.120655395	;		TCS[3][	58	]=	0.074083946	;		TCS[4][	58	]=	0.127123355	;		TCS[5][	58	]=	0.324304391	;		TCS[6][	58	]=	0.51392783	;		TCS[7][	58	]=	0.560924563	;		TCS[8][	58	]=	0.48818094	;		TCS[9][	58	]=	0.050026767	;		TCS[10][	58	]=	0.069012977	;		TCS[11][	58	]=	0.109565612	;		TCS[12][	58	]=	0.07002878	;		TCS[13][	58	]=	0.356720159	;		TCS[14][	58	]=	0.041699231	;
	TCS[0][	59	]=	419	;		TCS[1][	59	]=	0.24481438	;		TCS[2][	59	]=	0.1208208	;		TCS[3][	59	]=	0.074074971	;		TCS[4][	59	]=	0.127543198	;		TCS[5][	59	]=	0.325152226	;		TCS[6][	59	]=	0.515512307	;		TCS[7][	59	]=	0.56107775	;		TCS[8][	59	]=	0.489321594	;		TCS[9][	59	]=	0.050039791	;		TCS[10][	59	]=	0.068990177	;		TCS[11][	59	]=	0.108769483	;		TCS[12][	59	]=	0.072386278	;		TCS[13][	59	]=	0.358000108	;		TCS[14][	59	]=	0.04188177	;
	TCS[0][	60	]=	420	;		TCS[1][	60	]=	0.244	;		TCS[2][	60	]=	0.121	;		TCS[3][	60	]=	0.074	;		TCS[4][	60	]=	0.128	;		TCS[5][	60	]=	0.326	;		TCS[6][	60	]=	0.517	;		TCS[7][	60	]=	0.561	;		TCS[8][	60	]=	0.49	;		TCS[9][	60	]=	0.05	;		TCS[10][	60	]=	0.069	;		TCS[11][	60	]=	0.108	;		TCS[12][	60	]=	0.075	;		TCS[13][	60	]=	0.359	;		TCS[14][	60	]=	0.042	;
	TCS[0][	61	]=	421	;		TCS[1][	61	]=	0.243150382	;		TCS[2][	61	]=	0.121209594	;		TCS[3][	61	]=	0.073841423	;		TCS[4][	61	]=	0.128501214	;		TCS[5][	61	]=	0.326828566	;		TCS[6][	61	]=	0.518441762	;		TCS[7][	61	]=	0.560631851	;		TCS[8][	61	]=	0.490227445	;		TCS[9][	61	]=	0.049883621	;		TCS[10][	61	]=	0.069066092	;		TCS[11][	61	]=	0.107268943	;		TCS[12][	61	]=	0.077842191	;		TCS[13][	61	]=	0.359671845	;		TCS[14][	61	]=	0.042040044	;
	TCS[0][	62	]=	422	;		TCS[1][	62	]=	0.242291144	;		TCS[2][	62	]=	0.121435786	;		TCS[3][	62	]=	0.073625237	;		TCS[4][	62	]=	0.129049883	;		TCS[5][	62	]=	0.327637986	;		TCS[6][	62	]=	0.519854376	;		TCS[7][	62	]=	0.560044241	;		TCS[8][	62	]=	0.490066179	;		TCS[9][	62	]=	0.04970347	;		TCS[10][	62	]=	0.069195828	;		TCS[11][	62	]=	0.106589667	;		TCS[12][	62	]=	0.080976628	;		TCS[13][	62	]=	0.360095699	;		TCS[14][	62	]=	0.042026211	;
	TCS[0][	63	]=	423	;		TCS[1][	63	]=	0.241456716	;		TCS[2][	63	]=	0.12165718	;		TCS[3][	63	]=	0.073388339	;		TCS[4][	63	]=	0.129647945	;		TCS[5][	63	]=	0.328433123	;		TCS[6][	63	]=	0.521246109	;		TCS[7][	63	]=	0.559340704	;		TCS[8][	63	]=	0.48959119	;		TCS[9][	63	]=	0.049481508	;		TCS[10][	63	]=	0.069392519	;		TCS[11][	63	]=	0.105975919	;		TCS[12][	63	]=	0.084489969	;		TCS[13][	63	]=	0.360383631	;		TCS[14][	63	]=	0.041992356	;
	TCS[0][	64	]=	424	;		TCS[1][	64	]=	0.240681525	;		TCS[2][	64	]=	0.121852383	;		TCS[3][	64	]=	0.073167627	;		TCS[4][	64	]=	0.130297338	;		TCS[5][	64	]=	0.32921884	;		TCS[6][	64	]=	0.522625228	;		TCS[7][	64	]=	0.558624779	;		TCS[8][	64	]=	0.488877467	;		TCS[9][	64	]=	0.049239698	;		TCS[10][	64	]=	0.069659473	;		TCS[11][	64	]=	0.105441447	;		TCS[12][	64	]=	0.088468873	;		TCS[13][	64	]=	0.360647708	;		TCS[14][	64	]=	0.041972334	;
	TCS[0][	65	]=	425	;		TCS[1][	65	]=	0.24	;		TCS[2][	65	]=	0.122	;		TCS[3][	65	]=	0.073	;		TCS[4][	65	]=	0.131	;		TCS[5][	65	]=	0.33	;		TCS[6][	65	]=	0.524	;		TCS[7][	65	]=	0.558	;		TCS[8][	65	]=	0.488	;		TCS[9][	65	]=	0.049	;		TCS[10][	65	]=	0.07	;		TCS[11][	65	]=	0.105	;		TCS[12][	65	]=	0.093	;		TCS[13][	65	]=	0.361	;		TCS[14][	65	]=	0.042	;
	TCS[0][	66	]=	426	;		TCS[1][	66	]=	0.239428951	;		TCS[2][	66	]=	0.122084432	;		TCS[3][	66	]=	0.072912359	;		TCS[4][	66	]=	0.131754829	;		TCS[5][	66	]=	0.330781405	;		TCS[6][	66	]=	0.525377907	;		TCS[7][	66	]=	0.557538968	;		TCS[8][	66	]=	0.487019528	;		TCS[9][	66	]=	0.048779562	;		TCS[10][	66	]=	0.070410033	;		TCS[11][	66	]=	0.10465997	;		TCS[12][	66	]=	0.098138232	;		TCS[13][	66	]=	0.361520518	;		TCS[14][	66	]=	0.0421009	;
	TCS[0][	67	]=	427	;		TCS[1][	67	]=	0.238914711	;		TCS[2][	67	]=	0.122113265	;		TCS[3][	67	]=	0.072891618	;		TCS[4][	67	]=	0.132548555	;		TCS[5][	67	]=	0.331567613	;		TCS[6][	67	]=	0.526763297	;		TCS[7][	67	]=	0.557190536	;		TCS[8][	67	]=	0.485939797	;		TCS[9][	67	]=	0.048576272	;		TCS[10][	67	]=	0.070855999	;		TCS[11][	67	]=	0.104408334	;		TCS[12][	67	]=	0.103811346	;		TCS[13][	67	]=	0.362161048	;		TCS[14][	67	]=	0.042267347	;
	TCS[0][	68	]=	428	;		TCS[1][	68	]=	0.238385996	;		TCS[2][	68	]=	0.122099883	;		TCS[3][	68	]=	0.072914699	;		TCS[4][	68	]=	0.133364866	;		TCS[5][	68	]=	0.332363117	;		TCS[6][	68	]=	0.528159733	;		TCS[7][	68	]=	0.55687262	;		TCS[8][	68	]=	0.484750301	;		TCS[9][	68	]=	0.0483832	;		TCS[10][	68	]=	0.071296948	;		TCS[11][	68	]=	0.104226713	;		TCS[12][	68	]=	0.109915344	;		TCS[13][	68	]=	0.362841319	;		TCS[14][	68	]=	0.042483343	;
	TCS[0][	69	]=	429	;		TCS[1][	69	]=	0.237771521	;		TCS[2][	69	]=	0.122057667	;		TCS[3][	69	]=	0.07295852	;		TCS[4][	69	]=	0.134187452	;		TCS[5][	69	]=	0.333172415	;		TCS[6][	69	]=	0.52957078	;		TCS[7][	69	]=	0.556503136	;		TCS[8][	69	]=	0.483440537	;		TCS[9][	69	]=	0.048193419	;		TCS[10][	69	]=	0.071691932	;		TCS[11][	69	]=	0.104096728	;		TCS[12][	69	]=	0.116346228	;		TCS[13][	69	]=	0.36348106	;		TCS[14][	69	]=	0.042732893	;
	TCS[0][	70	]=	430	;		TCS[1][	70	]=	0.237	;		TCS[2][	70	]=	0.122	;		TCS[3][	70	]=	0.073	;		TCS[4][	70	]=	0.135	;		TCS[5][	70	]=	0.334	;		TCS[6][	70	]=	0.531	;		TCS[7][	70	]=	0.556	;		TCS[8][	70	]=	0.482	;		TCS[9][	70	]=	0.048	;		TCS[10][	70	]=	0.072	;		TCS[11][	70	]=	0.104	;		TCS[12][	70	]=	0.123	;		TCS[13][	70	]=	0.364	;		TCS[14][	70	]=	0.043	;
	TCS[0][	71	]=	431	;		TCS[1][	71	]=	0.236029815	;		TCS[2][	71	]=	0.121940679	;		TCS[3][	71	]=	0.073021143	;		TCS[4][	71	]=	0.13579147	;		TCS[5][	71	]=	0.334853812	;		TCS[6][	71	]=	0.53244661	;		TCS[7][	71	]=	0.555300275	;		TCS[8][	71	]=	0.480422442	;		TCS[9][	71	]=	0.047798129	;		TCS[10][	71	]=	0.072197776	;		TCS[11][	71	]=	0.103923175	;		TCS[12][	71	]=	0.129804883	;		TCS[13][	71	]=	0.364342083	;		TCS[14][	71	]=	0.043268355	;
	TCS[0][	72	]=	432	;		TCS[1][	72	]=	0.23493801	;		TCS[2][	72	]=	0.121895154	;		TCS[3][	72	]=	0.073024289	;		TCS[4][	72	]=	0.136571898	;		TCS[5][	72	]=	0.335755563	;		TCS[6][	72	]=	0.533892437	;		TCS[7][	72	]=	0.554417614	;		TCS[8][	72	]=	0.478718635	;		TCS[9][	72	]=	0.047591442	;		TCS[10][	72	]=	0.072332177	;		TCS[11][	72	]=	0.103872996	;		TCS[12][	72	]=	0.13681799	;		TCS[13][	72	]=	0.36454811	;		TCS[14][	72	]=	0.043520402	;
	TCS[0][	73	]=	433	;		TCS[1][	73	]=	0.233831299	;		TCS[2][	73	]=	0.121879289	;		TCS[3][	73	]=	0.073016865	;		TCS[4][	73	]=	0.137356591	;		TCS[5][	73	]=	0.336730408	;		TCS[6][	73	]=	0.535314958	;		TCS[7][	73	]=	0.553384815	;		TCS[8][	73	]=	0.476903607	;		TCS[9][	73	]=	0.047385692	;		TCS[10][	73	]=	0.072467688	;		TCS[11][	73	]=	0.10386123	;		TCS[12][	73	]=	0.144128655	;		TCS[13][	73	]=	0.364683095	;		TCS[14][	73	]=	0.043738271	;
	TCS[0][	74	]=	434	;		TCS[1][	74	]=	0.232816391	;		TCS[2][	74	]=	0.12190895	;		TCS[3][	74	]=	0.073006293	;		TCS[4][	74	]=	0.138160856	;		TCS[5][	74	]=	0.337803502	;		TCS[6][	74	]=	0.536691653	;		TCS[7][	74	]=	0.552234677	;		TCS[8][	74	]=	0.474992386	;		TCS[9][	74	]=	0.047186627	;		TCS[10][	74	]=	0.0726688	;		TCS[11][	74	]=	0.103899642	;		TCS[12][	74	]=	0.151826213	;		TCS[13][	74	]=	0.364812053	;		TCS[14][	74	]=	0.043904094	;
	TCS[0][	75	]=	435	;		TCS[1][	75	]=	0.232	;		TCS[2][	75	]=	0.122	;		TCS[3][	75	]=	0.073	;		TCS[4][	75	]=	0.139	;		TCS[5][	75	]=	0.339	;		TCS[6][	75	]=	0.538	;		TCS[7][	75	]=	0.551	;		TCS[8][	75	]=	0.473	;		TCS[9][	75	]=	0.047	;		TCS[10][	75	]=	0.073	;		TCS[11][	75	]=	0.104	;		TCS[12][	75	]=	0.16	;		TCS[13][	75	]=	0.365	;		TCS[14][	75	]=	0.044	;
	TCS[0][	76	]=	436	;		TCS[1][	76	]=	0.231451791	;		TCS[2][	76	]=	0.122160854	;		TCS[3][	76	]=	0.07300307	;		TCS[4][	76	]=	0.139887293	;		TCS[5][	76	]=	0.340331346	;		TCS[6][	76	]=	0.539227651	;		TCS[7][	76	]=	0.54970793	;		TCS[8][	76	]=	0.470938705	;		TCS[9][	76	]=	0.046827923	;		TCS[10][	76	]=	0.073502861	;		TCS[11][	76	]=	0.104167328	;		TCS[12][	76	]=	0.168706237	;		TCS[13][	76	]=	0.365295149	;		TCS[14][	76	]=	0.044017678	;
	TCS[0][	77	]=	437	;		TCS[1][	77	]=	0.231093248	;		TCS[2][	77	]=	0.122370121	;		TCS[3][	77	]=	0.073011224	;		TCS[4][	77	]=	0.140827855	;		TCS[5][	77	]=	0.341754135	;		TCS[6][	77	]=	0.540402955	;		TCS[7][	77	]=	0.548363007	;		TCS[8][	77	]=	0.468809665	;		TCS[9][	77	]=	0.046657959	;		TCS[10][	77	]=	0.074127295	;		TCS[11][	77	]=	0.104379681	;		TCS[12][	77	]=	0.177868696	;		TCS[13][	77	]=	0.365678513	;		TCS[14][	77	]=	0.043987045	;
	TCS[0][	78	]=	438	;		TCS[1][	78	]=	0.230808809	;		TCS[2][	78	]=	0.122598961	;		TCS[3][	78	]=	0.073017843	;		TCS[4][	78	]=	0.141824771	;		TCS[5][	78	]=	0.343211252	;		TCS[6][	78	]=	0.541564434	;		TCS[7][	78	]=	0.546964119	;		TCS[8][	78	]=	0.466611272	;		TCS[9][	78	]=	0.046474033	;		TCS[10][	78	]=	0.074800299	;		TCS[11][	78	]=	0.104608369	;		TCS[12][	78	]=	0.187378036	;		TCS[13][	78	]=	0.366114302	;		TCS[14][	78	]=	0.043947572	;
	TCS[0][	79	]=	439	;		TCS[1][	79	]=	0.230482914	;		TCS[2][	79	]=	0.122818534	;		TCS[3][	79	]=	0.073016308	;		TCS[4][	79	]=	0.142881125	;		TCS[5][	79	]=	0.344645579	;		TCS[6][	79	]=	0.542750608	;		TCS[7][	79	]=	0.545510154	;		TCS[8][	79	]=	0.46434192	;		TCS[9][	79	]=	0.046260072	;		TCS[10][	79	]=	0.075448868	;		TCS[11][	79	]=	0.104824705	;		TCS[12][	79	]=	0.197124918	;		TCS[13][	79	]=	0.366566727	;		TCS[14][	79	]=	0.043938732	;
	TCS[0][	80	]=	440	;		TCS[1][	80	]=	0.23	;		TCS[2][	80	]=	0.123	;		TCS[3][	80	]=	0.073	;		TCS[4][	80	]=	0.144	;		TCS[5][	80	]=	0.346	;		TCS[6][	80	]=	0.544	;		TCS[7][	80	]=	0.544	;		TCS[8][	80	]=	0.462	;		TCS[9][	80	]=	0.046	;		TCS[10][	80	]=	0.076	;		TCS[11][	80	]=	0.105	;		TCS[12][	80	]=	0.207	;		TCS[13][	80	]=	0.367	;		TCS[14][	80	]=	0.044	;
	TCS[0][	81	]=	441	;		TCS[1][	81	]=	0.229283022	;		TCS[2][	81	]=	0.123127907	;		TCS[3][	81	]=	0.072966578	;		TCS[4][	81	]=	0.14518736	;		TCS[5][	81	]=	0.347236804	;		TCS[6][	81	]=	0.545338784	;		TCS[7][	81	]=	0.542428005	;		TCS[8][	81	]=	0.45959074	;		TCS[9][	81	]=	0.04568218	;		TCS[10][	81	]=	0.076406779	;		TCS[11][	81	]=	0.105119512	;		TCS[12][	81	]=	0.21690617	;		TCS[13][	81	]=	0.36738932	;		TCS[14][	81	]=	0.044156931	;
	TCS[0][	82	]=	442	;		TCS[1][	82	]=	0.228408999	;		TCS[2][	82	]=	0.123240363	;		TCS[3][	82	]=	0.072930816	;		TCS[4][	82	]=	0.146460683	;		TCS[5][	82	]=	0.348395896	;		TCS[6][	82	]=	0.546743741	;		TCS[7][	82	]=	0.540770358	;		TCS[8][	82	]=	0.457146707	;		TCS[9][	82	]=	0.045312723	;		TCS[10][	82	]=	0.076726643	;		TCS[11][	82	]=	0.105224282	;		TCS[12][	82	]=	0.226795228	;		TCS[13][	82	]=	0.367753839	;		TCS[14][	82	]=	0.04437942	;
	TCS[0][	83	]=	443	;		TCS[1][	83	]=	0.227493465	;		TCS[2][	83	]=	0.123388866	;		TCS[3][	83	]=	0.072911764	;		TCS[4][	83	]=	0.147840326	;		TCS[5][	83	]=	0.349536586	;		TCS[6][	83	]=	0.548179307	;		TCS[7][	83	]=	0.538998708	;		TCS[8][	83	]=	0.454707304	;		TCS[9][	83	]=	0.044902176	;		TCS[10][	83	]=	0.077043117	;		TCS[11][	83	]=	0.105369295	;		TCS[12][	83	]=	0.2366312	;		TCS[13][	83	]=	0.368123698	;		TCS[14][	83	]=	0.044623442	;
	TCS[0][	84	]=	444	;		TCS[1][	84	]=	0.226651954	;		TCS[2][	84	]=	0.123624912	;		TCS[3][	84	]=	0.072928475	;		TCS[4][	84	]=	0.149346646	;		TCS[5][	84	]=	0.350718184	;		TCS[6][	84	]=	0.549609915	;		TCS[7][	84	]=	0.537084706	;		TCS[8][	84	]=	0.452311934	;		TCS[9][	84	]=	0.044461086	;		TCS[10][	84	]=	0.077439728	;		TCS[11][	84	]=	0.105609539	;		TCS[12][	84	]=	0.246378115	;		TCS[13][	84	]=	0.368529038	;		TCS[14][	84	]=	0.044844977	;
	TCS[0][	85	]=	445	;		TCS[1][	85	]=	0.226	;		TCS[2][	85	]=	0.124	;		TCS[3][	85	]=	0.073	;		TCS[4][	85	]=	0.151	;		TCS[5][	85	]=	0.352	;		TCS[6][	85	]=	0.551	;		TCS[7][	85	]=	0.535	;		TCS[8][	85	]=	0.45	;		TCS[9][	85	]=	0.044	;		TCS[10][	85	]=	0.078	;		TCS[11][	85	]=	0.106	;		TCS[12][	85	]=	0.256	;		TCS[13][	85	]=	0.369	;		TCS[14][	85	]=	0.045	;
	TCS[0][	86	]=	446	;		TCS[1][	86	]=	0.22561612	;		TCS[2][	86	]=	0.124543518	;		TCS[3][	86	]=	0.073138617	;		TCS[4][	86	]=	0.152811268	;		TCS[5][	86	]=	0.353425438	;		TCS[6][	86	]=	0.552313214	;		TCS[7][	86	]=	0.532724051	;		TCS[8][	86	]=	0.447794336	;		TCS[9][	86	]=	0.043531356	;		TCS[10][	86	]=	0.078782022	;		TCS[11][	86	]=	0.106578624	;		TCS[12][	86	]=	0.265453083	;		TCS[13][	86	]=	0.369555571	;		TCS[14][	86	]=	0.045058596	;
	TCS[0][	87	]=	447	;		TCS[1][	87	]=	0.225430756	;		TCS[2][	87	]=	0.125196426	;		TCS[3][	87	]=	0.073329513	;		TCS[4][	87	]=	0.154753414	;		TCS[5][	87	]=	0.354974281	;		TCS[6][	87	]=	0.55351008	;		TCS[7][	87	]=	0.530267562	;		TCS[8][	87	]=	0.445651507	;		TCS[9][	87	]=	0.043075148	;		TCS[10][	87	]=	0.079742133	;		TCS[11][	87	]=	0.107315193	;		TCS[12][	87	]=	0.274662394	;		TCS[13][	87	]=	0.370170131	;		TCS[14][	87	]=	0.045047277	;
	TCS[0][	88	]=	448	;		TCS[1][	88	]=	0.225337332	;		TCS[2][	88	]=	0.125877575	;		TCS[3][	88	]=	0.0735511	;		TCS[4][	88	]=	0.156789927	;		TCS[5][	88	]=	0.356610405	;		TCS[6][	88	]=	0.554550339	;		TCS[7][	88	]=	0.527649048	;		TCS[8][	88	]=	0.44351151	;		TCS[9][	88	]=	0.042653263	;		TCS[10][	88	]=	0.080811232	;		TCS[11][	88	]=	0.108162451	;		TCS[12][	88	]=	0.283545163	;		TCS[13][	88	]=	0.370806905	;		TCS[14][	88	]=	0.045006659	;
	TCS[0][	89	]=	449	;		TCS[1][	89	]=	0.225229272	;		TCS[2][	89	]=	0.126505816	;		TCS[3][	89	]=	0.073781791	;		TCS[4][	89	]=	0.158884293	;		TCS[5][	89	]=	0.358297686	;		TCS[6][	89	]=	0.555393732	;		TCS[7][	89	]=	0.524887022	;		TCS[8][	89	]=	0.441314342	;		TCS[9][	89	]=	0.042287585	;		TCS[10][	89	]=	0.081920221	;		TCS[11][	89	]=	0.109073139	;		TCS[12][	89	]=	0.292018622	;		TCS[13][	89	]=	0.371429119	;		TCS[14][	89	]=	0.044977361	;
	TCS[0][	90	]=	450	;		TCS[1][	90	]=	0.225	;		TCS[2][	90	]=	0.127	;		TCS[3][	90	]=	0.074	;		TCS[4][	90	]=	0.161	;		TCS[5][	90	]=	0.36	;		TCS[6][	90	]=	0.556	;		TCS[7][	90	]=	0.522	;		TCS[8][	90	]=	0.439	;		TCS[9][	90	]=	0.042	;		TCS[10][	90	]=	0.083	;		TCS[11][	90	]=	0.11	;		TCS[12][	90	]=	0.3	;		TCS[13][	90	]=	0.372	;		TCS[14][	90	]=	0.045	;
	TCS[0][	91	]=	451	;		TCS[1][	91	]=	0.224572497	;		TCS[2][	91	]=	0.12730602	;		TCS[3][	91	]=	0.074190953	;		TCS[4][	91	]=	0.163111569	;		TCS[5][	91	]=	0.361693443	;		TCS[6][	91	]=	0.556344361	;		TCS[7][	91	]=	0.519003791	;		TCS[8][	91	]=	0.436527916	;		TCS[9][	91	]=	0.041800397	;		TCS[10][	91	]=	0.084001132	;		TCS[11][	91	]=	0.110909993	;		TCS[12][	91	]=	0.307417499	;		TCS[13][	91	]=	0.372492395	;		TCS[14][	91	]=	0.045104683	;
	TCS[0][	92	]=	452	;		TCS[1][	92	]=	0.223987976	;		TCS[2][	92	]=	0.127477933	;		TCS[3][	92	]=	0.074367133	;		TCS[4][	92	]=	0.16523766	;		TCS[5][	92	]=	0.363402979	;		TCS[6][	92	]=	0.556463939	;		TCS[7][	92	]=	0.515903394	;		TCS[8][	92	]=	0.433935264	;		TCS[9][	92	]=	0.041650683	;		TCS[10][	92	]=	0.084952826	;		TCS[11][	92	]=	0.111826945	;		TCS[12][	92	]=	0.314243198	;		TCS[13][	92	]=	0.372917638	;		TCS[14][	92	]=	0.045279472	;
	TCS[0][	93	]=	453	;		TCS[1][	93	]=	0.223317207	;		TCS[2][	93	]=	0.127596835	;		TCS[3][	93	]=	0.074547837	;		TCS[4][	93	]=	0.167407967	;		TCS[5][	93	]=	0.365165795	;		TCS[6][	93	]=	0.556411338	;		TCS[7][	93	]=	0.5127011	;		TCS[8][	93	]=	0.431278654	;		TCS[9][	93	]=	0.041500772	;		TCS[10][	93	]=	0.085903954	;		TCS[11][	93	]=	0.112788901	;		TCS[12][	93	]=	0.320460148	;		TCS[13][	93	]=	0.373296683	;		TCS[14][	93	]=	0.045501921	;
	TCS[0][	94	]=	454	;		TCS[1][	94	]=	0.222630958	;		TCS[2][	94	]=	0.127743825	;		TCS[3][	94	]=	0.07475236	;		TCS[4][	94	]=	0.169652182	;		TCS[5][	94	]=	0.367019074	;		TCS[6][	94	]=	0.556239157	;		TCS[7][	94	]=	0.509399205	;		TCS[8][	94	]=	0.428614696	;		TCS[9][	94	]=	0.041300573	;		TCS[10][	94	]=	0.086903388	;		TCS[11][	94	]=	0.113833905	;		TCS[12][	94	]=	0.326051398	;		TCS[13][	94	]=	0.373650485	;		TCS[14][	94	]=	0.045749579	;
	TCS[0][	95	]=	455	;		TCS[1][	95	]=	0.222	;		TCS[2][	95	]=	0.128	;		TCS[3][	95	]=	0.075	;		TCS[4][	95	]=	0.172	;		TCS[5][	95	]=	0.369	;		TCS[6][	95	]=	0.556	;		TCS[7][	95	]=	0.506	;		TCS[8][	95	]=	0.426	;		TCS[9][	95	]=	0.041	;		TCS[10][	95	]=	0.088	;		TCS[11][	95	]=	0.115	;		TCS[12][	95	]=	0.331	;		TCS[13][	95	]=	0.374	;		TCS[14][	95	]=	0.046	;
	TCS[0][	96	]=	456	;		TCS[1][	96	]=	0.22147789	;		TCS[2][	96	]=	0.128424401	;		TCS[3][	96	]=	0.075305571	;		TCS[4][	96	]=	0.174478455	;		TCS[5][	96	]=	0.371136791	;		TCS[6][	96	]=	0.555733343	;		TCS[7][	96	]=	0.502508783	;		TCS[8][	96	]=	0.423470001	;		TCS[9][	96	]=	0.040563057	;		TCS[10][	96	]=	0.089229451	;		TCS[11][	96	]=	0.116317404	;		TCS[12][	96	]=	0.335292923	;		TCS[13][	96	]=	0.374362848	;		TCS[14][	96	]=	0.046234672	;
	TCS[0][	97	]=	457	;		TCS[1][	97	]=	0.221049338	;		TCS[2][	97	]=	0.128987843	;		TCS[3][	97	]=	0.075665955	;		TCS[4][	97	]=	0.177103944	;		TCS[5][	97	]=	0.373421801	;		TCS[6][	97	]=	0.555426163	;		TCS[7][	97	]=	0.498942863	;		TCS[8][	97	]=	0.420975438	;		TCS[9][	97	]=	0.040010118	;		TCS[10][	97	]=	0.090574564	;		TCS[11][	97	]=	0.117785025	;		TCS[12][	97	]=	0.338932816	;		TCS[13][	97	]=	0.374743318	;		TCS[14][	97	]=	0.046450833	;
	TCS[0][	98	]=	458	;		TCS[1][	98	]=	0.220681841	;		TCS[2][	98	]=	0.129639085	;		TCS[3][	98	]=	0.076073554	;		TCS[4][	98	]=	0.179890206	;		TCS[5][	98	]=	0.375838415	;		TCS[6][	98	]=	0.555052311	;		TCS[7][	98	]=	0.495322551	;		TCS[8][	98	]=	0.418445875	;		TCS[9][	98	]=	0.039375651	;		TCS[10][	98	]=	0.092004951	;		TCS[11][	98	]=	0.119393944	;		TCS[12][	98	]=	0.341926247	;		TCS[13][	98	]=	0.375142363	;		TCS[14][	98	]=	0.046649658	;
	TCS[0][	99	]=	459	;		TCS[1][	99	]=	0.220342896	;		TCS[2][	99	]=	0.130326884	;		TCS[3][	99	]=	0.076520769	;		TCS[4][	99	]=	0.182850979	;		TCS[5][	99	]=	0.378370019	;		TCS[6][	99	]=	0.554585639	;		TCS[7][	99	]=	0.491668159	;		TCS[8][	99	]=	0.415810874	;		TCS[9][	99	]=	0.038694122	;		TCS[10][	99	]=	0.093490226	;		TCS[11][	99	]=	0.121135242	;		TCS[12][	99	]=	0.344279785	;		TCS[13][	99	]=	0.375560939	;		TCS[14][	99	]=	0.046832322	;
	TCS[0][	100	]=	460	;		TCS[1][	100	]=	0.22	;		TCS[2][	100	]=	0.131	;		TCS[3][	100	]=	0.077	;		TCS[4][	100	]=	0.186	;		TCS[5][	100	]=	0.381	;		TCS[6][	100	]=	0.554	;		TCS[7][	100	]=	0.488	;		TCS[8][	100	]=	0.413	;		TCS[9][	100	]=	0.038	;		TCS[10][	100	]=	0.095	;		TCS[11][	100	]=	0.123	;		TCS[12][	100	]=	0.346	;		TCS[13][	100	]=	0.376	;		TCS[14][	100	]=	0.047	;
	TCS[0][	101	]=	461	;		TCS[1][	101	]=	0.219627941	;		TCS[2][	101	]=	0.131620375	;		TCS[3][	101	]=	0.077506765	;		TCS[4][	101	]=	0.189350611	;		TCS[5][	101	]=	0.383703392	;		TCS[6][	101	]=	0.553274268	;		TCS[7][	101	]=	0.484329076	;		TCS[8][	101	]=	0.409968078	;		TCS[9][	101	]=	0.037323376	;		TCS[10][	101	]=	0.096513064	;		TCS[11][	101	]=	0.12498039	;		TCS[12][	101	]=	0.34710681	;		TCS[13][	101	]=	0.376464212	;		TCS[14][	101	]=	0.047156629	;
	TCS[0][	102	]=	462	;		TCS[1][	102	]=	0.21923067	;		TCS[2][	102	]=	0.132202694	;		TCS[3][	102	]=	0.078049047	;		TCS[4][	102	]=	0.192914563	;		TCS[5][	102	]=	0.386421817	;		TCS[6][	102	]=	0.552407411	;		TCS[7][	102	]=	0.480629155	;		TCS[8][	102	]=	0.406770983	;		TCS[9][	102	]=	0.036676846	;		TCS[10][	102	]=	0.098044919	;		TCS[11][	102	]=	0.127072953	;		TCS[12][	102	]=	0.34767354	;		TCS[13][	102	]=	0.376973091	;		TCS[14][	102	]=	0.047317195	;
	TCS[0][	103	]=	463	;		TCS[1][	103	]=	0.218819429	;		TCS[2][	103	]=	0.132774825	;		TCS[3][	103	]=	0.078637947	;		TCS[4][	103	]=	0.196703209	;		TCS[5][	103	]=	0.389088546	;		TCS[6][	103	]=	0.551403419	;		TCS[7][	103	]=	0.476864696	;		TCS[8][	103	]=	0.403489848	;		TCS[9][	103	]=	0.036068626	;		TCS[10][	103	]=	0.099620241	;		TCS[11][	103	]=	0.129275321	;		TCS[12][	103	]=	0.347786865	;		TCS[13][	103	]=	0.377549864	;		TCS[14][	103	]=	0.047499447	;
	TCS[0][	104	]=	464	;		TCS[1][	104	]=	0.218405458	;		TCS[2][	104	]=	0.133364637	;		TCS[3][	104	]=	0.079284565	;		TCS[4][	104	]=	0.200727904	;		TCS[5][	104	]=	0.39163685	;		TCS[6][	104	]=	0.550266285	;		TCS[7][	104	]=	0.473000158	;		TCS[8][	104	]=	0.400205808	;		TCS[9][	104	]=	0.035506938	;		TCS[10][	104	]=	0.101263709	;		TCS[11][	104	]=	0.131585126	;		TCS[12][	104	]=	0.34753346	;		TCS[13][	104	]=	0.378217758	;		TCS[14][	104	]=	0.047721132	;
	TCS[0][	105	]=	465	;		TCS[1][	105	]=	0.218	;		TCS[2][	105	]=	0.134	;		TCS[3][	105	]=	0.08	;		TCS[4][	105	]=	0.205	;		TCS[5][	105	]=	0.394	;		TCS[6][	105	]=	0.549	;		TCS[7][	105	]=	0.469	;		TCS[8][	105	]=	0.397	;		TCS[9][	105	]=	0.035	;		TCS[10][	105	]=	0.103	;		TCS[11][	105	]=	0.134	;		TCS[12][	105	]=	0.347	;		TCS[13][	105	]=	0.379	;		TCS[14][	105	]=	0.048	;
	TCS[0][	106	]=	466	;		TCS[1][	106	]=	0.217610345	;		TCS[2][	106	]=	0.134702098	;		TCS[3][	106	]=	0.08079537	;		TCS[4][	106	]=	0.209519101	;		TCS[5][	106	]=	0.396129642	;		TCS[6][	106	]=	0.547609586	;		TCS[7][	106	]=	0.464846913	;		TCS[8][	106	]=	0.393929685	;		TCS[9][	106	]=	0.034551437	;		TCS[10][	106	]=	0.104846292	;		TCS[11][	106	]=	0.136521034	;		TCS[12][	106	]=	0.346255836	;		TCS[13][	106	]=	0.379908303	;		TCS[14][	106	]=	0.048346812	;
	TCS[0][	107	]=	467	;		TCS[1][	107	]=	0.217227981	;		TCS[2][	107	]=	0.135465382	;		TCS[3][	107	]=	0.081681856	;		TCS[4][	107	]=	0.214237805	;		TCS[5][	107	]=	0.398050932	;		TCS[6][	107	]=	0.546104195	;		TCS[7][	107	]=	0.460596518	;		TCS[8][	107	]=	0.390956631	;		TCS[9][	107	]=	0.0341465	;		TCS[10][	107	]=	0.106789762	;		TCS[11][	107	]=	0.139163161	;		TCS[12][	107	]=	0.345301024	;		TCS[13][	107	]=	0.380908319	;		TCS[14][	107	]=	0.048744387	;
	TCS[0][	108	]=	468	;		TCS[1][	108	]=	0.216840444	;		TCS[2][	108	]=	0.136277616	;		TCS[3][	108	]=	0.082670658	;		TCS[4][	108	]=	0.219096958	;		TCS[5][	108	]=	0.399807401	;		TCS[6][	108	]=	0.544494012	;		TCS[7][	108	]=	0.456322666	;		TCS[8][	108	]=	0.388018735	;		TCS[9][	108	]=	0.033765844	;		TCS[10][	108	]=	0.108810086	;		TCS[11][	108	]=	0.14194477	;		TCS[12][	108	]=	0.344118293	;		TCS[13][	108	]=	0.381954182	;		TCS[14][	108	]=	0.049168555	;
	TCS[0][	109	]=	469	;		TCS[1][	109	]=	0.216435272	;		TCS[2][	109	]=	0.137126567	;		TCS[3][	109	]=	0.083772973	;		TCS[4][	109	]=	0.224037407	;		TCS[5][	109	]=	0.401442579	;		TCS[6][	109	]=	0.542789219	;		TCS[7][	109	]=	0.452099209	;		TCS[8][	109	]=	0.385053893	;		TCS[9][	109	]=	0.033390126	;		TCS[10][	109	]=	0.11088694	;		TCS[11][	109	]=	0.144884253	;		TCS[12][	109	]=	0.342690375	;		TCS[13][	109	]=	0.383000031	;		TCS[14][	109	]=	0.049595149	;
	TCS[0][	110	]=	470	;		TCS[1][	110	]=	0.216	;		TCS[2][	110	]=	0.138	;		TCS[3][	110	]=	0.085	;		TCS[4][	110	]=	0.229	;		TCS[5][	110	]=	0.403	;		TCS[6][	110	]=	0.541	;		TCS[7][	110	]=	0.448	;		TCS[8][	110	]=	0.382	;		TCS[9][	110	]=	0.033	;		TCS[10][	110	]=	0.113	;		TCS[11][	110	]=	0.148	;		TCS[12][	110	]=	0.341	;		TCS[13][	110	]=	0.384	;		TCS[14][	110	]=	0.05	;
	TCS[0][	111	]=	471	;		TCS[1][	111	]=	0.215530678	;		TCS[2][	111	]=	0.138891232	;		TCS[3][	111	]=	0.086367755	;		TCS[4][	111	]=	0.233940985	;		TCS[5][	111	]=	0.404514039	;		TCS[6][	111	]=	0.539135388	;		TCS[7][	111	]=	0.444075271	;		TCS[8][	111	]=	0.378817183	;		TCS[9][	111	]=	0.032582874	;		TCS[10][	111	]=	0.115141767	;		TCS[11][	111	]=	0.151311472	;		TCS[12][	111	]=	0.339029845	;		TCS[13][	111	]=	0.384926575	;		TCS[14][	111	]=	0.050368122	;
	TCS[0][	112	]=	472	;		TCS[1][	112	]=	0.215057406	;		TCS[2][	112	]=	0.139815779	;		TCS[3][	112	]=	0.087911527	;		TCS[4][	112	]=	0.238878219	;		TCS[5][	112	]=	0.405982455	;		TCS[6][	112	]=	0.537199808	;		TCS[7][	112	]=	0.440280774	;		TCS[8][	112	]=	0.375554493	;		TCS[9][	112	]=	0.032153154	;		TCS[10][	112	]=	0.117356033	;		TCS[11][	112	]=	0.154842403	;		TCS[12][	112	]=	0.336762365	;		TCS[13][	112	]=	0.385825635	;		TCS[14][	112	]=	0.050721258	;
	TCS[0][	113	]=	473	;		TCS[1][	113	]=	0.214618794	;		TCS[2][	113	]=	0.140794711	;		TCS[3][	113	]=	0.089671421	;		TCS[4][	113	]=	0.24384496	;		TCS[5][	113	]=	0.407393852	;		TCS[6][	113	]=	0.535196534	;		TCS[7][	113	]=	0.436548642	;		TCS[8][	113	]=	0.372283212	;		TCS[9][	113	]=	0.031731997	;		TCS[10][	113	]=	0.119699416	;		TCS[11][	113	]=	0.158617599	;		TCS[12][	113	]=	0.334179963	;		TCS[13][	113	]=	0.386761407	;		TCS[14][	113	]=	0.051090333	;
	TCS[0][	114	]=	474	;		TCS[1][	114	]=	0.214253455	;		TCS[2][	114	]=	0.141849096	;		TCS[3][	114	]=	0.091687543	;		TCS[4][	114	]=	0.248874468	;		TCS[5][	114	]=	0.408736832	;		TCS[6][	114	]=	0.53312884	;		TCS[7][	114	]=	0.432811007	;		TCS[8][	114	]=	0.36907462	;		TCS[9][	114	]=	0.03134056	;		TCS[10][	114	]=	0.122228533	;		TCS[11][	114	]=	0.162661863	;		TCS[12][	114	]=	0.331265041	;		TCS[13][	114	]=	0.38779812	;		TCS[14][	114	]=	0.051506272	;
	TCS[0][	115	]=	475	;		TCS[1][	115	]=	0.214	;		TCS[2][	115	]=	0.143	;		TCS[3][	115	]=	0.094	;		TCS[4][	115	]=	0.254	;		TCS[5][	115	]=	0.41	;		TCS[6][	115	]=	0.531	;		TCS[7][	115	]=	0.429	;		TCS[8][	115	]=	0.366	;		TCS[9][	115	]=	0.031	;		TCS[10][	115	]=	0.125	;		TCS[11][	115	]=	0.167	;		TCS[12][	115	]=	0.328	;		TCS[13][	115	]=	0.389	;		TCS[14][	115	]=	0.052	;
	TCS[0][	116	]=	476	;		TCS[1][	116	]=	0.213882942	;		TCS[2][	116	]=	0.144260975	;		TCS[3][	116	]=	0.096629609	;		TCS[4][	116	]=	0.259244959	;		TCS[5][	116	]=	0.411174201	;		TCS[6][	116	]=	0.528808863	;		TCS[7][	116	]=	0.425060002	;		TCS[8][	116	]=	0.363105582	;		TCS[9][	116	]=	0.030725067	;		TCS[10][	116	]=	0.128050641	;		TCS[11][	116	]=	0.171641078	;		TCS[12][	116	]=	0.324376785	;		TCS[13][	116	]=	0.390409397	;		TCS[14][	116	]=	0.0525887	;
	TCS[0][	117	]=	477	;		TCS[1][	117	]=	0.213870396	;		TCS[2][	117	]=	0.145615501	;		TCS[3][	117	]=	0.099520035	;		TCS[4][	117	]=	0.26459332	;		TCS[5][	117	]=	0.412259248	;		TCS[6][	117	]=	0.526536574	;		TCS[7][	117	]=	0.420984385	;		TCS[8][	117	]=	0.360337395	;		TCS[9][	117	]=	0.030504885	;		TCS[10][	117	]=	0.131338105	;		TCS[11][	117	]=	0.176531226	;		TCS[12][	117	]=	0.320425516	;		TCS[13][	117	]=	0.391981142	;		TCS[14][	117	]=	0.053234582	;
	TCS[0][	118	]=	478	;		TCS[1][	118	]=	0.21391638	;		TCS[2][	118	]=	0.147039538	;		TCS[3][	118	]=	0.102595658	;		TCS[4][	118	]=	0.270019201	;		TCS[5][	118	]=	0.413257193	;		TCS[6][	118	]=	0.524159854	;		TCS[7][	118	]=	0.416778766	;		TCS[8][	118	]=	0.357616417	;		TCS[9][	118	]=	0.030322169	;		TCS[10][	118	]=	0.134800249	;		TCS[11][	118	]=	0.181600834	;		TCS[12][	118	]=	0.316185854	;		TCS[13][	118	]=	0.393648189	;		TCS[14][	118	]=	0.053886115	;
	TCS[0][	119	]=	479	;		TCS[1][	119	]=	0.213974909	;		TCS[2][	119	]=	0.148509051	;		TCS[3][	119	]=	0.105780853	;		TCS[4][	119	]=	0.275496722	;		TCS[5][	119	]=	0.414170093	;		TCS[6][	119	]=	0.521655423	;		TCS[7][	119	]=	0.412448765	;		TCS[8][	119	]=	0.354863626	;		TCS[9][	119	]=	0.030159635	;		TCS[10][	119	]=	0.138374928	;		TCS[11][	119	]=	0.186780295	;		TCS[12][	119	]=	0.311697461	;		TCS[13][	119	]=	0.395343491	;		TCS[14][	119	]=	0.054491765	;
	TCS[0][	120	]=	480	;		TCS[1][	120	]=	0.214	;		TCS[2][	120	]=	0.15	;		TCS[3][	120	]=	0.109	;		TCS[4][	120	]=	0.281	;		TCS[5][	120	]=	0.415	;		TCS[6][	120	]=	0.519	;		TCS[7][	120	]=	0.408	;		TCS[8][	120	]=	0.352	;		TCS[9][	120	]=	0.03	;		TCS[10][	120	]=	0.142	;		TCS[11][	120	]=	0.192	;		TCS[12][	120	]=	0.307	;		TCS[13][	120	]=	0.397	;		TCS[14][	120	]=	0.055	;
	TCS[0][	121	]=	481	;		TCS[1][	121	]=	0.213961554	;		TCS[2][	121	]=	0.151504868	;		TCS[3][	121	]=	0.11220181	;		TCS[4][	121	]=	0.286503179	;		TCS[5][	121	]=	0.415749157	;		TCS[6][	121	]=	0.516181161	;		TCS[7][	121	]=	0.403444719	;		TCS[8][	121	]=	0.348976488	;		TCS[9][	121	]=	0.029828856	;		TCS[10][	121	]=	0.14563967	;		TCS[11][	121	]=	0.197212215	;		TCS[12][	121	]=	0.302135014	;		TCS[13][	121	]=	0.398571837	;		TCS[14][	121	]=	0.055381078	;
	TCS[0][	122	]=	482	;		TCS[1][	122	]=	0.213893009	;		TCS[2][	122	]=	0.153082219	;		TCS[3][	122	]=	0.115432332	;		TCS[4][	122	]=	0.291980502	;		TCS[5][	122	]=	0.416420555	;		TCS[6][	122	]=	0.513229896	;		TCS[7][	122	]=	0.398821686	;		TCS[8][	122	]=	0.345863926	;		TCS[9][	122	]=	0.029643306	;		TCS[10][	122	]=	0.149363547	;		TCS[11][	122	]=	0.202456694	;		TCS[12][	122	]=	0.297151571	;		TCS[13][	122	]=	0.400097796	;		TCS[14][	122	]=	0.055692413	;
	TCS[0][	123	]=	483	;		TCS[1][	123	]=	0.213843687	;		TCS[2][	123	]=	0.154807135	;		TCS[3][	123	]=	0.118761948	;		TCS[4][	123	]=	0.297406235	;		TCS[5][	123	]=	0.417017375	;		TCS[6][	123	]=	0.510188051	;		TCS[7][	123	]=	0.394176293	;		TCS[8][	123	]=	0.34276312	;		TCS[9][	123	]=	0.029443328	;		TCS[10][	123	]=	0.153267589	;		TCS[11][	123	]=	0.207795066	;		TCS[12][	123	]=	0.292100621	;		TCS[13][	123	]=	0.401637835	;		TCS[14][	123	]=	0.056013209	;
	TCS[0][	124	]=	484	;		TCS[1][	124	]=	0.21386291	;		TCS[2][	124	]=	0.156754701	;		TCS[3][	124	]=	0.122261043	;		TCS[4][	124	]=	0.302754645	;		TCS[5][	124	]=	0.417542797	;		TCS[6][	124	]=	0.50709747	;		TCS[7][	124	]=	0.389553933	;		TCS[8][	124	]=	0.339774875	;		TCS[9][	124	]=	0.029228899	;		TCS[10][	124	]=	0.157447754	;		TCS[11][	124	]=	0.213288958	;		TCS[12][	124	]=	0.287033114	;		TCS[13][	124	]=	0.403251917	;		TCS[14][	124	]=	0.05642267	;
	TCS[0][	125	]=	485	;		TCS[1][	125	]=	0.214	;		TCS[2][	125	]=	0.159	;		TCS[3][	125	]=	0.126	;		TCS[4][	125	]=	0.308	;		TCS[5][	125	]=	0.418	;		TCS[6][	125	]=	0.504	;		TCS[7][	125	]=	0.385	;		TCS[8][	125	]=	0.337	;		TCS[9][	125	]=	0.029	;		TCS[10][	125	]=	0.162	;		TCS[11][	125	]=	0.219	;		TCS[12][	125	]=	0.282	;		TCS[13][	125	]=	0.405	;		TCS[14][	125	]=	0.057	;
	TCS[0][	126	]=	486	;		TCS[1][	126	]=	0.214286842	;		TCS[2][	126	]=	0.161591553	;		TCS[3][	126	]=	0.130027152	;		TCS[4][	126	]=	0.313118324	;		TCS[5][	126	]=	0.418389173	;		TCS[6][	126	]=	0.500922494	;		TCS[7][	126	]=	0.380545122	;		TCS[8][	126	]=	0.334500465	;		TCS[9][	126	]=	0.028759507	;		TCS[10][	126	]=	0.166982678	;		TCS[11][	126	]=	0.224982063	;		TCS[12][	126	]=	0.27703516	;		TCS[13][	126	]=	0.406927253	;		TCS[14][	126	]=	0.057798988	;
	TCS[0][	127	]=	487	;		TCS[1][	127	]=	0.214685568	;		TCS[2][	127	]=	0.164471625	;		TCS[3][	127	]=	0.134302639	;		TCS[4][	127	]=	0.318092672	;		TCS[5][	127	]=	0.418698533	;		TCS[6][	127	]=	0.497831842	;		TCS[7][	127	]=	0.376160872	;		TCS[8][	127	]=	0.332182901	;		TCS[9][	127	]=	0.02852189	;		TCS[10][	127	]=	0.172303705	;		TCS[11][	127	]=	0.231258	;		TCS[12][	127	]=	0.272104201	;		TCS[13][	127	]=	0.409019674	;		TCS[14][	127	]=	0.058771766	;
	TCS[0][	128	]=	488	;		TCS[1][	128	]=	0.215140874	;		TCS[2][	128	]=	0.167555922	;		TCS[3][	128	]=	0.138764549	;		TCS[4][	128	]=	0.322907858	;		TCS[5][	128	]=	0.418913307	;		TCS[6][	128	]=	0.494679944	;		TCS[7][	128	]=	0.371804062	;		TCS[8][	128	]=	0.329915104	;		TCS[9][	128	]=	0.028304521	;		TCS[10][	128	]=	0.177833395	;		TCS[11][	128	]=	0.237842904	;		TCS[12][	128	]=	0.267155662	;		TCS[13][	128	]=	0.411248469	;		TCS[14][	128	]=	0.05984505	;
	TCS[0][	129	]=	489	;		TCS[1][	129	]=	0.215597453	;		TCS[2][	129	]=	0.170760146	;		TCS[3][	129	]=	0.143350973	;		TCS[4][	129	]=	0.327548697	;		TCS[5][	129	]=	0.419018721	;		TCS[6][	129	]=	0.491418697	;		TCS[7][	129	]=	0.367431501	;		TCS[8][	129	]=	0.327564872	;		TCS[9][	129	]=	0.028124767	;		TCS[10][	129	]=	0.183442056	;		TCS[11][	129	]=	0.244751872	;		TCS[12][	129	]=	0.262138082	;		TCS[13][	129	]=	0.413584842	;		TCS[14][	129	]=	0.060945556	;
	TCS[0][	130	]=	490	;		TCS[1][	130	]=	0.216	;		TCS[2][	130	]=	0.174	;		TCS[3][	130	]=	0.148	;		TCS[4][	130	]=	0.332	;		TCS[5][	130	]=	0.419	;		TCS[6][	130	]=	0.488	;		TCS[7][	130	]=	0.363	;		TCS[8][	130	]=	0.325	;		TCS[9][	130	]=	0.028	;		TCS[10][	130	]=	0.189	;		TCS[11][	130	]=	0.252	;		TCS[12][	130	]=	0.257	;		TCS[13][	130	]=	0.416	;		TCS[14][	130	]=	0.062	;
	TCS[0][	131	]=	491	;		TCS[1][	131	]=	0.216315078	;		TCS[2][	131	]=	0.177208922	;		TCS[3][	131	]=	0.152665582	;		TCS[4][	131	]=	0.336255526	;		TCS[5][	131	]=	0.418846153	;		TCS[6][	131	]=	0.484392863	;		TCS[7][	131	]=	0.358486794	;		TCS[8][	131	]=	0.322133653	;		TCS[9][	131	]=	0.027941117	;		TCS[10][	131	]=	0.194437619	;		TCS[11][	131	]=	0.259579532	;		TCS[12][	131	]=	0.251708347	;		TCS[13][	131	]=	0.41847115	;		TCS[14][	131	]=	0.062958968	;
	TCS[0][	132	]=	492	;		TCS[1][	132	]=	0.216596717	;		TCS[2][	132	]=	0.18039128	;		TCS[3][	132	]=	0.157365114	;		TCS[4][	132	]=	0.34034481	;		TCS[5][	132	]=	0.418561313	;		TCS[6][	132	]=	0.480634735	;		TCS[7][	132	]=	0.353950825	;		TCS[8][	132	]=	0.319060472	;		TCS[9][	132	]=	0.027933132	;		TCS[10][	132	]=	0.199925631	;		TCS[11][	132	]=	0.267391308	;		TCS[12][	132	]=	0.246303626	;		TCS[13][	132	]=	0.420999507	;		TCS[14][	132	]=	0.063868522	;
	TCS[0][	133	]=	493	;		TCS[1][	133	]=	0.216920818	;		TCS[2][	133	]=	0.183569177	;		TCS[3][	133	]=	0.162131856	;		TCS[4][	133	]=	0.344306331	;		TCS[5][	133	]=	0.418153397	;		TCS[6][	133	]=	0.476780175	;		TCS[7][	133	]=	0.349471458	;		TCS[8][	133	]=	0.315920463	;		TCS[9][	133	]=	0.027954589	;		TCS[10][	133	]=	0.205694833	;		TCS[11][	133	]=	0.275313319	;		TCS[12][	133	]=	0.240844731	;		TCS[13][	133	]=	0.423592289	;		TCS[14][	133	]=	0.064798592	;
	TCS[0][	134	]=	494	;		TCS[1][	134	]=	0.217363279	;		TCS[2][	134	]=	0.186764716	;		TCS[3][	134	]=	0.166999065	;		TCS[4][	134	]=	0.348178568	;		TCS[5][	134	]=	0.417630321	;		TCS[6][	134	]=	0.472883744	;		TCS[7][	134	]=	0.345128061	;		TCS[8][	134	]=	0.312853637	;		TCS[9][	134	]=	0.027984031	;		TCS[10][	134	]=	0.211976023	;		TCS[11][	134	]=	0.283223553	;		TCS[12][	134	]=	0.235390557	;		TCS[13][	134	]=	0.426256714	;		TCS[14][	134	]=	0.065819107	;
	TCS[0][	135	]=	495	;		TCS[1][	135	]=	0.218	;		TCS[2][	135	]=	0.19	;		TCS[3][	135	]=	0.172	;		TCS[4][	135	]=	0.352	;		TCS[5][	135	]=	0.417	;		TCS[6][	135	]=	0.469	;		TCS[7][	135	]=	0.341	;		TCS[8][	135	]=	0.31	;		TCS[9][	135	]=	0.028	;		TCS[10][	135	]=	0.219	;		TCS[11][	135	]=	0.291	;		TCS[12][	135	]=	0.23	;		TCS[13][	135	]=	0.429	;		TCS[14][	135	]=	0.067	;
	TCS[0][	136	]=	496	;		TCS[1][	136	]=	0.218876847	;		TCS[2][	136	]=	0.193292761	;		TCS[3][	136	]=	0.177150522	;		TCS[4][	136	]=	0.355795571	;		TCS[5][	136	]=	0.416274216	;		TCS[6][	136	]=	0.465170054	;		TCS[7][	136	]=	0.337147701	;		TCS[8][	136	]=	0.307460922	;		TCS[9][	136	]=	0.027988025	;		TCS[10][	136	]=	0.226906845	;		TCS[11][	136	]=	0.298531809	;		TCS[12][	136	]=	0.224715452	;		TCS[13][	136	]=	0.431820148	;		TCS[14][	136	]=	0.068389138	;
	TCS[0][	137	]=	497	;		TCS[1][	137	]=	0.219919562	;		TCS[2][	137	]=	0.196643255	;		TCS[3][	137	]=	0.182396905	;		TCS[4][	137	]=	0.359536087	;		TCS[5][	137	]=	0.415480214	;		TCS[6][	137	]=	0.461381219	;		TCS[7][	137	]=	0.333555828	;		TCS[8][	137	]=	0.305183213	;		TCS[9][	137	]=	0.02796158	;		TCS[10][	137	]=	0.235473771	;		TCS[11][	137	]=	0.305752767	;		TCS[12][	137	]=	0.219513296	;		TCS[13][	137	]=	0.434678299	;		TCS[14][	137	]=	0.069946146	;
	TCS[0][	138	]=	498	;		TCS[1][	138	]=	0.221023853	;		TCS[2][	138	]=	0.200047369	;		TCS[3][	138	]=	0.187668027	;		TCS[4][	138	]=	0.363178817	;		TCS[5][	138	]=	0.414649104	;		TCS[6][	138	]=	0.457607356	;		TCS[7][	138	]=	0.330190104	;		TCS[8][	138	]=	0.303075043	;		TCS[9][	138	]=	0.027941121	;		TCS[10][	138	]=	0.244387275	;		TCS[11][	138	]=	0.312607821	;		TCS[12][	138	]=	0.214353414	;		TCS[13][	138	]=	0.437526375	;		TCS[14][	138	]=	0.071608584	;
	TCS[0][	139	]=	499	;		TCS[1][	139	]=	0.222085429	;		TCS[2][	139	]=	0.203500989	;		TCS[3][	139	]=	0.192892766	;		TCS[4][	139	]=	0.366681032	;		TCS[5][	139	]=	0.413811996	;		TCS[6][	139	]=	0.453822329	;		TCS[7][	139	]=	0.327016254	;		TCS[8][	139	]=	0.301044582	;		TCS[9][	139	]=	0.027947109	;		TCS[10][	139	]=	0.253333852	;		TCS[11][	139	]=	0.319041916	;		TCS[12][	139	]=	0.209195688	;		TCS[13][	139	]=	0.440316301	;		TCS[14][	139	]=	0.073314015	;
	TCS[0][	140	]=	500	;		TCS[1][	140	]=	0.223	;		TCS[2][	140	]=	0.207	;		TCS[3][	140	]=	0.198	;		TCS[4][	140	]=	0.37	;		TCS[5][	140	]=	0.413	;		TCS[6][	140	]=	0.45	;		TCS[7][	140	]=	0.324	;		TCS[8][	140	]=	0.299	;		TCS[9][	140	]=	0.028	;		TCS[10][	140	]=	0.262	;		TCS[11][	140	]=	0.325	;		TCS[12][	140	]=	0.204	;		TCS[13][	140	]=	0.443	;		TCS[14][	140	]=	0.075	;
	TCS[0][	141	]=	501	;		TCS[1][	141	]=	0.223689533	;		TCS[2][	141	]=	0.210540034	;		TCS[3][	141	]=	0.202932332	;		TCS[4][	141	]=	0.373098188	;		TCS[5][	141	]=	0.412232982	;		TCS[6][	141	]=	0.44612692	;		TCS[7][	141	]=	0.321114402	;		TCS[8][	141	]=	0.296878658	;		TCS[9][	141	]=	0.028114781	;		TCS[10][	141	]=	0.270191001	;		TCS[11][	141	]=	0.330437232	;		TCS[12][	141	]=	0.198741847	;		TCS[13][	141	]=	0.445536257	;		TCS[14][	141	]=	0.076620479	;
	TCS[0][	142	]=	502	;		TCS[1][	142	]=	0.224181035	;		TCS[2][	142	]=	0.214115699	;		TCS[3][	142	]=	0.207687266	;		TCS[4][	142	]=	0.375958841	;		TCS[5][	142	]=	0.41148583	;		TCS[6][	142	]=	0.44224039	;		TCS[7][	142	]=	0.318361864	;		TCS[8][	142	]=	0.294734676	;		TCS[9][	142	]=	0.028284549	;		TCS[10][	142	]=	0.278187284	;		TCS[11][	142	]=	0.335349623	;		TCS[12][	142	]=	0.193459191	;		TCS[13][	142	]=	0.447911298	;		TCS[14][	142	]=	0.078194896	;
	TCS[0][	143	]=	503	;		TCS[1][	143	]=	0.22452777	;		TCS[2][	143	]=	0.217721346	;		TCS[3][	143	]=	0.212276036	;		TCS[4][	143	]=	0.3785704	;		TCS[5][	143	]=	0.410722186	;		TCS[6][	143	]=	0.438390401	;		TCS[7][	143	]=	0.315752124	;		TCS[8][	143	]=	0.292651366	;		TCS[9][	143	]=	0.028496925	;		TCS[10][	143	]=	0.286388068	;		TCS[11][	143	]=	0.339743398	;		TCS[12][	143	]=	0.188205612	;		TCS[13][	143	]=	0.450118211	;		TCS[14][	143	]=	0.079759074	;
	TCS[0][	144	]=	504	;		TCS[1][	144	]=	0.224783003	;		TCS[2][	144	]=	0.221351329	;		TCS[3][	144	]=	0.21670987	;		TCS[4][	144	]=	0.380921306	;		TCS[5][	144	]=	0.409905695	;		TCS[6][	144	]=	0.434626941	;		TCS[7][	144	]=	0.313294923	;		TCS[8][	144	]=	0.290712037	;		TCS[9][	144	]=	0.028739534	;		TCS[10][	144	]=	0.295192567	;		TCS[11][	144	]=	0.343624782	;		TCS[12][	144	]=	0.183034689	;		TCS[13][	144	]=	0.452150082	;		TCS[14][	144	]=	0.081348834	;
	TCS[0][	145	]=	505	;		TCS[1][	145	]=	0.225	;		TCS[2][	145	]=	0.225	;		TCS[3][	145	]=	0.221	;		TCS[4][	145	]=	0.383	;		TCS[5][	145	]=	0.409	;		TCS[6][	145	]=	0.431	;		TCS[7][	145	]=	0.311	;		TCS[8][	145	]=	0.289	;		TCS[9][	145	]=	0.029	;		TCS[10][	145	]=	0.305	;		TCS[11][	145	]=	0.347	;		TCS[12][	145	]=	0.178	;		TCS[13][	145	]=	0.454	;		TCS[14][	145	]=	0.083	;
	TCS[0][	146	]=	506	;		TCS[1][	146	]=	0.225221019	;		TCS[2][	146	]=	0.228651103	;		TCS[3][	146	]=	0.225160152	;		TCS[4][	146	]=	0.384803677	;		TCS[5][	146	]=	0.407977856	;		TCS[6][	146	]=	0.427538266	;		TCS[7][	146	]=	0.30886669	;		TCS[8][	146	]=	0.287568446	;		TCS[9][	146	]=	0.029264849	;		TCS[10][	146	]=	0.316065153	;		TCS[11][	146	]=	0.349871265	;		TCS[12][	146	]=	0.173133162	;		TCS[13][	146	]=	0.455666824	;		TCS[14][	146	]=	0.084736947	;
	TCS[0][	147	]=	507	;		TCS[1][	147	]=	0.225444298	;		TCS[2][	147	]=	0.232245951	;		TCS[3][	147	]=	0.229214029	;		TCS[4][	147	]=	0.38636455	;		TCS[5][	147	]=	0.406848467	;		TCS[6][	147	]=	0.42418522	;		TCS[7][	147	]=	0.306852717	;		TCS[8][	147	]=	0.286350081	;		TCS[9][	147	]=	0.029516226	;		TCS[10][	147	]=	0.328065092	;		TCS[11][	147	]=	0.352224743	;		TCS[12][	147	]=	0.16837794	;		TCS[13][	147	]=	0.457172509	;		TCS[14][	147	]=	0.086538272	;
	TCS[0][	148	]=	508	;		TCS[1][	148	]=	0.225657067	;		TCS[2][	148	]=	0.235715246	;		TCS[3][	148	]=	0.233187831	;		TCS[4][	148	]=	0.387723583	;		TCS[5][	148	]=	0.405630151	;		TCS[6][	148	]=	0.420863041	;		TCS[7][	148	]=	0.304905398	;		TCS[8][	148	]=	0.285247494	;		TCS[9][	148	]=	0.029735178	;		TCS[10][	148	]=	0.340532455	;		TCS[11][	148	]=	0.354042588	;		TCS[12][	148	]=	0.163656138	;		TCS[13][	148	]=	0.458544782	;		TCS[14][	148	]=	0.088371122	;
	TCS[0][	149	]=	509	;		TCS[1][	149	]=	0.225846557	;		TCS[2][	149	]=	0.238989695	;		TCS[3][	149	]=	0.237107755	;		TCS[4][	149	]=	0.388921745	;		TCS[5][	149	]=	0.404341223	;		TCS[6][	149	]=	0.417493908	;		TCS[7][	149	]=	0.302972053	;		TCS[8][	149	]=	0.284163271	;		TCS[9][	149	]=	0.029902754	;		TCS[10][	149	]=	0.352999879	;		TCS[11][	149	]=	0.355306956	;		TCS[12][	149	]=	0.158889557	;		TCS[13][	149	]=	0.45981137	;		TCS[14][	149	]=	0.090202648	;
	TCS[0][	150	]=	510	;		TCS[1][	150	]=	0.226	;		TCS[2][	150	]=	0.242	;		TCS[3][	150	]=	0.241	;		TCS[4][	150	]=	0.39	;		TCS[5][	150	]=	0.403	;		TCS[6][	150	]=	0.414	;		TCS[7][	150	]=	0.301	;		TCS[8][	150	]=	0.283	;		TCS[9][	150	]=	0.03	;		TCS[10][	150	]=	0.365	;		TCS[11][	150	]=	0.356	;		TCS[12][	150	]=	0.154	;		TCS[13][	150	]=	0.461	;		TCS[14][	150	]=	0.092	;
	TCS[0][	151	]=	511	;		TCS[1][	151	]=	0.22610639	;		TCS[2][	151	]=	0.244695554	;		TCS[3][	151	]=	0.244883061	;		TCS[4][	151	]=	0.390991103	;		TCS[5][	151	]=	0.401623595	;		TCS[6][	151	]=	0.410328016	;		TCS[7][	151	]=	0.298954836	;		TCS[8][	151	]=	0.281687559	;		TCS[9][	151	]=	0.030017821	;		TCS[10][	151	]=	0.376180389	;		TCS[11][	151	]=	0.356125709	;		TCS[12][	151	]=	0.148941505	;		TCS[13][	151	]=	0.462132446	;		TCS[14][	151	]=	0.093735732	;
	TCS[0][	152	]=	512	;		TCS[1][	152	]=	0.226161774	;		TCS[2][	152	]=	0.247100499	;		TCS[3][	152	]=	0.248744617	;		TCS[4][	152	]=	0.391894961	;		TCS[5][	152	]=	0.400224301	;		TCS[6][	152	]=	0.40652273	;		TCS[7][	152	]=	0.296875269	;		TCS[8][	152	]=	0.280264998	;		TCS[9][	152	]=	0.029986547	;		TCS[10][	152	]=	0.386648348	;		TCS[11][	152	]=	0.355775407	;		TCS[12][	152	]=	0.143797047	;		TCS[13][	152	]=	0.463206666	;		TCS[14][	152	]=	0.095404018	;
	TCS[0][	153	]=	513	;		TCS[1][	153	]=	0.226163963	;		TCS[2][	153	]=	0.249257668	;		TCS[3][	153	]=	0.252564642	;		TCS[4][	153	]=	0.392703267	;		TCS[5][	153	]=	0.398813211	;		TCS[6][	153	]=	0.402653437	;		TCS[7][	153	]=	0.294818283	;		TCS[8][	153	]=	0.278798657	;		TCS[9][	153	]=	0.029946361	;		TCS[10][	153	]=	0.396626113	;		TCS[11][	153	]=	0.35506225	;		TCS[12][	153	]=	0.138681837	;		TCS[13][	153	]=	0.464214663	;		TCS[14][	153	]=	0.097004438	;
	TCS[0][	154	]=	514	;		TCS[1][	154	]=	0.226110768	;		TCS[2][	154	]=	0.251209891	;		TCS[3][	154	]=	0.256323111	;		TCS[4][	154	]=	0.393407715	;		TCS[5][	154	]=	0.397401414	;		TCS[6][	154	]=	0.398789429	;		TCS[7][	154	]=	0.292840865	;		TCS[8][	154	]=	0.277354877	;		TCS[9][	154	]=	0.029937451	;		TCS[10][	154	]=	0.406335918	;		TCS[11][	154	]=	0.354099395	;		TCS[12][	154	]=	0.133711084	;		TCS[13][	154	]=	0.46514844	;		TCS[14][	154	]=	0.098536572	;
	TCS[0][	155	]=	515	;		TCS[1][	155	]=	0.226	;		TCS[2][	155	]=	0.253	;		TCS[3][	155	]=	0.26	;		TCS[4][	155	]=	0.394	;		TCS[5][	155	]=	0.396	;		TCS[6][	155	]=	0.395	;		TCS[7][	155	]=	0.291	;		TCS[8][	155	]=	0.276	;		TCS[9][	155	]=	0.03	;		TCS[10][	155	]=	0.416	;		TCS[11][	155	]=	0.353	;		TCS[12][	155	]=	0.129	;		TCS[13][	155	]=	0.466	;		TCS[14][	155	]=	0.1	;
	TCS[0][	156	]=	516	;		TCS[1][	156	]=	0.225833422	;		TCS[2][	156	]=	0.254662682	;		TCS[3][	156	]=	0.263587604	;		TCS[4][	156	]=	0.39447191	;		TCS[5][	156	]=	0.394615766	;		TCS[6][	156	]=	0.39133367	;		TCS[7][	156	]=	0.289329965	;		TCS[8][	156	]=	0.274777317	;		TCS[9][	156	]=	0.030159865	;		TCS[10][	156	]=	0.425789291	;		TCS[11][	156	]=	0.351849898	;		TCS[12][	156	]=	0.124628818	;		TCS[13][	156	]=	0.46676339	;		TCS[14][	156	]=	0.101408126	;
	TCS[0][	157	]=	517	;		TCS[1][	157	]=	0.225628608	;		TCS[2][	157	]=	0.256200052	;		TCS[3][	157	]=	0.267127505	;		TCS[4][	157	]=	0.394815607	;		TCS[5][	157	]=	0.393238327	;		TCS[6][	157	]=	0.387755859	;		TCS[7][	157	]=	0.287774208	;		TCS[8][	157	]=	0.273637927	;		TCS[9][	157	]=	0.030385587	;		TCS[10][	157	]=	0.435669515	;		TCS[11][	157	]=	0.350625629	;		TCS[12][	157	]=	0.120537871	;		TCS[13][	157	]=	0.467440826	;		TCS[14][	157	]=	0.102829657	;
	TCS[0][	158	]=	518	;		TCS[1][	158	]=	0.225407082	;		TCS[2][	158	]=	0.257606081	;		TCS[3][	158	]=	0.270673603	;		TCS[4][	158	]=	0.39502335	;		TCS[5][	158	]=	0.391853006	;		TCS[6][	158	]=	0.384211212	;		TCS[7][	158	]=	0.286253468	;		TCS[8][	158	]=	0.272509878	;		TCS[9][	158	]=	0.030631376	;		TCS[10][	158	]=	0.445555094	;		TCS[11][	158	]=	0.349276412	;		TCS[12][	158	]=	0.116632515	;		TCS[13][	158	]=	0.468036567	;		TCS[14][	158	]=	0.104347125	;
	TCS[0][	159	]=	519	;		TCS[1][	159	]=	0.225190371	;		TCS[2][	159	]=	0.25887474	;		TCS[3][	159	]=	0.274279801	;		TCS[4][	159	]=	0.395087395	;		TCS[5][	159	]=	0.390445123	;		TCS[6][	159	]=	0.380644378	;		TCS[7][	159	]=	0.284688486	;		TCS[8][	159	]=	0.271321219	;		TCS[9][	159	]=	0.030851443	;		TCS[10][	159	]=	0.455360448	;		TCS[11][	159	]=	0.347751463	;		TCS[12][	159	]=	0.112818106	;		TCS[13][	159	]=	0.468554872	;		TCS[14][	159	]=	0.106043062	;
	TCS[0][	160	]=	520	;		TCS[1][	160	]=	0.225	;		TCS[2][	160	]=	0.26	;		TCS[3][	160	]=	0.278	;		TCS[4][	160	]=	0.395	;		TCS[5][	160	]=	0.389	;		TCS[6][	160	]=	0.377	;		TCS[7][	160	]=	0.283	;		TCS[8][	160	]=	0.27	;		TCS[9][	160	]=	0.031	;		TCS[10][	160	]=	0.465	;		TCS[11][	160	]=	0.346	;		TCS[12][	160	]=	0.109	;		TCS[13][	160	]=	0.469	;		TCS[14][	160	]=	0.108	;
	TCS[0][	161	]=	521	;		TCS[1][	161	]=	0.224855921	;		TCS[2][	161	]=	0.260981717	;		TCS[3][	161	]=	0.281902522	;		TCS[4][	161	]=	0.394753258	;		TCS[5][	161	]=	0.387505342	;		TCS[6][	161	]=	0.373241305	;		TCS[7][	161	]=	0.281133303	;		TCS[8][	161	]=	0.268499172	;		TCS[9][	161	]=	0.031046717	;		TCS[10][	161	]=	0.474398446	;		TCS[11][	161	]=	0.3439787	;		TCS[12][	161	]=	0.105111222	;		TCS[13][	161	]=	0.469381993	;		TCS[14][	161	]=	0.110271765	;
	TCS[0][	162	]=	522	;		TCS[1][	162	]=	0.224771794	;		TCS[2][	162	]=	0.261843291	;		TCS[3][	162	]=	0.286113365	;		TCS[4][	162	]=	0.39433861	;		TCS[5][	162	]=	0.385958389	;		TCS[6][	162	]=	0.369405835	;		TCS[7][	162	]=	0.279131899	;		TCS[8][	162	]=	0.266871295	;		TCS[9][	162	]=	0.031023104	;		TCS[10][	162	]=	0.48352159	;		TCS[11][	162	]=	0.341674077	;		TCS[12][	162	]=	0.101195468	;		TCS[13][	162	]=	0.469734029	;		TCS[14][	162	]=	0.112797355	;
	TCS[0][	163	]=	523	;		TCS[1][	163	]=	0.224759707	;		TCS[2][	163	]=	0.262614006	;		TCS[3][	163	]=	0.290772947	;		TCS[4][	163	]=	0.393747333	;		TCS[5][	163	]=	0.384358765	;		TCS[6][	163	]=	0.365549713	;		TCS[7][	163	]=	0.277063843	;		TCS[8][	163	]=	0.265193832	;		TCS[9][	163	]=	0.030976134	;		TCS[10][	163	]=	0.492345511	;		TCS[11][	163	]=	0.339080103	;		TCS[12][	163	]=	0.097324104	;		TCS[13][	163	]=	0.470095068	;		TCS[14][	163	]=	0.115487062	;
	TCS[0][	164	]=	524	;		TCS[1][	164	]=	0.224831747	;		TCS[2][	164	]=	0.263323147	;		TCS[3][	164	]=	0.296021686	;		TCS[4][	164	]=	0.392970704	;		TCS[5][	164	]=	0.382706094	;		TCS[6][	164	]=	0.361729061	;		TCS[7][	164	]=	0.274997192	;		TCS[8][	164	]=	0.263544246	;		TCS[9][	164	]=	0.030952775	;		TCS[10][	164	]=	0.500846288	;		TCS[11][	164	]=	0.336190753	;		TCS[12][	164	]=	0.093568493	;		TCS[13][	164	]=	0.470504071	;		TCS[14][	164	]=	0.11825118	;
	TCS[0][	165	]=	525	;		TCS[1][	165	]=	0.225	;		TCS[2][	165	]=	0.264	;		TCS[3][	165	]=	0.302	;		TCS[4][	165	]=	0.392	;		TCS[5][	165	]=	0.381	;		TCS[6][	165	]=	0.358	;		TCS[7][	165	]=	0.273	;		TCS[8][	165	]=	0.262	;		TCS[9][	165	]=	0.031	;		TCS[10][	165	]=	0.509	;		TCS[11][	165	]=	0.333	;		TCS[12][	165	]=	0.09	;		TCS[13][	165	]=	0.471	;		TCS[14][	165	]=	0.121	;
	TCS[0][	166	]=	526	;		TCS[1][	166	]=	0.225270894	;		TCS[2][	166	]=	0.264666449	;		TCS[3][	166	]=	0.308778309	;		TCS[4][	166	]=	0.390835058	;		TCS[5][	166	]=	0.379242867	;		TCS[6][	166	]=	0.35440511	;		TCS[7][	166	]=	0.271128821	;		TCS[8][	166	]=	0.260617996	;		TCS[9][	166	]=	0.031149268	;		TCS[10][	166	]=	0.516800923	;		TCS[11][	166	]=	0.329515303	;		TCS[12][	166	]=	0.086670294	;		TCS[13][	166	]=	0.471604638	;		TCS[14][	166	]=	0.123656815	;
	TCS[0][	167	]=	527	;		TCS[1][	167	]=	0.225628214	;		TCS[2][	167	]=	0.265314784	;		TCS[3][	167	]=	0.316147036	;		TCS[4][	167	]=	0.389509953	;		TCS[5][	167	]=	0.377448117	;		TCS[6][	167	]=	0.3509328	;		TCS[7][	167	]=	0.269394195	;		TCS[8][	167	]=	0.259372894	;		TCS[9][	167	]=	0.031369995	;		TCS[10][	167	]=	0.524316123	;		TCS[11][	167	]=	0.325798064	;		TCS[12][	167	]=	0.083552256	;		TCS[13][	167	]=	0.472271059	;		TCS[14][	167	]=	0.126196924	;
	TCS[0][	168	]=	528	;		TCS[1][	168	]=	0.226050088	;		TCS[2][	168	]=	0.265929894	;		TCS[3][	168	]=	0.32382661	;		TCS[4][	168	]=	0.388067319	;		TCS[5][	168	]=	0.375631934	;		TCS[6][	168	]=	0.347557934	;		TCS[7][	168	]=	0.267795158	;		TCS[8][	168	]=	0.258218794	;		TCS[9][	168	]=	0.031616089	;		TCS[10][	168	]=	0.531630861	;		TCS[11][	168	]=	0.321923175	;		TCS[12][	168	]=	0.08059907	;		TCS[13][	168	]=	0.472935161	;		TCS[14][	168	]=	0.128608625	;
	TCS[0][	169	]=	529	;		TCS[1][	169	]=	0.226514641	;		TCS[2][	169	]=	0.26649667	;		TCS[3][	169	]=	0.331537456	;		TCS[4][	169	]=	0.38654979	;		TCS[5][	169	]=	0.373810501	;		TCS[6][	169	]=	0.344255379	;		TCS[7][	169	]=	0.266330747	;		TCS[8][	169	]=	0.257109796	;		TCS[9][	169	]=	0.031841455	;		TCS[10][	169	]=	0.5388304	;		TCS[11][	169	]=	0.317965524	;		TCS[12][	169	]=	0.077763924	;		TCS[13][	169	]=	0.473532843	;		TCS[14][	169	]=	0.130880218	;
	TCS[0][	170	]=	530	;		TCS[1][	170	]=	0.227	;		TCS[2][	170	]=	0.267	;		TCS[3][	170	]=	0.339	;		TCS[4][	170	]=	0.385	;		TCS[5][	170	]=	0.372	;		TCS[6][	170	]=	0.341	;		TCS[7][	170	]=	0.265	;		TCS[8][	170	]=	0.256	;		TCS[9][	170	]=	0.032	;		TCS[10][	170	]=	0.546	;		TCS[11][	170	]=	0.314	;		TCS[12][	170	]=	0.075	;		TCS[13][	170	]=	0.474	;		TCS[14][	170	]=	0.133	;
	TCS[0][	171	]=	531	;		TCS[1][	171	]=	0.227492505	;		TCS[2][	171	]=	0.267432486	;		TCS[3][	171	]=	0.345992244	;		TCS[4][	171	]=	0.38345051	;		TCS[5][	171	]=	0.370211192	;		TCS[6][	171	]=	0.337770254	;		TCS[7][	171	]=	0.263799413	;		TCS[8][	171	]=	0.254860845	;		TCS[9][	171	]=	0.032060213	;		TCS[10][	171	]=	0.55319786	;		TCS[11][	171	]=	0.31008009	;		TCS[12][	171	]=	0.072271603	;		TCS[13][	171	]=	0.474303456	;		TCS[14][	171	]=	0.134964974	;
	TCS[0][	172	]=	532	;		TCS[1][	172	]=	0.228011349	;		TCS[2][	172	]=	0.267817573	;		TCS[3][	172	]=	0.35252249	;		TCS[4][	172	]=	0.381893579	;		TCS[5][	172	]=	0.368433144	;		TCS[6][	172	]=	0.334558966	;		TCS[7][	172	]=	0.262715322	;		TCS[8][	172	]=	0.253733129	;		TCS[9][	172	]=	0.032048915	;		TCS[10][	172	]=	0.560373917	;		TCS[11][	172	]=	0.306173666	;		TCS[12][	172	]=	0.06958751	;		TCS[13][	172	]=	0.474533735	;		TCS[14][	172	]=	0.136806948	;
	TCS[0][	173	]=	533	;		TCS[1][	173	]=	0.228583941	;		TCS[2][	173	]=	0.268186416	;		TCS[3][	173	]=	0.358656613	;		TCS[4][	173	]=	0.380311393	;		TCS[5][	173	]=	0.366649499	;		TCS[6][	173	]=	0.331362551	;		TCS[7][	173	]=	0.261731525	;		TCS[8][	173	]=	0.252674991	;		TCS[9][	173	]=	0.032007511	;		TCS[10][	173	]=	0.567451044	;		TCS[11][	173	]=	0.302227197	;		TCS[12][	173	]=	0.066967615	;		TCS[13][	173	]=	0.474812286	;		TCS[14][	173	]=	0.138566436	;
	TCS[0][	174	]=	534	;		TCS[1][	174	]=	0.229237689	;		TCS[2][	174	]=	0.268570174	;		TCS[3][	174	]=	0.364460491	;		TCS[4][	174	]=	0.378686138	;		TCS[5][	174	]=	0.364843903	;		TCS[6][	174	]=	0.328177423	;		TCS[7][	174	]=	0.260831819	;		TCS[8][	174	]=	0.251744568	;		TCS[9][	174	]=	0.031977405	;		TCS[10][	174	]=	0.574352114	;		TCS[11][	174	]=	0.298187152	;		TCS[12][	174	]=	0.064431813	;		TCS[13][	174	]=	0.475260558	;		TCS[14][	174	]=	0.14028395	;
	TCS[0][	175	]=	535	;		TCS[1][	175	]=	0.23	;		TCS[2][	175	]=	0.269	;		TCS[3][	175	]=	0.37	;		TCS[4][	175	]=	0.377	;		TCS[5][	175	]=	0.363	;		TCS[6][	175	]=	0.325	;		TCS[7][	175	]=	0.26	;		TCS[8][	175	]=	0.251	;		TCS[9][	175	]=	0.032	;		TCS[10][	175	]=	0.581	;		TCS[11][	175	]=	0.294	;		TCS[12][	175	]=	0.062	;		TCS[13][	175	]=	0.476	;		TCS[14][	175	]=	0.142	;
	TCS[0][	176	]=	536	;		TCS[1][	176	]=	0.230895088	;		TCS[2][	176	]=	0.269499607	;		TCS[3][	176	]=	0.375308715	;		TCS[4][	176	]=	0.375234904	;		TCS[5][	176	]=	0.361104366	;		TCS[6][	176	]=	0.321825872	;		TCS[7][	176	]=	0.259225529	;		TCS[8][	176	]=	0.250482625	;		TCS[9][	176	]=	0.03210588	;		TCS[10][	176	]=	0.587335637	;		TCS[11][	176	]=	0.289628338	;		TCS[12][	176	]=	0.059683294	;		TCS[13][	176	]=	0.477109537	;		TCS[14][	176	]=	0.14373929	;
	TCS[0][	177	]=	537	;		TCS[1][	177	]=	0.231934389	;		TCS[2][	177	]=	0.270062925	;		TCS[3][	177	]=	0.380291005	;		TCS[4][	177	]=	0.373371733	;		TCS[5][	177	]=	0.359155309	;		TCS[6][	177	]=	0.318647336	;		TCS[7][	177	]=	0.258520517	;		TCS[8][	177	]=	0.25016659	;		TCS[9][	177	]=	0.032282343	;		TCS[10][	177	]=	0.59337221	;		TCS[11][	177	]=	0.285099272	;		TCS[12][	177	]=	0.057457706	;		TCS[13][	177	]=	0.478497999	;		TCS[14][	177	]=	0.145463282	;
	TCS[0][	178	]=	538	;		TCS[1][	178	]=	0.233126147	;		TCS[2][	178	]=	0.27067644	;		TCS[3][	178	]=	0.384818937	;		TCS[4][	178	]=	0.37139111	;		TCS[5][	178	]=	0.357154069	;		TCS[6][	178	]=	0.315455864	;		TCS[7][	178	]=	0.257902742	;		TCS[8][	178	]=	0.250009243	;		TCS[9][	178	]=	0.032505866	;		TCS[10][	178	]=	0.599140964	;		TCS[11][	178	]=	0.280456037	;		TCS[12][	178	]=	0.055290471	;		TCS[13][	178	]=	0.480031693	;		TCS[14][	178	]=	0.147117629	;
	TCS[0][	179	]=	539	;		TCS[1][	179	]=	0.234478603	;		TCS[2][	179	]=	0.271326636	;		TCS[3][	179	]=	0.38876458	;		TCS[4][	179	]=	0.369273658	;		TCS[5][	179	]=	0.355101886	;		TCS[6][	179	]=	0.312242928	;		TCS[7][	179	]=	0.257389977	;		TCS[8][	179	]=	0.24996793	;		TCS[9][	179	]=	0.032752926	;		TCS[10][	179	]=	0.604673145	;		TCS[11][	179	]=	0.275741868	;		TCS[12][	179	]=	0.053148824	;		TCS[13][	179	]=	0.481576925	;		TCS[14][	179	]=	0.148647984	;
	TCS[0][	180	]=	540	;		TCS[1][	180	]=	0.236	;		TCS[2][	180	]=	0.272	;		TCS[3][	180	]=	0.392	;		TCS[4][	180	]=	0.367	;		TCS[5][	180	]=	0.353	;		TCS[6][	180	]=	0.309	;		TCS[7][	180	]=	0.257	;		TCS[8][	180	]=	0.25	;		TCS[9][	180	]=	0.033	;		TCS[10][	180	]=	0.61	;		TCS[11][	180	]=	0.271	;		TCS[12][	180	]=	0.051	;		TCS[13][	180	]=	0.483	;		TCS[14][	180	]=	0.15	;
	TCS[0][	181	]=	541	;		TCS[1][	181	]=	0.237687144	;		TCS[2][	181	]=	0.272689086	;		TCS[3][	181	]=	0.394444896	;		TCS[4][	181	]=	0.364561876	;		TCS[5][	181	]=	0.350851344	;		TCS[6][	181	]=	0.305726257	;		TCS[7][	181	]=	0.256746473	;		TCS[8][	181	]=	0.250072654	;		TCS[9][	181	]=	0.033228266	;		TCS[10][	181	]=	0.615147591	;		TCS[11][	181	]=	0.26627056	;		TCS[12][	181	]=	0.048827221	;		TCS[13][	181	]=	0.484218395	;		TCS[14][	181	]=	0.151133867	;
	TCS[0][	182	]=	542	;		TCS[1][	182	]=	0.239491093	;		TCS[2][	182	]=	0.273410727	;		TCS[3][	182	]=	0.396209491	;		TCS[4][	182	]=	0.361995491	;		TCS[5][	182	]=	0.348665622	;		TCS[6][	182	]=	0.30245169	;		TCS[7][	182	]=	0.256626608	;		TCS[8][	182	]=	0.250192509	;		TCS[9][	182	]=	0.033437712	;		TCS[10][	182	]=	0.620121244	;		TCS[11][	182	]=	0.261581247	;		TCS[12][	182	]=	0.046677666	;		TCS[13][	182	]=	0.485354267	;		TCS[14][	182	]=	0.152067924	;
	TCS[0][	183	]=	543	;		TCS[1][	183	]=	0.241351471	;		TCS[2][	183	]=	0.274187825	;		TCS[3][	183	]=	0.397451637	;		TCS[4][	183	]=	0.359348168	;		TCS[5][	183	]=	0.346454227	;		TCS[6][	183	]=	0.299213995	;		TCS[7][	183	]=	0.256633508	;		TCS[8][	183	]=	0.250376038	;		TCS[9][	183	]=	0.033633024	;		TCS[10][	183	]=	0.624921102	;		TCS[11][	183	]=	0.256956655	;		TCS[12][	183	]=	0.0446145	;		TCS[13][	183	]=	0.486580941	;		TCS[14][	183	]=	0.152835048	;
	TCS[0][	184	]=	544	;		TCS[1][	184	]=	0.243207899	;		TCS[2][	184	]=	0.275043282	;		TCS[3][	184	]=	0.398329189	;		TCS[4][	184	]=	0.356667231	;		TCS[5][	184	]=	0.344228554	;		TCS[6][	184	]=	0.296050867	;		TCS[7][	184	]=	0.256760272	;		TCS[8][	184	]=	0.250639711	;		TCS[9][	184	]=	0.033818891	;		TCS[10][	184	]=	0.629547307	;		TCS[11][	184	]=	0.252421375	;		TCS[12][	184	]=	0.042700889	;		TCS[13][	184	]=	0.488071743	;		TCS[14][	184	]=	0.153468114	;
	TCS[0][	185	]=	545	;		TCS[1][	185	]=	0.245	;		TCS[2][	185	]=	0.276	;		TCS[3][	185	]=	0.399	;		TCS[4][	185	]=	0.354	;		TCS[5][	185	]=	0.342	;		TCS[6][	185	]=	0.293	;		TCS[7][	185	]=	0.257	;		TCS[8][	185	]=	0.251	;		TCS[9][	185	]=	0.034	;		TCS[10][	185	]=	0.634	;		TCS[11][	185	]=	0.248	;		TCS[12][	185	]=	0.041	;		TCS[13][	185	]=	0.49	;		TCS[14][	185	]=	0.154	;
	TCS[0][	186	]=	546	;		TCS[1][	186	]=	0.246684337	;		TCS[2][	186	]=	0.277072049	;		TCS[3][	186	]=	0.3995837	;		TCS[4][	186	]=	0.351381593	;		TCS[5][	186	]=	0.339778256	;		TCS[6][	186	]=	0.290085099	;		TCS[7][	186	]=	0.257340581	;		TCS[8][	186	]=	0.251466759	;		TCS[9][	186	]=	0.034181054	;		TCS[10][	186	]=	0.638273998	;		TCS[11][	186	]=	0.243705423	;		TCS[12][	186	]=	0.039551821	;		TCS[13][	186	]=	0.492488882	;		TCS[14][	186	]=	0.154453242	;
	TCS[0][	187	]=	547	;		TCS[1][	187	]=	0.248285238	;		TCS[2][	187	]=	0.278238167	;		TCS[3][	187	]=	0.400047032	;		TCS[4][	187	]=	0.348798303	;		TCS[5][	187	]=	0.337566205	;		TCS[6][	187	]=	0.287273903	;		TCS[7][	187	]=	0.257749049	;		TCS[8][	187	]=	0.252023373	;		TCS[9][	187	]=	0.03436681	;		TCS[10][	187	]=	0.642342813	;		TCS[11][	187	]=	0.239503739	;		TCS[12][	187	]=	0.03830363	;		TCS[13][	187	]=	0.495460934	;		TCS[14][	187	]=	0.154809022	;
	TCS[0][	188	]=	548	;		TCS[1][	188	]=	0.249843969	;		TCS[2][	188	]=	0.279468261	;		TCS[3][	188	]=	0.400318513	;		TCS[4][	188	]=	0.346224217	;		TCS[5][	188	]=	0.335365025	;		TCS[6][	188	]=	0.284520156	;		TCS[7][	188	]=	0.258187227	;		TCS[8][	188	]=	0.252646606	;		TCS[9][	188	]=	0.034562039	;		TCS[10][	188	]=	0.646174628	;		TCS[11][	188	]=	0.235349343	;		TCS[12][	188	]=	0.037179529	;		TCS[13][	188	]=	0.498788545	;		TCS[14][	188	]=	0.155038181	;
	TCS[0][	189	]=	549	;		TCS[1][	189	]=	0.251401801	;		TCS[2][	189	]=	0.280732236	;		TCS[3][	189	]=	0.400326663	;		TCS[4][	189	]=	0.34363342	;		TCS[5][	189	]=	0.333175897	;		TCS[6][	189	]=	0.281777606	;		TCS[7][	189	]=	0.258616936	;		TCS[8][	189	]=	0.253313227	;		TCS[9][	189	]=	0.034771512	;		TCS[10][	189	]=	0.649737629	;		TCS[11][	189	]=	0.231196632	;		TCS[12][	189	]=	0.036103619	;		TCS[13][	189	]=	0.502344104	;		TCS[14][	189	]=	0.155111559	;
	TCS[0][	190	]=	550	;		TCS[1][	190	]=	0.253	;		TCS[2][	190	]=	0.282	;		TCS[3][	190	]=	0.4	;		TCS[4][	190	]=	0.341	;		TCS[5][	190	]=	0.331	;		TCS[6][	190	]=	0.279	;		TCS[7][	190	]=	0.259	;		TCS[8][	190	]=	0.254	;		TCS[9][	190	]=	0.035	;		TCS[10][	190	]=	0.653	;		TCS[11][	190	]=	0.227	;		TCS[12][	190	]=	0.035	;		TCS[13][	190	]=	0.506	;		TCS[14][	190	]=	0.155	;
	TCS[0][	191	]=	551	;		TCS[1][	191	]=	0.254671508	;		TCS[2][	191	]=	0.283254719	;		TCS[3][	191	]=	0.399284302	;		TCS[4][	191	]=	0.338303751	;		TCS[5][	191	]=	0.328835631	;		TCS[6][	191	]=	0.276157345	;		TCS[7][	191	]=	0.259307204	;		TCS[8][	191	]=	0.254692309	;		TCS[9][	191	]=	0.035255518	;		TCS[10][	191	]=	0.655948416	;		TCS[11][	191	]=	0.222731748	;		TCS[12][	191	]=	0.033813495	;		TCS[13][	191	]=	0.509666077	;		TCS[14][	191	]=	0.154685163	;
	TCS[0][	192	]=	552	;		TCS[1][	192	]=	0.256415956	;		TCS[2][	192	]=	0.284532606	;		TCS[3][	192	]=	0.398194382	;		TCS[4][	192	]=	0.335547296	;		TCS[5][	192	]=	0.326669559	;		TCS[6][	192	]=	0.273284699	;		TCS[7][	192	]=	0.259545196	;		TCS[8][	192	]=	0.255410001	;		TCS[9][	192	]=	0.035559049	;		TCS[10][	192	]=	0.658643505	;		TCS[11][	192	]=	0.218435797	;		TCS[12][	192	]=	0.032571813	;		TCS[13][	192	]=	0.513401998	;		TCS[14][	192	]=	0.154191987	;
	TCS[0][	193	]=	553	;		TCS[1][	193	]=	0.258224651	;		TCS[2][	193	]=	0.285883133	;		TCS[3][	193	]=	0.396762311	;		TCS[4][	193	]=	0.332738965	;		TCS[5][	193	]=	0.324485672	;		TCS[6][	193	]=	0.27043338	;		TCS[7][	193	]=	0.259729585	;		TCS[8][	193	]=	0.256181537	;		TCS[9][	193	]=	0.035934822	;		TCS[10][	193	]=	0.661164387	;		TCS[11][	193	]=	0.214173972	;		TCS[12][	193	]=	0.031323384	;		TCS[13][	193	]=	0.517304881	;		TCS[14][	193	]=	0.15355623	;
	TCS[0][	194	]=	554	;		TCS[1][	194	]=	0.260088897	;		TCS[2][	194	]=	0.287355773	;		TCS[3][	194	]=	0.39502016	;		TCS[4][	194	]=	0.32988709	;		TCS[5][	194	]=	0.322267857	;		TCS[6][	194	]=	0.267654708	;		TCS[7][	194	]=	0.259875983	;		TCS[8][	194	]=	0.257035383	;		TCS[9][	194	]=	0.036407063	;		TCS[10][	194	]=	0.663590179	;		TCS[11][	194	]=	0.210008097	;		TCS[12][	194	]=	0.030116636	;		TCS[13][	194	]=	0.521471842	;		TCS[14][	194	]=	0.152813648	;
	TCS[0][	195	]=	555	;		TCS[1][	195	]=	0.262	;		TCS[2][	195	]=	0.289	;		TCS[3][	195	]=	0.393	;		TCS[4][	195	]=	0.327	;		TCS[5][	195	]=	0.32	;		TCS[6][	195	]=	0.265	;		TCS[7][	195	]=	0.26	;		TCS[8][	195	]=	0.258	;		TCS[9][	195	]=	0.037	;		TCS[10][	195	]=	0.666	;		TCS[11][	195	]=	0.206	;		TCS[12][	195	]=	0.029	;		TCS[13][	195	]=	0.526	;		TCS[14][	195	]=	0.152	;
	TCS[0][	196	]=	556	;		TCS[1][	196	]=	0.263949632	;		TCS[2][	196	]=	0.290845075	;		TCS[3][	196	]=	0.39073509	;		TCS[4][	196	]=	0.324083403	;		TCS[5][	196	]=	0.31767122	;		TCS[6][	196	]=	0.262501519	;		TCS[7][	196	]=	0.260110602	;		TCS[8][	196	]=	0.259092005	;		TCS[9][	196	]=	0.037724875	;		TCS[10][	196	]=	0.668452339	;		TCS[11][	196	]=	0.202191584	;		TCS[12][	196	]=	0.028010197	;		TCS[13][	196	]=	0.530950809	;		TCS[14][	196	]=	0.151142104	;
	TCS[0][	197	]=	557	;		TCS[1][	197	]=	0.265930937	;		TCS[2][	197	]=	0.292839411	;		TCS[3][	197	]=	0.388263439	;		TCS[4][	197	]=	0.321132513	;		TCS[5][	197	]=	0.315291558	;		TCS[6][	197	]=	0.2601153	;		TCS[7][	197	]=	0.260190168	;		TCS[8][	197	]=	0.260280625	;		TCS[9][	197	]=	0.038540994	;		TCS[10][	197	]=	0.670923167	;		TCS[11][	197	]=	0.198545073	;		TCS[12][	197	]=	0.027137116	;		TCS[13][	197	]=	0.536243073	;		TCS[14][	197	]=	0.150231028	;
	TCS[0][	198	]=	558	;		TCS[1][	198	]=	0.267937425	;		TCS[2][	198	]=	0.294911209	;		TCS[3][	198	]=	0.385624242	;		TCS[4][	198	]=	0.318139922	;		TCS[5][	198	]=	0.312876286	;		TCS[6][	198	]=	0.257778322	;		TCS[7][	198	]=	0.260214434	;		TCS[8][	198	]=	0.261523244	;		TCS[9][	198	]=	0.039394674	;		TCS[10][	198	]=	0.673367826	;		TCS[11][	198	]=	0.19500277	;		TCS[12][	198	]=	0.026358936	;		TCS[13][	198	]=	0.541759932	;		TCS[14][	198	]=	0.1492489	;
	TCS[0][	199	]=	559	;		TCS[1][	199	]=	0.269962609	;		TCS[2][	199	]=	0.296988672	;		TCS[3][	199	]=	0.382856697	;		TCS[4][	199	]=	0.31509822	;		TCS[5][	199	]=	0.310440676	;		TCS[6][	199	]=	0.255427563	;		TCS[7][	199	]=	0.260159133	;		TCS[8][	199	]=	0.262777241	;		TCS[9][	199	]=	0.040232236	;		TCS[10][	199	]=	0.675741656	;		TCS[11][	199	]=	0.191506978	;		TCS[12][	199	]=	0.025653837	;		TCS[13][	199	]=	0.547384527	;		TCS[14][	199	]=	0.148177848	;
	TCS[0][	200	]=	560	;		TCS[1][	200	]=	0.272	;		TCS[2][	200	]=	0.299	;		TCS[3][	200	]=	0.38	;		TCS[4][	200	]=	0.312	;		TCS[5][	200	]=	0.308	;		TCS[6][	200	]=	0.253	;		TCS[7][	200	]=	0.26	;		TCS[8][	200	]=	0.264	;		TCS[9][	200	]=	0.041	;		TCS[10][	200	]=	0.678	;		TCS[11][	200	]=	0.188	;		TCS[12][	200	]=	0.025	;		TCS[13][	200	]=	0.553	;		TCS[14][	200	]=	0.147	;
	TCS[0][	201	]=	561	;		TCS[1][	201	]=	0.274049965	;		TCS[2][	201	]=	0.300900982	;		TCS[3][	201	]=	0.377087338	;		TCS[4][	201	]=	0.308842638	;		TCS[5][	201	]=	0.305567489	;		TCS[6][	201	]=	0.250460578	;		TCS[7][	201	]=	0.259722388	;		TCS[8][	201	]=	0.265155672	;		TCS[9][	201	]=	0.041660981	;		TCS[10][	201	]=	0.680106228	;		TCS[11][	201	]=	0.184437915	;		TCS[12][	201	]=	0.024377715	;		TCS[13][	201	]=	0.558530687	;		TCS[14][	201	]=	0.145706419	;
	TCS[0][	202	]=	562	;		TCS[1][	202	]=	0.276140298	;		TCS[2][	202	]=	0.302757751	;		TCS[3][	202	]=	0.374127863	;		TCS[4][	202	]=	0.305642652	;		TCS[5][	202	]=	0.303148209	;		TCS[6][	202	]=	0.247886099	;		TCS[7][	202	]=	0.259350131	;		TCS[8][	202	]=	0.266235498	;		TCS[9][	202	]=	0.042244976	;		TCS[10][	202	]=	0.682055827	;		TCS[11][	202	]=	0.18083191	;		TCS[12][	202	]=	0.023775723	;		TCS[13][	202	]=	0.564065711	;		TCS[14][	202	]=	0.1443239	;
	TCS[0][	203	]=	563	;		TCS[1][	203	]=	0.278305648	;		TCS[2][	203	]=	0.30466403	;		TCS[3][	203	]=	0.371124719	;		TCS[4][	203	]=	0.302421348	;		TCS[5][	203	]=	0.300745184	;		TCS[6][	203	]=	0.245381331	;		TCS[7][	203	]=	0.258916679	;		TCS[8][	203	]=	0.267237487	;		TCS[9][	203	]=	0.042798482	;		TCS[10][	203	]=	0.683852311	;		TCS[11][	203	]=	0.177206947	;		TCS[12][	203	]=	0.023184872	;		TCS[13][	203	]=	0.569735392	;		TCS[14][	203	]=	0.142888171	;
	TCS[0][	204	]=	564	;		TCS[1][	204	]=	0.280580665	;		TCS[2][	204	]=	0.306713539	;		TCS[3][	204	]=	0.36808105	;		TCS[4][	204	]=	0.299200029	;		TCS[5][	204	]=	0.29836144	;		TCS[6][	204	]=	0.243051042	;		TCS[7][	204	]=	0.258455484	;		TCS[8][	204	]=	0.268159651	;		TCS[9][	204	]=	0.043367992	;		TCS[10][	204	]=	0.685499197	;		TCS[11][	204	]=	0.173587989	;		TCS[12][	204	]=	0.022596014	;		TCS[13][	204	]=	0.575670048	;		TCS[14][	204	]=	0.141434961	;
	TCS[0][	205	]=	565	;		TCS[1][	205	]=	0.283	;		TCS[2][	205	]=	0.309	;		TCS[3][	205	]=	0.365	;		TCS[4][	205	]=	0.296	;		TCS[5][	205	]=	0.296	;		TCS[6][	205	]=	0.241	;		TCS[7][	205	]=	0.258	;		TCS[8][	205	]=	0.269	;		TCS[9][	205	]=	0.044	;		TCS[10][	205	]=	0.687	;		TCS[11][	205	]=	0.17	;		TCS[12][	205	]=	0.022	;		TCS[13][	205	]=	0.582	;		TCS[14][	205	]=	0.14	;
	TCS[0][	206	]=	566	;		TCS[1][	206	]=	0.285594509	;		TCS[2][	206	]=	0.311574999	;		TCS[3][	206	]=	0.361883559	;		TCS[4][	206	]=	0.292834046	;		TCS[5][	206	]=	0.293658824	;		TCS[6][	206	]=	0.23929617	;		TCS[7][	206	]=	0.257575845	;		TCS[8][	206	]=	0.269757306	;		TCS[9][	206	]=	0.044727202	;		TCS[10][	206	]=	0.688362749	;		TCS[11][	206	]=	0.166464755	;		TCS[12][	206	]=	0.021390941	;		TCS[13][	206	]=	0.588806443	;		TCS[14][	206	]=	0.13860822	;
	TCS[0][	207	]=	567	;		TCS[1][	207	]=	0.288379873	;		TCS[2][	207	]=	0.314321584	;		TCS[3][	207	]=	0.35872911	;		TCS[4][	207	]=	0.289680878	;		TCS[5][	207	]=	0.291315607	;		TCS[6][	207	]=	0.237860304	;		TCS[7][	207	]=	0.257177309	;		TCS[8][	207	]=	0.270433383	;		TCS[9][	207	]=	0.045527101	;		TCS[10][	207	]=	0.689613527	;		TCS[11][	207	]=	0.162991287	;		TCS[12][	207	]=	0.020775993	;		TCS[13][	207	]=	0.595974083	;		TCS[14][	207	]=	0.137241374	;
	TCS[0][	208	]=	568	;		TCS[1][	208	]=	0.291367984	;		TCS[2][	208	]=	0.31708067	;		TCS[3][	208	]=	0.35553288	;		TCS[4][	208	]=	0.286510686	;		TCS[5][	208	]=	0.288942978	;		TCS[6][	208	]=	0.236576354	;		TCS[7][	208	]=	0.256790851	;		TCS[8][	208	]=	0.271030807	;		TCS[9][	208	]=	0.046363398	;		TCS[10][	208	]=	0.69078293	;		TCS[11][	208	]=	0.159585441	;		TCS[12][	208	]=	0.020165576	;		TCS[13][	208	]=	0.6033385	;		TCS[14][	208	]=	0.135870417	;
	TCS[0][	209	]=	569	;		TCS[1][	209	]=	0.29457073	;		TCS[2][	209	]=	0.31969317	;		TCS[3][	209	]=	0.352291101	;		TCS[4][	209	]=	0.283293663	;		TCS[5][	209	]=	0.286513566	;		TCS[6][	209	]=	0.235328269	;		TCS[7][	209	]=	0.256402929	;		TCS[8][	209	]=	0.271552154	;		TCS[9][	209	]=	0.047199796	;		TCS[10][	209	]=	0.691901556	;		TCS[11][	209	]=	0.156253064	;		TCS[12][	209	]=	0.019570105	;		TCS[13][	209	]=	0.610735279	;		TCS[14][	209	]=	0.134466307	;
	TCS[0][	210	]=	570	;		TCS[1][	210	]=	0.298	;		TCS[2][	210	]=	0.322	;		TCS[3][	210	]=	0.349	;		TCS[4][	210	]=	0.28	;		TCS[5][	210	]=	0.284	;		TCS[6][	210	]=	0.234	;		TCS[7][	210	]=	0.256	;		TCS[8][	210	]=	0.272	;		TCS[9][	210	]=	0.048	;		TCS[10][	210	]=	0.693	;		TCS[11][	210	]=	0.153	;		TCS[12][	210	]=	0.019	;		TCS[13][	210	]=	0.618	;		TCS[14][	210	]=	0.133	;
	TCS[0][	211	]=	571	;		TCS[1][	211	]=	0.301660001	;		TCS[2][	211	]=	0.323887024	;		TCS[3][	211	]=	0.345658425	;		TCS[4][	211	]=	0.276613178	;		TCS[5][	211	]=	0.281389215	;		TCS[6][	211	]=	0.232514744	;		TCS[7][	211	]=	0.255574232	;		TCS[8][	211	]=	0.272383105	;		TCS[9][	211	]=	0.04874221	;		TCS[10][	211	]=	0.694098776	;		TCS[11][	211	]=	0.149831064	;		TCS[12][	211	]=	0.018466521	;		TCS[13][	211	]=	0.625003541	;		TCS[14][	211	]=	0.131452701	;
	TCS[0][	212	]=	572	;		TCS[1][	212	]=	0.305524209	;		TCS[2][	212	]=	0.325419913	;		TCS[3][	212	]=	0.342275699	;		TCS[4][	212	]=	0.273169837	;		TCS[5][	212	]=	0.278725364	;		TCS[6][	212	]=	0.230952684	;		TCS[7][	212	]=	0.255140633	;		TCS[8][	212	]=	0.27273497	;		TCS[9][	212	]=	0.049462621	;		TCS[10][	212	]=	0.695178066	;		TCS[11][	212	]=	0.146746941	;		TCS[12][	212	]=	0.017984304	;		TCS[13][	212	]=	0.631757959	;		TCS[14][	212	]=	0.129846606	;
	TCS[0][	213	]=	573	;		TCS[1][	213	]=	0.309558416	;		TCS[2][	213	]=	0.326709291	;		TCS[3][	213	]=	0.338863759	;		TCS[4][	213	]=	0.269719908	;		TCS[5][	213	]=	0.276066906	;		TCS[6][	213	]=	0.229433253	;		TCS[7][	213	]=	0.254719916	;		TCS[8][	213	]=	0.273095284	;		TCS[9][	213	]=	0.050211927	;		TCS[10][	213	]=	0.696207968	;		TCS[11][	213	]=	0.143747287	;		TCS[12][	213	]=	0.017568826	;		TCS[13][	213	]=	0.638310606	;		TCS[14][	213	]=	0.128214161	;
	TCS[0][	214	]=	574	;		TCS[1][	214	]=	0.313728415	;		TCS[2][	214	]=	0.327865779	;		TCS[3][	214	]=	0.335434546	;		TCS[4][	214	]=	0.266313319	;		TCS[5][	214	]=	0.273472298	;		TCS[6][	214	]=	0.228075881	;		TCS[7][	214	]=	0.2543328	;		TCS[8][	214	]=	0.273503731	;		TCS[9][	214	]=	0.051040823	;		TCS[10][	214	]=	0.69715858	;		TCS[11][	214	]=	0.140831755	;		TCS[12][	214	]=	0.017235565	;		TCS[13][	214	]=	0.644708836	;		TCS[14][	214	]=	0.126587811	;
	TCS[0][	215	]=	575	;		TCS[1][	215	]=	0.318	;		TCS[2][	215	]=	0.329	;		TCS[3][	215	]=	0.332	;		TCS[4][	215	]=	0.263	;		TCS[5][	215	]=	0.271	;		TCS[6][	215	]=	0.227	;		TCS[7][	215	]=	0.254	;		TCS[8][	215	]=	0.274	;		TCS[9][	215	]=	0.052	;		TCS[10][	215	]=	0.698	;		TCS[11][	215	]=	0.138	;		TCS[12][	215	]=	0.017	;		TCS[13][	215	]=	0.651	;		TCS[14][	215	]=	0.125	;
	TCS[0][	216	]=	576	;		TCS[1][	216	]=	0.322349488	;		TCS[2][	216	]=	0.330196906	;		TCS[3][	216	]=	0.328570739	;		TCS[4][	216	]=	0.259809242	;		TCS[5][	216	]=	0.268688316	;		TCS[6][	216	]=	0.226284856	;		TCS[7][	216	]=	0.253743226	;		TCS[8][	216	]=	0.274614275	;		TCS[9][	216	]=	0.053135958	;		TCS[10][	216	]=	0.698714146	;		TCS[11][	216	]=	0.13525099	;		TCS[12][	216	]=	0.016870974	;		TCS[13][	216	]=	0.657211394	;		TCS[14][	216	]=	0.123476976	;
	TCS[0][	217	]=	577	;		TCS[1][	217	]=	0.326795292	;		TCS[2][	217	]=	0.331438763	;		TCS[3][	217	]=	0.325152096	;		TCS[4][	217	]=	0.256687773	;		TCS[5][	217	]=	0.266494937	;		TCS[6][	217	]=	0.225848959	;		TCS[7][	217	]=	0.253588161	;		TCS[8][	217	]=	0.275338735	;		TCS[9][	217	]=	0.054478415	;		TCS[10][	217	]=	0.699330208	;		TCS[11][	217	]=	0.132580947	;		TCS[12][	217	]=	0.016830791	;		TCS[13][	217	]=	0.663290083	;		TCS[14][	217	]=	0.122020201	;
	TCS[0][	218	]=	578	;		TCS[1][	218	]=	0.331366353	;		TCS[2][	218	]=	0.332682167	;		TCS[3][	218	]=	0.321748084	;		TCS[4][	218	]=	0.253561684	;		TCS[5][	218	]=	0.2643574	;		TCS[6][	218	]=	0.225570633	;		TCS[7][	218	]=	0.253561483	;		TCS[8][	218	]=	0.276156058	;		TCS[9][	218	]=	0.056052893	;		TCS[10][	218	]=	0.699889198	;		TCS[11][	218	]=	0.12998541	;		TCS[12][	218	]=	0.016855121	;		TCS[13][	218	]=	0.669163075	;		TCS[14][	218	]=	0.120624937	;
	TCS[0][	219	]=	579	;		TCS[1][	219	]=	0.33609161	;		TCS[2][	219	]=	0.333883714	;		TCS[3][	219	]=	0.318362715	;		TCS[4][	219	]=	0.250357063	;		TCS[5][	219	]=	0.262213242	;		TCS[6][	219	]=	0.225328205	;		TCS[7][	219	]=	0.25368987	;		TCS[8][	219	]=	0.277048921	;		TCS[9][	219	]=	0.057884914	;		TCS[10][	219	]=	0.700432125	;		TCS[11][	219	]=	0.127459915	;		TCS[12][	219	]=	0.016919634	;		TCS[13][	219	]=	0.674757378	;		TCS[14][	219	]=	0.119286449	;
	TCS[0][	220	]=	580	;		TCS[1][	220	]=	0.341	;		TCS[2][	220	]=	0.335	;		TCS[3][	220	]=	0.315	;		TCS[4][	220	]=	0.247	;		TCS[5][	220	]=	0.26	;		TCS[6][	220	]=	0.225	;		TCS[7][	220	]=	0.254	;		TCS[8][	220	]=	0.278	;		TCS[9][	220	]=	0.06	;		TCS[10][	220	]=	0.701	;		TCS[11][	220	]=	0.125	;		TCS[12][	220	]=	0.017	;		TCS[13][	220	]=	0.68	;		TCS[14][	220	]=	0.118	;
	TCS[0][	221	]=	581	;		TCS[1][	221	]=	0.346102049	;		TCS[2][	221	]=	0.335997354	;		TCS[3][	221	]=	0.311666619	;		TCS[4][	221	]=	0.243445855	;		TCS[5][	221	]=	0.257665521	;		TCS[6][	221	]=	0.224497833	;		TCS[7][	221	]=	0.254516866	;		TCS[8][	221	]=	0.278999795	;		TCS[9][	221	]=	0.062425957	;		TCS[10][	221	]=	0.701620641	;		TCS[11][	221	]=	0.122604978	;		TCS[12][	221	]=	0.017073584	;		TCS[13][	221	]=	0.684838883	;		TCS[14][	221	]=	0.116759393	;
	TCS[0][	222	]=	582	;		TCS[1][	222	]=	0.351334622	;		TCS[2][	222	]=	0.336881036	;		TCS[3][	222	]=	0.308379916	;		TCS[4][	222	]=	0.23976707	;		TCS[5][	222	]=	0.255198888	;		TCS[6][	222	]=	0.223867481	;		TCS[7][	222	]=	0.255258725	;		TCS[8][	222	]=	0.280070088	;		TCS[9][	222	]=	0.065199719	;		TCS[10][	222	]=	0.702269101	;		TCS[11][	222	]=	0.12028927	;		TCS[12][	222	]=	0.017124533	;		TCS[13][	222	]=	0.68930571	;		TCS[14][	222	]=	0.11555259	;
	TCS[0][	223	]=	583	;		TCS[1][	223	]=	0.356616171	;		TCS[2][	223	]=	0.337666042	;		TCS[3][	223	]=	0.305159904	;		TCS[4][	223	]=	0.236065358	;		TCS[5][	223	]=	0.252599494	;		TCS[6][	223	]=	0.223188213	;		TCS[7][	223	]=	0.256242151	;		TCS[8][	223	]=	0.281240483	;		TCS[9][	223	]=	0.068360502	;		TCS[10][	223	]=	0.70290724	;		TCS[11][	223	]=	0.118071073	;		TCS[12][	223	]=	0.01713869	;		TCS[13][	223	]=	0.693453094	;		TCS[14][	223	]=	0.114366089	;
	TCS[0][	224	]=	584	;		TCS[1][	224	]=	0.361865146	;		TCS[2][	224	]=	0.338367365	;		TCS[3][	224	]=	0.302026595	;		TCS[4][	224	]=	0.23244243	;		TCS[5][	224	]=	0.249866734	;		TCS[6][	224	]=	0.222539297	;		TCS[7][	224	]=	0.257483718	;		TCS[8][	224	]=	0.282540586	;		TCS[9][	224	]=	0.071947523	;		TCS[10][	224	]=	0.703496919	;		TCS[11][	224	]=	0.115968584	;		TCS[12][	224	]=	0.017101898	;		TCS[13][	224	]=	0.697333652	;		TCS[14][	224	]=	0.113186393	;
	TCS[0][	225	]=	585	;		TCS[1][	225	]=	0.367	;		TCS[2][	225	]=	0.339	;		TCS[3][	225	]=	0.299	;		TCS[4][	225	]=	0.229	;		TCS[5][	225	]=	0.247	;		TCS[6][	225	]=	0.222	;		TCS[7][	225	]=	0.259	;		TCS[8][	225	]=	0.284	;		TCS[9][	225	]=	0.076	;		TCS[10][	225	]=	0.704	;		TCS[11][	225	]=	0.114	;		TCS[12][	225	]=	0.017	;		TCS[13][	225	]=	0.701	;		TCS[14][	225	]=	0.112	;
	TCS[0][	226	]=	586	;		TCS[1][	226	]=	0.371954317	;		TCS[2][	226	]=	0.33957368	;		TCS[3][	226	]=	0.296090786	;		TCS[4][	226	]=	0.225807338	;		TCS[5][	226	]=	0.244009602	;		TCS[6][	226	]=	0.221627813	;		TCS[7][	226	]=	0.260797312	;		TCS[8][	226	]=	0.285650546	;		TCS[9][	226	]=	0.080536214	;		TCS[10][	226	]=	0.70438729	;		TCS[11][	226	]=	0.112177098	;		TCS[12][	226	]=	0.016826692	;		TCS[13][	226	]=	0.704497072	;		TCS[14][	226	]=	0.110797451	;
	TCS[0][	227	]=	587	;		TCS[1][	227	]=	0.376722219	;		TCS[2][	227	]=	0.340077094	;		TCS[3][	227	]=	0.293272238	;		TCS[4][	227	]=	0.222803946	;		TCS[5][	227	]=	0.240949512	;		TCS[6][	227	]=	0.221393117	;		TCS[7][	227	]=	0.262840941	;		TCS[8][	227	]=	0.287532914	;		TCS[9][	227	]=	0.085490711	;		TCS[10][	227	]=	0.704665389	;		TCS[11][	227	]=	0.110485972	;		TCS[12][	227	]=	0.016607079	;		TCS[13][	227	]=	0.707839079	;		TCS[14][	227	]=	0.109585441	;
	TCS[0][	228	]=	588	;		TCS[1][	228	]=	0.381312963	;		TCS[2][	228	]=	0.340493667	;		TCS[3][	228	]=	0.290508298	;		TCS[4][	228	]=	0.219896886	;		TCS[5][	228	]=	0.237884623	;		TCS[6][	228	]=	0.221244515	;		TCS[7][	228	]=	0.265085913	;		TCS[8][	228	]=	0.289690008	;		TCS[9][	228	]=	0.0907771	;		TCS[10][	228	]=	0.704849842	;		TCS[11][	228	]=	0.108906298	;		TCS[12][	228	]=	0.01637412	;		TCS[13][	228	]=	0.711032549	;		TCS[14][	228	]=	0.108374705	;
	TCS[0][	229	]=	589	;		TCS[1][	229	]=	0.385735804	;		TCS[2][	229	]=	0.340806827	;		TCS[3][	229	]=	0.287762905	;		TCS[4][	229	]=	0.216993217	;		TCS[5][	229	]=	0.234879822	;		TCS[6][	229	]=	0.221130608	;		TCS[7][	229	]=	0.267487257	;		TCS[8][	229	]=	0.292164735	;		TCS[9][	229	]=	0.096308993	;		TCS[10][	229	]=	0.704956197	;		TCS[11][	229	]=	0.107417749	;		TCS[12][	229	]=	0.016160774	;		TCS[13][	229	]=	0.714084013	;		TCS[14][	229	]=	0.10717598	;
	TCS[0][	230	]=	590	;		TCS[1][	230	]=	0.39	;		TCS[2][	230	]=	0.341	;		TCS[3][	230	]=	0.285	;		TCS[4][	230	]=	0.214	;		TCS[5][	230	]=	0.232	;		TCS[6][	230	]=	0.221	;		TCS[7][	230	]=	0.27	;		TCS[8][	230	]=	0.295	;		TCS[9][	230	]=	0.102	;		TCS[10][	230	]=	0.705	;		TCS[11][	230	]=	0.106	;		TCS[12][	230	]=	0.016	;		TCS[13][	230	]=	0.717	;		TCS[14][	230	]=	0.106	;
	TCS[0][	231	]=	591	;		TCS[1][	231	]=	0.394112684	;		TCS[2][	231	]=	0.341067926	;		TCS[3][	231	]=	0.282202238	;		TCS[4][	231	]=	0.210852793	;		TCS[5][	231	]=	0.229296073	;		TCS[6][	231	]=	0.220814914	;		TCS[7][	231	]=	0.272589885	;		TCS[8][	231	]=	0.29823802	;		TCS[9][	231	]=	0.107813187	;		TCS[10][	231	]=	0.704998199	;		TCS[11][	231	]=	0.104638631	;		TCS[12][	231	]=	0.01591565	;		TCS[13][	231	]=	0.719780828	;		TCS[14][	231	]=	0.104858804	;
	TCS[0][	232	]=	592	;		TCS[1][	232	]=	0.398072501	;		TCS[2][	232	]=	0.34105059	;		TCS[3][	232	]=	0.27942713	;		TCS[4][	232	]=	0.207601144	;		TCS[5][	232	]=	0.226763063	;		TCS[6][	232	]=	0.22059205	;		TCS[7][	232	]=	0.275265513	;		TCS[8][	232	]=	0.301918258	;		TCS[9][	232	]=	0.113909439	;		TCS[10][	232	]=	0.704973345	;		TCS[11][	232	]=	0.103342841	;		TCS[12][	232	]=	0.015895152	;		TCS[13][	232	]=	0.722401975	;		TCS[14][	232	]=	0.103769648	;
	TCS[0][	233	]=	593	;		TCS[1][	233	]=	0.401875977	;		TCS[2][	233	]=	0.340999292	;		TCS[3][	233	]=	0.276750904	;		TCS[4][	233	]=	0.204323099	;		TCS[5][	233	]=	0.224382015	;		TCS[6][	233	]=	0.220361729	;		TCS[7][	233	]=	0.278046198	;		TCS[8][	233	]=	0.306079485	;		TCS[9][	233	]=	0.120499098	;		TCS[10][	233	]=	0.704949392	;		TCS[11][	233	]=	0.102127736	;		TCS[12][	233	]=	0.015916829	;		TCS[13][	233	]=	0.724832708	;		TCS[14][	233	]=	0.102751089	;
	TCS[0][	234	]=	594	;		TCS[1][	234	]=	0.405519636	;		TCS[2][	234	]=	0.340965329	;		TCS[3][	234	]=	0.274249785	;		TCS[4][	234	]=	0.201096702	;		TCS[5][	234	]=	0.222133979	;		TCS[6][	234	]=	0.220154272	;		TCS[7][	234	]=	0.280951255	;		TCS[8][	234	]=	0.310760475	;		TCS[9][	234	]=	0.127792505	;		TCS[10][	234	]=	0.704950293	;		TCS[11][	234	]=	0.101008421	;		TCS[12][	234	]=	0.015959005	;		TCS[13][	234	]=	0.727042294	;		TCS[14][	234	]=	0.101821687	;
	TCS[0][	235	]=	595	;		TCS[1][	235	]=	0.409	;		TCS[2][	235	]=	0.341	;		TCS[3][	235	]=	0.272	;		TCS[4][	235	]=	0.198	;		TCS[5][	235	]=	0.22	;		TCS[6][	235	]=	0.22	;		TCS[7][	235	]=	0.284	;		TCS[8][	235	]=	0.316	;		TCS[9][	235	]=	0.136	;		TCS[10][	235	]=	0.705	;		TCS[11][	235	]=	0.1	;		TCS[12][	235	]=	0.016	;		TCS[13][	235	]=	0.729	;		TCS[14][	235	]=	0.101	;
	TCS[0][	236	]=	596	;		TCS[1][	236	]=	0.412314949	;		TCS[2][	236	]=	0.341138617	;		TCS[3][	236	]=	0.270052263	;		TCS[4][	236	]=	0.195093489	;		TCS[5][	236	]=	0.217958106	;		TCS[6][	236	]=	0.219920532	;		TCS[7][	236	]=	0.287211147	;		TCS[8][	236	]=	0.321805372	;		TCS[9][	236	]=	0.145267039	;		TCS[10][	236	]=	0.705115915	;		TCS[11][	236	]=	0.099108379	;		TCS[12][	236	]=	0.01602271	;		TCS[13][	236	]=	0.730691615	;		TCS[14][	236	]=	0.100295332	;
	TCS[0][	237	]=	597	;		TCS[1][	237	]=	0.415467775	;		TCS[2][	237	]=	0.341352547	;		TCS[3][	237	]=	0.26835524	;		TCS[4][	237	]=	0.192367476	;		TCS[5][	237	]=	0.215974237	;		TCS[6][	237	]=	0.219902684	;		TCS[7][	237	]=	0.290601008	;		TCS[8][	237	]=	0.328058055	;		TCS[9][	237	]=	0.155479533	;		TCS[10][	237	]=	0.705289231	;		TCS[11][	237	]=	0.098302663	;		TCS[12][	237	]=	0.016028313	;		TCS[13][	237	]=	0.73216902	;		TCS[14][	237	]=	0.099679968	;
	TCS[0][	238	]=	598	;		TCS[1][	238	]=	0.418463127	;		TCS[2][	238	]=	0.341597167	;		TCS[3][	238	]=	0.266832086	;		TCS[4][	238	]=	0.189794718	;		TCS[5][	238	]=	0.214011316	;		TCS[6][	238	]=	0.21992457	;		TCS[7][	238	]=	0.294185296	;		TCS[8][	238	]=	0.334608053	;		TCS[9][	238	]=	0.166458508	;		TCS[10][	238	]=	0.705504589	;		TCS[11][	238	]=	0.097542757	;		TCS[12][	238	]=	0.016022562	;		TCS[13][	238	]=	0.733500618	;		TCS[14][	238	]=	0.099116938	;
	TCS[0][	239	]=	599	;		TCS[1][	239	]=	0.421305653	;		TCS[2][	239	]=	0.341827858	;		TCS[3][	239	]=	0.265405954	;		TCS[4][	239	]=	0.187347974	;		TCS[5][	239	]=	0.212032263	;		TCS[6][	239	]=	0.219964304	;		TCS[7][	239	]=	0.297979722	;		TCS[8][	239	]=	0.341305367	;		TCS[9][	239	]=	0.178024988	;		TCS[10][	239	]=	0.705746632	;		TCS[11][	239	]=	0.096788568	;		TCS[12][	239	]=	0.016011207	;		TCS[13][	239	]=	0.73475481	;		TCS[14][	239	]=	0.098569272	;
	TCS[0][	240	]=	600	;		TCS[1][	240	]=	0.424	;		TCS[2][	240	]=	0.342	;		TCS[3][	240	]=	0.264	;		TCS[4][	240	]=	0.185	;		TCS[5][	240	]=	0.21	;		TCS[6][	240	]=	0.22	;		TCS[7][	240	]=	0.302	;		TCS[8][	240	]=	0.348	;		TCS[9][	240	]=	0.19	;		TCS[10][	240	]=	0.706	;		TCS[11][	240	]=	0.096	;		TCS[12][	240	]=	0.016	;		TCS[13][	240	]=	0.736	;		TCS[14][	240	]=	0.098	;
	TCS[0][	241	]=	601	;		TCS[1][	241	]=	0.426547522	;		TCS[2][	241	]=	0.342081605	;		TCS[3][	241	]=	0.262556711	;		TCS[4][	241	]=	0.182733249	;		TCS[5][	241	]=	0.207895505	;		TCS[6][	241	]=	0.220014958	;		TCS[7][	241	]=	0.306245528	;		TCS[8][	241	]=	0.354604491	;		TCS[9][	241	]=	0.202254657	;		TCS[10][	241	]=	0.706250142	;		TCS[11][	241	]=	0.095151853	;		TCS[12][	241	]=	0.015993512	;		TCS[13][	241	]=	0.73728471	;		TCS[14][	241	]=	0.097383867	;
	TCS[0][	242	]=	602	;		TCS[1][	242	]=	0.428936398	;		TCS[2][	242	]=	0.342091224	;		TCS[3][	242	]=	0.261095909	;		TCS[4][	242	]=	0.18056895	;		TCS[5][	242	]=	0.205771988	;		TCS[6][	242	]=	0.220013215	;		TCS[7][	242	]=	0.310650456	;		TCS[8][	242	]=	0.361281521	;		TCS[9][	242	]=	0.214860429	;		TCS[10][	242	]=	0.706485731	;		TCS[11][	242	]=	0.094278507	;		TCS[12][	242	]=	0.015991595	;		TCS[13][	242	]=	0.738577943	;		TCS[14][	242	]=	0.096742479	;
	TCS[0][	243	]=	603	;		TCS[1][	243	]=	0.431151513	;		TCS[2][	243	]=	0.34206004	;		TCS[3][	243	]=	0.259656753	;		TCS[4][	243	]=	0.178538027	;		TCS[5][	243	]=	0.20370072	;		TCS[6][	243	]=	0.220003992	;		TCS[7][	243	]=	0.31513262	;		TCS[8][	243	]=	0.368256305	;		TCS[9][	243	]=	0.227938872	;		TCS[10][	243	]=	0.70669625	;		TCS[11][	243	]=	0.093429234	;		TCS[12][	243	]=	0.015992922	;		TCS[13][	243	]=	0.739828821	;		TCS[14][	243	]=	0.096109157	;
	TCS[0][	244	]=	604	;		TCS[1][	244	]=	0.433177752	;		TCS[2][	244	]=	0.342019237	;		TCS[3][	244	]=	0.258278397	;		TCS[4][	244	]=	0.176671403	;		TCS[5][	244	]=	0.201752967	;		TCS[6][	244	]=	0.219996513	;		TCS[7][	244	]=	0.319609855	;		TCS[8][	244	]=	0.375754059	;		TCS[9][	244	]=	0.241611543	;		TCS[10][	244	]=	0.706871179	;		TCS[11][	244	]=	0.092653307	;		TCS[12][	244	]=	0.015996166	;		TCS[13][	244	]=	0.740986466	;		TCS[14][	244	]=	0.095517224	;
	TCS[0][	245	]=	605	;		TCS[1][	245	]=	0.435	;		TCS[2][	245	]=	0.342	;		TCS[3][	245	]=	0.257	;		TCS[4][	245	]=	0.175	;		TCS[5][	245	]=	0.2	;		TCS[6][	245	]=	0.22	;		TCS[7][	245	]=	0.324	;		TCS[8][	245	]=	0.384	;		TCS[9][	245	]=	0.256	;		TCS[10][	245	]=	0.707	;		TCS[11][	245	]=	0.092	;		TCS[12][	245	]=	0.016	;		TCS[13][	245	]=	0.742	;		TCS[14][	245	]=	0.095	;
	TCS[0][	246	]=	606	;		TCS[1][	246	]=	0.436614964	;		TCS[2][	246	]=	0.342022962	;		TCS[3][	246	]=	0.255848894	;		TCS[4][	246	]=	0.173541514	;		TCS[5][	246	]=	0.198491875	;		TCS[6][	246	]=	0.220019637	;		TCS[7][	246	]=	0.328238741	;		TCS[8][	246	]=	0.393136663	;		TCS[9][	246	]=	0.271170331	;		TCS[10][	246	]=	0.707075519	;		TCS[11][	246	]=	0.091500207	;		TCS[12][	246	]=	0.016003243	;		TCS[13][	246	]=	0.742833543	;		TCS[14][	246	]=	0.094577201	;
	TCS[0][	247	]=	607	;		TCS[1][	247	]=	0.438066634	;		TCS[2][	247	]=	0.342066558	;		TCS[3][	247	]=	0.254805123	;		TCS[4][	247	]=	0.172260722	;		TCS[5][	247	]=	0.197193809	;		TCS[6][	247	]=	0.220044458	;		TCS[7][	247	]=	0.332333169	;		TCS[8][	247	]=	0.402975861	;		TCS[9][	247	]=	0.286966751	;		TCS[10][	247	]=	0.707103844	;		TCS[11][	247	]=	0.091111309	;		TCS[12][	247	]=	0.016005307	;		TCS[13][	247	]=	0.743511206	;		TCS[14][	247	]=	0.094214117	;
	TCS[0][	248	]=	608	;		TCS[1][	248	]=	0.439410822	;		TCS[2][	248	]=	0.342098673	;		TCS[3][	248	]=	0.253836904	;		TCS[4][	248	]=	0.171109173	;		TCS[5][	248	]=	0.196049805	;		TCS[6][	248	]=	0.220059461	;		TCS[7][	248	]=	0.336308226	;		TCS[8][	248	]=	0.413246728	;		TCS[9][	248	]=	0.303178006	;		TCS[10][	248	]=	0.70709441	;		TCS[11][	248	]=	0.090772307	;		TCS[12][	248	]=	0.016005748	;		TCS[13][	248	]=	0.744072098	;		TCS[14][	248	]=	0.093862433	;
	TCS[0][	249	]=	609	;		TCS[1][	249	]=	0.44070334	;		TCS[2][	249	]=	0.342087192	;		TCS[3][	249	]=	0.252912456	;		TCS[4][	249	]=	0.170038416	;		TCS[5][	249	]=	0.195003867	;		TCS[6][	249	]=	0.220049642	;		TCS[7][	249	]=	0.340188856	;		TCS[8][	249	]=	0.423678396	;		TCS[9][	249	]=	0.31959284	;		TCS[10][	249	]=	0.70705665	;		TCS[11][	249	]=	0.090422203	;		TCS[12][	249	]=	0.016004127	;		TCS[13][	249	]=	0.744555326	;		TCS[14][	249	]=	0.093473833	;
	TCS[0][	250	]=	610	;		TCS[1][	250	]=	0.442	;		TCS[2][	250	]=	0.342	;		TCS[3][	250	]=	0.252	;		TCS[4][	250	]=	0.169	;		TCS[5][	250	]=	0.194	;		TCS[6][	250	]=	0.22	;		TCS[7][	250	]=	0.344	;		TCS[8][	250	]=	0.434	;		TCS[9][	250	]=	0.336	;		TCS[10][	250	]=	0.707	;		TCS[11][	250	]=	0.09	;		TCS[12][	250	]=	0.016	;		TCS[13][	250	]=	0.745	;		TCS[14][	250	]=	0.093	;
	TCS[0][	251	]=	611	;		TCS[1][	251	]=	0.443336623	;		TCS[2][	251	]=	0.341818547	;		TCS[3][	251	]=	0.251071711	;		TCS[4][	251	]=	0.167956696	;		TCS[5][	251	]=	0.192992993	;		TCS[6][	251	]=	0.219906496	;		TCS[7][	251	]=	0.347759509	;		TCS[8][	251	]=	0.444000858	;		TCS[9][	251	]=	0.352248017	;		TCS[10][	251	]=	0.706935784	;		TCS[11][	251	]=	0.089463318	;		TCS[12][	251	]=	0.015993515	;		TCS[13][	251	]=	0.745437117	;		TCS[14][	251	]=	0.092411329	;
	TCS[0][	252	]=	612	;		TCS[1][	252	]=	0.444669067	;		TCS[2][	252	]=	0.341578545	;		TCS[3][	252	]=	0.2501156	;		TCS[4][	252	]=	0.166916162	;		TCS[5][	252	]=	0.191980776	;		TCS[6][	252	]=	0.219808954	;		TCS[7][	252	]=	0.35145687	;		TCS[8][	252	]=	0.453711036	;		TCS[9][	252	]=	0.368424565	;		TCS[10][	252	]=	0.706882893	;		TCS[11][	252	]=	0.088844257	;		TCS[12][	252	]=	0.015987178	;		TCS[13][	252	]=	0.745865232	;		TCS[14][	252	]=	0.091753052	;
	TCS[0][	253	]=	613	;		TCS[1][	253	]=	0.4459332	;		TCS[2][	253	]=	0.341329269	;		TCS[3][	253	]=	0.249123633	;		TCS[4][	253	]=	0.165897281	;		TCS[5][	253	]=	0.190972062	;		TCS[6][	253	]=	0.219758164	;		TCS[7][	253	]=	0.355074476	;		TCS[8][	253	]=	0.463220784	;		TCS[9][	253	]=	0.384677105	;		TCS[10][	253	]=	0.706862111	;		TCS[11][	253	]=	0.088193538	;		TCS[12][	253	]=	0.015984084	;		TCS[13][	253	]=	0.746274788	;		TCS[14][	253	]=	0.09108911	;
	TCS[0][	254	]=	614	;		TCS[1][	254	]=	0.447064888	;		TCS[2][	254	]=	0.341119995	;		TCS[3][	254	]=	0.248087777	;		TCS[4][	254	]=	0.164918933	;		TCS[5][	254	]=	0.189975565	;		TCS[6][	254	]=	0.219804917	;		TCS[7][	254	]=	0.358594721	;		TCS[8][	254	]=	0.472620355	;		TCS[9][	254	]=	0.401153097	;		TCS[10][	254	]=	0.706894219	;		TCS[11][	254	]=	0.087561879	;		TCS[12][	254	]=	0.015987326	;		TCS[13][	254	]=	0.746656229	;		TCS[14][	254	]=	0.090483445	;
	TCS[0][	255	]=	615	;		TCS[1][	255	]=	0.448	;		TCS[2][	255	]=	0.341	;		TCS[3][	255	]=	0.247	;		TCS[4][	255	]=	0.164	;		TCS[5][	255	]=	0.189	;		TCS[6][	255	]=	0.22	;		TCS[7][	255	]=	0.362	;		TCS[8][	255	]=	0.482	;		TCS[9][	255	]=	0.418	;		TCS[10][	255	]=	0.707	;		TCS[11][	255	]=	0.087	;		TCS[12][	255	]=	0.016	;		TCS[13][	255	]=	0.747	;		TCS[14][	255	]=	0.09	;
	TCS[0][	256	]=	616	;		TCS[1][	256	]=	0.448694544	;		TCS[2][	256	]=	0.340998848	;		TCS[3][	256	]=	0.24585626	;		TCS[4][	256	]=	0.163151704	;		TCS[5][	256	]=	0.188056151	;		TCS[6][	256	]=	0.22037838	;		TCS[7][	256	]=	0.365275222	;		TCS[8][	256	]=	0.491419905	;		TCS[9][	256	]=	0.435301601	;		TCS[10][	256	]=	0.707189346	;		TCS[11][	256	]=	0.086542521	;		TCS[12][	256	]=	0.016022695	;		TCS[13][	256	]=	0.747297989	;		TCS[14][	256	]=	0.089681483	;
	TCS[0][	257	]=	617	;		TCS[1][	257	]=	0.449185098	;		TCS[2][	257	]=	0.341067262	;		TCS[3][	257	]=	0.244668478	;		TCS[4][	257	]=	0.16235463	;		TCS[5][	257	]=	0.187163087	;		TCS[6][	257	]=	0.220911726	;		TCS[7][	257	]=	0.368415352	;		TCS[8][	257	]=	0.500819996	;		TCS[9][	257	]=	0.452886987	;		TCS[10][	257	]=	0.707428583	;		TCS[11][	257	]=	0.086159661	;		TCS[12][	257	]=	0.016045979	;		TCS[13][	257	]=	0.747547867	;		TCS[14][	257	]=	0.089485676	;
	TCS[0][	258	]=	618	;		TCS[1][	258	]=	0.449528379	;		TCS[2][	258	]=	0.341136251	;		TCS[3][	258	]=	0.243452566	;		TCS[4][	258	]=	0.161581704	;		TCS[5][	258	]=	0.186341947	;		TCS[6][	258	]=	0.221555881	;		TCS[7][	258	]=	0.371417872	;		TCS[8][	258	]=	0.510110135	;		TCS[9][	258	]=	0.470521573	;		TCS[10][	258	]=	0.707673147	;		TCS[11][	258	]=	0.085805541	;		TCS[12][	258	]=	0.016057916	;		TCS[13][	258	]=	0.74774875	;		TCS[14][	258	]=	0.089349127	;
	TCS[0][	259	]=	619	;		TCS[1][	259	]=	0.449781107	;		TCS[2][	259	]=	0.341136827	;		TCS[3][	259	]=	0.242224436	;		TCS[4][	259	]=	0.160805852	;		TCS[5][	259	]=	0.185613872	;		TCS[6][	259	]=	0.222266691	;		TCS[7][	259	]=	0.374280261	;		TCS[8][	259	]=	0.519200182	;		TCS[9][	259	]=	0.487970773	;		TCS[10][	259	]=	0.707878474	;		TCS[11][	259	]=	0.085434281	;		TCS[12][	259	]=	0.016046569	;		TCS[13][	259	]=	0.747899756	;		TCS[14][	259	]=	0.089208386	;
	TCS[0][	260	]=	620	;		TCS[1][	260	]=	0.45	;		TCS[2][	260	]=	0.341	;		TCS[3][	260	]=	0.241	;		TCS[4][	260	]=	0.16	;		TCS[5][	260	]=	0.185	;		TCS[6][	260	]=	0.223	;		TCS[7][	260	]=	0.377	;		TCS[8][	260	]=	0.528	;		TCS[9][	260	]=	0.505	;		TCS[10][	260	]=	0.708	;		TCS[11][	260	]=	0.085	;		TCS[12][	260	]=	0.016	;		TCS[13][	260	]=	0.748	;		TCS[14][	260	]=	0.089	;
	TCS[0][	261	]=	621	;		TCS[1][	261	]=	0.4502292	;		TCS[2][	261	]=	0.340682059	;		TCS[3][	261	]=	0.239791249	;		TCS[4][	261	]=	0.159148489	;		TCS[5][	261	]=	0.184510403	;		TCS[6][	261	]=	0.223723984	;		TCS[7][	261	]=	0.379579604	;		TCS[8][	261	]=	0.536447523	;		TCS[9][	261	]=	0.521417581	;		TCS[10][	261	]=	0.708010834	;		TCS[11][	261	]=	0.084470599	;		TCS[12][	261	]=	0.015915705	;		TCS[13][	261	]=	0.748050928	;		TCS[14][	261	]=	0.088678738	;
	TCS[0][	262	]=	622	;		TCS[1][	262	]=	0.450462542	;		TCS[2][	262	]=	0.340240408	;		TCS[3][	262	]=	0.238594489	;		TCS[4][	262	]=	0.158281318	;		TCS[5][	262	]=	0.184110876	;		TCS[6][	262	]=	0.224456143	;		TCS[7][	262	]=	0.382041722	;		TCS[8][	262	]=	0.544592981	;		TCS[9][	262	]=	0.537203487	;		TCS[10][	262	]=	0.707954776	;		TCS[11][	262	]=	0.083869097	;		TCS[12][	262	]=	0.015828904	;		TCS[13][	262	]=	0.748063301	;		TCS[14][	262	]=	0.088272244	;
	TCS[0][	263	]=	623	;		TCS[1][	263	]=	0.450681284	;		TCS[2][	263	]=	0.339757726	;		TCS[3][	263	]=	0.237402104	;		TCS[4][	263	]=	0.157439903	;		TCS[5][	263	]=	0.183756149	;		TCS[6][	263	]=	0.22522631	;		TCS[7][	263	]=	0.384414038	;		TCS[8][	263	]=	0.552514677	;		TCS[9][	263	]=	0.552380603	;		TCS[10][	263	]=	0.707893302	;		TCS[11][	263	]=	0.083232297	;		TCS[12][	263	]=	0.015784251	;		TCS[13][	263	]=	0.74805021	;		TCS[14][	263	]=	0.08782638	;
	TCS[0][	264	]=	624	;		TCS[1][	264	]=	0.450866684	;		TCS[2][	264	]=	0.339316697	;		TCS[3][	264	]=	0.23620648	;		TCS[4][	264	]=	0.156665659	;		TCS[5][	264	]=	0.183400947	;		TCS[6][	264	]=	0.226064319	;		TCS[7][	264	]=	0.386724236	;		TCS[8][	264	]=	0.560290915	;		TCS[9][	264	]=	0.566971813	;		TCS[10][	264	]=	0.707887885	;		TCS[11][	264	]=	0.082596997	;		TCS[12][	264	]=	0.015826398	;		TCS[13][	264	]=	0.748024746	;		TCS[14][	264	]=	0.087387011	;
	TCS[0][	265	]=	625	;		TCS[1][	265	]=	0.451	;		TCS[2][	265	]=	0.339	;		TCS[3][	265	]=	0.235	;		TCS[4][	265	]=	0.156	;		TCS[5][	265	]=	0.183	;		TCS[6][	265	]=	0.227	;		TCS[7][	265	]=	0.389	;		TCS[8][	265	]=	0.568	;		TCS[9][	265	]=	0.581	;		TCS[10][	265	]=	0.708	;		TCS[11][	265	]=	0.082	;		TCS[12][	265	]=	0.016	;		TCS[13][	265	]=	0.748	;		TCS[14][	265	]=	0.087	;
	TCS[0][	266	]=	626	;		TCS[1][	266	]=	0.451068655	;		TCS[2][	266	]=	0.338864914	;		TCS[3][	266	]=	0.233778744	;		TCS[4][	266	]=	0.155470342	;		TCS[5][	266	]=	0.182518238	;		TCS[6][	266	]=	0.228053686	;		TCS[7][	266	]=	0.391262363	;		TCS[8][	266	]=	0.575686004	;		TCS[9][	266	]=	0.594468076	;		TCS[10][	266	]=	0.70827132	;		TCS[11][	266	]=	0.081471085	;		TCS[12][	266	]=	0.016330487	;		TCS[13][	266	]=	0.7479863	;		TCS[14][	266	]=	0.086699565	;
	TCS[0][	267	]=	627	;		TCS[1][	267	]=	0.451084734	;		TCS[2][	267	]=	0.338867107	;		TCS[3][	267	]=	0.232553566	;		TCS[4][	267	]=	0.155048098	;		TCS[5][	267	]=	0.181961407	;		TCS[6][	267	]=	0.229207703	;		TCS[7][	267	]=	0.39350576	;		TCS[8][	267	]=	0.583256082	;		TCS[9][	267	]=	0.607299064	;		TCS[10][	267	]=	0.708664313	;		TCS[11][	267	]=	0.08101195	;		TCS[12][	267	]=	0.016766406	;		TCS[13][	267	]=	0.747982929	;		TCS[14][	267	]=	0.08647335	;
	TCS[0][	268	]=	628	;		TCS[1][	268	]=	0.451066485	;		TCS[2][	268	]=	0.338936843	;		TCS[3][	268	]=	0.231339016	;		TCS[4][	268	]=	0.154690684	;		TCS[5][	268	]=	0.181345458	;		TCS[6][	268	]=	0.230434877	;		TCS[7][	268	]=	0.395717975	;		TCS[8][	268	]=	0.590583158	;		TCS[9][	268	]=	0.619396014	;		TCS[10][	268	]=	0.709121646	;		TCS[11][	268	]=	0.080617272	;		TCS[12][	268	]=	0.017237081	;		TCS[13][	268	]=	0.747986408	;		TCS[14][	268	]=	0.086297351	;
	TCS[0][	269	]=	629	;		TCS[1][	269	]=	0.451032157	;		TCS[2][	269	]=	0.339004386	;		TCS[3][	269	]=	0.230149645	;		TCS[4][	269	]=	0.154355513	;		TCS[5][	269	]=	0.180686339	;		TCS[6][	269	]=	0.231708034	;		TCS[7][	269	]=	0.397886794	;		TCS[8][	269	]=	0.597540156	;		TCS[9][	269	]=	0.630661976	;		TCS[10][	269	]=	0.709585986	;		TCS[11][	269	]=	0.08028173	;		TCS[12][	269	]=	0.017671837	;		TCS[13][	269	]=	0.747993258	;		TCS[14][	269	]=	0.086147569	;
	TCS[0][	270	]=	630	;		TCS[1][	270	]=	0.451	;		TCS[2][	270	]=	0.339	;		TCS[3][	270	]=	0.229	;		TCS[4][	270	]=	0.154	;		TCS[5][	270	]=	0.18	;		TCS[6][	270	]=	0.233	;		TCS[7][	270	]=	0.4	;		TCS[8][	270	]=	0.604	;		TCS[9][	270	]=	0.641	;		TCS[10][	270	]=	0.71	;		TCS[11][	270	]=	0.08	;		TCS[12][	270	]=	0.018	;		TCS[13][	270	]=	0.748	;		TCS[14][	270	]=	0.086	;
	TCS[0][	271	]=	631	;		TCS[1][	271	]=	0.450984178	;		TCS[2][	271	]=	0.338874283	;		TCS[3][	271	]=	0.227901777	;		TCS[4][	271	]=	0.153594145	;		TCS[5][	271	]=	0.179304645	;		TCS[6][	271	]=	0.234285273	;		TCS[7][	271	]=	0.402050944	;		TCS[8][	271	]=	0.609872461	;		TCS[9][	271	]=	0.650366114	;		TCS[10][	271	]=	0.710319887	;		TCS[11][	271	]=	0.079765062	;		TCS[12][	271	]=	0.018170348	;		TCS[13][	271	]=	0.748003872	;		TCS[14][	271	]=	0.085835001	;
	TCS[0][	272	]=	632	;		TCS[1][	272	]=	0.450982522	;		TCS[2][	272	]=	0.338659163	;		TCS[3][	272	]=	0.226855247	;		TCS[4][	272	]=	0.15315829	;		TCS[5][	272	]=	0.178627494	;		TCS[6][	272	]=	0.235545046	;		TCS[7][	272	]=	0.404055239	;		TCS[8][	272	]=	0.615214691	;		TCS[9][	272	]=	0.658928256	;		TCS[10][	272	]=	0.710555973	;		TCS[11][	272	]=	0.079563104	;		TCS[12][	272	]=	0.018209474	;		TCS[13][	272	]=	0.748004982	;		TCS[14][	272	]=	0.085650358	;
	TCS[0][	273	]=	633	;		TCS[1][	273	]=	0.450988776	;		TCS[2][	273	]=	0.338406901	;		TCS[3][	273	]=	0.22585783	;		TCS[4][	273	]=	0.152725362	;		TCS[5][	273	]=	0.17799802	;		TCS[6][	273	]=	0.236762181	;		TCS[7][	273	]=	0.406034062	;		TCS[8][	273	]=	0.620120692	;		TCS[9][	273	]=	0.666907341	;		TCS[10][	273	]=	0.710732116	;		TCS[11][	273	]=	0.079378614	;		TCS[12][	273	]=	0.018163427	;		TCS[13][	273	]=	0.748004157	;		TCS[14][	273	]=	0.085448214	;
	TCS[0][	274	]=	634	;		TCS[1][	274	]=	0.450996687	;		TCS[2][	274	]=	0.33816976	;		TCS[3][	274	]=	0.224906941	;		TCS[4][	274	]=	0.152328289	;		TCS[5][	274	]=	0.177445698	;		TCS[6][	274	]=	0.237919545	;		TCS[7][	274	]=	0.408008589	;		TCS[8][	274	]=	0.624684461	;		TCS[9][	274	]=	0.674524284	;		TCS[10][	274	]=	0.710872172	;		TCS[11][	274	]=	0.079196083	;		TCS[12][	274	]=	0.018078253	;		TCS[13][	274	]=	0.748002221	;		TCS[14][	274	]=	0.085230714	;
	TCS[0][	275	]=	635	;		TCS[1][	275	]=	0.451	;		TCS[2][	275	]=	0.338	;		TCS[3][	275	]=	0.224	;		TCS[4][	275	]=	0.152	;		TCS[5][	275	]=	0.177	;		TCS[6][	275	]=	0.239	;		TCS[7][	275	]=	0.41	;		TCS[8][	275	]=	0.629	;		TCS[9][	275	]=	0.682	;		TCS[10][	275	]=	0.711	;		TCS[11][	275	]=	0.079	;		TCS[12][	275	]=	0.018	;		TCS[13][	275	]=	0.748	;		TCS[14][	275	]=	0.085	;
	TCS[0][	276	]=	636	;		TCS[1][	276	]=	0.450994632	;		TCS[2][	276	]=	0.337933954	;		TCS[3][	276	]=	0.22313415	;		TCS[4][	276	]=	0.151761079	;		TCS[5][	276	]=	0.176679181	;		TCS[6][	276	]=	0.23999722	;		TCS[7][	276	]=	0.412021859	;		TCS[8][	276	]=	0.633144153	;		TCS[9][	276	]=	0.689491467	;		TCS[10][	276	]=	0.711137131	;		TCS[11][	276	]=	0.078780667	;		TCS[12][	276	]=	0.017964122	;		TCS[13][	276	]=	0.747998212	;		TCS[14][	276	]=	0.08476043	;
	TCS[0][	277	]=	637	;		TCS[1][	277	]=	0.450985179	;		TCS[2][	277	]=	0.337944241	;		TCS[3][	277	]=	0.222305445	;		TCS[4][	277	]=	0.151582744	;		TCS[5][	277	]=	0.176456617	;		TCS[6][	277	]=	0.240948114	;		TCS[7][	277	]=	0.414057284	;		TCS[8][	277	]=	0.637125153	;		TCS[9][	277	]=	0.696899911	;		TCS[10][	277	]=	0.711295794	;		TCS[11][	277	]=	0.078551635	;		TCS[12][	277	]=	0.017963698	;		TCS[13][	277	]=	0.747997142	;		TCS[14][	277	]=	0.084525218	;
	TCS[0][	278	]=	638	;		TCS[1][	278	]=	0.450978411	;		TCS[2][	278	]=	0.337987551	;		TCS[3][	278	]=	0.221509664	;		TCS[4][	278	]=	0.151423869	;		TCS[5][	278	]=	0.176294461	;		TCS[6][	278	]=	0.241900397	;		TCS[7][	278	]=	0.416081779	;		TCS[8][	278	]=	0.640934075	;		TCS[9][	278	]=	0.704062622	;		TCS[10][	278	]=	0.711485891	;		TCS[11][	278	]=	0.07833227	;		TCS[12][	278	]=	0.017981213	;		TCS[13][	278	]=	0.747996965	;		TCS[14][	278	]=	0.084309791	;
	TCS[0][	279	]=	639	;		TCS[1][	279	]=	0.450981096	;		TCS[2][	279	]=	0.338020574	;		TCS[3][	279	]=	0.220742589	;		TCS[4][	279	]=	0.151243329	;		TCS[5][	279	]=	0.176154871	;		TCS[6][	279	]=	0.242901787	;		TCS[7][	279	]=	0.418070849	;		TCS[8][	279	]=	0.644561999	;		TCS[9][	279	]=	0.710816889	;		TCS[10][	279	]=	0.711717325	;		TCS[11][	279	]=	0.078141937	;		TCS[12][	279	]=	0.017999152	;		TCS[13][	279	]=	0.747997859	;		TCS[14][	279	]=	0.084129576	;
	TCS[0][	280	]=	640	;		TCS[1][	280	]=	0.451	;		TCS[2][	280	]=	0.338	;		TCS[3][	280	]=	0.22	;		TCS[4][	280	]=	0.151	;		TCS[5][	280	]=	0.176	;		TCS[6][	280	]=	0.244	;		TCS[7][	280	]=	0.42	;		TCS[8][	280	]=	0.648	;		TCS[9][	280	]=	0.717	;		TCS[10][	280	]=	0.712	;		TCS[11][	280	]=	0.078	;		TCS[12][	280	]=	0.018	;		TCS[13][	280	]=	0.748	;		TCS[14][	280	]=	0.084	;
	TCS[0][	281	]=	641	;		TCS[1][	281	]=	0.451037295	;		TCS[2][	281	]=	0.3378939	;		TCS[3][	281	]=	0.219281623	;		TCS[4][	281	]=	0.150665539	;		TCS[5][	281	]=	0.17580263	;		TCS[6][	281	]=	0.245229845	;		TCS[7][	281	]=	0.421853619	;		TCS[8][	281	]=	0.651246926	;		TCS[9][	281	]=	0.722500018	;		TCS[10][	281	]=	0.712339589	;		TCS[11][	281	]=	0.077920271	;		TCS[12][	281	]=	0.017973164	;		TCS[13][	281	]=	0.74800328	;		TCS[14][	281	]=	0.083931277	;
	TCS[0][	282	]=	642	;		TCS[1][	282	]=	0.45107676	;		TCS[2][	282	]=	0.337715872	;		TCS[3][	282	]=	0.218602974	;		TCS[4][	282	]=	0.150262736	;		TCS[5][	282	]=	0.17557804	;		TCS[6][	282	]=	0.246574499	;		TCS[7][	282	]=	0.423651626	;		TCS[8][	282	]=	0.654332697	;		TCS[9][	282	]=	0.727408099	;		TCS[10][	282	]=	0.712724852	;		TCS[11][	282	]=	0.077894355	;		TCS[12][	282	]=	0.017935733	;		TCS[13][	282	]=	0.748006451	;		TCS[14][	282	]=	0.083912768	;
	TCS[0][	283	]=	643	;		TCS[1][	283	]=	0.451097578	;		TCS[2][	283	]=	0.337490893	;		TCS[3][	283	]=	0.217983512	;		TCS[4][	283	]=	0.149827164	;		TCS[5][	283	]=	0.175352135	;		TCS[6][	283	]=	0.24800423	;		TCS[7][	283	]=	0.425422823	;		TCS[8][	283	]=	0.657295006	;		TCS[9][	283	]=	0.73186617	;		TCS[10][	283	]=	0.71314032	;		TCS[11][	283	]=	0.077908304	;		TCS[12][	283	]=	0.017911722	;		TCS[13][	283	]=	0.748007983	;		TCS[14][	283	]=	0.083928621	;
	TCS[0][	284	]=	644	;		TCS[1][	284	]=	0.451078931	;		TCS[2][	284	]=	0.337243943	;		TCS[3][	284	]=	0.217442701	;		TCS[4][	284	]=	0.149394394	;		TCS[5][	284	]=	0.17515082	;		TCS[6][	284	]=	0.249489307	;		TCS[7][	284	]=	0.427196014	;		TCS[8][	284	]=	0.660171544	;		TCS[9][	284	]=	0.736016161	;		TCS[10][	284	]=	0.713570526	;		TCS[11][	284	]=	0.077948168	;		TCS[12][	284	]=	0.01792514	;		TCS[13][	284	]=	0.748006343	;		TCS[14][	284	]=	0.083962982	;
	TCS[0][	285	]=	645	;		TCS[1][	285	]=	0.451	;		TCS[2][	285	]=	0.337	;		TCS[3][	285	]=	0.217	;		TCS[4][	285	]=	0.149	;		TCS[5][	285	]=	0.175	;		TCS[6][	285	]=	0.251	;		TCS[7][	285	]=	0.429	;		TCS[8][	285	]=	0.663	;		TCS[9][	285	]=	0.74	;		TCS[10][	285	]=	0.714	;		TCS[11][	285	]=	0.078	;		TCS[12][	285	]=	0.018	;		TCS[13][	285	]=	0.748	;		TCS[14][	285	]=	0.084	;
	TCS[0][	286	]=	646	;		TCS[1][	286	]=	0.450848188	;		TCS[2][	286	]=	0.336778445	;		TCS[3][	286	]=	0.216667357	;		TCS[4][	286	]=	0.148672764	;		TCS[5][	286	]=	0.1749183	;		TCS[6][	286	]=	0.2525074	;		TCS[7][	286	]=	0.430851665	;		TCS[8][	286	]=	0.665804144	;		TCS[9][	286	]=	0.74392446	;		TCS[10][	286	]=	0.714416514	;		TCS[11][	286	]=	0.078050248	;		TCS[12][	286	]=	0.018151223	;		TCS[13][	286	]=	0.747988669	;		TCS[14][	286	]=	0.084026461	;
	TCS[0][	287	]=	647	;		TCS[1][	287	]=	0.450643779	;		TCS[2][	287	]=	0.336576272	;		TCS[3][	287	]=	0.216426661	;		TCS[4][	287	]=	0.148414311	;		TCS[5][	287	]=	0.174895225	;		TCS[6][	287	]=	0.253985892	;		TCS[7][	287	]=	0.432720213	;		TCS[8][	287	]=	0.668552058	;		TCS[9][	287	]=	0.747755693	;		TCS[10][	287	]=	0.714820799	;		TCS[11][	287	]=	0.078086943	;		TCS[12][	287	]=	0.018357368	;		TCS[13][	287	]=	0.747977053	;		TCS[14][	287	]=	0.084039708	;
	TCS[0][	288	]=	648	;		TCS[1][	288	]=	0.450415275	;		TCS[2][	288	]=	0.336384876	;		TCS[3][	288	]=	0.216252286	;		TCS[4][	288	]=	0.148219476	;		TCS[5][	288	]=	0.174913	;		TCS[6][	288	]=	0.255410684	;		TCS[7][	288	]=	0.434562928	;		TCS[8][	288	]=	0.671197899	;		TCS[9][	288	]=	0.751424697	;		TCS[10][	288	]=	0.715216827	;		TCS[11][	288	]=	0.078098515	;		TCS[12][	288	]=	0.018587901	;		TCS[13][	288	]=	0.747971102	;		TCS[14][	288	]=	0.084039725	;
	TCS[0][	289	]=	649	;		TCS[1][	289	]=	0.450191181	;		TCS[2][	289	]=	0.336195653	;		TCS[3][	289	]=	0.216118607	;		TCS[4][	289	]=	0.148083094	;		TCS[5][	289	]=	0.17495385	;		TCS[6][	289	]=	0.256756984	;		TCS[7][	289	]=	0.436337096	;		TCS[8][	289	]=	0.673695827	;		TCS[9][	289	]=	0.754862467	;		TCS[10][	289	]=	0.715608571	;		TCS[11][	289	]=	0.078073391	;		TCS[12][	289	]=	0.018812289	;		TCS[13][	289	]=	0.747976768	;		TCS[14][	289	]=	0.084026495	;
	TCS[0][	290	]=	650	;		TCS[1][	290	]=	0.45	;		TCS[2][	290	]=	0.336	;		TCS[3][	290	]=	0.216	;		TCS[4][	290	]=	0.148	;		TCS[5][	290	]=	0.175	;		TCS[6][	290	]=	0.258	;		TCS[7][	290	]=	0.438	;		TCS[8][	290	]=	0.676	;		TCS[9][	290	]=	0.758	;		TCS[10][	290	]=	0.716	;		TCS[11][	290	]=	0.078	;		TCS[12][	290	]=	0.019	;		TCS[13][	290	]=	0.748	;		TCS[14][	290	]=	0.084	;
	TCS[0][	291	]=	651	;		TCS[1][	291	]=	0.449865952	;		TCS[2][	291	]=	0.335792319	;		TCS[3][	291	]=	0.215880949	;		TCS[4][	291	]=	0.147963404	;		TCS[5][	291	]=	0.17503617	;		TCS[6][	291	]=	0.259124556	;		TCS[7][	291	]=	0.439523721	;		TCS[8][	291	]=	0.678080497	;		TCS[9][	291	]=	0.760794141	;		TCS[10][	291	]=	0.716394356	;		TCS[11][	291	]=	0.077878738	;		TCS[12][	291	]=	0.019133942	;		TCS[13][	291	]=	0.748042046	;		TCS[14][	291	]=	0.08396288	;
	TCS[0][	292	]=	652	;		TCS[1][	292	]=	0.449796124	;		TCS[2][	292	]=	0.335579041	;		TCS[3][	292	]=	0.215786384	;		TCS[4][	292	]=	0.147960019	;		TCS[5][	292	]=	0.17505706	;		TCS[6][	292	]=	0.260153935	;		TCS[7][	292	]=	0.440939523	;		TCS[8][	292	]=	0.679971072	;		TCS[9][	292	]=	0.763305128	;		TCS[10][	292	]=	0.716791952	;		TCS[11][	292	]=	0.077757872	;		TCS[12][	292	]=	0.019250794	;		TCS[13][	292	]=	0.748085338	;		TCS[14][	292	]=	0.083928399	;
	TCS[0][	293	]=	653	;		TCS[1][	293	]=	0.44979332	;		TCS[2][	293	]=	0.335369603	;		TCS[3][	293	]=	0.215751345	;		TCS[4][	293	]=	0.147974931	;		TCS[5][	293	]=	0.175059865	;		TCS[6][	293	]=	0.261121036	;		TCS[7][	293	]=	0.442293464	;		TCS[8][	293	]=	0.681721399	;		TCS[9][	293	]=	0.765619043	;		TCS[10][	293	]=	0.71719237	;		TCS[11][	293	]=	0.077697637	;		TCS[12][	293	]=	0.019400674	;		TCS[13][	293	]=	0.748107608	;		TCS[14][	293	]=	0.083912478	;
	TCS[0][	294	]=	654	;		TCS[1][	294	]=	0.449860344	;		TCS[2][	294	]=	0.335173444	;		TCS[3][	294	]=	0.21581087	;		TCS[4][	294	]=	0.147993229	;		TCS[5][	294	]=	0.17504178	;		TCS[6][	294	]=	0.262058758	;		TCS[7][	294	]=	0.443631604	;		TCS[8][	294	]=	0.68338115	;		TCS[9][	294	]=	0.767821972	;		TCS[10][	294	]=	0.717595192	;		TCS[11][	294	]=	0.077758268	;		TCS[12][	294	]=	0.019633703	;		TCS[13][	294	]=	0.748086585	;		TCS[14][	294	]=	0.083931038	;
	TCS[0][	295	]=	655	;		TCS[1][	295	]=	0.45	;		TCS[2][	295	]=	0.335	;		TCS[3][	295	]=	0.216	;		TCS[4][	295	]=	0.148	;		TCS[5][	295	]=	0.175	;		TCS[6][	295	]=	0.263	;		TCS[7][	295	]=	0.445	;		TCS[8][	295	]=	0.685	;		TCS[9][	295	]=	0.77	;		TCS[10][	295	]=	0.718	;		TCS[11][	295	]=	0.078	;		TCS[12][	295	]=	0.02	;		TCS[13][	295	]=	0.748	;		TCS[14][	295	]=	0.084	;
	TCS[0][	296	]=	656	;		TCS[1][	296	]=	0.450208004	;		TCS[2][	296	]=	0.334852279	;		TCS[3][	296	]=	0.216344846	;		TCS[4][	296	]=	0.147985619	;		TCS[5][	296	]=	0.17493702	;		TCS[6][	296	]=	0.263970377	;		TCS[7][	296	]=	0.446429449	;		TCS[8][	296	]=	0.686617867	;		TCS[9][	296	]=	0.772218974	;		TCS[10][	296	]=	0.718406062	;		TCS[11][	296	]=	0.0784588	;		TCS[12][	296	]=	0.020529007	;		TCS[13][	296	]=	0.747835149	;		TCS[14][	296	]=	0.08413002	;
	TCS[0][	297	]=	657	;		TCS[1][	297	]=	0.450451724	;		TCS[2][	297	]=	0.334707566	;		TCS[3][	297	]=	0.216835802	;		TCS[4][	297	]=	0.147961614	;		TCS[5][	297	]=	0.174876536	;		TCS[6][	297	]=	0.264966369	;		TCS[7][	297	]=	0.447889694	;		TCS[8][	297	]=	0.688235653	;		TCS[9][	297	]=	0.774463796	;		TCS[10][	297	]=	0.718811393	;		TCS[11][	297	]=	0.079073568	;		TCS[12][	297	]=	0.021167456	;		TCS[13][	297	]=	0.747617594	;		TCS[14][	297	]=	0.084310697	;
	TCS[0][	298	]=	658	;		TCS[1][	298	]=	0.450691443	;		TCS[2][	298	]=	0.334536712	;		TCS[3][	298	]=	0.217454336	;		TCS[4][	298	]=	0.147944799	;		TCS[5][	298	]=	0.174847541	;		TCS[6][	298	]=	0.265977173	;		TCS[7][	298	]=	0.449335214	;		TCS[8][	298	]=	0.689844506	;		TCS[9][	298	]=	0.776699131	;		TCS[10][	298	]=	0.719213693	;		TCS[11][	298	]=	0.079758935	;		TCS[12][	298	]=	0.021841401	;		TCS[13][	298	]=	0.747382465	;		TCS[14][	298	]=	0.084526363	;
	TCS[0][	299	]=	659	;		TCS[1][	299	]=	0.450887441	;		TCS[2][	299	]=	0.334310573	;		TCS[3][	299	]=	0.218181913	;		TCS[4][	299	]=	0.147951989	;		TCS[5][	299	]=	0.174879031	;		TCS[6][	299	]=	0.266991985	;		TCS[7][	299	]=	0.45072049	;		TCS[8][	299	]=	0.691435572	;		TCS[9][	299	]=	0.778889644	;		TCS[10][	299	]=	0.719610662	;		TCS[11][	299	]=	0.080429535	;		TCS[12][	299	]=	0.022476898	;		TCS[13][	299	]=	0.747164891	;		TCS[14][	299	]=	0.084761353	;
	TCS[0][	300	]=	660	;		TCS[1][	300	]=	0.451	;		TCS[2][	300	]=	0.334	;		TCS[3][	300	]=	0.219	;		TCS[4][	300	]=	0.148	;		TCS[5][	300	]=	0.175	;		TCS[6][	300	]=	0.268	;		TCS[7][	300	]=	0.452	;		TCS[8][	300	]=	0.693	;		TCS[9][	300	]=	0.781	;		TCS[10][	300	]=	0.72	;		TCS[11][	300	]=	0.081	;		TCS[12][	300	]=	0.023	;		TCS[13][	300	]=	0.747	;		TCS[14][	300	]=	0.085	;
	TCS[0][	301	]=	661	;		TCS[1][	301	]=	0.451006033	;		TCS[2][	301	]=	0.333590564	;		TCS[3][	301	]=	0.219891668	;		TCS[4][	301	]=	0.148102119	;		TCS[5][	301	]=	0.175231749	;		TCS[6][	301	]=	0.268993936	;		TCS[7][	301	]=	0.453142482	;		TCS[8][	301	]=	0.694528034	;		TCS[9][	301	]=	0.783001962	;		TCS[10][	301	]=	0.720381394	;		TCS[11][	301	]=	0.081414062	;		TCS[12][	301	]=	0.023358031	;		TCS[13][	301	]=	0.74691336	;		TCS[14][	301	]=	0.085237039	;
	TCS[0][	302	]=	662	;		TCS[1][	302	]=	0.450948978	;		TCS[2][	302	]=	0.333126697	;		TCS[3][	302	]=	0.220846406	;		TCS[4][	302	]=	0.148257526	;		TCS[5][	302	]=	0.175564798	;		TCS[6][	302	]=	0.269980587	;		TCS[7][	302	]=	0.4541737	;		TCS[8][	302	]=	0.696006314	;		TCS[9][	302	]=	0.784895688	;		TCS[10][	302	]=	0.720762475	;		TCS[11][	302	]=	0.081731857	;		TCS[12][	302	]=	0.023583384	;		TCS[13][	302	]=	0.746892286	;		TCS[14][	302	]=	0.085508813	;
	TCS[0][	303	]=	663	;		TCS[1][	303	]=	0.450888908	;		TCS[2][	303	]=	0.332667548	;		TCS[3][	303	]=	0.221855311	;		TCS[4][	303	]=	0.148461873	;		TCS[5][	303	]=	0.175981973	;		TCS[6][	303	]=	0.270970271	;		TCS[7][	303	]=	0.455133678	;		TCS[8][	303	]=	0.697420577	;		TCS[9][	303	]=	0.786688432	;		TCS[10][	303	]=	0.721152859	;		TCS[11][	303	]=	0.082042621	;		TCS[12][	303	]=	0.023729721	;		TCS[13][	303	]=	0.746914532	;		TCS[14][	303	]=	0.085862068	;
	TCS[0][	304	]=	664	;		TCS[1][	304	]=	0.450885891	;		TCS[2][	304	]=	0.332272266	;		TCS[3][	304	]=	0.222909477	;		TCS[4][	304	]=	0.148710814	;		TCS[5][	304	]=	0.176466098	;		TCS[6][	304	]=	0.271973304	;		TCS[7][	304	]=	0.456062437	;		TCS[8][	304	]=	0.69875656	;		TCS[9][	304	]=	0.788387451	;		TCS[10][	304	]=	0.721562162	;		TCS[11][	304	]=	0.08243559	;		TCS[12][	304	]=	0.023850706	;		TCS[13][	304	]=	0.746957852	;		TCS[14][	304	]=	0.086343549	;
	TCS[0][	305	]=	665	;		TCS[1][	305	]=	0.451	;		TCS[2][	305	]=	0.332	;		TCS[3][	305	]=	0.224	;		TCS[4][	305	]=	0.149	;		TCS[5][	305	]=	0.177	;		TCS[6][	305	]=	0.273	;		TCS[7][	305	]=	0.457	;		TCS[8][	305	]=	0.7	;		TCS[9][	305	]=	0.79	;		TCS[10][	305	]=	0.722	;		TCS[11][	305	]=	0.083	;		TCS[12][	305	]=	0.024	;		TCS[13][	305	]=	0.747	;		TCS[14][	305	]=	0.087	;
	TCS[0][	306	]=	666	;		TCS[1][	306	]=	0.451271865	;		TCS[2][	306	]=	0.331889466	;		TCS[3][	306	]=	0.225120484	;		TCS[4][	306	]=	0.149325905	;		TCS[5][	306	]=	0.177567984	;		TCS[6][	306	]=	0.274053881	;		TCS[7][	306	]=	0.457976624	;		TCS[8][	306	]=	0.701141995	;		TCS[9][	306	]=	0.791533177	;		TCS[10][	306	]=	0.72247636	;		TCS[11][	306	]=	0.083796952	;		TCS[12][	306	]=	0.024222871	;		TCS[13][	306	]=	0.747023413	;		TCS[14][	306	]=	0.087857824	;
	TCS[0][	307	]=	667	;		TCS[1][	307	]=	0.451664362	;		TCS[2][	307	]=	0.331897648	;		TCS[3][	307	]=	0.226274573	;		TCS[4][	307	]=	0.149688283	;		TCS[5][	307	]=	0.178160272	;		TCS[6][	307	]=	0.275111281	;		TCS[7][	307	]=	0.458983504	;		TCS[8][	307	]=	0.702195089	;		TCS[9][	307	]=	0.792993453	;		TCS[10][	307	]=	0.723002706	;		TCS[11][	307	]=	0.084775005	;		TCS[12][	307	]=	0.02453101	;		TCS[13][	307	]=	0.747029264	;		TCS[14][	307	]=	0.088862049	;
	TCS[0][	308	]=	668	;		TCS[1][	308	]=	0.452120927	;		TCS[2][	308	]=	0.331961097	;		TCS[3][	308	]=	0.22746842	;		TCS[4][	308	]=	0.150087709	;		TCS[5][	308	]=	0.178768569	;		TCS[6][	308	]=	0.276141741	;		TCS[7][	308	]=	0.460002073	;		TCS[8][	308	]=	0.703177185	;		TCS[9][	308	]=	0.794387141	;		TCS[10][	308	]=	0.723590872	;		TCS[11][	308	]=	0.085854582	;		TCS[12][	308	]=	0.024927714	;		TCS[13][	308	]=	0.747023408	;		TCS[14][	308	]=	0.089937363	;
	TCS[0][	309	]=	669	;		TCS[1][	309	]=	0.452584994	;		TCS[2][	309	]=	0.332016364	;		TCS[3][	309	]=	0.228708178	;		TCS[4][	309	]=	0.150524756	;		TCS[5][	309	]=	0.179384577	;		TCS[6][	309	]=	0.277114801	;		TCS[7][	309	]=	0.461013761	;		TCS[8][	309	]=	0.704106187	;		TCS[9][	309	]=	0.795720552	;		TCS[10][	309	]=	0.724252692	;		TCS[11][	309	]=	0.086956106	;		TCS[12][	309	]=	0.025416278	;		TCS[13][	309	]=	0.747011701	;		TCS[14][	309	]=	0.091008451	;
	TCS[0][	310	]=	670	;		TCS[1][	310	]=	0.453	;		TCS[2][	310	]=	0.332	;		TCS[3][	310	]=	0.23	;		TCS[4][	310	]=	0.151	;		TCS[5][	310	]=	0.18	;		TCS[6][	310	]=	0.278	;		TCS[7][	310	]=	0.462	;		TCS[8][	310	]=	0.705	;		TCS[9][	310	]=	0.797	;		TCS[10][	310	]=	0.725	;		TCS[11][	310	]=	0.088	;		TCS[12][	310	]=	0.026	;		TCS[13][	310	]=	0.747	;		TCS[14][	310	]=	0.092	;
	TCS[0][	311	]=	671	;		TCS[1][	311	]=	0.453322506	;		TCS[2][	311	]=	0.331867573	;		TCS[3][	311	]=	0.231354396	;		TCS[4][	311	]=	0.15151426	;		TCS[5][	311	]=	0.180608316	;		TCS[6][	311	]=	0.278774542	;		TCS[7][	311	]=	0.462943024	;		TCS[8][	311	]=	0.705871984	;		TCS[9][	311	]=	0.798233328	;		TCS[10][	311	]=	0.725833165	;		TCS[11][	311	]=	0.088934129	;		TCS[12][	311	]=	0.026678485	;		TCS[13][	311	]=	0.746992988	;		TCS[14][	311	]=	0.092859666	;
	TCS[0][	312	]=	672	;		TCS[1][	312	]=	0.453561572	;		TCS[2][	312	]=	0.331650713	;		TCS[3][	312	]=	0.232799301	;		TCS[4][	312	]=	0.152069341	;		TCS[5][	312	]=	0.181210112	;		TCS[6][	312	]=	0.279446288	;		TCS[7][	312	]=	0.463828282	;		TCS[8][	312	]=	0.70671733	;		TCS[9][	312	]=	0.799434499	;		TCS[10][	312	]=	0.7267067	;		TCS[11][	312	]=	0.089816123	;		TCS[12][	312	]=	0.027436575	;		TCS[13][	312	]=	0.746990659	;		TCS[14][	312	]=	0.09362699	;
	TCS[0][	313	]=	673	;		TCS[1][	313	]=	0.453739386	;		TCS[2][	313	]=	0.331400066	;		TCS[3][	313	]=	0.234367008	;		TCS[4][	313	]=	0.152667291	;		TCS[5][	313	]=	0.18180775	;		TCS[6][	313	]=	0.280030763	;		TCS[7][	313	]=	0.464642029	;		TCS[8][	313	]=	0.707526683	;		TCS[9][	313	]=	0.800619006	;		TCS[10][	313	]=	0.727563652	;		TCS[11][	313	]=	0.090731053	;		TCS[12][	313	]=	0.028255423	;		TCS[13][	313	]=	0.746991837	;		TCS[14][	313	]=	0.09436448	;
	TCS[0][	314	]=	674	;		TCS[1][	314	]=	0.453878133	;		TCS[2][	314	]=	0.33116628	;		TCS[3][	314	]=	0.236089811	;		TCS[4][	314	]=	0.153310161	;		TCS[5][	314	]=	0.182403592	;		TCS[6][	314	]=	0.280543492	;		TCS[7][	314	]=	0.465370517	;		TCS[8][	314	]=	0.708290691	;		TCS[9][	314	]=	0.801802342	;		TCS[10][	314	]=	0.728347069	;		TCS[11][	314	]=	0.091763988	;		TCS[12][	314	]=	0.029116181	;		TCS[13][	314	]=	0.746995343	;		TCS[14][	314	]=	0.095134647	;
	TCS[0][	315	]=	675	;		TCS[1][	315	]=	0.454	;		TCS[2][	315	]=	0.331	;		TCS[3][	315	]=	0.238	;		TCS[4][	315	]=	0.154	;		TCS[5][	315	]=	0.183	;		TCS[6][	315	]=	0.281	;		TCS[7][	315	]=	0.466	;		TCS[8][	315	]=	0.709	;		TCS[9][	315	]=	0.803	;		TCS[10][	315	]=	0.729	;		TCS[11][	315	]=	0.093	;		TCS[12][	315	]=	0.03	;		TCS[13][	315	]=	0.747	;		TCS[14][	315	]=	0.096	;
	TCS[0][	316	]=	676	;		TCS[1][	316	]=	0.454126112	;		TCS[2][	316	]=	0.330936243	;		TCS[3][	316	]=	0.240125933	;		TCS[4][	316	]=	0.154737054	;		TCS[5][	316	]=	0.183598751	;		TCS[6][	316	]=	0.281415951	;		TCS[7][	316	]=	0.466523281	;		TCS[8][	316	]=	0.709650068	;		TCS[9][	316	]=	0.804221511	;		TCS[10][	316	]=	0.72948698	;		TCS[11][	316	]=	0.09449853	;		TCS[12][	316	]=	0.03089519	;		TCS[13][	316	]=	0.747004636	;		TCS[14][	316	]=	0.097007511	;
	TCS[0][	317	]=	677	;		TCS[1][	317	]=	0.454273349	;		TCS[2][	317	]=	0.330947502	;		TCS[3][	317	]=	0.242480223	;		TCS[4][	317	]=	0.155514353	;		TCS[5][	317	]=	0.184199278	;		TCS[6][	317	]=	0.281807566	;		TCS[7][	317	]=	0.466959366	;		TCS[8][	317	]=	0.710255593	;		TCS[9][	317	]=	0.805452551	;		TCS[10][	317	]=	0.729858495	;		TCS[11][	317	]=	0.096216501	;		TCS[12][	317	]=	0.031818689	;		TCS[13][	317	]=	0.747008099	;		TCS[14][	317	]=	0.098141992	;
	TCS[0][	318	]=	678	;		TCS[1][	318	]=	0.45445753	;		TCS[2][	318	]=	0.33099064	;		TCS[3][	318	]=	0.245071546	;		TCS[4][	318	]=	0.156323125	;		TCS[5][	318	]=	0.18480043	;		TCS[6][	318	]=	0.282191205	;		TCS[7][	318	]=	0.46733381	;		TCS[8][	318	]=	0.710836084	;		TCS[9][	318	]=	0.806672836	;		TCS[10][	318	]=	0.730186521	;		TCS[11][	318	]=	0.098085208	;		TCS[12][	318	]=	0.032794593	;		TCS[13][	318	]=	0.747009245	;		TCS[14][	318	]=	0.099372718	;
	TCS[0][	319	]=	679	;		TCS[1][	319	]=	0.454694474	;		TCS[2][	319	]=	0.331022518	;		TCS[3][	319	]=	0.247908579	;		TCS[4][	319	]=	0.157154599	;		TCS[5][	319	]=	0.185401054	;		TCS[6][	319	]=	0.28258323	;		TCS[7][	319	]=	0.46767217	;		TCS[8][	319	]=	0.71141105	;		TCS[9][	319	]=	0.807862081	;		TCS[10][	319	]=	0.730543031	;		TCS[11][	319	]=	0.100035943	;		TCS[12][	319	]=	0.033846998	;		TCS[13][	319	]=	0.747006927	;		TCS[14][	319	]=	0.100668963	;
	TCS[0][	320	]=	680	;		TCS[1][	320	]=	0.455	;		TCS[2][	320	]=	0.331	;		TCS[3][	320	]=	0.251	;		TCS[4][	320	]=	0.158	;		TCS[5][	320	]=	0.186	;		TCS[6][	320	]=	0.283	;		TCS[7][	320	]=	0.468	;		TCS[8][	320	]=	0.712	;		TCS[9][	320	]=	0.809	;		TCS[10][	320	]=	0.731	;		TCS[11][	320	]=	0.102	;		TCS[12][	320	]=	0.035	;		TCS[13][	320	]=	0.747	;		TCS[14][	320	]=	0.102	;
	TCS[0][	321	]=	681	;		TCS[1][	321	]=	0.455381047	;		TCS[2][	321	]=	0.330891455	;		TCS[3][	321	]=	0.254341872	;		TCS[4][	321	]=	0.158849526	;		TCS[5][	321	]=	0.186596681	;		TCS[6][	321	]=	0.283457655	;		TCS[7][	321	]=	0.468339851	;		TCS[8][	321	]=	0.712615744	;		TCS[9][	321	]=	0.81007263	;		TCS[10][	321	]=	0.731610915	;		TCS[11][	321	]=	0.10392775	;		TCS[12][	321	]=	0.036276757	;		TCS[13][	321	]=	0.746988469	;		TCS[14][	321	]=	0.103350291	;
	TCS[0][	322	]=	682	;		TCS[1][	322	]=	0.455809033	;		TCS[2][	322	]=	0.330711279	;		TCS[3][	322	]=	0.257879808	;		TCS[4][	322	]=	0.159689248	;		TCS[5][	322	]=	0.187192776	;		TCS[6][	322	]=	0.283971448	;		TCS[7][	322	]=	0.468702253	;		TCS[8][	322	]=	0.713244299	;		TCS[9][	322	]=	0.811091297	;		TCS[10][	322	]=	0.732355319	;		TCS[11][	322	]=	0.105845871	;		TCS[12][	322	]=	0.03769667	;		TCS[13][	322	]=	0.746976944	;		TCS[14][	322	]=	0.104765042	;
	TCS[0][	323	]=	683	;		TCS[1][	323	]=	0.456246495	;		TCS[2][	323	]=	0.330485376	;		TCS[3][	323	]=	0.261546808	;		TCS[4][	323	]=	0.160504207	;		TCS[5][	323	]=	0.187790531	;		TCS[6][	323	]=	0.284556415	;		TCS[7][	323	]=	0.469094729	;		TCS[8][	323	]=	0.713864981	;		TCS[9][	323	]=	0.812073649	;		TCS[10][	323	]=	0.733194264	;		TCS[11][	323	]=	0.107800116	;		TCS[12][	323	]=	0.039278206	;		TCS[13][	323	]=	0.746971184	;		TCS[14][	323	]=	0.106304648	;
	TCS[0][	324	]=	684	;		TCS[1][	324	]=	0.456655972	;		TCS[2][	324	]=	0.330239648	;		TCS[3][	324	]=	0.265275872	;		TCS[4][	324	]=	0.161279444	;		TCS[5][	324	]=	0.188392191	;		TCS[6][	324	]=	0.285227588	;		TCS[7][	324	]=	0.469524803	;		TCS[8][	324	]=	0.714457109	;		TCS[9][	324	]=	0.813037334	;		TCS[10][	324	]=	0.734088806	;		TCS[11][	324	]=	0.109836241	;		TCS[12][	324	]=	0.041039828	;		TCS[13][	324	]=	0.74697695	;		TCS[14][	324	]=	0.108029503	;
	TCS[0][	325	]=	685	;		TCS[1][	325	]=	0.457	;		TCS[2][	325	]=	0.33	;		TCS[3][	325	]=	0.269	;		TCS[4][	325	]=	0.162	;		TCS[5][	325	]=	0.189	;		TCS[6][	325	]=	0.286	;		TCS[7][	325	]=	0.47	;		TCS[8][	325	]=	0.715	;		TCS[9][	325	]=	0.814	;		TCS[10][	325	]=	0.735	;		TCS[11][	325	]=	0.112	;		TCS[12][	325	]=	0.043	;		TCS[13][	325	]=	0.747	;		TCS[14][	325	]=	0.11	;
	TCS[0][	326	]=	686	;		TCS[1][	326	]=	0.4572537	;		TCS[2][	326	]=	0.329785938	;		TCS[3][	326	]=	0.272674579	;		TCS[4][	326	]=	0.162656844	;		TCS[5][	326	]=	0.189614525	;		TCS[6][	326	]=	0.286881431	;		TCS[7][	326	]=	0.470525313	;		TCS[8][	326	]=	0.715478956	;		TCS[9][	326	]=	0.81497597	;		TCS[10][	326	]=	0.735893358	;		TCS[11][	326	]=	0.11432647	;		TCS[12][	326	]=	0.045173784	;		TCS[13][	326	]=	0.747041486	;		TCS[14][	326	]=	0.112255327	;
	TCS[0][	327	]=	687	;		TCS[1][	327	]=	0.457442519	;		TCS[2][	327	]=	0.329591382	;		TCS[3][	327	]=	0.276344545	;		TCS[4][	327	]=	0.163264657	;		TCS[5][	327	]=	0.190229617	;		TCS[6][	327	]=	0.28785064	;		TCS[7][	327	]=	0.471095621	;		TCS[8][	327	]=	0.715903213	;		TCS[9][	327	]=	0.815966261	;		TCS[10][	327	]=	0.73675223	;		TCS[11][	327	]=	0.116808016	;		TCS[12][	327	]=	0.04756263	;		TCS[13][	327	]=	0.747084124	;		TCS[14][	327	]=	0.11474984	;
	TCS[0][	328	]=	688	;		TCS[1][	328	]=	0.457604489	;		TCS[2][	328	]=	0.329403858	;		TCS[3][	328	]=	0.280077222	;		TCS[4][	328	]=	0.163844048	;		TCS[5][	328	]=	0.190837446	;		TCS[6][	328	]=	0.288879135	;		TCS[7][	328	]=	0.471703273	;		TCS[8][	328	]=	0.716287992	;		TCS[9][	328	]=	0.816968568	;		TCS[10][	328	]=	0.737564422	;		TCS[11][	328	]=	0.119426328	;		TCS[12][	328	]=	0.050164583	;		TCS[13][	328	]=	0.747106018	;		TCS[14][	328	]=	0.11741669	;
	TCS[0][	329	]=	689	;		TCS[1][	329	]=	0.457777639	;		TCS[2][	329	]=	0.329210889	;		TCS[3][	329	]=	0.283939933	;		TCS[4][	329	]=	0.164415626	;		TCS[5][	329	]=	0.191430183	;		TCS[6][	329	]=	0.289938419	;		TCS[7][	329	]=	0.472340616	;		TCS[8][	329	]=	0.716648514	;		TCS[9][	329	]=	0.817980584	;		TCS[10][	329	]=	0.738317743	;		TCS[11][	329	]=	0.122163093	;		TCS[12][	329	]=	0.052977691	;		TCS[13][	329	]=	0.747085275	;		TCS[14][	329	]=	0.120189027	;
	TCS[0][	330	]=	690	;		TCS[1][	330	]=	0.458	;		TCS[2][	330	]=	0.329	;		TCS[3][	330	]=	0.288	;		TCS[4][	330	]=	0.165	;		TCS[5][	330	]=	0.192	;		TCS[6][	330	]=	0.291	;		TCS[7][	330	]=	0.473	;		TCS[8][	330	]=	0.717	;		TCS[9][	330	]=	0.819	;		TCS[10][	330	]=	0.739	;		TCS[11][	330	]=	0.125	;		TCS[12][	330	]=	0.056	;		TCS[13][	330	]=	0.747	;		TCS[14][	330	]=	0.123	;
	TCS[0][	331	]=	691	;		TCS[1][	331	]=	0.458300154	;		TCS[2][	331	]=	0.328764794	;		TCS[3][	331	]=	0.292311811	;		TCS[4][	331	]=	0.165611098	;		TCS[5][	331	]=	0.192545217	;		TCS[6][	331	]=	0.292040622	;		TCS[7][	331	]=	0.473678895	;		TCS[8][	331	]=	0.717356433	;		TCS[9][	331	]=	0.820023492	;		TCS[10][	331	]=	0.739607652	;		TCS[11][	331	]=	0.127926372	;		TCS[12][	331	]=	0.059228107	;		TCS[13][	331	]=	0.746837585	;		TCS[14][	331	]=	0.125796402	;
	TCS[0][	332	]=	692	;		TCS[1][	332	]=	0.45866889	;		TCS[2][	332	]=	0.328523192	;		TCS[3][	332	]=	0.29687801	;		TCS[4][	332	]=	0.166236124	;		TCS[5][	332	]=	0.193088755	;		TCS[6][	332	]=	0.29305799	;		TCS[7][	332	]=	0.474395261	;		TCS[8][	332	]=	0.717726851	;		TCS[9][	332	]=	0.821043658	;		TCS[10][	332	]=	0.740171762	;		TCS[11][	332	]=	0.130962066	;		TCS[12][	332	]=	0.062652811	;		TCS[13][	332	]=	0.746622561	;		TCS[14][	332	]=	0.128579597	;
	TCS[0][	333	]=	693	;		TCS[1][	333	]=	0.459087549	;		TCS[2][	333	]=	0.328299192	;		TCS[3][	333	]=	0.301688303	;		TCS[4][	333	]=	0.166855601	;		TCS[5][	333	]=	0.193659685	;		TCS[6][	333	]=	0.294055046	;		TCS[7][	333	]=	0.475172179	;		TCS[8][	333	]=	0.718119051	;		TCS[9][	333	]=	0.822052078	;		TCS[10][	333	]=	0.740732047	;		TCS[11][	333	]=	0.134134574	;		TCS[12][	333	]=	0.066263461	;		TCS[13][	333	]=	0.746388744	;		TCS[14][	333	]=	0.131364591	;
	TCS[0][	334	]=	694	;		TCS[1][	334	]=	0.459537472	;		TCS[2][	334	]=	0.328116795	;		TCS[3][	334	]=	0.306732397	;		TCS[4][	334	]=	0.167450052	;		TCS[5][	334	]=	0.194287076	;		TCS[6][	334	]=	0.295034735	;		TCS[7][	334	]=	0.476032732	;		TCS[8][	334	]=	0.718540835	;		TCS[9][	334	]=	0.823040332	;		TCS[10][	334	]=	0.741328221	;		TCS[11][	334	]=	0.137471388	;		TCS[12][	334	]=	0.070049408	;		TCS[13][	334	]=	0.746169952	;		TCS[14][	334	]=	0.13416639	;
	TCS[0][	335	]=	695	;		TCS[1][	335	]=	0.46	;		TCS[2][	335	]=	0.328	;		TCS[3][	335	]=	0.312	;		TCS[4][	335	]=	0.168	;		TCS[5][	335	]=	0.195	;		TCS[6][	335	]=	0.296	;		TCS[7][	335	]=	0.477	;		TCS[8][	335	]=	0.719	;		TCS[9][	335	]=	0.824	;		TCS[10][	335	]=	0.742	;		TCS[11][	335	]=	0.141	;		TCS[12][	335	]=	0.074	;		TCS[13][	335	]=	0.746	;		TCS[14][	335	]=	0.137	;
	TCS[0][	336	]=	696	;		TCS[1][	336	]=	0.460457685	;		TCS[2][	336	]=	0.327962886	;		TCS[3][	336	]=	0.317470175	;		TCS[4][	336	]=	0.168490764	;		TCS[5][	336	]=	0.195812606	;		TCS[6][	336	]=	0.296964081	;		TCS[7][	336	]=	0.478087106	;		TCS[8][	336	]=	0.71949531	;		TCS[9][	336	]=	0.824922063	;		TCS[10][	336	]=	0.742772035	;		TCS[11][	336	]=	0.144736044	;		TCS[12][	336	]=	0.078113789	;		TCS[13][	336	]=	0.745904174	;		TCS[14][	336	]=	0.139879064	;
	TCS[0][	337	]=	697	;		TCS[1][	337	]=	0.460897922	;		TCS[2][	337	]=	0.32797985	;		TCS[3][	337	]=	0.323079414	;		TCS[4][	337	]=	0.168926847	;		TCS[5][	337	]=	0.196679362	;		TCS[6][	337	]=	0.297981401	;		TCS[7][	337	]=	0.479267335	;		TCS[8][	337	]=	0.719989384	;		TCS[9][	337	]=	0.825795108	;		TCS[10][	337	]=	0.74360872	;		TCS[11][	337	]=	0.148647722	;		TCS[12][	337	]=	0.082426128	;		TCS[13][	337	]=	0.745873633	;		TCS[14][	337	]=	0.14281177	;
	TCS[0][	338	]=	698	;		TCS[1][	338	]=	0.461309316	;		TCS[2][	338	]=	0.328015372	;		TCS[3][	338	]=	0.328753566	;		TCS[4][	338	]=	0.169317547	;		TCS[5][	338	]=	0.197539815	;		TCS[6][	338	]=	0.299116681	;		TCS[7][	338	]=	0.48050401	;		TCS[8][	338	]=	0.720435802	;		TCS[9][	338	]=	0.82660712	;		TCS[10][	338	]=	0.744459389	;		TCS[11][	338	]=	0.152691378	;		TCS[12][	338	]=	0.086981573	;		TCS[13][	338	]=	0.745891004	;		TCS[14][	338	]=	0.145804945	;
	TCS[0][	339	]=	699	;		TCS[1][	339	]=	0.461680473	;		TCS[2][	339	]=	0.32803393	;		TCS[3][	339	]=	0.334418478	;		TCS[4][	339	]=	0.169672166	;		TCS[5][	339	]=	0.198333512	;		TCS[6][	339	]=	0.30043464	;		TCS[7][	339	]=	0.481760457	;		TCS[8][	339	]=	0.720788147	;		TCS[9][	339	]=	0.827346089	;		TCS[10][	339	]=	0.745273372	;		TCS[11][	339	]=	0.156823356	;		TCS[12][	339	]=	0.091824678	;		TCS[13][	339	]=	0.745938918	;		TCS[14][	339	]=	0.148865413	;
	TCS[0][	340	]=	700	;		TCS[1][	340	]=	0.462	;		TCS[2][	340	]=	0.328	;		TCS[3][	340	]=	0.34	;		TCS[4][	340	]=	0.17	;		TCS[5][	340	]=	0.199	;		TCS[6][	340	]=	0.302	;		TCS[7][	340	]=	0.483	;		TCS[8][	340	]=	0.721	;		TCS[9][	340	]=	0.828	;		TCS[10][	340	]=	0.746	;		TCS[11][	340	]=	0.161	;		TCS[12][	340	]=	0.097	;		TCS[13][	340	]=	0.746	;		TCS[14][	340	]=	0.152	;
	TCS[0][	341	]=	701	;		TCS[1][	341	]=	0.462261106	;		TCS[2][	341	]=	0.327887663	;		TCS[3][	341	]=	0.345439488	;		TCS[4][	341	]=	0.170305847	;		TCS[5][	341	]=	0.199492359	;		TCS[6][	341	]=	0.303855056	;		TCS[7][	341	]=	0.48419668	;		TCS[8][	341	]=	0.721038325	;		TCS[9][	341	]=	0.828560255	;		TCS[10][	341	]=	0.74660021	;		TCS[11][	341	]=	0.165185453	;		TCS[12][	341	]=	0.102540739	;		TCS[13][	341	]=	0.74605772	;		TCS[14][	341	]=	0.155215342	;
	TCS[0][	342	]=	702	;		TCS[1][	342	]=	0.462475424	;		TCS[2][	342	]=	0.327709406	;		TCS[3][	342	]=	0.350740333	;		TCS[4][	342	]=	0.17057649	;		TCS[5][	342	]=	0.199817797	;		TCS[6][	342	]=	0.305952407	;		TCS[7][	342	]=	0.4853674	;		TCS[8][	342	]=	0.720923613	;		TCS[9][	342	]=	0.829031912	;		TCS[10][	342	]=	0.747081356	;		TCS[11][	342	]=	0.169375047	;		TCS[12][	342	]=	0.108434678	;		TCS[13][	342	]=	0.746098909	;		TCS[14][	342	]=	0.158517321	;
	TCS[0][	343	]=	703	;		TCS[1][	343	]=	0.462659188	;		TCS[2][	343	]=	0.327487318	;		TCS[3][	343	]=	0.355921434	;		TCS[4][	343	]=	0.170794209	;		TCS[5][	343	]=	0.199997055	;		TCS[6][	343	]=	0.308222231	;		TCS[7][	343	]=	0.48653978	;		TCS[8][	343	]=	0.720689739	;		TCS[9][	343	]=	0.82942344	;		TCS[10][	343	]=	0.747462397	;		TCS[11][	343	]=	0.173571916	;		TCS[12][	343	]=	0.114658248	;		TCS[13][	343	]=	0.746111238	;		TCS[14][	343	]=	0.161911628	;
	TCS[0][	344	]=	704	;		TCS[1][	344	]=	0.462828634	;		TCS[2][	344	]=	0.327243486	;		TCS[3][	344	]=	0.36100169	;		TCS[4][	344	]=	0.170941286	;		TCS[5][	344	]=	0.200050876	;		TCS[6][	344	]=	0.310594703	;		TCS[7][	344	]=	0.48774144	;		TCS[8][	344	]=	0.720370577	;		TCS[9][	344	]=	0.829743313	;		TCS[10][	344	]=	0.747762292	;		TCS[11][	344	]=	0.17777919	;		TCS[12][	344	]=	0.121187879	;		TCS[13][	344	]=	0.746082378	;		TCS[14][	344	]=	0.165403957	;
	TCS[0][	345	]=	705	;		TCS[1][	345	]=	0.463	;		TCS[2][	345	]=	0.327	;		TCS[3][	345	]=	0.366	;		TCS[4][	345	]=	0.171	;		TCS[5][	345	]=	0.2	;		TCS[6][	345	]=	0.313	;		TCS[7][	345	]=	0.489	;		TCS[8][	345	]=	0.72	;		TCS[9][	345	]=	0.83	;		TCS[10][	345	]=	0.748	;		TCS[11][	345	]=	0.182	;		TCS[12][	345	]=	0.128	;		TCS[13][	345	]=	0.746	;		TCS[14][	345	]=	0.169	;
	TCS[0][	346	]=	706	;		TCS[1][	346	]=	0.46318589	;		TCS[2][	346	]=	0.326774461	;		TCS[3][	346	]=	0.370931872	;		TCS[4][	346	]=	0.170957849	;		TCS[5][	346	]=	0.199865959	;		TCS[6][	346	]=	0.315383697	;		TCS[7][	346	]=	0.490334175	;		TCS[8][	346	]=	0.719615391	;		TCS[9][	346	]=	0.830204916	;		TCS[10][	346	]=	0.748195125	;		TCS[11][	346	]=	0.186234145	;		TCS[12][	346	]=	0.135075257	;		TCS[13][	346	]=	0.745856945	;		TCS[14][	346	]=	0.172699568	;
	TCS[0][	347	]=	707	;		TCS[1][	347	]=	0.463384384	;		TCS[2][	347	]=	0.326566524	;		TCS[3][	347	]=	0.375799253	;		TCS[4][	347	]=	0.170823194	;		TCS[5][	347	]=	0.199673451	;		TCS[6][	347	]=	0.31775297	;		TCS[7][	347	]=	0.491727065	;		TCS[8][	347	]=	0.719268165	;		TCS[9][	347	]=	0.830381246	;		TCS[10][	347	]=	0.748369855	;		TCS[11][	347	]=	0.190468088	;		TCS[12][	347	]=	0.14241116	;		TCS[13][	347	]=	0.745666731	;		TCS[14][	347	]=	0.176478946	;
	TCS[0][	348	]=	708	;		TCS[1][	348	]=	0.463589934	;		TCS[2][	348	]=	0.326371356	;		TCS[3][	348	]=	0.380600697	;		TCS[4][	348	]=	0.170609615	;		TCS[5][	348	]=	0.199447963	;		TCS[6][	348	]=	0.320130395	;		TCS[7][	348	]=	0.493152869	;		TCS[8][	348	]=	0.719013242	;		TCS[9][	348	]=	0.830555118	;		TCS[10][	348	]=	0.748547022	;		TCS[11][	348	]=	0.194684959	;		TCS[12][	348	]=	0.150009435	;		TCS[13][	348	]=	0.745448045	;		TCS[14][	348	]=	0.180308541	;
	TCS[0][	349	]=	709	;		TCS[1][	349	]=	0.463796989	;		TCS[2][	349	]=	0.326184125	;		TCS[3][	349	]=	0.385334761	;		TCS[4][	349	]=	0.170330691	;		TCS[5][	349	]=	0.199214984	;		TCS[6][	349	]=	0.322538547	;		TCS[7][	349	]=	0.494585781	;		TCS[8][	349	]=	0.718905547	;		TCS[9][	349	]=	0.83075266	;		TCS[10][	349	]=	0.74874946	;		TCS[11][	349	]=	0.198867886	;		TCS[12][	349	]=	0.157871806	;		TCS[13][	349	]=	0.745219572	;		TCS[14][	349	]=	0.184158758	;
	TCS[0][	350	]=	710	;		TCS[1][	350	]=	0.464	;		TCS[2][	350	]=	0.326	;		TCS[3][	350	]=	0.39	;		TCS[4][	350	]=	0.17	;		TCS[5][	350	]=	0.199	;		TCS[6][	350	]=	0.325	;		TCS[7][	350	]=	0.496	;		TCS[8][	350	]=	0.719	;		TCS[9][	350	]=	0.831	;		TCS[10][	350	]=	0.749	;		TCS[11][	350	]=	0.203	;		TCS[12][	350	]=	0.166	;		TCS[13][	350	]=	0.745	;		TCS[14][	350	]=	0.188	;
	TCS[0][	351	]=	711	;		TCS[1][	351	]=	0.464195335	;		TCS[2][	351	]=	0.325814493	;		TCS[3][	351	]=	0.394593023	;		TCS[4][	351	]=	0.169630759	;		TCS[5][	351	]=	0.198819804	;		TCS[6][	351	]=	0.327530155	;		TCS[7][	351	]=	0.497378621	;		TCS[8][	351	]=	0.719332111	;		TCS[9][	351	]=	0.831316081	;		TCS[10][	351	]=	0.749315289	;		TCS[11][	351	]=	0.207069967	;		TCS[12][	351	]=	0.174390232	;		TCS[13][	351	]=	0.744802498	;		TCS[14][	351	]=	0.191810387	;
	TCS[0][	352	]=	712	;		TCS[1][	352	]=	0.46438704	;		TCS[2][	352	]=	0.325624499	;		TCS[3][	352	]=	0.399102656	;		TCS[4][	352	]=	0.169234734	;		TCS[5][	352	]=	0.198656398	;		TCS[6][	352	]=	0.330115711	;		TCS[7][	352	]=	0.498740339	;		TCS[8][	352	]=	0.719859729	;		TCS[9][	352	]=	0.831691106	;		TCS[10][	352	]=	0.749687224	;		TCS[11][	352	]=	0.211088599	;		TCS[12][	352	]=	0.183016681	;		TCS[13][	352	]=	0.744618166	;		TCS[14][	352	]=	0.195598894	;
	TCS[0][	353	]=	713	;		TCS[1][	353	]=	0.464581076	;		TCS[2][	353	]=	0.325427258	;		TCS[3][	353	]=	0.403515777	;		TCS[4][	353	]=	0.168823329	;		TCS[5][	353	]=	0.198483091	;		TCS[6][	353	]=	0.332736188	;		TCS[7][	353	]=	0.500112746	;		TCS[8][	353	]=	0.720521292	;		TCS[9][	353	]=	0.832108089	;		TCS[10][	353	]=	0.750101514	;		TCS[11][	353	]=	0.215072249	;		TCS[12][	353	]=	0.191848013	;		TCS[13][	353	]=	0.744432584	;		TCS[14][	353	]=	0.199382206	;
	TCS[0][	354	]=	714	;		TCS[1][	354	]=	0.464783409	;		TCS[2][	354	]=	0.325220012	;		TCS[3][	354	]=	0.407819265	;		TCS[4][	354	]=	0.16840795	;		TCS[5][	354	]=	0.19827319	;		TCS[6][	354	]=	0.335371111	;		TCS[7][	354	]=	0.501523435	;		TCS[8][	354	]=	0.721255237	;		TCS[9][	354	]=	0.832550048	;		TCS[10][	354	]=	0.75054387	;		TCS[11][	354	]=	0.219037266	;		TCS[12][	354	]=	0.200852896	;		TCS[13][	354	]=	0.744231335	;		TCS[14][	354	]=	0.203177012	;
	TCS[0][	355	]=	715	;		TCS[1][	355	]=	0.465	;		TCS[2][	355	]=	0.325	;		TCS[3][	355	]=	0.412	;		TCS[4][	355	]=	0.168	;		TCS[5][	355	]=	0.198	;		TCS[6][	355	]=	0.338	;		TCS[7][	355	]=	0.503	;		TCS[8][	355	]=	0.722	;		TCS[9][	355	]=	0.833	;		TCS[10][	355	]=	0.751	;		TCS[11][	355	]=	0.223	;		TCS[12][	355	]=	0.21	;		TCS[13][	355	]=	0.744	;		TCS[14][	355	]=	0.207	;
	TCS[0][	356	]=	716	;		TCS[1][	356	]=	0.465232769	;		TCS[2][	356	]=	0.324767568	;		TCS[3][	356	]=	0.416048035	;		TCS[4][	356	]=	0.167607117	;		TCS[5][	356	]=	0.197646826	;		TCS[6][	356	]=	0.340607681	;		TCS[7][	356	]=	0.50455934	;		TCS[8][	356	]=	0.722704167	;		TCS[9][	356	]=	0.833442759	;		TCS[10][	356	]=	0.751455718	;		TCS[11][	356	]=	0.226965989	;		TCS[12][	356	]=	0.219259814	;		TCS[13][	356	]=	0.743733062	;		TCS[14][	356	]=	0.210858883	;
	TCS[0][	357	]=	717	;		TCS[1][	357	]=	0.465467457	;		TCS[2][	357	]=	0.324535481	;		TCS[3][	357	]=	0.419966125	;		TCS[4][	357	]=	0.167221872	;		TCS[5][	357	]=	0.197236955	;		TCS[6][	357	]=	0.343200186	;		TCS[7][	357	]=	0.50617558	;		TCS[8][	357	]=	0.723356919	;		TCS[9][	357	]=	0.833870332	;		TCS[10][	357	]=	0.75189725	;		TCS[11][	357	]=	0.230897514	;		TCS[12][	357	]=	0.228610118	;		TCS[13][	357	]=	0.743460606	;		TCS[14][	357	]=	0.214725479	;
	TCS[0][	358	]=	718	;		TCS[1][	358	]=	0.465685761	;		TCS[2][	358	]=	0.324319611	;		TCS[3][	358	]=	0.423760196	;		TCS[4][	358	]=	0.166833068	;		TCS[5][	358	]=	0.196803671	;		TCS[6][	358	]=	0.345788851	;		TCS[7][	358	]=	0.507812149	;		TCS[8][	358	]=	0.723957588	;		TCS[9][	358	]=	0.834276526	;		TCS[10][	358	]=	0.752310922	;		TCS[11][	358	]=	0.234746046	;		TCS[12][	358	]=	0.238030515	;		TCS[13][	358	]=	0.743221619	;		TCS[14][	358	]=	0.218562634	;
	TCS[0][	359	]=	719	;		TCS[1][	359	]=	0.465869376	;		TCS[2][	359	]=	0.324135827	;		TCS[3][	359	]=	0.427436179	;		TCS[4][	359	]=	0.166429509	;		TCS[5][	359	]=	0.196380258	;		TCS[6][	359	]=	0.348385011	;		TCS[7][	359	]=	0.509432479	;		TCS[8][	359	]=	0.724505505	;		TCS[9][	359	]=	0.834655147	;		TCS[10][	359	]=	0.752683062	;		TCS[11][	359	]=	0.238463051	;		TCS[12][	359	]=	0.247500608	;		TCS[13][	359	]=	0.743055088	;		TCS[14][	359	]=	0.222333193	;
	TCS[0][	360	]=	720	;		TCS[1][	360	]=	0.466	;		TCS[2][	360	]=	0.324	;		TCS[3][	360	]=	0.431	;		TCS[4][	360	]=	0.166	;		TCS[5][	360	]=	0.196	;		TCS[6][	360	]=	0.351	;		TCS[7][	360	]=	0.511	;		TCS[8][	360	]=	0.725	;		TCS[9][	360	]=	0.835	;		TCS[10][	360	]=	0.753	;		TCS[11][	360	]=	0.242	;		TCS[12][	360	]=	0.257	;		TCS[13][	360	]=	0.743	;		TCS[14][	360	]=	0.226	;
	TCS[0][	361	]=	721	;		TCS[1][	361	]=	0.466065588	;		TCS[2][	361	]=	0.323923236	;		TCS[3][	361	]=	0.434454835	;		TCS[4][	361	]=	0.165540773	;		TCS[5][	361	]=	0.195688893	;		TCS[6][	361	]=	0.353639121	;		TCS[7][	361	]=	0.512488018	;		TCS[8][	361	]=	0.725443223	;		TCS[9][	361	]=	0.835304884	;		TCS[10][	361	]=	0.753253837	;		TCS[11][	361	]=	0.245322078	;		TCS[12][	361	]=	0.266514513	;		TCS[13][	361	]=	0.743081255	;		TCS[14][	361	]=	0.229538082	;
	TCS[0][	362	]=	722	;		TCS[1][	362	]=	0.466079131	;		TCS[2][	362	]=	0.323897577	;		TCS[3][	362	]=	0.437792845	;		TCS[4][	362	]=	0.165077779	;		TCS[5][	362	]=	0.195443782	;		TCS[6][	362	]=	0.356283544	;		TCS[7][	362	]=	0.513909343	;		TCS[8][	362	]=	0.725848594	;		TCS[9][	362	]=	0.835563566	;		TCS[10][	362	]=	0.753459778	;		TCS[11][	362	]=	0.248449343	;		TCS[12][	362	]=	0.276054849	;		TCS[13][	362	]=	0.74326741	;		TCS[14][	362	]=	0.23297119	;
	TCS[0][	363	]=	723	;		TCS[1][	363	]=	0.466059881	;		TCS[2][	363	]=	0.323910299	;		TCS[3][	363	]=	0.441003437	;		TCS[4][	363	]=	0.164644399	;		TCS[5][	363	]=	0.195254225	;		TCS[6][	363	]=	0.358908407	;		TCS[7][	363	]=	0.515286658	;		TCS[8][	363	]=	0.726232355	;		TCS[9][	363	]=	0.835769807	;		TCS[10][	363	]=	0.7536388	;		TCS[11][	363	]=	0.251415569	;		TCS[12][	363	]=	0.285637928	;		TCS[13][	363	]=	0.743512939	;		TCS[14][	363	]=	0.236335257	;
	TCS[0][	364	]=	724	;		TCS[1][	364	]=	0.466027087	;		TCS[2][	364	]=	0.323948682	;		TCS[3][	364	]=	0.44407602	;		TCS[4][	364	]=	0.164274013	;		TCS[5][	364	]=	0.195109778	;		TCS[6][	364	]=	0.361488846	;		TCS[7][	364	]=	0.516642649	;		TCS[8][	364	]=	0.726610743	;		TCS[9][	364	]=	0.835917365	;		TCS[10][	364	]=	0.753811881	;		TCS[11][	364	]=	0.25425453	;		TCS[12][	364	]=	0.295280672	;		TCS[13][	364	]=	0.743772311	;		TCS[14][	364	]=	0.239666216	;
	TCS[0][	365	]=	725	;		TCS[1][	365	]=	0.466	;		TCS[2][	365	]=	0.324	;		TCS[3][	365	]=	0.447	;		TCS[4][	365	]=	0.164	;		TCS[5][	365	]=	0.195	;		TCS[6][	365	]=	0.364	;		TCS[7][	365	]=	0.518	;		TCS[8][	365	]=	0.727	;		TCS[9][	365	]=	0.836	;		TCS[10][	365	]=	0.754	;		TCS[11][	365	]=	0.257	;		TCS[12][	365	]=	0.305	;		TCS[13][	365	]=	0.744	;		TCS[14][	365	]=	0.243	;
	TCS[0][	366	]=	726	;		TCS[1][	366	]=	0.465992879	;		TCS[2][	366	]=	0.324051489	;		TCS[3][	366	]=	0.449772624	;		TCS[4][	366	]=	0.163845791	;		TCS[5][	366	]=	0.194917602	;		TCS[6][	366	]=	0.366427835	;		TCS[7][	366	]=	0.519376587	;		TCS[8][	366	]=	0.727410943	;		TCS[9][	366	]=	0.836017705	;		TCS[10][	366	]=	0.754216932	;		TCS[11][	366	]=	0.259681697	;		TCS[12][	366	]=	0.314802133	;		TCS[13][	366	]=	0.744165919	;		TCS[14][	366	]=	0.246364789	;
	TCS[0][	367	]=	727	;		TCS[1][	367	]=	0.466000018	;		TCS[2][	367	]=	0.324090213	;		TCS[3][	367	]=	0.452422495	;		TCS[4][	367	]=	0.163795011	;		TCS[5][	367	]=	0.194867916	;		TCS[6][	367	]=	0.368801636	;		TCS[7][	367	]=	0.52077105	;		TCS[8][	367	]=	0.727832704	;		TCS[9][	367	]=	0.835995402	;		TCS[10][	367	]=	0.754447639	;		TCS[11][	367	]=	0.262313112	;		TCS[12][	367	]=	0.324650486	;		TCS[13][	367	]=	0.744301752	;		TCS[14][	367	]=	0.24975776	;
	TCS[0][	368	]=	728	;		TCS[1][	368	]=	0.466010716	;		TCS[2][	368	]=	0.324103192	;		TCS[3][	368	]=	0.454986054	;		TCS[4][	368	]=	0.163821335	;		TCS[5][	368	]=	0.19485943	;		TCS[6][	368	]=	0.371161521	;		TCS[7][	368	]=	0.52217722	;		TCS[8][	368	]=	0.728248993	;		TCS[9][	368	]=	0.835964247	;		TCS[10][	368	]=	0.75466988	;		TCS[11][	368	]=	0.264903678	;		TCS[12][	368	]=	0.334497772	;		TCS[13][	368	]=	0.744454626	;		TCS[14][	368	]=	0.253168336	;
	TCS[0][	369	]=	729	;		TCS[1][	369	]=	0.466014277	;		TCS[2][	369	]=	0.324077447	;		TCS[3][	369	]=	0.457499742	;		TCS[4][	369	]=	0.16389844	;		TCS[5][	369	]=	0.194900629	;		TCS[6][	369	]=	0.373547603	;		TCS[7][	369	]=	0.523588926	;		TCS[8][	369	]=	0.728643522	;		TCS[9][	369	]=	0.835955395	;		TCS[10][	369	]=	0.754861414	;		TCS[11][	369	]=	0.26746283	;		TCS[12][	369	]=	0.344296706	;		TCS[13][	369	]=	0.744671666	;		TCS[14][	369	]=	0.256585941	;
	TCS[0][	370	]=	730	;		TCS[1][	370	]=	0.466	;		TCS[2][	370	]=	0.324	;		TCS[3][	370	]=	0.46	;		TCS[4][	370	]=	0.164	;		TCS[5][	370	]=	0.195	;		TCS[6][	370	]=	0.376	;		TCS[7][	370	]=	0.525	;		TCS[8][	370	]=	0.729	;		TCS[9][	370	]=	0.836	;		TCS[10][	370	]=	0.755	;		TCS[11][	370	]=	0.27	;		TCS[12][	370	]=	0.354	;		TCS[13][	370	]=	0.745	;		TCS[14][	370	]=	0.26	;
	TCS[0][	371	]=	731	;		TCS[1][	371	]=	0.465962895	;		TCS[2][	371	]=	0.323862808	;		TCS[3][	371	]=	0.462510668	;		TCS[4][	371	]=	0.164108064	;		TCS[5][	371	]=	0.195160698	;		TCS[6][	371	]=	0.37854554	;		TCS[7][	371	]=	0.526405633	;		TCS[8][	371	]=	0.729305006	;		TCS[9][	371	]=	0.836120296	;		TCS[10][	371	]=	0.755070435	;		TCS[11][	371	]=	0.272519132	;		TCS[12][	371	]=	0.363572954	;		TCS[13][	371	]=	0.745471069	;		TCS[14][	371	]=	0.26340276	;
	TCS[0][	372	]=	732	;		TCS[1][	372	]=	0.465920798	;		TCS[2][	372	]=	0.323677573	;		TCS[3][	372	]=	0.465005175	;		TCS[4][	372	]=	0.164238178	;		TCS[5][	372	]=	0.195364552	;		TCS[6][	372	]=	0.38115791	;		TCS[7][	372	]=	0.527806456	;		TCS[8][	372	]=	0.72955659	;		TCS[9][	372	]=	0.836302824	;		TCS[10][	372	]=	0.755085666	;		TCS[11][	372	]=	0.275002208	;		TCS[12][	372	]=	0.373031206	;		TCS[13][	372	]=	0.746053581	;		TCS[14][	372	]=	0.266797769	;
	TCS[0][	373	]=	733	;		TCS[1][	373	]=	0.465897254	;		TCS[2][	373	]=	0.323460934	;		TCS[3][	373	]=	0.467444348	;		TCS[4][	373	]=	0.164414259	;		TCS[5][	373	]=	0.195588056	;		TCS[6][	373	]=	0.38379751	;		TCS[7][	373	]=	0.529204464	;		TCS[8][	373	]=	0.729755672	;		TCS[9][	373	]=	0.836525204	;		TCS[10][	373	]=	0.75506568	;		TCS[11][	373	]=	0.277425718	;		TCS[12][	373	]=	0.382402982	;		TCS[13][	373	]=	0.746700558	;		TCS[14][	373	]=	0.270191398	;
	TCS[0][	374	]=	734	;		TCS[1][	374	]=	0.465915806	;		TCS[2][	374	]=	0.323229531	;		TCS[3][	374	]=	0.469789014	;		TCS[4][	374	]=	0.164660227	;		TCS[5][	374	]=	0.195807707	;		TCS[6][	374	]=	0.38642474	;		TCS[7][	374	]=	0.530601647	;		TCS[8][	374	]=	0.729903169	;		TCS[9][	374	]=	0.836765056	;		TCS[10][	374	]=	0.755030463	;		TCS[11][	374	]=	0.279766151	;		TCS[12][	374	]=	0.391716505	;		TCS[13][	374	]=	0.747365024	;		TCS[14][	374	]=	0.273590018	;
	TCS[0][	375	]=	735	;		TCS[1][	375	]=	0.466	;		TCS[2][	375	]=	0.323	;		TCS[3][	375	]=	0.472	;		TCS[4][	375	]=	0.165	;		TCS[5][	375	]=	0.196	;		TCS[6][	375	]=	0.389	;		TCS[7][	375	]=	0.532	;		TCS[8][	375	]=	0.73	;		TCS[9][	375	]=	0.837	;		TCS[10][	375	]=	0.755	;		TCS[11][	375	]=	0.282	;		TCS[12][	375	]=	0.401	;		TCS[13][	375	]=	0.748	;		TCS[14][	375	]=	0.277	;
	TCS[0][	376	]=	736	;		TCS[1][	376	]=	0.466163542	;		TCS[2][	376	]=	0.322785279	;		TCS[3][	376	]=	0.474048704	;		TCS[4][	376	]=	0.165449952	;		TCS[5][	376	]=	0.196151604	;		TCS[6][	376	]=	0.391494005	;		TCS[7][	376	]=	0.533400882	;		TCS[8][	376	]=	0.730049033	;		TCS[9][	376	]=	0.837213112	;		TCS[10][	376	]=	0.754989329	;		TCS[11][	376	]=	0.284113773	;		TCS[12][	376	]=	0.410266051	;		TCS[13][	376	]=	0.748565803	;		TCS[14][	376	]=	0.280424169	;
	TCS[0][	377	]=	737	;		TCS[1][	377	]=	0.466380791	;		TCS[2][	377	]=	0.322583495	;		TCS[3][	377	]=	0.475948805	;		TCS[4][	377	]=	0.165996278	;		TCS[5][	377	]=	0.196289876	;		TCS[6][	377	]=	0.393918724	;		TCS[7][	377	]=	0.534803124	;		TCS[8][	377	]=	0.730060935	;		TCS[9][	377	]=	0.837409302	;		TCS[10][	377	]=	0.754993696	;		TCS[11][	377	]=	0.286134055	;		TCS[12][	377	]=	0.419464688	;		TCS[13][	377	]=	0.749051923	;		TCS[14][	377	]=	0.283851162	;
	TCS[0][	378	]=	738	;		TCS[1][	378	]=	0.466616269	;		TCS[2][	378	]=	0.322389071	;		TCS[3][	378	]=	0.477724554	;		TCS[4][	378	]=	0.166617628	;		TCS[5][	378	]=	0.196452346	;		TCS[6][	378	]=	0.396296441	;		TCS[7][	378	]=	0.536204926	;		TCS[8][	378	]=	0.73004832	;		TCS[9][	378	]=	0.837598935	;		TCS[10][	378	]=	0.755003398	;		TCS[11][	378	]=	0.288097451	;		TCS[12][	378	]=	0.428530299	;		TCS[13][	378	]=	0.749455141	;		TCS[14][	378	]=	0.287266071	;
	TCS[0][	379	]=	739	;		TCS[1][	379	]=	0.466834498	;		TCS[2][	379	]=	0.322196431	;		TCS[3][	379	]=	0.479400202	;		TCS[4][	379	]=	0.167292652	;		TCS[5][	379	]=	0.196676544	;		TCS[6][	379	]=	0.398649438	;		TCS[7][	379	]=	0.537604485	;		TCS[8][	379	]=	0.730023803	;		TCS[9][	379	]=	0.837792379	;		TCS[10][	379	]=	0.755008734	;		TCS[11][	379	]=	0.290040565	;		TCS[12][	379	]=	0.437397273	;		TCS[13][	379	]=	0.749772239	;		TCS[14][	379	]=	0.290653987	;
	TCS[0][	380	]=	740	;		TCS[1][	380	]=	0.467	;		TCS[2][	380	]=	0.322	;		TCS[3][	380	]=	0.481	;		TCS[4][	380	]=	0.168	;		TCS[5][	380	]=	0.197	;		TCS[6][	380	]=	0.401	;		TCS[7][	380	]=	0.539	;		TCS[8][	380	]=	0.73	;		TCS[9][	380	]=	0.838	;		TCS[10][	380	]=	0.755	;		TCS[11][	380	]=	0.292	;		TCS[12][	380	]=	0.446	;		TCS[13][	380	]=	0.75	;		TCS[14][	380	]=	0.294	;
	TCS[0][	381	]=	741	;		TCS[1][	381	]=	0.467086938	;		TCS[2][	381	]=	0.321796075	;		TCS[3][	381	]=	0.482542518	;		TCS[4][	381	]=	0.168724127	;		TCS[5][	381	]=	0.197448886	;		TCS[6][	381	]=	0.40336644	;		TCS[7][	381	]=	0.540390839	;		TCS[8][	381	]=	0.729986861	;		TCS[9][	381	]=	0.838227255	;		TCS[10][	381	]=	0.754972249	;		TCS[11][	381	]=	0.294001776	;		TCS[12][	381	]=	0.45429084	;		TCS[13][	381	]=	0.750137717	;		TCS[14][	381	]=	0.297292564	;
	TCS[0][	382	]=	742	;		TCS[1][	382	]=	0.467108039	;		TCS[2][	382	]=	0.321588448	;		TCS[3][	382	]=	0.484023606	;		TCS[4][	382	]=	0.169472709	;		TCS[5][	382	]=	0.198003944	;		TCS[6][	382	]=	0.405751194	;		TCS[7][	382	]=	0.541781046	;		TCS[8][	382	]=	0.72998367	;		TCS[9][	382	]=	0.838459969	;		TCS[10][	382	]=	0.75493955	;		TCS[11][	382	]=	0.296029571	;		TCS[12][	382	]=	0.462294042	;		TCS[13][	382	]=	0.750194727	;		TCS[14][	382	]=	0.300533581	;
	TCS[0][	383	]=	743	;		TCS[1][	383	]=	0.467085671	;		TCS[2][	383	]=	0.321382783	;		TCS[3][	383	]=	0.485433435	;		TCS[4][	383	]=	0.170259227	;		TCS[5][	383	]=	0.198634559	;		TCS[6][	383	]=	0.408152728	;		TCS[7][	383	]=	0.543175834	;		TCS[8][	383	]=	0.72998705	;		TCS[9][	383	]=	0.838679054	;		TCS[10][	383	]=	0.754920727	;		TCS[11][	383	]=	0.298056478	;		TCS[12][	383	]=	0.470051823	;		TCS[13][	383	]=	0.750182879	;		TCS[14][	383	]=	0.303728316	;
	TCS[0][	384	]=	744	;		TCS[1][	384	]=	0.467042202	;		TCS[2][	384	]=	0.321184746	;		TCS[3][	384	]=	0.486762177	;		TCS[4][	384	]=	0.171097164	;		TCS[5][	384	]=	0.199310116	;		TCS[6][	384	]=	0.410569508	;		TCS[7][	384	]=	0.544580414	;		TCS[8][	384	]=	0.72999362	;		TCS[9][	384	]=	0.838865426	;		TCS[10][	384	]=	0.754934602	;		TCS[11][	384	]=	0.30005559	;		TCS[12][	384	]=	0.477606402	;		TCS[13][	384	]=	0.750114021	;		TCS[14][	384	]=	0.306882034	;
	TCS[0][	385	]=	745	;		TCS[1][	385	]=	0.467	;		TCS[2][	385	]=	0.321	;		TCS[3][	385	]=	0.488	;		TCS[4][	385	]=	0.172	;		TCS[5][	385	]=	0.2	;		TCS[6][	385	]=	0.413	;		TCS[7][	385	]=	0.546	;		TCS[8][	385	]=	0.73	;		TCS[9][	385	]=	0.839	;		TCS[10][	385	]=	0.755	;		TCS[11][	385	]=	0.302	;		TCS[12][	385	]=	0.485	;		TCS[13][	385	]=	0.75	;		TCS[14][	385	]=	0.31	;
	TCS[0][	386	]=	746	;		TCS[1][	386	]=	0.466976706	;		TCS[2][	386	]=	0.32083042	;		TCS[3][	386	]=	0.489141226	;		TCS[4][	386	]=	0.172973541	;		TCS[5][	386	]=	0.200676853	;		TCS[6][	386	]=	0.415440235	;		TCS[7][	386	]=	0.547435761	;		TCS[8][	386	]=	0.730003525	;		TCS[9][	386	]=	0.839069866	;		TCS[10][	386	]=	0.755129675	;		TCS[11][	386	]=	0.303863123	;		TCS[12][	386	]=	0.492266587	;		TCS[13][	386	]=	0.749851328	;		TCS[14][	386	]=	0.313085576	;
	TCS[0][	387	]=	747	;		TCS[1][	387	]=	0.466971053	;		TCS[2][	387	]=	0.320662713	;		TCS[3][	387	]=	0.490196771	;		TCS[4][	387	]=	0.173992887	;		TCS[5][	387	]=	0.201326348	;		TCS[6][	387	]=	0.4178765	;		TCS[7][	387	]=	0.548872691	;		TCS[8][	387	]=	0.730004383	;		TCS[9][	387	]=	0.839086824	;		TCS[10][	387	]=	0.755312103	;		TCS[11][	387	]=	0.30561966	;		TCS[12][	387	]=	0.499407146	;		TCS[13][	387	]=	0.749673167	;		TCS[14][	387	]=	0.316134514	;
	TCS[0][	388	]=	748	;		TCS[1][	388	]=	0.466977047	;		TCS[2][	388	]=	0.320479797	;		TCS[3][	388	]=	0.491181704	;		TCS[4][	388	]=	0.175025462	;		TCS[5][	388	]=	0.201937417	;		TCS[6][	388	]=	0.420292648	;		TCS[7][	388	]=	0.55029174	;		TCS[8][	388	]=	0.73000348	;		TCS[9][	388	]=	0.839068848	;		TCS[10][	388	]=	0.755529695	;		TCS[11][	388	]=	0.307244637	;		TCS[12][	388	]=	0.506414411	;		TCS[13][	388	]=	0.749469342	;		TCS[14][	388	]=	0.319140664	;
	TCS[0][	389	]=	749	;		TCS[1][	389	]=	0.466988694	;		TCS[2][	389	]=	0.320264587	;		TCS[3][	389	]=	0.492111091	;		TCS[4][	389	]=	0.176038692	;		TCS[5][	389	]=	0.202498991	;		TCS[6][	389	]=	0.42267253	;		TCS[7][	389	]=	0.55167386	;		TCS[8][	389	]=	0.730001718	;		TCS[9][	389	]=	0.839033915	;		TCS[10][	389	]=	0.755764858	;		TCS[11][	389	]=	0.308713075	;		TCS[12][	389	]=	0.513281117	;		TCS[13][	389	]=	0.749243678	;		TCS[14][	389	]=	0.322097876	;
	TCS[0][	390	]=	750	;		TCS[1][	390	]=	0.467	;		TCS[2][	390	]=	0.32	;		TCS[3][	390	]=	0.493	;		TCS[4][	390	]=	0.177	;		TCS[5][	390	]=	0.203	;		TCS[6][	390	]=	0.425	;		TCS[7][	390	]=	0.553	;		TCS[8][	390	]=	0.73	;		TCS[9][	390	]=	0.839	;		TCS[10][	390	]=	0.756	;		TCS[11][	390	]=	0.31	;		TCS[12][	390	]=	0.52	;		TCS[13][	390	]=	0.749	;		TCS[14][	390	]=	0.325	;
	TCS[0][	391	]=	751	;		TCS[1][	391	]=	0.467006238	;		TCS[2][	391	]=	0.319674245	;		TCS[3][	391	]=	0.49386058	;		TCS[4][	391	]=	0.177885711	;		TCS[5][	391	]=	0.203435703	;		TCS[6][	391	]=	0.427264621	;		TCS[7][	391	]=	0.554258117	;		TCS[8][	391	]=	0.729999041	;		TCS[9][	391	]=	0.838981279	;		TCS[10][	391	]=	0.756221053	;		TCS[11][	391	]=	0.311089733	;		TCS[12][	391	]=	0.526562812	;		TCS[13][	391	]=	0.74874497	;		TCS[14][	391	]=	0.327845134	;
	TCS[0][	392	]=	752	;		TCS[1][	392	]=	0.467007748	;		TCS[2][	392	]=	0.319296699	;		TCS[3][	392	]=	0.494693309	;		TCS[4][	392	]=	0.178707745	;		TCS[5][	392	]=	0.203826664	;		TCS[6][	392	]=	0.429478806	;		TCS[7][	392	]=	0.555464191	;		TCS[8][	392	]=	0.729998796	;		TCS[9][	392	]=	0.838976736	;		TCS[10][	392	]=	0.756428036	;		TCS[11][	392	]=	0.312003788	;		TCS[12][	392	]=	0.532957376	;		TCS[13][	392	]=	0.748496603	;		TCS[14][	392	]=	0.330648365	;
	TCS[0][	393	]=	753	;		TCS[1][	393	]=	0.46700614	;		TCS[2][	393	]=	0.31888203	;		TCS[3][	393	]=	0.495495748	;		TCS[4][	393	]=	0.179486924	;		TCS[5][	393	]=	0.204199773	;		TCS[6][	393	]=	0.431660681	;		TCS[7][	393	]=	0.556641206	;		TCS[8][	393	]=	0.729999031	;		TCS[9][	393	]=	0.838981552	;		TCS[10][	393	]=	0.756624494	;		TCS[11][	393	]=	0.312772976	;		TCS[12][	393	]=	0.539170534	;		TCS[13][	393	]=	0.748275751	;		TCS[14][	393	]=	0.333429029	;
	TCS[0][	394	]=	754	;		TCS[1][	394	]=	0.467003021	;		TCS[2][	394	]=	0.318444908	;		TCS[3][	394	]=	0.496265458	;		TCS[4][	394	]=	0.180244069	;		TCS[5][	394	]=	0.204581921	;		TCS[6][	394	]=	0.43382837	;		TCS[7][	394	]=	0.557812147	;		TCS[8][	394	]=	0.72999951	;		TCS[9][	394	]=	0.838990913	;		TCS[10][	394	]=	0.756813967	;		TCS[11][	394	]=	0.313428109	;		TCS[12][	394	]=	0.545189128	;		TCS[13][	394	]=	0.748103266	;		TCS[14][	394	]=	0.336206462	;
	TCS[0][	395	]=	755	;		TCS[1][	395	]=	0.467	;		TCS[2][	395	]=	0.318	;		TCS[3][	395	]=	0.497	;		TCS[4][	395	]=	0.181	;		TCS[5][	395	]=	0.205	;		TCS[6][	395	]=	0.436	;		TCS[7][	395	]=	0.559	;		TCS[8][	395	]=	0.73	;		TCS[9][	395	]=	0.839	;		TCS[10][	395	]=	0.757	;		TCS[11][	395	]=	0.314	;		TCS[12][	395	]=	0.551	;		TCS[13][	395	]=	0.748	;		TCS[14][	395	]=	0.339	;
	TCS[0][	396	]=	756	;		TCS[1][	396	]=	0.466998343	;		TCS[2][	396	]=	0.317560599	;		TCS[3][	396	]=	0.497696456	;		TCS[4][	396	]=	0.181771617	;		TCS[5][	396	]=	0.205476335	;		TCS[6][	396	]=	0.438189282	;		TCS[7][	396	]=	0.56021977	;		TCS[8][	396	]=	0.730000311	;		TCS[9][	396	]=	0.839005016	;		TCS[10][	396	]=	0.757186114	;		TCS[11][	396	]=	0.314521946	;		TCS[12][	396	]=	0.556594167	;		TCS[13][	396	]=	0.747976791	;		TCS[14][	396	]=	0.34182189	;
	TCS[0][	397	]=	757	;		TCS[1][	397	]=	0.466997953	;		TCS[2][	397	]=	0.317134491	;		TCS[3][	397	]=	0.498349994	;		TCS[4][	397	]=	0.182560134	;		TCS[5][	397	]=	0.206014997	;		TCS[6][	397	]=	0.440392276	;		TCS[7][	397	]=	0.561454546	;		TCS[8][	397	]=	0.730000432	;		TCS[9][	397	]=	0.839006233	;		TCS[10][	397	]=	0.757375751	;		TCS[11][	397	]=	0.315037189	;		TCS[12][	397	]=	0.561979351	;		TCS[13][	397	]=	0.74800442	;		TCS[14][	397	]=	0.344656027	;
	TCS[0][	398	]=	758	;		TCS[1][	398	]=	0.466998392	;		TCS[2][	398	]=	0.316728082	;		TCS[3][	398	]=	0.498955304	;		TCS[4][	398	]=	0.183362842	;		TCS[5][	398	]=	0.206615492	;		TCS[6][	398	]=	0.442600629	;		TCS[7][	398	]=	0.562679437	;		TCS[8][	398	]=	0.730000398	;		TCS[9][	398	]=	0.839004943	;		TCS[10][	398	]=	0.75757233	;		TCS[11][	398	]=	0.31559146	;		TCS[12][	398	]=	0.567167452	;		TCS[13][	398	]=	0.748043654	;		TCS[14][	398	]=	0.347479219	;
	TCS[0][	399	]=	759	;		TCS[1][	399	]=	0.46699922	;		TCS[2][	399	]=	0.316347783	;		TCS[3][	399	]=	0.499507076	;		TCS[4][	399	]=	0.184177033	;		TCS[5][	399	]=	0.207277324	;		TCS[6][	399	]=	0.444805988	;		TCS[7][	399	]=	0.563869552	;		TCS[8][	399	]=	0.730000242	;		TCS[9][	399	]=	0.839002435	;		TCS[10][	399	]=	0.757779273	;		TCS[11][	399	]=	0.316230487	;		TCS[12][	399	]=	0.572170369	;		TCS[13][	399	]=	0.748055258	;		TCS[14][	399	]=	0.350268275	;
	TCS[0][	400	]=	760	;		TCS[1][	400	]=	0.467	;		TCS[2][	400	]=	0.316	;		TCS[3][	400	]=	0.5	;		TCS[4][	400	]=	0.185	;		TCS[5][	400	]=	0.208	;		TCS[6][	400	]=	0.447	;		TCS[7][	400	]=	0.565	;		TCS[8][	400	]=	0.73	;		TCS[9][	400	]=	0.839	;		TCS[10][	400	]=	0.758	;		TCS[11][	400	]=	0.317	;		TCS[12][	400	]=	0.577	;		TCS[13][	400	]=	0.748	;		TCS[14][	400	]=	0.353	;
	TCS[0][	401	]=	761	;		TCS[1][	401	]=	0.46700039	;		TCS[2][	401	]=	0.315691357	;		TCS[3][	401	]=	0.500433598	;		TCS[4][	401	]=	0.18582782	;		TCS[5][	401	]=	0.208778956	;		TCS[6][	401	]=	0.449178252	;		TCS[7][	401	]=	0.566054802	;		TCS[8][	401	]=	0.729999716	;		TCS[9][	401	]=	0.838998657	;		TCS[10][	401	]=	0.75823449	;		TCS[11][	401	]=	0.317934484	;		TCS[12][	401	]=	0.581668521	;		TCS[13][	401	]=	0.747851865	;		TCS[14][	401	]=	0.355659308	;
	TCS[0][	402	]=	762	;		TCS[1][	402	]=	0.467000439	;		TCS[2][	402	]=	0.315429338	;		TCS[3][	402	]=	0.500826717	;		TCS[4][	402	]=	0.186651719	;		TCS[5][	402	]=	0.209593347	;		TCS[6][	402	]=	0.451352092	;		TCS[7][	402	]=	0.567053625	;		TCS[8][	402	]=	0.729999476	;		TCS[9][	402	]=	0.838998331	;		TCS[10][	402	]=	0.75846896	;		TCS[11][	402	]=	0.319023455	;		TCS[12][	402	]=	0.586189219	;		TCS[13][	402	]=	0.747637716	;		TCS[14][	402	]=	0.358263528	;
	TCS[0][	403	]=	763	;		TCS[1][	403	]=	0.467000293	;		TCS[2][	403	]=	0.31522164	;		TCS[3][	403	]=	0.501203037	;		TCS[4][	403	]=	0.187461708	;		TCS[5][	403	]=	0.210418261	;		TCS[6][	403	]=	0.453536805	;		TCS[7][	403	]=	0.568025047	;		TCS[8][	403	]=	0.729999379	;		TCS[9][	403	]=	0.838998678	;		TCS[10][	403	]=	0.758686185	;		TCS[11][	403	]=	0.320245183	;		TCS[12][	403	]=	0.590575656	;		TCS[13][	403	]=	0.747397634	;		TCS[14][	403	]=	0.360838093	;
	TCS[0][	404	]=	764	;		TCS[1][	404	]=	0.467000098	;		TCS[2][	404	]=	0.315075961	;		TCS[3][	404	]=	0.501586239	;		TCS[4][	404	]=	0.188247798	;		TCS[5][	404	]=	0.211228783	;		TCS[6][	404	]=	0.455747679	;		TCS[7][	404	]=	0.568997646	;		TCS[8][	404	]=	0.729999521	;		TCS[9][	404	]=	0.838999349	;		TCS[10][	404	]=	0.75886894	;		TCS[11][	404	]=	0.321577941	;		TCS[12][	404	]=	0.594841395	;		TCS[13][	404	]=	0.747171701	;		TCS[14][	404	]=	0.36340844	;
	TCS[0][	405	]=	765	;		TCS[1][	405	]=	0.467	;		TCS[2][	405	]=	0.315	;		TCS[3][	405	]=	0.502	;		TCS[4][	405	]=	0.189	;		TCS[5][	405	]=	0.212	;		TCS[6][	405	]=	0.458	;		TCS[7][	405	]=	0.57	;		TCS[8][	405	]=	0.73	;		TCS[9][	405	]=	0.839	;		TCS[10][	405	]=	0.759	;		TCS[11][	405	]=	0.323	;		TCS[12][	405	]=	0.599	;		TCS[13][	405	]=	0.747	;		TCS[14][	405	]=	0.366	;
	TCS[0][	406	]=	766	;		TCS[1][	406	]=	0.467000096	;		TCS[2][	406	]=	0.314993971	;		TCS[3][	406	]=	0.502465153	;		TCS[4][	406	]=	0.189709101	;		TCS[5][	406	]=	0.212711842	;		TCS[6][	406	]=	0.460297709	;		TCS[7][	406	]=	0.571049021	;		TCS[8][	406	]=	0.730000827	;		TCS[9][	406	]=	0.839000357	;		TCS[10][	406	]=	0.759067925	;		TCS[11][	406	]=	0.324484117	;		TCS[12][	406	]=	0.603059748	;		TCS[13][	406	]=	0.746911749	;		TCS[14][	406	]=	0.368628879	;
	TCS[0][	407	]=	767	;		TCS[1][	407	]=	0.46700029	;		TCS[2][	407	]=	0.315028157	;		TCS[3][	407	]=	0.502991138	;		TCS[4][	407	]=	0.190368988	;		TCS[5][	407	]=	0.213363614	;		TCS[6][	407	]=	0.462599357	;		TCS[7][	407	]=	0.572114953	;		TCS[8][	407	]=	0.730001664	;		TCS[9][	407	]=	0.839000442	;		TCS[10][	407	]=	0.759084409	;		TCS[11][	407	]=	0.325980992	;		TCS[12][	407	]=	0.607007773	;		TCS[13][	407	]=	0.746892717	;		TCS[14][	407	]=	0.371273863	;
	TCS[0][	408	]=	768	;		TCS[1][	408	]=	0.467000436	;		TCS[2][	408	]=	0.315065358	;		TCS[3][	408	]=	0.503584547	;		TCS[4][	408	]=	0.190974325	;		TCS[5][	408	]=	0.213959465	;		TCS[6][	408	]=	0.464852152	;		TCS[7][	408	]=	0.573156375	;		TCS[8][	408	]=	0.730002088	;		TCS[9][	408	]=	0.839000347	;		TCS[10][	408	]=	0.759066931	;		TCS[11][	408	]=	0.327435807	;		TCS[12][	408	]=	0.610825924	;		TCS[13][	408	]=	0.746917811	;		TCS[14][	408	]=	0.373904407	;
	TCS[0][	409	]=	769	;		TCS[1][	409	]=	0.467000388	;		TCS[2][	409	]=	0.315068372	;		TCS[3][	409	]=	0.50425197	;		TCS[4][	409	]=	0.191519775	;		TCS[5][	409	]=	0.214503544	;		TCS[6][	409	]=	0.467003297	;		TCS[7][	409	]=	0.574131864	;		TCS[8][	409	]=	0.730001675	;		TCS[9][	409	]=	0.839000169	;		TCS[10][	409	]=	0.759032968	;		TCS[11][	409	]=	0.328793749	;		TCS[12][	409	]=	0.61449605	;		TCS[13][	409	]=	0.746961936	;		TCS[14][	409	]=	0.376489967	;
	TCS[0][	410	]=	770	;		TCS[1][	410	]=	0.467	;		TCS[2][	410	]=	0.315	;		TCS[3][	410	]=	0.505	;		TCS[4][	410	]=	0.192	;		TCS[5][	410	]=	0.215	;		TCS[6][	410	]=	0.469	;		TCS[7][	410	]=	0.575	;		TCS[8][	410	]=	0.73	;		TCS[9][	410	]=	0.839	;		TCS[10][	410	]=	0.759	;		TCS[11][	410	]=	0.33	;		TCS[12][	410	]=	0.618	;		TCS[13][	410	]=	0.747	;		TCS[14][	410	]=	0.379	;
	TCS[0][	411	]=	771	;		TCS[1][	411	]=	0.466999224	;		TCS[2][	411	]=	0.314836758	;		TCS[3][	411	]=	0.505833789	;		TCS[4][	411	]=	0.192415776	;		TCS[5][	411	]=	0.215453676	;		TCS[6][	411	]=	0.470806913	;		TCS[7][	411	]=	0.575733115	;		TCS[8][	411	]=	0.729996977	;		TCS[9][	411	]=	0.838999915	;		TCS[10][	411	]=	0.75898181	;		TCS[11][	411	]=	0.331017046	;		TCS[12][	411	]=	0.621324488	;		TCS[13][	411	]=	0.747013139	;		TCS[14][	411	]=	0.381409175	;
	TCS[0][	412	]=	772	;		TCS[1][	412	]=	0.4669984	;		TCS[2][	412	]=	0.314610033	;		TCS[3][	412	]=	0.50675273	;		TCS[4][	412	]=	0.192792327	;		TCS[5][	412	]=	0.215872196	;		TCS[6][	412	]=	0.472458479	;		TCS[7][	412	]=	0.576358563	;		TCS[8][	412	]=	0.729993868	;		TCS[9][	412	]=	0.838999903	;		TCS[10][	412	]=	0.758977404	;		TCS[11][	412	]=	0.331876578	;		TCS[12][	412	]=	0.62447569	;		TCS[13][	412	]=	0.747007416	;		TCS[14][	412	]=	0.383713021	;
	TCS[0][	413	]=	773	;		TCS[1][	413	]=	0.466997964	;		TCS[2][	413	]=	0.314364929	;		TCS[3][	413	]=	0.507754776	;		TCS[4][	413	]=	0.19316099	;		TCS[5][	413	]=	0.216263878	;		TCS[6][	413	]=	0.474006589	;		TCS[7][	413	]=	0.576917454	;		TCS[8][	413	]=	0.72999227	;		TCS[9][	413	]=	0.838999933	;		TCS[10][	413	]=	0.758982092	;		TCS[11][	413	]=	0.332627587	;		TCS[12][	413	]=	0.627464648	;		TCS[13][	413	]=	0.746995123	;		TCS[14][	413	]=	0.385912279	;
	TCS[0][	414	]=	774	;		TCS[1][	414	]=	0.466998352	;		TCS[2][	414	]=	0.31414655	;		TCS[3][	414	]=	0.508837882	;		TCS[4][	414	]=	0.193553102	;		TCS[5][	414	]=	0.21663704	;		TCS[6][	414	]=	0.475503132	;		TCS[7][	414	]=	0.577450897	;		TCS[8][	414	]=	0.729993781	;		TCS[9][	414	]=	0.838999976	;		TCS[10][	414	]=	0.758991187	;		TCS[11][	414	]=	0.333319064	;		TCS[12][	414	]=	0.630302404	;		TCS[13][	414	]=	0.746988554	;		TCS[14][	414	]=	0.388007691	;
	TCS[0][	415	]=	775	;		TCS[1][	415	]=	0.467	;		TCS[2][	415	]=	0.314	;		TCS[3][	415	]=	0.51	;		TCS[4][	415	]=	0.194	;		TCS[5][	415	]=	0.217	;		TCS[6][	415	]=	0.477	;		TCS[7][	415	]=	0.578	;		TCS[8][	415	]=	0.73	;		TCS[9][	415	]=	0.839	;		TCS[10][	415	]=	0.759	;		TCS[11][	415	]=	0.334	;		TCS[12][	415	]=	0.633	;		TCS[13][	415	]=	0.747	;		TCS[14][	415	]=	0.39	;
	TCS[0][	416	]=	776	;		TCS[1][	416	]=	0.467003006	;		TCS[2][	416	]=	0.313954997	;		TCS[3][	416	]=	0.511231691	;		TCS[4][	416	]=	0.194523796	;		TCS[5][	416	]=	0.217361453	;		TCS[6][	416	]=	0.478538639	;		TCS[7][	416	]=	0.578594519	;		TCS[8][	416	]=	0.730011263	;		TCS[9][	416	]=	0.838999984	;		TCS[10][	416	]=	0.759004835	;		TCS[11][	416	]=	0.334711697	;		TCS[12][	416	]=	0.635570301	;		TCS[13][	416	]=	0.747035694	;		TCS[14][	416	]=	0.391894419	;
	TCS[0][	417	]=	777	;		TCS[1][	417	]=	0.467006109	;		TCS[2][	417	]=	0.313979711	;		TCS[3][	417	]=	0.512493942	;		TCS[4][	417	]=	0.195109704	;		TCS[5][	417	]=	0.217731601	;		TCS[6][	417	]=	0.480118726	;		TCS[7][	417	]=	0.579218794	;		TCS[8][	417	]=	0.730022864	;		TCS[9][	417	]=	0.838999948	;		TCS[10][	417	]=	0.759005976	;		TCS[11][	417	]=	0.335464695	;		TCS[12][	417	]=	0.638033467	;		TCS[13][	417	]=	0.747077618	;		TCS[14][	417	]=	0.393714053	;
	TCS[0][	418	]=	778	;		TCS[1][	418	]=	0.467007709	;		TCS[2][	418	]=	0.314026926	;		TCS[3][	418	]=	0.513740348	;		TCS[4][	418	]=	0.195733714	;		TCS[5][	418	]=	0.218121023	;		TCS[6][	418	]=	0.481729493	;		TCS[7][	418	]=	0.579845809	;		TCS[8][	418	]=	0.730028833	;		TCS[9][	418	]=	0.838999919	;		TCS[10][	418	]=	0.7590047	;		TCS[11][	418	]=	0.336261844	;		TCS[12][	418	]=	0.640411483	;		TCS[13][	418	]=	0.747101696	;		TCS[14][	418	]=	0.395486477	;
	TCS[0][	419	]=	779	;		TCS[1][	419	]=	0.467006206	;		TCS[2][	419	]=	0.314049428	;		TCS[3][	419	]=	0.514924502	;		TCS[4][	419	]=	0.196371816	;		TCS[5][	419	]=	0.218540296	;		TCS[6][	419	]=	0.483360174	;		TCS[7][	419	]=	0.580448549	;		TCS[8][	419	]=	0.730023201	;		TCS[9][	419	]=	0.838999927	;		TCS[10][	419	]=	0.759002282	;		TCS[11][	419	]=	0.337105996	;		TCS[12][	419	]=	0.642726332	;		TCS[13][	419	]=	0.74708385	;		TCS[14][	419	]=	0.397239267	;
	TCS[0][	420	]=	780	;		TCS[1][	420	]=	0.467	;		TCS[2][	420	]=	0.314	;		TCS[3][	420	]=	0.516	;		TCS[4][	420	]=	0.197	;		TCS[5][	420	]=	0.219	;		TCS[6][	420	]=	0.485	;		TCS[7][	420	]=	0.581	;		TCS[8][	420	]=	0.73	;		TCS[9][	420	]=	0.839	;		TCS[10][	420	]=	0.759	;		TCS[11][	420	]=	0.338	;		TCS[12][	420	]=	0.645	;		TCS[13][	420	]=	0.747	;		TCS[14][	420	]=	0.399	;
	TCS[0][	421	]=	781	;		TCS[1][	421	]=	0.466988752	;		TCS[2][	421	]=	0.313847256	;		TCS[3][	421	]=	0.516935448	;		TCS[4][	421	]=	0.197601041	;		TCS[5][	421	]=	0.219508511	;		TCS[6][	421	]=	0.48663853	;		TCS[7][	421	]=	0.581480807	;		TCS[8][	421	]=	0.729957969	;		TCS[9][	421	]=	0.839000148	;		TCS[10][	421	]=	0.758998848	;		TCS[11][	421	]=	0.338944167	;		TCS[12][	421	]=	0.64725031	;		TCS[13][	421	]=	0.746836086	;		TCS[14][	421	]=	0.400789147	;
	TCS[0][	422	]=	782	;		TCS[1][	422	]=	0.466977164	;		TCS[2][	422	]=	0.313623125	;		TCS[3][	422	]=	0.517759503	;		TCS[4][	422	]=	0.198184858	;		TCS[5][	422	]=	0.220065399	;		TCS[6][	422	]=	0.488266616	;		TCS[7][	422	]=	0.581902261	;		TCS[8][	422	]=	0.729914676	;		TCS[9][	422	]=	0.839000306	;		TCS[10][	422	]=	0.758998691	;		TCS[11][	422	]=	0.339928643	;		TCS[12][	422	]=	0.649478443	;		TCS[13][	422	]=	0.74661811	;		TCS[14][	422	]=	0.402598767	;
	TCS[0][	423	]=	783	;		TCS[1][	423	]=	0.466971201	;		TCS[2][	423	]=	0.313375366	;		TCS[3][	423	]=	0.518515833	;		TCS[4][	423	]=	0.198768154	;		TCS[5][	423	]=	0.220668032	;		TCS[6][	423	]=	0.489875438	;		TCS[7][	423	]=	0.58228331	;		TCS[8][	423	]=	0.7298924	;		TCS[9][	423	]=	0.83900039	;		TCS[10][	423	]=	0.758999109	;		TCS[11][	423	]=	0.340941036	;		TCS[12][	423	]=	0.651681421	;		TCS[13][	423	]=	0.746382091	;		TCS[14][	423	]=	0.404413813	;
	TCS[0][	424	]=	784	;		TCS[1][	424	]=	0.466976825	;		TCS[2][	424	]=	0.313151738	;		TCS[3][	424	]=	0.519248109	;		TCS[4][	424	]=	0.199367633	;		TCS[5][	424	]=	0.221313776	;		TCS[6][	424	]=	0.491456174	;		TCS[7][	424	]=	0.582642907	;		TCS[8][	424	]=	0.729913415	;		TCS[9][	424	]=	0.839000316	;		TCS[10][	424	]=	0.758999685	;		TCS[11][	424	]=	0.341968953	;		TCS[12][	424	]=	0.653856267	;		TCS[13][	424	]=	0.746164048	;		TCS[14][	424	]=	0.406219239	;
	TCS[0][	425	]=	785	;		TCS[1][	425	]=	0.467	;		TCS[2][	425	]=	0.313	;		TCS[3][	425	]=	0.52	;		TCS[4][	425	]=	0.2	;		TCS[5][	425	]=	0.222	;		TCS[6][	425	]=	0.493	;		TCS[7][	425	]=	0.583	;		TCS[8][	425	]=	0.73	;		TCS[9][	425	]=	0.839	;		TCS[10][	425	]=	0.759	;		TCS[11][	425	]=	0.343	;		TCS[12][	425	]=	0.656	;		TCS[13][	425	]=	0.746	;		TCS[14][	425	]=	0.408	;
	TCS[0][	426	]=	786	;		TCS[1][	426	]=	0.467041987	;		TCS[2][	426	]=	0.312951981	;		TCS[3][	426	]=	0.520802517	;		TCS[4][	426	]=	0.20068004	;		TCS[5][	426	]=	0.222724502	;		TCS[6][	426	]=	0.494499242	;		TCS[7][	426	]=	0.583370251	;		TCS[8][	426	]=	0.730164862	;		TCS[9][	426	]=	0.838999423	;		TCS[10][	426	]=	0.758999771	;		TCS[11][	426	]=	0.344023637	;		TCS[12][	426	]=	0.658108461	;		TCS[13][	426	]=	0.745915962	;		TCS[14][	426	]=	0.409740991	;
	TCS[0][	427	]=	787	;		TCS[1][	427	]=	0.467085234	;		TCS[2][	427	]=	0.312975791	;		TCS[3][	427	]=	0.521636047	;		TCS[4][	427	]=	0.201414865	;		TCS[5][	427	]=	0.223486802	;		TCS[6][	427	]=	0.495950808	;		TCS[7][	427	]=	0.583756163	;		TCS[8][	427	]=	0.730382431	;		TCS[9][	427	]=	0.838998827	;		TCS[10][	427	]=	0.75899926	;		TCS[11][	427	]=	0.345036733	;		TCS[12][	427	]=	0.660172762	;		TCS[13][	427	]=	0.745897941	;		TCS[14][	427	]=	0.411426879	;
	TCS[0][	428	]=	788	;		TCS[1][	428	]=	0.467107488	;		TCS[2][	428	]=	0.313023611	;		TCS[3][	428	]=	0.522468319	;		TCS[4][	428	]=	0.202209671	;		TCS[5][	428	]=	0.224286851	;		TCS[6][	428	]=	0.497352753	;		TCS[7][	428	]=	0.58415695	;		TCS[8][	428	]=	0.730617569	;		TCS[9][	428	]=	0.83899852	;		TCS[10][	428	]=	0.758998863	;		TCS[11][	428	]=	0.34603801	;		TCS[12][	428	]=	0.662182832	;		TCS[13][	428	]=	0.745921938	;		TCS[14][	428	]=	0.413042271	;
	TCS[0][	429	]=	789	;		TCS[1][	429	]=	0.467086494	;		TCS[2][	429	]=	0.31304762	;		TCS[3][	429	]=	0.52326706	;		TCS[4][	429	]=	0.203069651	;		TCS[5][	429	]=	0.2251246	;		TCS[6][	429	]=	0.498703132	;		TCS[7][	429	]=	0.584571824	;		TCS[8][	429	]=	0.730835138	;		TCS[9][	429	]=	0.838998808	;		TCS[10][	429	]=	0.758998978	;		TCS[11][	429	]=	0.347026192	;		TCS[12][	429	]=	0.664128601	;		TCS[13][	429	]=	0.745963957	;		TCS[14][	429	]=	0.414571775	;
	TCS[0][	430	]=	790	;		TCS[1][	430	]=	0.467	;		TCS[2][	430	]=	0.313	;		TCS[3][	430	]=	0.524	;		TCS[4][	430	]=	0.204	;		TCS[5][	430	]=	0.226	;		TCS[6][	430	]=	0.5	;		TCS[7][	430	]=	0.585	;		TCS[8][	430	]=	0.731	;		TCS[9][	430	]=	0.839	;		TCS[10][	430	]=	0.759	;		TCS[11][	430	]=	0.348	;		TCS[12][	430	]=	0.666	;		TCS[13][	430	]=	0.746	;		TCS[14][	430	]=	0.416	;
	TCS[0][	431	]=	791	;		TCS[1][	431	]=	0.466835302	;		TCS[2][	431	]=	0.31284882	;		TCS[3][	431	]=	0.524646482	;		TCS[4][	431	]=	0.2050068	;		TCS[5][	431	]=	0.226913482	;		TCS[6][	431	]=	0.501244503	;		TCS[7][	431	]=	0.585438188	;		TCS[8][	431	]=	0.731086585	;		TCS[9][	431	]=	0.83900216	;		TCS[10][	431	]=	0.759002067	;		TCS[11][	431	]=	0.348961287	;		TCS[12][	431	]=	0.667787846	;		TCS[13][	431	]=	0.746012064	;		TCS[14][	431	]=	0.417318888	;
	TCS[0][	432	]=	792	;		TCS[1][	432	]=	0.4666179	;		TCS[2][	432	]=	0.312625711	;		TCS[3][	432	]=	0.525232307	;		TCS[4][	432	]=	0.206099681	;		TCS[5][	432	]=	0.227867394	;		TCS[6][	432	]=	0.502450152	;		TCS[7][	432	]=	0.585873086	;		TCS[8][	432	]=	0.7311076	;		TCS[9][	432	]=	0.839004385	;		TCS[10][	432	]=	0.759004269	;		TCS[11][	432	]=	0.349924427	;		TCS[12][	432	]=	0.669486511	;		TCS[13][	432	]=	0.746006126	;		TCS[14][	432	]=	0.418549718	;
	TCS[0][	433	]=	793	;		TCS[1][	433	]=	0.466382848	;		TCS[2][	433	]=	0.312378191	;		TCS[3][	433	]=	0.525794892	;		TCS[4][	433	]=	0.207289163	;		TCS[5][	433	]=	0.228864565	;		TCS[6][	433	]=	0.503633549	;		TCS[7][	433	]=	0.58628889	;		TCS[8][	433	]=	0.731085323	;		TCS[9][	433	]=	0.83900553	;		TCS[10][	433	]=	0.759005438	;		TCS[11][	433	]=	0.350906923	;		TCS[12][	433	]=	0.671091252	;		TCS[13][	433	]=	0.745994155	;		TCS[14][	433	]=	0.419721104	;
	TCS[0][	434	]=	794	;		TCS[1][	434	]=	0.466165197	;		TCS[2][	434	]=	0.312153781	;		TCS[3][	434	]=	0.526371651	;		TCS[4][	434	]=	0.208585763	;		TCS[5][	434	]=	0.229907824	;		TCS[6][	434	]=	0.504811298	;		TCS[7][	434	]=	0.586669796	;		TCS[8][	434	]=	0.731042031	;		TCS[9][	434	]=	0.83900445	;		TCS[10][	434	]=	0.759004405	;		TCS[11][	434	]=	0.351926279	;		TCS[12][	434	]=	0.672597329	;		TCS[13][	434	]=	0.745988123	;		TCS[14][	434	]=	0.42086166	;
	TCS[0][	435	]=	795	;		TCS[1][	435	]=	0.466	;		TCS[2][	435	]=	0.312	;		TCS[3][	435	]=	0.527	;		TCS[4][	435	]=	0.21	;		TCS[5][	435	]=	0.231	;		TCS[6][	435	]=	0.506	;		TCS[7][	435	]=	0.587	;		TCS[8][	435	]=	0.731	;		TCS[9][	435	]=	0.839	;		TCS[10][	435	]=	0.759	;		TCS[11][	435	]=	0.353	;		TCS[12][	435	]=	0.674	;		TCS[13][	435	]=	0.746	;		TCS[14][	435	]=	0.422	;
	TCS[0][	436	]=	796	;		TCS[1][	436	]=	0.465912807	;		TCS[2][	436	]=	0.311948738	;		TCS[3][	436	]=	0.527707554	;		TCS[4][	436	]=	0.211532762	;		TCS[5][	436	]=	0.232141572	;		TCS[6][	436	]=	0.507210747	;		TCS[7][	436	]=	0.587268998	;		TCS[8][	436	]=	0.7309768	;		TCS[9][	436	]=	0.838991938	;		TCS[10][	436	]=	0.758991963	;		TCS[11][	436	]=	0.354139215	;		TCS[12][	436	]=	0.675300153	;		TCS[13][	436	]=	0.74603578	;		TCS[14][	436	]=	0.423159458	;
	TCS[0][	437	]=	797	;		TCS[1][	437	]=	0.465891166	;		TCS[2][	437	]=	0.311969365	;		TCS[3][	437	]=	0.528482723	;		TCS[4][	437	]=	0.213146411	;		TCS[5][	437	]=	0.233323624	;		TCS[6][	437	]=	0.508432586	;		TCS[7][	437	]=	0.587487493	;		TCS[8][	437	]=	0.730971169	;		TCS[9][	437	]=	0.838983633	;		TCS[10][	437	]=	0.758983664	;		TCS[11][	437	]=	0.355329561	;		TCS[12][	437	]=	0.676521195	;		TCS[13][	437	]=	0.746077555	;		TCS[14][	437	]=	0.424342251	;
	TCS[0][	438	]=	798	;		TCS[1][	438	]=	0.46591312	;		TCS[2][	438	]=	0.312015624	;		TCS[3][	438	]=	0.529304114	;		TCS[4][	438	]=	0.214793679	;		TCS[5][	438	]=	0.234534889	;		TCS[6][	438	]=	0.509649051	;		TCS[7][	438	]=	0.587671489	;		TCS[8][	438	]=	0.730977138	;		TCS[9][	438	]=	0.83897936	;		TCS[10][	438	]=	0.758979385	;		TCS[11][	438	]=	0.356550298	;		TCS[12][	438	]=	0.677692159	;		TCS[13][	438	]=	0.74610144	;		TCS[14][	438	]=	0.425545314	;
	TCS[0][	439	]=	799	;		TCS[1][	439	]=	0.465956717	;		TCS[2][	439	]=	0.312041255	;		TCS[3][	439	]=	0.530150337	;		TCS[4][	439	]=	0.216427298	;		TCS[5][	439	]=	0.235764103	;		TCS[6][	439	]=	0.510843677	;		TCS[7][	439	]=	0.58783699	;		TCS[8][	439	]=	0.730988738	;		TCS[9][	439	]=	0.838983391	;		TCS[10][	439	]=	0.758983403	;		TCS[11][	439	]=	0.357780691	;		TCS[12][	439	]=	0.678842083	;		TCS[13][	439	]=	0.74608355	;		TCS[14][	439	]=	0.426765585	;
	TCS[0][	440	]=	800	;		TCS[1][	440	]=	0.466	;		TCS[2][	440	]=	0.312	;		TCS[3][	440	]=	0.531	;		TCS[4][	440	]=	0.218	;		TCS[5][	440	]=	0.237	;		TCS[6][	440	]=	0.512	;		TCS[7][	440	]=	0.588	;		TCS[8][	440	]=	0.731	;		TCS[9][	440	]=	0.839	;		TCS[10][	440	]=	0.759	;		TCS[11][	440	]=	0.359	;		TCS[12][	440	]=	0.68	;		TCS[13][	440	]=	0.746	;		TCS[14][	440	]=	0.428	;
	TCS[0][	441	]=	801	;		TCS[1][	441	]=	0.466025469	;		TCS[2][	441	]=	0.311860229	;		TCS[3][	441	]=	0.531835302	;		TCS[4][	441	]=	0.219478154	;		TCS[5][	441	]=	0.23823223	;		TCS[6][	441	]=	0.513104508	;		TCS[7][	441	]=	0.58817382	;		TCS[8][	441	]=	0.731006217	;		TCS[9][	441	]=	0.83903009	;		TCS[10][	441	]=	0.759030083	;		TCS[11][	441	]=	0.360193852	;		TCS[12][	441	]=	0.681187541	;		TCS[13][	441	]=	0.745836814	;		TCS[14][	441	]=	0.429243279	;
	TCS[0][	442	]=	802	;		TCS[1][	442	]=	0.466033438	;		TCS[2][	442	]=	0.311648828	;		TCS[3][	442	]=	0.532652802	;		TCS[4][	442	]=	0.220882677	;		TCS[5][	442	]=	0.239454111	;		TCS[6][	442	]=	0.514155506	;		TCS[7][	442	]=	0.588360941	;		TCS[8][	442	]=	0.731007725	;		TCS[9][	442	]=	0.839061082	;		TCS[10][	442	]=	0.759061074	;		TCS[11][	442	]=	0.361373331	;		TCS[12][	442	]=	0.682396711	;		TCS[13][	442	]=	0.745619653	;		TCS[14][	442	]=	0.430481279	;
	TCS[0][	443	]=	803	;		TCS[1][	443	]=	0.466028671	;		TCS[2][	443	]=	0.311407313	;		TCS[3][	443	]=	0.533452652	;		TCS[4][	443	]=	0.222248123	;		TCS[5][	443	]=	0.240659877	;		TCS[6][	443	]=	0.515154249	;		TCS[7][	443	]=	0.588561153	;		TCS[8][	443	]=	0.731006126	;		TCS[9][	443	]=	0.83907703	;		TCS[10][	443	]=	0.759077023	;		TCS[11][	443	]=	0.362555884	;		TCS[12][	443	]=	0.68361211	;		TCS[13][	443	]=	0.745384084	;		TCS[14][	443	]=	0.431697639	;
	TCS[0][	444	]=	804	;		TCS[1][	444	]=	0.466015937	;		TCS[2][	444	]=	0.311177199	;		TCS[3][	444	]=	0.534235001	;		TCS[4][	444	]=	0.223609046	;		TCS[5][	444	]=	0.241843762	;		TCS[6][	444	]=	0.516101994	;		TCS[7][	444	]=	0.588774243	;		TCS[8][	444	]=	0.731003018	;		TCS[9][	444	]=	0.839061985	;		TCS[10][	444	]=	0.759061982	;		TCS[11][	444	]=	0.363758957	;		TCS[12][	444	]=	0.68481834	;		TCS[13][	444	]=	0.745165677	;		TCS[14][	444	]=	0.432876	;
	TCS[0][	445	]=	805	;		TCS[1][	445	]=	0.466	;		TCS[2][	445	]=	0.311	;		TCS[3][	445	]=	0.535	;		TCS[4][	445	]=	0.225	;		TCS[5][	445	]=	0.243	;		TCS[6][	445	]=	0.517	;		TCS[7][	445	]=	0.589	;		TCS[8][	445	]=	0.731	;		TCS[9][	445	]=	0.839	;		TCS[10][	445	]=	0.759	;		TCS[11][	445	]=	0.365	;		TCS[12][	445	]=	0.686	;		TCS[13][	445	]=	0.745	;		TCS[14][	445	]=	0.434	;
	TCS[0][	446	]=	806	;		TCS[1][	446	]=	0.465985315	;		TCS[2][	446	]=	0.310906346	;		TCS[3][	446	]=	0.53575124	;		TCS[4][	446	]=	0.226450623	;		TCS[5][	446	]=	0.244129507	;		TCS[6][	446	]=	0.517851219	;		TCS[7][	446	]=	0.589235722	;		TCS[8][	446	]=	0.730998334	;		TCS[9][	446	]=	0.838879704	;		TCS[10][	446	]=	0.758879706	;		TCS[11][	446	]=	0.366293375	;		TCS[12][	446	]=	0.687141684	;		TCS[13][	446	]=	0.744912962	;		TCS[14][	446	]=	0.435059424	;
	TCS[0][	447	]=	807	;		TCS[1][	447	]=	0.465975083	;		TCS[2][	447	]=	0.310883322	;		TCS[3][	447	]=	0.536506069	;		TCS[4][	447	]=	0.227970883	;		TCS[5][	447	]=	0.245259931	;		TCS[6][	447	]=	0.518665392	;		TCS[7][	447	]=	0.589468742	;		TCS[8][	447	]=	0.73099793	;		TCS[9][	447	]=	0.838708038	;		TCS[10][	447	]=	0.75870804	;		TCS[11][	447	]=	0.367641115	;		TCS[12][	447	]=	0.688227963	;		TCS[13][	447	]=	0.744891834	;		TCS[14][	447	]=	0.436068632	;
	TCS[0][	448	]=	808	;		TCS[1][	448	]=	0.465972194	;		TCS[2][	448	]=	0.310907124	;		TCS[3][	448	]=	0.53728528	;		TCS[4][	448	]=	0.229565831	;		TCS[5][	448	]=	0.246425601	;		TCS[6][	448	]=	0.519453955	;		TCS[7][	448	]=	0.5896839	;		TCS[8][	448	]=	0.730998358	;		TCS[9][	448	]=	0.83849652	;		TCS[10][	448	]=	0.758496522	;		TCS[11][	448	]=	0.369042167	;		TCS[12][	448	]=	0.689243399	;		TCS[13][	448	]=	0.744914224	;		TCS[14][	448	]=	0.437048128	;
	TCS[0][	449	]=	809	;		TCS[1][	449	]=	0.465979537	;		TCS[2][	449	]=	0.310953951	;		TCS[3][	449	]=	0.53810966	;		TCS[4][	449	]=	0.23124052	;		TCS[5][	449	]=	0.247660848	;		TCS[6][	449	]=	0.520228346	;		TCS[7][	449	]=	0.589866039	;		TCS[8][	449	]=	0.730999191	;		TCS[9][	449	]=	0.838256668	;		TCS[10][	449	]=	0.758256669	;		TCS[11][	449	]=	0.370495479	;		TCS[12][	449	]=	0.690172557	;		TCS[13][	449	]=	0.744957743	;		TCS[14][	449	]=	0.438018416	;
	TCS[0][	450	]=	810	;		TCS[1][	450	]=	0.466	;		TCS[2][	450	]=	0.311	;		TCS[3][	450	]=	0.539	;		TCS[4][	450	]=	0.233	;		TCS[5][	450	]=	0.249	;		TCS[6][	450	]=	0.521	;		TCS[7][	450	]=	0.59	;		TCS[8][	450	]=	0.731	;		TCS[9][	450	]=	0.838	;		TCS[10][	450	]=	0.758	;		TCS[11][	450	]=	0.372	;		TCS[12][	450	]=	0.691	;		TCS[13][	450	]=	0.745	;		TCS[14][	450	]=	0.439	;
	TCS[0][	451	]=	811	;		TCS[1][	451	]=	0.466033271	;		TCS[2][	451	]=	0.311026385	;		TCS[3][	451	]=	0.53996774	;		TCS[4][	451	]=	0.234847355	;		TCS[5][	451	]=	0.250465741	;		TCS[6][	451	]=	0.521778615	;		TCS[7][	451	]=	0.590075292	;		TCS[8][	451	]=	0.731000447	;		TCS[9][	451	]=	0.837739094	;		TCS[10][	451	]=	0.757739093	;		TCS[11][	451	]=	0.373552646	;		TCS[12][	451	]=	0.691717722	;		TCS[13][	451	]=	0.745023336	;		TCS[14][	451	]=	0.440007024	;
	TCS[0][	452	]=	812	;		TCS[1][	452	]=	0.466066228	;		TCS[2][	452	]=	0.311033885	;		TCS[3][	452	]=	0.54098692	;		TCS[4][	452	]=	0.236777792	;		TCS[5][	452	]=	0.252034164	;		TCS[6][	452	]=	0.522566927	;		TCS[7][	452	]=	0.590100093	;		TCS[8][	452	]=	0.731000555	;		TCS[9][	452	]=	0.837490765	;		TCS[10][	452	]=	0.757490765	;		TCS[11][	452	]=	0.375142208	;		TCS[12][	452	]=	0.692347439	;		TCS[13][	452	]=	0.745029013	;		TCS[14][	452	]=	0.441028192	;
	TCS[0][	453	]=	813	;		TCS[1][	453	]=	0.466082551	;		TCS[2][	453	]=	0.311028191	;		TCS[3][	453	]=	0.54202223	;		TCS[4][	453	]=	0.238784553	;		TCS[5][	453	]=	0.253669717	;		TCS[6][	453	]=	0.523365931	;		TCS[7][	453	]=	0.590087247	;		TCS[8][	453	]=	0.731000441	;		TCS[9][	453	]=	0.83727289	;		TCS[10][	453	]=	0.757272889	;		TCS[11][	453	]=	0.376755448	;		TCS[12][	453	]=	0.692918294	;		TCS[13][	453	]=	0.745023021	;		TCS[14][	453	]=	0.442045848	;
	TCS[0][	454	]=	814	;		TCS[1][	454	]=	0.466065915	;		TCS[2][	454	]=	0.311014998	;		TCS[3][	454	]=	0.54303836	;		TCS[4][	454	]=	0.240860875	;		TCS[5][	454	]=	0.255336847	;		TCS[6][	454	]=	0.524176624	;		TCS[7][	454	]=	0.590049601	;		TCS[8][	454	]=	0.731000217	;		TCS[9][	454	]=	0.837103343	;		TCS[10][	454	]=	0.757103343	;		TCS[11][	454	]=	0.378379125	;		TCS[12][	454	]=	0.693459432	;		TCS[13][	454	]=	0.745011353	;		TCS[14][	454	]=	0.443042336	;
	TCS[0][	455	]=	815	;		TCS[1][	455	]=	0.466	;		TCS[2][	455	]=	0.311	;		TCS[3][	455	]=	0.544	;		TCS[4][	455	]=	0.243	;		TCS[5][	455	]=	0.257	;		TCS[6][	455	]=	0.525	;		TCS[7][	455	]=	0.59	;		TCS[8][	455	]=	0.731	;		TCS[9][	455	]=	0.837	;		TCS[10][	455	]=	0.757	;		TCS[11][	455	]=	0.38	;		TCS[12][	455	]=	0.694	;		TCS[13][	455	]=	0.745	;		TCS[14][	455	]=	0.444	;
	TCS[0][	456	]=	816	;		TCS[1][	456	]=	0.465873603	;		TCS[2][	456	]=	0.310988112	;		TCS[3][	456	]=	0.5448818	;		TCS[4][	456	]=	0.245191958	;		TCS[5][	456	]=	0.25863153	;		TCS[6][	456	]=	0.52583432	;		TCS[7][	456	]=	0.58995111	;		TCS[8][	456	]=	0.730999879	;		TCS[9][	456	]=	0.836971921	;		TCS[10][	456	]=	0.756971921	;		TCS[11][	456	]=	0.381608042	;		TCS[12][	456	]=	0.694563426	;		TCS[13][	456	]=	0.744993693	;		TCS[14][	456	]=	0.44490448	;
	TCS[0][	457	]=	817	;		TCS[1][	457	]=	0.465696003	;		TCS[2][	457	]=	0.31098114	;		TCS[3][	457	]=	0.54569825	;		TCS[4][	457	]=	0.247413948	;		TCS[5][	457	]=	0.260235412	;		TCS[6][	457	]=	0.5266669	;		TCS[7][	457	]=	0.589914888	;		TCS[8][	457	]=	0.730999849	;		TCS[9][	457	]=	0.836992901	;		TCS[10][	457	]=	0.756992901	;		TCS[11][	457	]=	0.383206052	;		TCS[12][	457	]=	0.695150283	;		TCS[13][	457	]=	0.744992116	;		TCS[14][	457	]=	0.4457546	;
	TCS[0][	458	]=	818	;		TCS[1][	458	]=	0.465481603	;		TCS[2][	458	]=	0.310980112	;		TCS[3][	458	]=	0.5464738	;		TCS[4][	458	]=	0.249639958	;		TCS[5][	458	]=	0.26182353	;		TCS[6][	458	]=	0.52748232	;		TCS[7][	458	]=	0.58990311	;		TCS[8][	458	]=	0.730999879	;		TCS[9][	458	]=	0.837027921	;		TCS[10][	458	]=	0.757027921	;		TCS[11][	458	]=	0.384800042	;		TCS[12][	458	]=	0.695755426	;		TCS[13][	458	]=	0.744993693	;		TCS[14][	458	]=	0.44655248	;
	TCS[0][	459	]=	819	;		TCS[1][	459	]=	0.465244801	;		TCS[2][	459	]=	0.310986056	;		TCS[3][	459	]=	0.5472329	;		TCS[4][	459	]=	0.251843979	;		TCS[5][	459	]=	0.263407765	;		TCS[6][	459	]=	0.52826516	;		TCS[7][	459	]=	0.589927555	;		TCS[8][	459	]=	0.73099994	;		TCS[9][	459	]=	0.83704196	;		TCS[10][	459	]=	0.75704196	;		TCS[11][	459	]=	0.386396021	;		TCS[12][	459	]=	0.696373713	;		TCS[13][	459	]=	0.744996846	;		TCS[14][	459	]=	0.44730024	;
	TCS[0][	460	]=	820	;		TCS[1][	460	]=	0.465	;		TCS[2][	460	]=	0.311	;		TCS[3][	460	]=	0.548	;		TCS[4][	460	]=	0.254	;		TCS[5][	460	]=	0.265	;		TCS[6][	460	]=	0.529	;		TCS[7][	460	]=	0.59	;		TCS[8][	460	]=	0.731	;		TCS[9][	460	]=	0.837	;		TCS[10][	460	]=	0.757	;		TCS[11][	460	]=	0.388	;		TCS[12][	460	]=	0.697	;		TCS[13][	460	]=	0.745	;		TCS[14][	460	]=	0.448	;
	TCS[0][	461	]=	821	;		TCS[1][	461	]=	0.464760319	;		TCS[2][	461	]=	0.311021166	;		TCS[3][	461	]=	0.54879306	;		TCS[4][	461	]=	0.256088813	;		TCS[5][	461	]=	0.266608141	;		TCS[6][	461	]=	0.529676104	;		TCS[7][	461	]=	0.590128267	;		TCS[8][	461	]=	0.731000036	;		TCS[9][	461	]=	0.836877224	;		TCS[10][	461	]=	0.756877224	;		TCS[11][	461	]=	0.389615187	;		TCS[12][	461	]=	0.697628572	;		TCS[13][	461	]=	0.745001892	;		TCS[14][	461	]=	0.448655056	;
	TCS[0][	462	]=	822	;		TCS[1][	462	]=	0.464533759	;		TCS[2][	462	]=	0.311041555	;		TCS[3][	462	]=	0.54960408	;		TCS[4][	462	]=	0.258118417	;		TCS[5][	462	]=	0.268224188	;		TCS[6][	462	]=	0.530301472	;		TCS[7][	462	]=	0.590304356	;		TCS[8][	462	]=	0.731000048	;		TCS[9][	462	]=	0.836689632	;		TCS[10][	462	]=	0.756689632	;		TCS[11][	462	]=	0.391233583	;		TCS[12][	462	]=	0.698251429	;		TCS[13][	462	]=	0.745002523	;		TCS[14][	462	]=	0.449273408	;
	TCS[0][	463	]=	823	;		TCS[1][	463	]=	0.464327039	;		TCS[2][	463	]=	0.311051361	;		TCS[3][	463	]=	0.55041857	;		TCS[4][	463	]=	0.260103615	;		TCS[5][	463	]=	0.269836165	;		TCS[6][	463	]=	0.530888788	;		TCS[7][	463	]=	0.590516311	;		TCS[8][	463	]=	0.731000042	;		TCS[9][	463	]=	0.836463428	;		TCS[10][	463	]=	0.756463428	;		TCS[11][	463	]=	0.392844385	;		TCS[12][	463	]=	0.698860001	;		TCS[13][	463	]=	0.745002207	;		TCS[14][	463	]=	0.449864232	;
	TCS[0][	464	]=	824	;		TCS[1][	464	]=	0.464146879	;		TCS[2][	464	]=	0.311040778	;		TCS[3][	464	]=	0.55122204	;		TCS[4][	464	]=	0.262059208	;		TCS[5][	464	]=	0.271432094	;		TCS[6][	464	]=	0.531450736	;		TCS[7][	464	]=	0.590752178	;		TCS[8][	464	]=	0.731000024	;		TCS[9][	464	]=	0.836224816	;		TCS[10][	464	]=	0.756224816	;		TCS[11][	464	]=	0.394436792	;		TCS[12][	464	]=	0.699445715	;		TCS[13][	464	]=	0.745001261	;		TCS[14][	464	]=	0.450436704	;
	TCS[0][	465	]=	825	;		TCS[1][	465	]=	0.464	;		TCS[2][	465	]=	0.311	;		TCS[3][	465	]=	0.552	;		TCS[4][	465	]=	0.264	;		TCS[5][	465	]=	0.273	;		TCS[6][	465	]=	0.532	;		TCS[7][	465	]=	0.591	;		TCS[8][	465	]=	0.731	;		TCS[9][	465	]=	0.836	;		TCS[10][	465	]=	0.756	;		TCS[11][	465	]=	0.396	;		TCS[12][	465	]=	0.7	;		TCS[13][	465	]=	0.745	;		TCS[14][	465	]=	0.451	;
	TCS[0][	466	]=	826	;		TCS[1][	466	]=	0.463893121	;		TCS[2][	466	]=	0.310919222	;		TCS[3][	466	]=	0.55273796	;		TCS[4][	466	]=	0.265940792	;		TCS[5][	466	]=	0.274527906	;		TCS[6][	466	]=	0.532549264	;		TCS[7][	466	]=	0.591247822	;		TCS[8][	466	]=	0.730999976	;		TCS[9][	466	]=	0.835815184	;		TCS[10][	466	]=	0.755815184	;		TCS[11][	466	]=	0.397523208	;		TCS[12][	466	]=	0.700514285	;		TCS[13][	466	]=	0.744998739	;		TCS[14][	466	]=	0.451563296	;
	TCS[0][	467	]=	827	;		TCS[1][	467	]=	0.463832961	;		TCS[2][	467	]=	0.310788639	;		TCS[3][	467	]=	0.55342143	;		TCS[4][	467	]=	0.267896385	;		TCS[5][	467	]=	0.276003835	;		TCS[6][	467	]=	0.533111212	;		TCS[7][	467	]=	0.591483689	;		TCS[8][	467	]=	0.730999958	;		TCS[9][	467	]=	0.835696572	;		TCS[10][	467	]=	0.755696572	;		TCS[11][	467	]=	0.398995615	;		TCS[12][	467	]=	0.700979999	;		TCS[13][	467	]=	0.744997793	;		TCS[14][	467	]=	0.452135768	;
	TCS[0][	468	]=	828	;		TCS[1][	468	]=	0.463826241	;		TCS[2][	468	]=	0.310598445	;		TCS[3][	468	]=	0.55403592	;		TCS[4][	468	]=	0.269881583	;		TCS[5][	468	]=	0.277415812	;		TCS[6][	468	]=	0.533698528	;		TCS[7][	468	]=	0.591695644	;		TCS[8][	468	]=	0.730999952	;		TCS[9][	468	]=	0.835670368	;		TCS[10][	468	]=	0.755670368	;		TCS[11][	468	]=	0.400406417	;		TCS[12][	468	]=	0.701388571	;		TCS[13][	468	]=	0.744997477	;		TCS[14][	468	]=	0.452726592	;
	TCS[0][	469	]=	829	;		TCS[1][	469	]=	0.463879681	;		TCS[2][	469	]=	0.310338834	;		TCS[3][	469	]=	0.55456694	;		TCS[4][	469	]=	0.271911187	;		TCS[5][	469	]=	0.278751859	;		TCS[6][	469	]=	0.534323896	;		TCS[7][	469	]=	0.591871733	;		TCS[8][	469	]=	0.730999964	;		TCS[9][	469	]=	0.835762776	;		TCS[10][	469	]=	0.755762776	;		TCS[11][	469	]=	0.401744813	;		TCS[12][	469	]=	0.701731428	;		TCS[13][	469	]=	0.744998108	;		TCS[14][	469	]=	0.453344944	;
	TCS[0][	470	]=	830	;		TCS[1][	470	]=	0.464	;		TCS[2][	470	]=	0.31	;		TCS[3][	470	]=	0.555	;		TCS[4][	470	]=	0.274	;		TCS[5][	470	]=	0.28	;		TCS[6][	470	]=	0.535	;		TCS[7][	470	]=	0.592	;		TCS[8][	470	]=	0.731	;		TCS[9][	470	]=	0.836	;		TCS[10][	470	]=	0.756	;		TCS[11][	470	]=	0.403	;		TCS[12][	470	]=	0.702	;		TCS[13][	470	]=	0.745	;		TCS[14][	470	]=	0.454	;
///////////////////
	
		int ind1,ind2;
		double tmp1;
//do nothing in case of incrementing wavelength; revert in case of decrementing
		if(WlgthSpectra[0]>WlgthSpectra[1])
		{
			
			for (ind1=0;ind1<=(int)(ArLength1/2);ind1++)
			{
				tmp1=WlgthSpectra[ArLength1-ind1];
				WlgthSpectra[ArLength1-ind1]=WlgthSpectra[ind1];
				WlgthSpectra[ind1]=tmp1;

				tmp1=SourceSpectr[ArLength1-ind1];
				SourceSpectr[ArLength1-ind1]=SourceSpectr[ind1];
				SourceSpectr[ind1]=tmp1;
			}
		}
///////////		
		double dwave = wavelength[1]-wavelength[0]; // wavelength increment = 1 nm		
		int param1=(int)(dwave*2.0/(WlgthSpectra[1]-WlgthSpectra[0]));
		tmp1=0;
		for(ind1=0;ind1<=param1;ind1++)
		{
			for(ind2=0;ind2<=ind1+param1;ind2++) tmp1+=SourceSpectr[ind2];
			tmp1/=ind1+param1+1;
			SourceSpectr[ind1]=tmp1;
			tmp1=0;
		}
		for(ind1=param1;ind1<=ArLength1-param1;ind1++)
		{
			for(ind2=-param1;ind2<=param1;ind2++)	tmp1+=SourceSpectr[ind1+ind2];
			tmp1/=2*param1+1;
			SourceSpectr[ind1]=tmp1;
			tmp1=0;
		}
		for(ind1=ArLength1-param1;ind1<=ArLength1;ind1++)
		{
			for(ind2=ind1-param1;ind2<=ArLength1;ind2++)	tmp1+=SourceSpectr[ind2];
			tmp1/=ArLength1-ind1+param1+1;
			SourceSpectr[ind1]=tmp1;
			tmp1=0;
		}
///////////	
	
		double SpectraShapeToXYZdimention[471];
//		ReshapeSpectraToXYZ(SpectraShapeToXYZdimention,WlgthSpectra, ArLength1, SourceSpectra,wavelength, 470);		//reshape spectra to X-axis of XYZ curves; just picking closest spectral points (no appriximation, interpolation)
																									//SpectraShapeToXYZdimention - returned spectra
																									//WlgthSpectra - x-scale of spectra
																									//ArLength1 - length of spectra array
																									//SourceSpectra - spectra itself
																									//wavelength - x-scale of XYZ curves
																									//470 - length (0..470) of XYZ array
//void CCRIcalcView::ReshapeSpectraToXYZ(double *BackSpectra, double *Wavelength, int SpectraLength, double *Spectra, double *XYZwavelength, int XYZLength)

		bool flag1=false;
		int index1=0;
		double diff1;
		for(ind1=0;ind1<=470;ind1++)
		{
			if(index1>50)	index1-=50;
			flag1=false;
			diff1=100000;
			while(flag1==false)
			{
				if(fabs(WlgthSpectra[index1]-wavelength[ind1])<=diff1)
				{
					diff1=fabs(WlgthSpectra[index1]-wavelength[ind1]);
					index1++;
				}
				else
				{
					flag1=true;
					SpectraShapeToXYZdimention[ind1]=SourceSpectr[index1-1];
				}
			}
		}

		for(ind1=0;ind1<=470;ind1++)	SpectraShapeToXYZdimention[ind1]-=SpectraShapeToXYZdimention[0];
/////////////////////////			
		X=0;
		for(ind1=0;ind1<=470;ind1++) X+=SpectraShapeToXYZdimention[ind1]*xbar[ind1];
		Y=0;
		for(ind1=0;ind1<=470;ind1++) Y+=SpectraShapeToXYZdimention[ind1]*ybar[ind1];
		Z=0;
		for(ind1=0;ind1<=470;ind1++) Z+=SpectraShapeToXYZdimention[ind1]*zbar[ind1];

		Yknormal=100/Y;
		double sum1=X+Y+Z;
		X=X/sum1;
		Y=Y/sum1;
		Z=Z/sum1;
		uk = 4*X/(-2*X+12*Y+3);
		vk = 6*Y/(-2*X+12*Y+3);

		ResultsData[0]=X;
		ResultsData[1]=Y;
		ResultsData[2]=Z;
		ResultsData[3]=uk;
		ResultsData[4]=vk;

//Calculate Temperature
		double d2,	d1=((vk-isoTempLinesTable[0][2])-isoTempLinesTable[0][3]*(uk-isoTempLinesTable[0][1]))/sqrt(1+isoTempLinesTable[0][3]*isoTempLinesTable[0][3]);
		for(ind1=0;ind1<=600;ind1++)
		{
			d2=((vk-isoTempLinesTable[ind1][2])-isoTempLinesTable[ind1][3]*(uk-isoTempLinesTable[ind1][1]))/sqrt(1+isoTempLinesTable[ind1][3]*isoTempLinesTable[ind1][3]);
			if(d1/d2<0)
			{
				index1=ind1;
				ind1=601;
			}
			else d1=d2;
		}
		if(index1==0) Tc=-1;
		else
		{		
			Tc=1/(1/isoTempLinesTable[index1-1][0]+d1/(d1-d2)*(1/isoTempLinesTable[index1][0]-1/isoTempLinesTable[index1-1][0]));	
			ur=1/(1/isoTempLinesTable[index1-1][1]+d1/(d1-d2)*(1/isoTempLinesTable[index1][1]-1/isoTempLinesTable[index1-1][1]));	//u of Planckian curve of Tc temperature
			vr=1/(1/isoTempLinesTable[index1-1][2]+d1/(d1-d2)*(1/isoTempLinesTable[index1][2]-1/isoTempLinesTable[index1-1][2])); 	//v of Planckian curve of Tc temperature
			DC=sqrt((ur-uk)*(ur-uk)+(vr-vk)*(vr-vk));//chromaticity distance (DC) of the test source to the Planckian locus	
		}
		ResultsData[5]=Tc;
		ResultsData[6]=DC;
////////////////

		double spdref[471];
		for(ind1=0;ind1<=470;ind1++)		spdref[ind1] = 1000/(wavelength[ind1]/1000*wavelength[ind1]/1000*wavelength[ind1]/1000*wavelength[ind1]/1000*wavelength[ind1]/1000) / (exp(14404000/wavelength[ind1]/Tc) - 1);

		X=0;
		for(ind1=0;ind1<=470;ind1++) X+=spdref[ind1]*xbar[ind1];
		Y=0;
		for(ind1=0;ind1<=470;ind1++) Y+=spdref[ind1]*ybar[ind1];
		Z=0;
		for(ind1=0;ind1<=470;ind1++) Z+=spdref[ind1]*zbar[ind1];

		Yrnormal=100/Y;
		sum1=X+Y+Z;
		X=X/sum1;
		Y=Y/sum1;
		Z=Z/sum1;
		ur = 4*X/(-2*X+12*Y+3);
		vr = 6*Y/(-2*X+12*Y+3);

		double Xtmp,Ytmp,Ztmp,Yri[15],Yki[15];
	
		for(ind1=1;ind1<=14;ind1++)
		{
			Xtmp=0;
			Ytmp=0;
			Ztmp=0;
			for(ind2=1;ind2<=470;ind2++)
			{
				Xtmp+=TCS[ind1][ind2]*SpectraShapeToXYZdimention[ind2]*xbar[ind2];
				Ytmp+=TCS[ind1][ind2]*SpectraShapeToXYZdimention[ind2]*ybar[ind2];
				Ztmp+=TCS[ind1][ind2]*SpectraShapeToXYZdimention[ind2]*zbar[ind2];
			}
			Yki[ind1] = Ytmp*Yknormal;			
			sum1=Xtmp+Ytmp+Ztmp;
			Xtmp=Xtmp/sum1;
			Ytmp=Ytmp/sum1;
			Ztmp=Ztmp/sum1;
			uki[ind1] = 4*Xtmp/(-2*Xtmp+12*Ytmp+3);//from 1 to 14
			vki[ind1] = 6*Ytmp/(-2*Xtmp+12*Ytmp+3);//from 1 to 14
			
			Xtmp=0;
			Ytmp=0;
			Ztmp=0;
			for(ind2=1;ind2<=470;ind2++)
			{
				Xtmp+=TCS[ind1][ind2]*spdref[ind2]*xbar[ind2];
				Ytmp+=TCS[ind1][ind2]*spdref[ind2]*ybar[ind2];
				Ztmp+=TCS[ind1][ind2]*spdref[ind2]*zbar[ind2];
			}
			Yri[ind1] = Ytmp*Yrnormal;			
			sum1=Xtmp+Ytmp+Ztmp;
			Xtmp=Xtmp/sum1;
			Ytmp=Ytmp/sum1;
			Ztmp=Ztmp/sum1;
			uri[ind1] = 4*Xtmp/(-2*Xtmp+12*Ytmp+3);//from 1 to 14
			vri[ind1] = 6*Ytmp/(-2*Xtmp+12*Ytmp+3);//from 1 to 14
		}

		// Apply adaptive (perceived) color shift.
		double ck = (4 - uk - 10*vk) / vk;
		double dk = (1.708*vk + 0.404 - 1.481*uk) / vk;
		double cr = (4 - ur - 10*vr) / vr;
		double dr = (1.708*vr + 0.404 - 1.481*ur) / vr;

		double cki;
		double dki;
		double ukip[15];
		double vkip[15];
		for(ind1=1;ind1<=14;ind1++)
		{
			cki = (4 - uki[ind1] - 10*vki[ind1]) / vki[ind1];
			dki = (1.708*vki[ind1] + 0.404 - 1.481*uki[ind1]) / vki[ind1];
			ukip[ind1] = (10.872 + 0.404*cr/ck*cki - 4*dr/dk*dki) / (16.518 + 1.481*cr/ck*cki - dr/dk*dki);
			vkip[ind1] = 5.520 / (16.518 + 1.481*cr/ck*cki - dr/dk*dki);
		}

		double Wstarr[15], Ustarr[15],Vstarr[15],Wstark[15],Ustark[15],Vstark[15];
		for(ind1=1;ind1<=14;ind1++)
		{
			Wstarr[ind1] = 25*pow(Yri[ind1],0.33333) - 17;
			Ustarr[ind1] = 13*Wstarr[ind1]*(uri[ind1] - ur);
			Vstarr[ind1] = 13*Wstarr[ind1]*(vri[ind1] - vr);
			
			Wstark[ind1] = 25*pow(Yki[ind1],0.33333) - 17;
			Ustark[ind1] = 13*Wstark[ind1]*(ukip[ind1] - ur); // after applying the adaptive color shift, u'k = ur
			Vstark[ind1] = 13*Wstark[ind1]*(vkip[ind1] - vr); // after applying the adaptive color shift, v'k = vr
		}
		ResultsData[35]=0;
		ResultsData[36]=0;
		for(ind1=1;ind1<=14;ind1++)
		{
			deltaE[ind1] = sqrt((Ustarr[ind1] - Ustark[ind1])*(Ustarr[ind1] - Ustark[ind1]) + (Vstarr[ind1] - Vstark[ind1])*(Vstarr[ind1] - Vstark[ind1]) + (Wstarr[ind1] - Wstark[ind1])*(Wstarr[ind1] - Wstark[ind1]));
			R[ind1] = 100 - 4.6*deltaE[ind1];
			ResultsData[6+ind1]=deltaE[ind1];
			ResultsData[20+ind1]=R[ind1];
		}
		for(ind1=1;ind1<=8;ind1++)	ResultsData[35]+=R[ind1];
		ResultsData[35]/=8;
		for(ind1=1;ind1<=14;ind1++)	ResultsData[36]+=R[ind1];
		ResultsData[36]/=14;
/*
	ResultsData[0]=X;
	ResultsData[1]=Y;
	ResultsData[2]=Z;
	ResultsData[3]=uk;
	ResultsData[4]=vk;
	ResultsData[5]=Tc;
	ResultsData[6]=DC;
	ResultsData[7]=deltaE[1];
	......
	ResultsData[20]=deltaE[14];
	ResultsData[21]=R[1];
	......
	ResultsData[34]=R[14];
	ResultsData[35]=meaqn of (R1..R14)
*/
}


void CCheckTrView::SaveServece(unsigned char *ArryaToWrite, int LenghtOfArrayToWrite) //service saving
{

	CWinApp* pApp=AfxGetApp();
	CString Out;
	char temp1;
	CFile* lpOutFile;
	int j,tmp1;

	VERIFY(pApp->m_pDocManager!=NULL);
		try
		{
			lpOutFile=new CFile("service_file.txt",CFile::modeCreate|CFile::modeReadWrite|CFile::shareDenyNone);
		}
		catch(...)
		{
			MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
		}
	
		lpOutFile->SeekToBegin();

		for(j=0;j<=LenghtOfArrayToWrite;j++)
		{
			Out.Format("%d", ArryaToWrite[j]);	
			tmp1=Out.GetLength();
			lpOutFile->Write(Out,tmp1);
			Out.Empty();

			temp1='\r';
			lpOutFile->Write(&temp1,sizeof(char));
			temp1='\n';
			lpOutFile->Write(&temp1,sizeof(char));
		}

		if(lpOutFile) lpOutFile->Close();
		delete lpOutFile;
}

void CCheckTrView::OnSaveCalibrationToFlash() 
{
	if(StartEx==false && Run_get_spec==true)//no run getting spectra
	{
		if(AllClbrToFLASH==false)	MessageBox("Stop Acquisition","Request",MB_OK|MB_SYSTEMMODAL);
		else						MessageBox("Writing to FLASH in process, Wait!!!","Request",MB_OK|MB_SYSTEMMODAL);
	}
	else
	{
		if(::MessageBox(0,"Wait! FLASH updated will take about 1 minute. Click OK to continue.","Information",MB_OKCANCEL)==IDOK)
		{
			int stateB;
			CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
			CButton *pXYSpace = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_XYSPACE));
			stateB=pXYSpace->GetCheck();
			
			AllClbrToFLASH=true;
			SendMessage(10);//write all calibration information (norm and color)
			while(AllClbrToFLASH==true) Sleep(1000);
	//		CalibrationCoeffToMemory();
	//		Sleep(1000);
			::MessageBox(0,"FLASH was updated","Information",MB_OK|MB_SYSTEMMODAL);
		}
	}
}

void CCheckTrView::OnFileSaveBmp() 
{
	OnSavescreen();
}


void CCheckTrView::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent==ID_CLOCK_TIMER)	AutoSaveSpec();
	if(nIDEvent==ID_CLOCK_TIMER+1)
	{
		//100ms interval
		ExpTimerCount++;
		if(ExpN*NScans>100)	
		{
			double countstmp=100*ExpTimerCount/(ExpN*NScans*0.01);
			CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
			CProgressCtrl *pProgressBar1= reinterpret_cast<CProgressCtrl *>(cFrame->m_wndChartBar.GetDlgItem(IDC_PROGRESS1));
			pProgressBar1->SetPos((int)(100*countstmp));
		}
	}
	CView::OnTimer(nIDEvent);
}

void CCheckTrView::AutoSaveSpec()
{
//		pThread->SuspendThread();
		CWinApp* pApp=AfxGetApp();
		CString Out;
		CString File_Name;
		char Cur_Dir[_MAX_DIR];
		VERIFY(pApp->m_pDocManager!=NULL);
		if(AutoNmb==0)
		{
			if(pApp->m_pDocManager->DoPromptFileName(File_Name,AFX_IDS_SAVEFILE,OFN_HIDEREADONLY|OFN_PATHMUSTEXIST,FALSE,NULL))
			{
				GetCurrentDirectory(_MAX_DIR,Cur_Dir);
				VERIFY(WriteProfileString("CONTROL","DIR",Cur_Dir));
				try
				{
					int tmpTXT=File_Name.Find(".txt",0);
					AutoDir=File_Name;
				}
				catch(...)
				{
					MessageBox("ERROR DURING CREATION THE OUT FILE","ERROR",MB_OK|MB_SYSTEMMODAL);
				}
				AutoNmb++;
			}
			else
			{
				AutoSave=false;
				KillTimer(ID_CLOCK_TIMER);
				AutoNmb=0;
			}
		}
		else
		{
			if(Run_get_spec==true)//getting spectra
			{
				if(AutoSave1==true)//Save spectra, txt
				{
					Out.Format("_S1_%d_.txt",AutoNmb);
					File_Name=AutoDir;
					File_Name.Insert(AutoDir.GetLength(),Out);
					SaveSpec1(File_Name);
				}
				if(AutoSave2==true)//Save screen, bmp
				{
					Out.Format("_S2_%d_.bmp",AutoNmb);
					File_Name=AutoDir;
					File_Name.Insert(AutoDir.GetLength(),Out);
					SaveSpec2(File_Name);
				}
				if(AutoSave3==true)//Save, 1nm step
				{
					Out.Format("_S3_%d_.txt",AutoNmb);
					File_Name=AutoDir;
					File_Name.Insert(AutoDir.GetLength(),Out);
					SaveSpec3(File_Name);
				}
				if(AutoSave4==true)//Save, 380-760nm normalized to sensitivity
				{
					Out.Format("_S4_%d_.txt",AutoNmb);
					File_Name=AutoDir;
					File_Name.Insert(AutoDir.GetLength(),Out);
					SaveSpec4(File_Name);
				}
				AutoNmb++;
			}
		}
//		pThread->ResumeThread();
}

void CCheckTrView::GaussT(int Length)
{
 	double A;
	double X0;
	double dX;
	double B;
	double LengthRaw;
	double minY1;
	int k,m;
	double DataRaw[10000];
	double SpecRaw[10000];
	double ErrorFactor=0.001;
	double CurrentErrorFuctor=1;
	double Iter=1;
	double deltadX=1;//initial guess for dX step
	double deltaB;
	double deltaA;
	double Res1=0;
	double Res2=1;
	double Appr1;
	double Appr2;
	double Appr3;
	double tmpD5;
	int smothfactor=21;//should be odd
	double tmpD=0;
	int maxInd=1;
	double deltaX0=(Spec[maxInd+1]-Spec[maxInd])/Iter;
	A=A_V;
	X0=X0_V;
	dX=dX_V;
	B=B_V;
	LengthRaw=Length;
	minY1=Data[0];

	for(k=0;k<Length;k++)
	{
		if(minY1>Data[k])	minY1=Data[k];
		DataRaw[k]=Data[k];
		SpecRaw[k]=Spec[k];
	}

	for(k=0;k<Length;k++)
		Data[k]=Data[k]-minY1;


//fisrs guess (smoothing)
	for(k=0;k<smothfactor;k++)
		tmpD=tmpD+DataRaw[k];

	for(k=(smothfactor-1)/2;k<Length-(smothfactor-1)/2;k++)
    {
		Data[k]=tmpD/smothfactor;
		tmpD=tmpD-DataRaw[k-(smothfactor-1)/2+1];
		tmpD=tmpD+DataRaw[k+(smothfactor-1)/2];
	}

	//Y=A*exp(-(x-X0)^2/dX^2)+B
	A=DataRaw[0];
	B=(Data[(smothfactor-1)/2]+Data[Length-(smothfactor-1)/2])/2;//average of the edges
	X0=0; 
	dX=smothfactor;
	//find maximum to make it A as a first guess
	for(k=(smothfactor-1)/2;k<Length-(smothfactor-1)/2;k++)
	{
		if(Data[k]>A)
		{
			A=Data[k];
	        maxInd=k;
		}
	}

	X0=Spec[maxInd];
	A=abs(A-B);
	for(k=0;k<Length;k++)		Data[k]=DataRaw[k];

	//main fitting procedure
	B=B+minY1;
	for(k=0;k<LengthRaw;k++)	   GaussData[k]=A*exp(-(SpecRaw[k]-X0)*(SpecRaw[k]-X0)/((dX/4)*(dX/4)))+B;
	
	deltaB=A/100;
	deltaA=A/100;

	while((CurrentErrorFuctor>=ErrorFactor)&&(Iter<=100)||(Iter<=4))
	{
	   //position (X0)
		Appr1=0;
		Appr2=0;
		Appr3=0;
		for(k=0;k<Length;k++)
		{
			tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0-deltaX0))*(Spec[k]-(X0-deltaX0))/((dX/4)*(dX/4)))+B);
			Appr1=Appr1+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr2=Appr2+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0+deltaX0))*(Spec[k]-(X0+deltaX0))/((dX/4)*(dX/4)))+B);
			Appr3=Appr3+tmpD5*tmpD5;
		}
		while((Appr2<Appr1)&&(Appr2<Appr3))//both deviations from X0 bigger than current Appr2
		{
			deltaX0=deltaX0/2;
			Appr1=0;
			Appr3=0;
			for(k=0;k<Length;k++)
			{
				tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0-deltaX0))*(Spec[k]-(X0-deltaX0))/((dX/4)*(dX/4)))+B);
				Appr1=Appr1+tmpD5*tmpD5;
				tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0+deltaX0))*(Spec[k]-(X0+deltaX0))/((dX/4)*(dX/4)))+B);
				Appr3=Appr3+tmpD5*tmpD5;
			}
		}
		if(Appr1<Appr3)//move towards X0-deltaX0
		{
			while(Appr1<Appr2)
			{
				deltaX0=deltaX0*2;
				if(X0-deltaX0>0)
				{
					Appr1=0;
					for(k=0;k<Length;k++)
					{
						tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0-deltaX0))*(Spec[k]-(X0-deltaX0))/((dX/4)*(dX/4)))+B);
						Appr1=Appr1+tmpD5*tmpD5;
					}
					deltaX0=deltaX0/2;
					Appr1=1;//exit from the loop
					Appr2=0;
				}
			}
			deltaX0=deltaX0/2;
			X0=X0-deltaX0;
		}
		else//move towards X0+deltaX0
		{
			while(Appr3<Appr2)
			{
				deltaX0=deltaX0*2;
				if(X0+deltaX0<Spec[Length])
				{
					Appr3=0;
					for(k=0;k<Length;k++)
					{
						tmpD5=Data[k]-(A*exp(-(Spec[k]-(X0+deltaX0))*(Spec[k]-(X0+deltaX0))/((dX/4)*(dX/4)))+B);
						Appr3=Appr3+tmpD5*tmpD5;
					}
				}
				else
				{
					deltaX0=deltaX0/2;
					Appr3=1;//exit from the loop
					Appr2=0;
				}
			}
			deltaX0=deltaX0/2;
			X0=X0+deltaX0;
		}

		//width (dX)
		Appr1=0;
		Appr2=0;
		Appr3=0;
		while(dX-deltadX<0)	deltadX=deltadX/2;
		for(k=0;k<Length;k++)
		{
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX-deltadX)/4)*((dX-deltadX)/4)))+B);
			Appr1=Appr1+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr2=Appr2+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX+deltadX)/4)*((dX+deltadX)/4)))+B);
			Appr3=Appr3+tmpD5*tmpD5;
		}
		while((Appr2<Appr1)&&(Appr2<Appr3))//both deviations from dX bigger than current Appr2
		{
			deltadX=deltadX/2;
			Appr1=0;
			Appr3=0;
			for(k=0;k<Length;k++)
			{
				tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX-deltadX)/4)*((dX-deltadX)/4)))+B);
				Appr1=Appr1+tmpD5*tmpD5;
				tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX+deltadX)/4)*((dX+deltadX)/4)))+B);
				Appr3=Appr3+tmpD5*tmpD5;
			}
		}
		if(Appr1<Appr3)//move towards dX-deltadX
		{
			while(Appr1<Appr2)
			{
				deltadX=deltadX*2;
				if(dX-deltadX>0)
				{
					Appr1=0;
					for(k=0;k<Length;k++)
					{
						tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX-deltadX)/4)*((dX-deltadX)/4)))+B);
						Appr1=Appr1+tmpD5*tmpD5;
					}
				}
				else
				{
					deltadX=deltadX/2;
					Appr1=1;//exit from the loop
					Appr2=0;
				}
			}
			deltadX=deltadX/2;
			dX=dX-deltadX;
		}
		else//move towards dX+deltadX
		{
			while((Appr3<Appr2)&&(deltadX<abs(Spec[1]-Spec[Length])))
			{
				deltadX=deltadX*2;
				Appr3=0;
				for(k=0;k<Length;k++)
				{
					tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/(((dX+deltadX)/4)*((dX+deltadX)/4)))+B);
					Appr3=Appr3+tmpD5*tmpD5;
				}
			}
			deltadX=deltadX/2;
			dX=dX+deltadX;
		}
		//Amplitude (A)
		Appr1=0;
		Appr2=0;
		Appr3=0;

		while(A-deltaA<0)	deltaA=deltaA/2;
		for(k=0;k<Length;k++)
		{
			tmpD5=Data[k]-((A-deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr1=Appr1+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr2=Appr2+tmpD5*tmpD5;
			tmpD5=Data[k]-((A+deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr3=Appr3+tmpD5*tmpD5;
		}
		while((Appr2<Appr1)&&(Appr2<Appr3))//both deviations from A bigger than current Appr2
		{
			deltaA=deltaA/2;
			Appr1=0;
			Appr3=0;
			for(k=0;k<Length;k++)
			{
				tmpD5=Data[k]-((A-deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
				Appr1=Appr1+tmpD5*tmpD5;
				tmpD5=Data[k]-((A+deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
				Appr3=Appr3+tmpD5*tmpD5;
			}
		}
		if(Appr1<Appr3)//move towards A-deltaA
		{
			while(Appr1<Appr2)
			{
				deltaA=deltaA*2;
				if(A-deltaA>0)
				{
					Appr1=0;
					for(k=0;k<Length;k++)
					{
						tmpD5=Data[k]-((A-deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
						Appr1=Appr1+tmpD5*tmpD5;
					}
				}
				else
				{
					deltaA=deltaA/2;
					Appr1=1;// exit from the loop
					Appr2=0;
				}
			}
			deltaA=deltaA/2;
			A=A-deltaA;
		}
		else//move towards A+deltaA
		{
			while(Appr3<Appr2)
			{
				deltaA=deltaA*2;
				Appr3=0;
				for(k=0;k<Length;k++)
				{
					tmpD5=Data[k]-((A+deltaA)*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
					Appr3=Appr3+tmpD5*tmpD5;
				}
			}
			deltaA=deltaA/2;
			A=A+deltaA;
		}
		//Baseline (B)
		Appr1=0;
		Appr2=0;
		Appr3=0;
		for(k=0;k<Length;k++)
		{
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B-deltaB);
			Appr1=Appr1+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B);
			Appr2=Appr2+tmpD5*tmpD5;
			tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B+deltaB);
			Appr3=Appr3+tmpD5*tmpD5;
		}
		while((Appr2<Appr1)&&(Appr2<Appr3))//both deviations from dX bigger than current Appr2
		{
			deltaB=deltaB/2;
			Appr1=0;
			Appr3=0;
			for(k=0;k<Length;k++)
			{
				tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B-deltaB);
				Appr1=Appr1+tmpD5*tmpD5;
				tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B+deltaB);
				Appr3=Appr3+tmpD5*tmpD5;
			}
		}
		if(Appr1<Appr3)//move towards dX-deltadX
		{
			while(Appr1<Appr2)
			{
				deltaB=deltaB*2;
				Appr1=0;
				for(k=0;k<Length;k++)
				{
					tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B-deltaB);
					Appr1=Appr1+tmpD5*tmpD5;
				}
			}
			deltaB=deltaB/2;
			B=B-deltaB;
		}
		else//move towards dX+deltadX
		{
			while(Appr3<Appr2)
			{
				deltaB=deltaB*2;
				Appr3=0;
				for(k=0;k<Length;k++)
				{
					tmpD5=Data[k]-(A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B+deltaB);
					Appr3=Appr3+tmpD5*tmpD5;
				}
			}
			deltaB=deltaB/2;
			B=B+deltaB;
		}
		Res1=Res2;
		Res2=0;
		for(k=0;k<=Length;k++)
		{
			GaussData[k]=A*exp(-(Spec[k]-X0)*(Spec[k]-X0)/((dX/4)*(dX/4)))+B;
			Res2=Res2+GaussData[k];
		}
		CurrentErrorFuctor=abs(Res1-Res2)/(Res1+Res2);
		Iter=Iter+1;
		if(Iter==300)//cut wings to extract Gaussian data only
		{
			m=1;
			for(k=0;k<Length;k++)
				if(GaussData[k]-B>0.01*A)
				{
					Data[m]=Data[k];
					Spec[m]=Spec[k];
					m=m+1;
				}
			Length=m-1;
		}
	}
	A_V=A;
	X0_V=X0;
	dX_V=dX;
	B_V=B;
}

void CCheckTrView::TDGraph(CDC*dc_Frame,
							 double SN,
							 double Xmin,//if Xmin=Xmax=-1; make X-autoscale
							 double Xmax,
							 double Ymin,//if Ymin=Ymax=-1; make Y-autoscale
							 double Ymax,
							 double*SpectraData,
							 double*SpectraWavelength,
							 int*SpectraLength,
							 int*SpectraColorR,
							 int*SpectraColorG,
							 int*SpectraColorB,
							 int*SpectraColorW)
{
	CRect rect;
	dc_Frame->GetClipBox(rect);
	double XStartLine=rect.Width()*0.075;//temporary start Xline; should depend on Y numbers maybe
	double XEndLine;// Y end line; maybe it should be defined as a fraction of the total windows width
	XEndLine=0.025;//5% from the total width
	double Nc; // single numbers that fits in X-scale
	Nc=(double)(rect.Width())/SN;
	double tmpD;
	int k=0;
	int m=0;
	int SpecsNumb=0;
	while(SpectraLength[SpecsNumb+1]!=-1)SpecsNumb+=1;
	if((Xmin==-1)&(Xmax==-1))
	{
		Xmin=SpectraWavelength[0];
		Xmax=SpectraWavelength[0];
		tmpD=0;
		for (k=0;k<=SpecsNumb;k++) tmpD+=SpectraLength[SpecsNumb];//total pixels number
		for (k=0;k<tmpD;k++)
		{
			if(SpectraWavelength[k]<Xmin) Xmin=SpectraWavelength[k];
			if(SpectraWavelength[k]>Xmax) Xmax=SpectraWavelength[k];
		}
	}
	if((Ymin==-1)&(Ymax==-1))
	{
		Ymin=SpectraData[0];
		Ymax=SpectraData[0];
		tmpD=0;
		for (k=0;k<=SpecsNumb;k++) tmpD+=SpectraLength[SpecsNumb];//total pixels number
		for (k=0;k<tmpD;k++)
		{
			if(SpectraData[k]<Ymin) Ymin=SpectraData[k];
			if(SpectraData[k]>Ymax) Ymax=SpectraData[k];
		}
		tmpD=Ymin-0.015*(Ymax-Ymin);
		Ymax=Ymax+0.015*(Ymax-Ymin);
		Ymin=tmpD;
	}
	
	k=0;
	m=0;
	double Dx = (Xmax - Xmin);
	double Nn =0; // number of tenths in the difference; if Nn=1; Dx<10
	double Gm=0; // number of numbers in Xmax or Xmin
	if(abs(Xmin)>abs(Xmax))
		tmpD=abs(Xmin);
	else
		tmpD=abs(Xmax);

	while(tmpD>1)
	{
		tmpD=tmpD/10;
		Gm=Gm+1;
	}

	if(Dx>=1)
		while(k==0)
		{
			Dx=Dx/10;
		    Nn=Nn+1;
			if(Dx<1) k=1;
		}
	else
		while(k==0)
        {
			Dx=Dx*10;
			Nn=Nn-1;
			if(Dx>1) k=1;
        }
	double TNb = Gm;// general number of letetrs in one number (if step 0.2 or 0.5)
	if(Nn<=1) TNb = TNb+1+abs(Nn);
	if(Xmin<0) TNb= TNb+1;

	double MlF;
	if(Nn==1) MlF=1;
	else
	{
		MlF=1;
		if(Nn>1)
			for(int k=2;k<=Nn;k++)
				MlF=MlF/10;
		else
			for(k=1;k<=abs(Nn);k++)
				MlF=MlF*10;
	}
	double XminM=ceil(Xmin*MlF);// Round toward infinity
	double XmaxM=floor(Xmax*MlF);//Round toward minus infinity
	if(XminM==XmaxM)
	{
	    MlF=MlF*10;
	    XminM=ceil(Xmin*MlF);// Round toward infinity
		XmaxM=floor(Xmax*MlF);//Round toward minus infinity
	}

	double NmbGr[6];
	NmbGr[0]=0;
	// steps: 0.2; 0.5; 1; 2; 5
	NmbGr[1] = (floor(Xmax*MlF*10)-ceil(Xmin*MlF*10))/2+1;// number of greeds at 0.2 step
	NmbGr[2] = (floor(Xmax*MlF*10)-ceil(Xmin*MlF*10))/5+1;// number of greeds at 0.5 step
	NmbGr[3] = (XmaxM-XminM)/1+1;// number of greeds at 1 step
	NmbGr[4] = (XmaxM-XminM)/2+1;// number of greeds at 2 step
	NmbGr[5] = (XmaxM-XminM)/5+1;// number of greeds at 5 step

	double TNbP[6];
	// total number of pixels in all numbers
	TNbP[1]=NmbGr[1]*TNb*SN;// for 0.2 step
	TNbP[2]=NmbGr[2]*TNb*SN;// for 0.5 step
	TNbP[3]=NmbGr[3]*(TNb-1)*SN;// for 1 step
	TNbP[4]=NmbGr[4]*(TNb-1)*SN;// for 2 step
	TNbP[5]=NmbGr[5]*(TNb-1)*SN;// for 5 step

//	numbers should take not more than half of the X-scale and total grids should not excide 8
	k=1;
	while( (( (((double)(rect.Width())*(1-XEndLine)-XStartLine)>TNbP[k]*1.2)&(NmbGr[k]<=10) )==false )&(k<=5))		k++;
	if(k==1) tmpD=0.2;
	if(k==2) tmpD=0.5;
	if(k==3) tmpD=1;
	if(k==4) tmpD=2;
	if(k==5) tmpD=5;

	LOGFONT logFont;
	CFont font;
	logFont.lfHeight=1.5*SN;
	logFont.lfWidth = 0;
	logFont.lfEscapement = 0;//-10*15;
	logFont.lfOrientation = 0;//-10*15;
	logFont.lfWeight = FW_NORMAL;
	logFont.lfItalic = TRUE;
	logFont.lfUnderline = false;
	logFont.lfStrikeOut = false;
	logFont.lfCharSet = ANSI_CHARSET;
	logFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
	logFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	logFont.lfQuality = DEFAULT_QUALITY;
	logFont.lfPitchAndFamily = FF_DONTCARE;
	strcpy(logFont.lfFaceName, "Arial");

	font.CreateFontIndirect( &logFont);
	CFont* oldFont = dc_Frame->SelectObject( &font);

	CString Out;
	if(k<6)
	{	
		Dx=tmpD/MlF;
		Nn=0;
		if(Dx>=1) Nn=0;
		else
		{
			while(Dx<1)
			{
				Dx=Dx*10;
				Nn=Nn+1;
			}
		}
		if(k==5) XminM=5*ceil(Xmin*MlF/5);
		if(k==2) XminM=0.5*ceil(Xmin*MlF/0.5);
		if(k==1)
		{
			XminM=ceil(Xmin*MlF*10);
			tmpD=2;
			MlF*=10;
		}
		for(int i=1;i<=10;i++)
		{
			dc_Frame->MoveTo(XStartLine+(rect.Width()*(1-XEndLine)-XStartLine)*(XminM/MlF-Xmin)/(Xmax-Xmin),rect.Height()-SN*2);
			dc_Frame->LineTo(XStartLine+(rect.Width()*(1-XEndLine)-XStartLine)*(XminM/MlF-Xmin)/(Xmax-Xmin),rect.Height()*XEndLine);
			if(Nn==0)	sprintf(Out.GetBuffer(32),"%.0f",XminM/MlF);
			else
				if(Nn==1) sprintf(Out.GetBuffer(32),"%.1f",XminM/MlF);
				else
					if(Nn==2) sprintf(Out.GetBuffer(32),"%.2f",XminM/MlF);
					else  sprintf(Out.GetBuffer(32),"%.3f",XminM/MlF);
			Out.ReleaseBuffer();
			dc_Frame->TextOut(XStartLine+(rect.Width()*(1-XEndLine)-XStartLine)*(XminM/MlF-Xmin)/(Xmax-Xmin)-(int)(Out.GetLength()*SN/3),rect.Height()-1.5*SN,Out);		
			XminM+=tmpD;
			if(XminM/MlF>Xmax) i=10;
		}
	}	
//////////////////////////////////////////////////////////
////// Y-SCALE////////////////////////////////////////////
//////////////////////////////////////////////////////////

	Dx = (Ymax - Ymin);
	k=0;
	m=0;
	Nn =0; // number of tenths in the difference; if Nn=1; Dx<10

	Gm=0; // number of numbers in Xmax or Xmin
	if(abs(Ymin)>abs(Ymax))
		tmpD=abs(Ymin);
	else
		tmpD=abs(Ymax);

	while(tmpD>1)
	{
		tmpD=tmpD/10;
		Gm=Gm+1;
	}

	if(Dx>=1)
		while(k==0)
		{
			Dx=Dx/10;
		    Nn=Nn+1;
			if(Dx<1) k=1;
		}
	else
		while(k==0)
        {
			Dx=Dx*10;
			Nn=Nn-1;
			if(Dx>1) k=1;
        }
	TNb = Gm;// general number of letetrs in one number (if step 0.2 or 0.5)
	if(Nn<=1) TNb = TNb+1+abs(Nn);
	if(Xmin<0) TNb= TNb+1;

	MlF;
	if(Nn==1) MlF=1;
	else
	{
		MlF=1;
		if(Nn>1)
			for(int k=2;k<=Nn;k++)
				MlF=MlF/10;
		else
			for(k=1;k<=abs(Nn);k++)
				MlF=MlF*10;
	}
	double YminM=ceil(Ymin*MlF);// Round toward infinity
	double YmaxM=floor(Ymax*MlF);//Round toward minus infinity
	if(YminM==YmaxM)
	{
	    MlF=MlF*10;
	    YminM=ceil(Ymin*MlF);// Round toward infinity
		YmaxM=floor(Ymax*MlF);//Round toward minus infinity
	}

	NmbGr[6];
	NmbGr[0]=0;
	// steps: 0.2; 0.5; 1; 2; 5
	NmbGr[1] = (floor(Ymax*MlF*10)-ceil(Ymin*MlF*10))/2+1;// number of greeds at 0.2 step
	NmbGr[2] = (floor(Ymax*MlF*10)-ceil(Ymin*MlF*10))/5+1;// number of greeds at 0.5 step
	NmbGr[3] = (floor(Ymax*MlF)-ceil(Ymin*MlF))/1+1;// number of greeds at 1 step
	NmbGr[4] = (floor(Ymax*MlF)-ceil(Ymin*MlF))/2+1;// number of greeds at 2 step
	NmbGr[5] = (floor(Ymax*MlF)-ceil(Ymin*MlF))/5+1;// number of greeds at 5 step

	TNbP[6];
	// total number of pixels in all numbers
	TNbP[1]=NmbGr[1]*TNb*SN;// for 0.2 step
	TNbP[2]=NmbGr[2]*TNb*SN;// for 0.5 step
	TNbP[3]=NmbGr[3]*(TNb-1)*SN;// for 1 step
	TNbP[4]=NmbGr[4]*(TNb-1)*SN;// for 2 step
	TNbP[5]=NmbGr[5]*(TNb-1)*SN;// for 5 step

//	numbers should take not more than half of the Y-scale and total grids should not excide 8
	k=1;
	while((((rect.Height()-SN*2>NmbGr[k]*SN*2.5)&(NmbGr[k]<=10) )==false )&(k<=5))		k++;
	if(k==1) tmpD=0.2;
	if(k==2) tmpD=0.5;
	if(k==3) tmpD=1;
	if(k==4) tmpD=2;
	if(k==5) tmpD=5;

	if(k<6)
	{	
		Dx=tmpD/MlF;
		Nn=0;
		if(Dx>=1) Nn=0;
		else
		{
			while(Dx<1)
			{
				Dx=Dx*10;
				Nn=Nn+1;
			}
		}
		if(k==5) YminM=5*ceil(Ymin*MlF/5);
		if(k==2) YminM=0.5*ceil(Ymin*MlF/0.5);
		if(k==1)
		{
			YminM=ceil(Ymin*MlF*10);
			tmpD=2;
			MlF*=10;
		}
		for(int i=1;i<=10;i++)
		{
			dc_Frame->MoveTo(XStartLine,rect.Height()-SN*2-(rect.Height()*(1-XEndLine)-SN*2)*(YminM/MlF-Ymin)/(Ymax-Ymin));
			dc_Frame->LineTo(XStartLine+rect.Width()*0.01,rect.Height()-SN*2-(rect.Height()*(1-XEndLine)-SN*2)*(YminM/MlF-Ymin)/(Ymax-Ymin));
			if(Nn==0)	sprintf(Out.GetBuffer(32),"%.0f",YminM/MlF);
			else
				if(Nn==1) sprintf(Out.GetBuffer(32),"%.1f",YminM/MlF);
				else
					if(Nn==2) sprintf(Out.GetBuffer(32),"%.2f",YminM/MlF);
					else  sprintf(Out.GetBuffer(32),"%.3f",YminM/MlF);
			Out.ReleaseBuffer();
			dc_Frame->TextOut(XStartLine-Out.GetLength()*SN*0.5-SN*1,rect.Height()-SN*2-(rect.Height()*(1-XEndLine)-SN*2)*(YminM/MlF-Ymin)/(Ymax-Ymin)-SN*0.65,Out);		
			YminM+=tmpD;
			if(YminM/MlF>Ymax) i=10;
		}
	}


	dc_Frame->SelectObject( oldFont);
	font.DeleteObject();

	double Xcoord; double Ycoord;
	bool flag1=false;
	int shiftTMP=0;
	for(k=0;k<=SpecsNumb;k++)
	{
		CPen CustomCPen	(PS_SOLID, 1, RGB(SpectraColorR[k],SpectraColorG[k],SpectraColorB[k]));
		CPen* OldPen =	(CPen*)dc_Frame->SelectObject(&CustomCPen);
		flag1=false;
		for(m=0;m<=SpectraLength[k];m++)
		{
			if(	(SpectraWavelength[m+shiftTMP]>=Xmin)&
				(SpectraWavelength[m+shiftTMP]<=Xmax)&
				(SpectraData[m+shiftTMP]>=Ymin)&
				(SpectraData[m+shiftTMP]<=Ymax))
			{
				Xcoord=XStartLine+(rect.Width()*(1-XEndLine)-XStartLine)*(SpectraWavelength[m+shiftTMP]-Xmin)/(Xmax-Xmin);
				Ycoord=rect.Height()-SN*2-(rect.Height()*(1-XEndLine)-SN*2)*(SpectraData[m+shiftTMP]-Ymin)/(Ymax-Ymin);
				if(flag1==true) dc_Frame->LineTo((int)(Xcoord),(int)(Ycoord));
				else
				{
					dc_Frame->MoveTo((int)(Xcoord),(int)(Ycoord));
					flag1=true;
				}
			}
			else
			{
				flag1=false;
			}
		}
		shiftTMP+=SpectraLength[k]+1;
		flag1=false;

		dc_Frame->SelectObject(OldPen);
		CustomCPen.DeleteObject();
	}


	dc_Frame->MoveTo(XStartLine,rect.Height()-SN*2); dc_Frame->LineTo(rect.Width()*(1-XEndLine),rect.Height()-SN*2);
	dc_Frame->LineTo(rect.Width()*(1-XEndLine),rect.Height()*XEndLine); dc_Frame->LineTo(XStartLine,rect.Height()*XEndLine);
	dc_Frame->LineTo(XStartLine,rect.Height()-SN*2);
}

void CCheckTrView::OnCalibrationOff() 
{
	for(int i=0;i<3653;i++)
	{
		Xscl_lmbd[i]=i;
		NormS[i]=1;
		ColorNorm[i]=1;
	}
	SclDir=true;
	slopeIndex=0;
	this->Invalidate(false);//create and show BitMap
}

void CCheckTrView::OnTrigger() 
{
	CMainFrame *cFrame = reinterpret_cast<CMainFrame *>(AfxGetMainWnd());
	CButton *pRun   = reinterpret_cast<CButton *>(cFrame->m_wndChartBar.GetDlgItem(IDC_RUN));
	if(pRun->GetCheck()==1)
	{
		pRun->SetCheck(0);
		Run_get_spec=false;//stop getting spectra
		if(AutoSave==true)
		{
			AutoSave=false;
			KillTimer(ID_CLOCK_TIMER);
			AutoNmb=0;
		}
	}

	if(AutoSave==true)
	{
		KillTimer(ID_CLOCK_TIMER);
		AutoSave=false;
	}

	CTrigger TrigDlg;
	TrigDlg.m_noTrig = noTrig;
	TrigDlg.m_OptTrig = OptTrig;
	TrigDlg.m_ExtTrig = ExtTrig;
	TrigDlg.m_BothEdgesElectr = BothEdgesElectr;
	TrigDlg.m_OneTimeElectr = OneTimeElectr;
	TrigDlg.m_FallEdgeElectr = FallEdgeElectr;
	TrigDlg.m_FallEdgeOneTineOpt = FallEdgeOneTineOpt;
	TrigDlg.m_FallEdgeOpt = FallEdgeOpt;
	TrigDlg.m_RisingEdgeElectr = RisingEdgeElectr;
	TrigDlg.m_RisingEdgeOneTimeOpt = RisingEdgeOneTimeOpt;
	TrigDlg.m_RisingEdgeOpt = RisingEdgeOpt;
	TrigDlg.m_ThreshOpt = ThreshOpt;
	CString Out;
	sprintf(Out.GetBuffer(100),"%.1f",TrigIntensity);
	Out.ReleaseBuffer();
	TrigDlg.m_TrigIntensity = Out;
	sprintf(Out.GetBuffer(100),"%.1f",TrigWavelength);
	Out.ReleaseBuffer();
	TrigDlg.m_TrigWavelength = Out;
	TrigDlg.TrigStat=TrigStat;

	if(TrigDlg.DoModal()==IDOK)
	{
		noTrig					=	TrigDlg.m_noTrig;
		OptTrig					=	TrigDlg.m_OptTrig;
		ExtTrig					=	TrigDlg.m_ExtTrig;
		if(noTrig==true)	TrigStat=0;
		if(OptTrig==true)	TrigStat=1;
		if(ExtTrig==true)	TrigStat=2;
		BothEdgesElectr			=	TrigDlg.m_BothEdgesElectr;
		OneTimeElectr			=	TrigDlg.m_OneTimeElectr;
		FallEdgeElectr			=	TrigDlg.m_FallEdgeElectr;
		FallEdgeOneTineOpt		=	TrigDlg.m_FallEdgeOneTineOpt;
		FallEdgeOpt				=	TrigDlg.m_FallEdgeOpt;
		RisingEdgeElectr		=	TrigDlg.m_RisingEdgeElectr;
		RisingEdgeOneTimeOpt	=	TrigDlg.m_RisingEdgeOneTimeOpt;
		RisingEdgeOpt			=	TrigDlg.m_RisingEdgeOpt;
		ThreshOpt				=	TrigDlg.m_ThreshOpt;
		CString Out;
		Out=TrigDlg.m_TrigIntensity;
		TrigIntensity			=	atof(Out);
		Out=TrigDlg.m_TrigWavelength;
		TrigWavelength			=	atof(Out);

		if(ExtTrig==false)
		{
			TrigEnableMode=0;
			TrigSignalFrontMode=0;
			enableMode=0;//Optical
		}
		if(ExtTrig==true)
		{
			enableMode=0;//Optical
			if(OneTimeElectr==false)	TrigEnableMode=1;
			else						TrigEnableMode=2;
			if(RisingEdgeElectr==true)	TrigSignalFrontMode=1;
			if(FallEdgeElectr==true)	TrigSignalFrontMode=2;
			if(BothEdgesElectr==true)	TrigSignalFrontMode=3;
		}
		if(OptTrig==true)
		{	
			if(FallEdgeOpt==true)			enableMode=1;	//trigger for falling edge
			if(RisingEdgeOpt==true)			enableMode=2;	//trigger on threshold
			if(RisingEdgeOneTimeOpt==true)	enableMode=0x81;//one time trigger for rising edge
			if(FallEdgeOneTineOpt==true)	enableMode=0x82;//one time trigger for rising edge
			
			pixel=Newton1(TrigWavelength, TotPix+1,  Xscl_lmbd);//index of the new new_lmbdMax
			if(SclDir==false)	pixel=TotPix-pixel;
			threshold=TrigIntensity*NormS[pixel]+4000;
		}

	}
}
